/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.meeting;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipRole;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.committee.impl.meeting.CommScheduleActItemBase;
import org.kuali.coeus.common.committee.impl.meeting.CommScheduleMinuteDocBase;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleAttendanceBase;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleMinuteBase;
import org.kuali.coeus.common.committee.impl.meeting.CommonMeetingService;
import org.kuali.coeus.common.committee.impl.meeting.MeetingHelperBase;
import org.kuali.coeus.common.committee.impl.meeting.MemberAbsentBean;
import org.kuali.coeus.common.committee.impl.meeting.MemberPresentBean;
import org.kuali.coeus.common.committee.impl.meeting.OtherPresentBeanBase;
import org.kuali.coeus.common.committee.impl.meeting.ProtocolContingencyBase;
import org.kuali.coeus.common.committee.impl.meeting.ProtocolSubmittedBean;
import org.kuali.coeus.common.committee.impl.meeting.ScheduleAgendaBase;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.Time12HrFmt;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionLiteBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class MeetingServiceImplBase<CS extends CommitteeScheduleBase<CS, CMT, ?, CSM>, CSM extends CommitteeScheduleMinuteBase<CSM, CS>, CMT extends CommitteeBase<CMT, ?, CS>>
implements CommonMeetingService<CS, CSM> {
    BusinessObjectService businessObjectService;
    SequenceAccessorService sequenceAccessorService;
    DateTimeService dateTimeService;
    private static final String PROTOCOL_SUBMISSIONS_REF_ID = "protocolSubmissions";
    private static final String COMMITTEE_SCHEDULE_MINUTES_REF_ID = "committeeScheduleMinutes";

    protected Date getAgendaGenerationDate(Long scheduleId) {
        List<ScheduleAgendaBase> scheduleAgendas = this.getAgenda(scheduleId);
        if (scheduleAgendas.isEmpty()) {
            return null;
        }
        return new Date(scheduleAgendas.get(scheduleAgendas.size() - 1).getCreateTimestamp().getTime());
    }

    protected List<ScheduleAgendaBase> getAgenda(Long scheduleId) {
        return (List)this.businessObjectService.findMatchingOrderBy(this.getScheduleAgendaBOClassHook(), Collections.singletonMap("scheduleIdFk", scheduleId), "createTimestamp", true);
    }

    protected abstract Class<? extends ScheduleAgendaBase> getScheduleAgendaBOClassHook();

    protected List<CommScheduleMinuteDocBase> getMinuteDoc(Long scheduleId) {
        return (List)this.businessObjectService.findMatchingOrderBy(this.getCommScheduleMinuteDocBOClassHook(), Collections.singletonMap("scheduleIdFk", scheduleId), "createTimestamp", true);
    }

    protected abstract Class<? extends CommScheduleMinuteDocBase> getCommScheduleMinuteDocBOClassHook();

    protected List<ProtocolCorrespondence> getCorrespondences(CS committeeSchedule) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        ArrayList<Long> protocolIds = new ArrayList<Long>();
        ArrayList<ProtocolCorrespondence> correspondences = new ArrayList<ProtocolCorrespondence>();
        for (ProtocolSubmissionLiteBase submission : ((CommitteeScheduleBase)committeeSchedule).getLatestProtocolSubmissions()) {
            if (protocolIds.contains(submission.getProtocolId())) continue;
            protocolIds.add(submission.getProtocolId());
            fieldValues.put("protocolId", submission.getProtocolId());
            correspondences.addAll(this.businessObjectService.findMatching(this.getProtocolCorrespondenceBOClassHook(), fieldValues));
        }
        return correspondences;
    }

    protected abstract Class<? extends ProtocolCorrespondence> getProtocolCorrespondenceBOClassHook();

    @Override
    public void saveMeetingDetails(CS committeeSchedule, List<? extends PersistableBusinessObject> deletedBos) {
        ((CommitteeScheduleBase)committeeSchedule).setStartTime(this.addHrMinToDate(((CommitteeScheduleBase)committeeSchedule).getViewStartTime()));
        ((CommitteeScheduleBase)committeeSchedule).setEndTime(this.addHrMinToDate(((CommitteeScheduleBase)committeeSchedule).getViewEndTime()));
        ((CommitteeScheduleBase)committeeSchedule).setTime(this.addHrMinToDate(((CommitteeScheduleBase)committeeSchedule).getViewTime()));
        if (!deletedBos.isEmpty()) {
            this.businessObjectService.delete(deletedBos);
        }
        this.refreshAndSaveSchedule(committeeSchedule);
        KNSGlobalVariables.getMessageList().add("message.saved", new String[0]);
    }

    @Override
    public String getStandardReviewComment(String protocolContingencyCode) {
        String description = null;
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("protocolContingencyCode", protocolContingencyCode);
        ProtocolContingencyBase protocolContingency = (ProtocolContingencyBase)this.businessObjectService.findByPrimaryKey(this.getProtocolContingencyBOClassHook(), queryMap);
        if (protocolContingency != null) {
            description = protocolContingency.getDescription();
        }
        return description;
    }

    protected abstract Class<? extends ProtocolContingencyBase> getProtocolContingencyBOClassHook();

    protected Timestamp addHrMinToDate(Time12HrFmt viewTime) {
        java.util.Date dt = new java.util.Date(0L);
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy h:mm a");
        try {
            dt = dateFormat.parse("01/01/1970 " + viewTime.getTime() + " " + viewTime.getMeridiem());
            return new Timestamp(dt.getTime());
        }
        catch (Exception e) {
            dt = DateUtils.round((java.util.Date)dt, (int)5);
            return new Timestamp(DateUtils.addMinutes((java.util.Date)dt, (int)viewTime.findMinutes()).getTime());
        }
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    @Override
    public void addOtherAction(CommScheduleActItemBase newOtherAction, CS committeeSchedule) {
        newOtherAction.refreshReferenceObject("scheduleActItemType");
        newOtherAction.setCommScheduleActItemsId(this.getNextCommScheduleActItemId(newOtherAction.getClass()));
        newOtherAction.setScheduleIdFk(((CommitteeScheduleBase)committeeSchedule).getId());
        newOtherAction.setActionItemNumber(this.getNextActionItemNumber(committeeSchedule));
        ((CommitteeScheduleBase)committeeSchedule).getCommScheduleActItems().add(newOtherAction);
    }

    protected Long getNextCommScheduleActItemId(Class boClass) {
        return this.sequenceAccessorService.getNextAvailableSequenceNumber("SEQ_MEETING_ID", boClass);
    }

    protected Integer getNextActionItemNumber(CS committeeSchedule) {
        Integer nextActionItemNumber = ((CommitteeScheduleBase)committeeSchedule).getCommScheduleActItems().size();
        for (CommScheduleActItemBase commScheduleActItem : ((CommitteeScheduleBase)committeeSchedule).getCommScheduleActItems()) {
            if (commScheduleActItem.getActionItemNumber() <= nextActionItemNumber) continue;
            nextActionItemNumber = commScheduleActItem.getActionItemNumber();
        }
        return nextActionItemNumber + 1;
    }

    @Override
    public void deleteOtherAction(CS committeeSchedule, int itemNumber, List<CommScheduleActItemBase> deletedOtherActions) {
        CommScheduleActItemBase commScheduleActItem = ((CommitteeScheduleBase)committeeSchedule).getCommScheduleActItems().get(itemNumber);
        if (commScheduleActItem.getCommScheduleActItemsId() != null) {
            deletedOtherActions.add(commScheduleActItem);
        }
        ((CommitteeScheduleBase)committeeSchedule).getCommScheduleActItems().remove(itemNumber);
    }

    @Override
    public void markAbsent(List<MemberPresentBean> memberPresentBeans, List<MemberAbsentBean> memberAbsentBeans, int itemNumber) {
        MemberPresentBean memberPresentBean = memberPresentBeans.get(itemNumber);
        MemberAbsentBean memberAbsentBean = new MemberAbsentBean();
        memberPresentBean.getAttendance().setAlternateFor(null);
        memberAbsentBean.setAttendance(memberPresentBean.getAttendance());
        memberAbsentBeans.add(memberAbsentBean);
        memberPresentBeans.remove(itemNumber);
    }

    @Override
    public void presentVoting(MeetingHelperBase meetingHelper, int itemNumber) {
        MemberAbsentBean memberAbsentBean = meetingHelper.getMemberAbsentBeans().get(itemNumber);
        MemberPresentBean memberPresentBean = new MemberPresentBean();
        memberPresentBean.setAttendance(memberAbsentBean.getAttendance());
        memberPresentBean.getAttendance().setAlternateFlag(this.isAlternateForMember(meetingHelper.getCommitteeSchedule(), memberPresentBean.getAttendance(), meetingHelper.getCommitteeSchedule().getScheduledDate()));
        meetingHelper.getMemberPresentBeans().add(memberPresentBean);
        meetingHelper.getMemberAbsentBeans().remove(itemNumber);
    }

    protected boolean isAlternateForMember(CS commonCommitteeSchedule, CommitteeScheduleAttendanceBase committeeScheduleAttendance, Date scheduledDate) {
        boolean isAlternate = false;
        for (CommitteeMembershipBase committeeMembership : ((CommitteeBase)((CommitteeScheduleBase)commonCommitteeSchedule).getParentCommittee()).getCommitteeMemberships()) {
            if ((!committeeScheduleAttendance.getNonEmployeeFlag() || committeeMembership.getRolodexId() == null || !committeeScheduleAttendance.getPersonId().equals(committeeMembership.getRolodexId().toString())) && (committeeScheduleAttendance.getNonEmployeeFlag() || !committeeScheduleAttendance.getPersonId().equals(committeeMembership.getPersonId())) || !this.isActiveMembership(committeeMembership, scheduledDate) || !this.isAlternate(committeeMembership, scheduledDate)) continue;
            isAlternate = true;
            break;
        }
        return isAlternate;
    }

    protected boolean isActiveMembership(CommitteeMembershipBase committeeMembership, Date scheduledDate) {
        return this.isActiveForScheduledDate(scheduledDate, committeeMembership.getTermStartDate(), committeeMembership.getTermEndDate()) && this.hasActiveMembershipRoleForScheduledDate(committeeMembership.getMembershipRoles(), scheduledDate);
    }

    private boolean hasActiveMembershipRoleForScheduledDate(List<CommitteeMembershipRole> committeeMembershipRoles, Date scheduledDate) {
        for (CommitteeMembershipRole membershipRole : committeeMembershipRoles) {
            if (membershipRole.getMembershipRoleCode().equals("14") || !this.isActiveForScheduledDate(scheduledDate, membershipRole.getStartDate(), membershipRole.getEndDate())) continue;
            return true;
        }
        return false;
    }

    private boolean isActiveForScheduledDate(Date scheduledDate, Date startDate, Date endDate) {
        return startDate.before(scheduledDate) && endDate.after(scheduledDate);
    }

    protected boolean isAlternate(CommitteeMembershipBase committeeMembership, Date scheduledDate) {
        boolean isAlternate = false;
        for (CommitteeMembershipRole membershipRole : committeeMembership.getMembershipRoles()) {
            if (!membershipRole.getMembershipRoleCode().equals("12") || membershipRole.getStartDate().after(scheduledDate) || membershipRole.getEndDate().before(scheduledDate)) continue;
            isAlternate = true;
            break;
        }
        return isAlternate;
    }

    protected void getRoleName(CommitteeScheduleAttendanceBase committeeScheduleAttendance, List<CommitteeMembershipBase> committeeMemberships, Date scheduleDate) {
        String roleName = "";
        for (CommitteeMembershipBase committeeMembership : committeeMemberships) {
            if ((!committeeScheduleAttendance.getNonEmployeeFlag() || committeeMembership.getRolodexId() == null || !committeeScheduleAttendance.getPersonId().equals(committeeMembership.getRolodexId().toString())) && (committeeScheduleAttendance.getNonEmployeeFlag() || !committeeScheduleAttendance.getPersonId().equals(committeeMembership.getPersonId()))) continue;
            roleName = this.getRoleNameForMembership(committeeMembership, scheduleDate);
            break;
        }
        committeeScheduleAttendance.setRoleName(roleName);
    }

    protected String getRoleNameForMembership(CommitteeMembershipBase committeeMembership, Date scheduledDate) {
        Object roleName = "";
        for (CommitteeMembershipRole membershipRole : committeeMembership.getMembershipRoles()) {
            if (!this.isActiveForScheduledDate(scheduledDate, membershipRole.getStartDate(), membershipRole.getEndDate())) continue;
            roleName = (String)roleName + "," + membershipRole.getMembershipRole().getDescription();
        }
        if (StringUtils.isNotBlank((CharSequence)roleName)) {
            roleName = ((String)roleName).substring(1);
        }
        return roleName;
    }

    protected boolean isActiveMember(CommitteeScheduleAttendanceBase committeeScheduleAttendance, List<CommitteeMembershipBase> committeeMemberships, Date scheduleDate) {
        boolean isActiveMember = false;
        for (CommitteeMembershipBase committeeMembership : committeeMemberships) {
            if ((!committeeScheduleAttendance.getNonEmployeeFlag() || committeeMembership.getRolodexId() == null || !committeeScheduleAttendance.getPersonId().equals(committeeMembership.getRolodexId().toString())) && (committeeScheduleAttendance.getNonEmployeeFlag() || !committeeScheduleAttendance.getPersonId().equals(committeeMembership.getPersonId())) || !this.isActiveForScheduledDate(scheduleDate, committeeMembership.getTermStartDate(), committeeMembership.getTermEndDate())) continue;
            isActiveMember = this.isActiveMembership(committeeMembership, scheduleDate);
        }
        return isActiveMember;
    }

    protected boolean isActiveMemberAbsent(CommitteeScheduleAttendanceBase committeeScheduleAttendance, CommitteeMembershipBase committeeMembership, Date scheduleDate) {
        boolean isActiveMember = false;
        if ((committeeScheduleAttendance.getNonEmployeeFlag() && committeeMembership.getRolodexId() != null && committeeScheduleAttendance.getPersonId().equals(committeeMembership.getRolodexId().toString()) || !committeeScheduleAttendance.getNonEmployeeFlag() && committeeScheduleAttendance.getPersonId() != null && committeeScheduleAttendance.getPersonId().equals(committeeMembership.getPersonId())) && !committeeMembership.getTermStartDate().after(scheduleDate) && !committeeMembership.getTermEndDate().before(scheduleDate)) {
            isActiveMember = this.isActiveMembership(committeeMembership, scheduleDate);
        }
        return isActiveMember;
    }

    @Override
    public void presentOther(MeetingHelperBase meetingHelper, int itemNumber) {
        MemberAbsentBean memberAbsentBean = meetingHelper.getMemberAbsentBeans().get(itemNumber);
        OtherPresentBeanBase otherPresentBean = this.getNewOtherPresentBeanInstanceHook();
        otherPresentBean.setAttendance(memberAbsentBean.getAttendance());
        otherPresentBean.setMember(true);
        meetingHelper.getOtherPresentBeans().add(otherPresentBean);
        meetingHelper.getMemberAbsentBeans().remove(itemNumber);
    }

    protected abstract OtherPresentBeanBase getNewOtherPresentBeanInstanceHook();

    @Override
    public void addOtherPresent(MeetingHelperBase meetingHelper) {
        OtherPresentBeanBase otherPresentBean = this.getNewOtherPresentBeanInstanceHook();
        otherPresentBean.setMember(false);
        meetingHelper.getNewOtherPresentBean().getAttendance().setRoleName("Guest");
        otherPresentBean.setAttendance(meetingHelper.getNewOtherPresentBean().getAttendance());
        this.memberHandling(meetingHelper, otherPresentBean);
        meetingHelper.getOtherPresentBeans().add(otherPresentBean);
        meetingHelper.setNewOtherPresentBean(this.getNewOtherPresentBeanInstanceHook());
    }

    protected void memberHandling(MeetingHelperBase meetingHelper, OtherPresentBeanBase otherPresentBean) {
        MemberAbsentBean matchedMemberAbsentBean = null;
        for (MemberAbsentBean memberAbsentBean : meetingHelper.getMemberAbsentBeans()) {
            if (!this.isAbsentMember(memberAbsentBean, otherPresentBean)) continue;
            otherPresentBean.setMember(true);
            this.getRoleName(otherPresentBean.getAttendance(), ((CommitteeBase)meetingHelper.getCommitteeSchedule().getParentCommittee()).getCommitteeMemberships(), meetingHelper.getCommitteeSchedule().getScheduledDate());
            matchedMemberAbsentBean = memberAbsentBean;
        }
        if (matchedMemberAbsentBean != null) {
            meetingHelper.getMemberAbsentBeans().remove(matchedMemberAbsentBean);
        }
    }

    protected boolean isAbsentMember(MemberAbsentBean memberAbsentBean, OtherPresentBeanBase otherPresentBean) {
        boolean isPresent = false;
        if (memberAbsentBean.getAttendance().getNonEmployeeFlag() && otherPresentBean.getAttendance().getNonEmployeeFlag() && memberAbsentBean.getAttendance().getPersonId().equals(otherPresentBean.getAttendance().getPersonId())) {
            isPresent = true;
        } else if (!memberAbsentBean.getAttendance().getNonEmployeeFlag() && !otherPresentBean.getAttendance().getNonEmployeeFlag() && memberAbsentBean.getAttendance().getPersonId().equals(otherPresentBean.getAttendance().getPersonId())) {
            isPresent = true;
        }
        return isPresent;
    }

    @Override
    public void deleteOtherPresent(MeetingHelperBase meetingHelper, int itemNumber) {
        OtherPresentBeanBase otherPresentBean = meetingHelper.getOtherPresentBeans().get(itemNumber);
        if (otherPresentBean.isMember()) {
            MemberAbsentBean memberAbsentBean = new MemberAbsentBean();
            memberAbsentBean.setAttendance(otherPresentBean.getAttendance());
            meetingHelper.getMemberAbsentBeans().add(memberAbsentBean);
        }
        meetingHelper.getOtherPresentBeans().remove(itemNumber);
    }

    @Override
    public void addCommitteeScheduleMinute(MeetingHelperBase meetingHelper) {
        if (meetingHelper.getNewCommitteeScheduleMinute().getProtocol() == null) {
            meetingHelper.getNewCommitteeScheduleMinute().refreshReferenceObject("protocol");
        }
        if (meetingHelper.getNewCommitteeScheduleMinute().getMinuteEntryType() == null) {
            meetingHelper.getNewCommitteeScheduleMinute().refreshReferenceObject("minuteEntryType");
        }
        if (meetingHelper.getNewCommitteeScheduleMinute().getCommScheduleActItem() == null) {
            meetingHelper.getNewCommitteeScheduleMinute().refreshReferenceObject("commScheduleActItem");
        }
        ProtocolBase protocol = null;
        String protocolNumber = null;
        Long submissionId = null;
        Integer submissionNumber = null;
        if (meetingHelper.getNewCommitteeScheduleMinute().getProtocol() != null) {
            protocol = meetingHelper.getNewCommitteeScheduleMinute().getProtocol();
            protocolNumber = protocol.getProtocolNumber();
            if (protocol.getProtocolSubmission() != null) {
                submissionId = protocol.getProtocolSubmission().getSubmissionId();
                submissionNumber = protocol.getProtocolSubmission().getSubmissionNumber();
            }
        }
        Long scheduleId = meetingHelper.getCommitteeSchedule().getId();
        Integer entryNumber = this.getNextMinuteEntryNumber(meetingHelper.getCommitteeSchedule());
        String principalName = GlobalVariables.getUserSession().getPrincipalName();
        String minuteEntryTypeCode = meetingHelper.getNewCommitteeScheduleMinute().getMinuteEntryTypeCode();
        Timestamp createTimestamp = this.dateTimeService.getCurrentTimestamp();
        meetingHelper.getNewCommitteeScheduleMinute().setSubmissionIdFk(submissionId);
        meetingHelper.getNewCommitteeScheduleMinute().setSubmissionNumber(submissionNumber);
        meetingHelper.getNewCommitteeScheduleMinute().setProtocolNumber(protocolNumber);
        meetingHelper.getNewCommitteeScheduleMinute().setScheduleIdFk(scheduleId);
        meetingHelper.getNewCommitteeScheduleMinute().setEntryNumber(entryNumber);
        meetingHelper.getNewCommitteeScheduleMinute().setCreateUser(principalName);
        meetingHelper.getNewCommitteeScheduleMinute().setUpdateUser(principalName);
        meetingHelper.getNewCommitteeScheduleMinute().setCreateTimestamp(createTimestamp);
        meetingHelper.getNewCommitteeScheduleMinute().setUpdateTimestamp(createTimestamp);
        if ("2".equals(minuteEntryTypeCode)) {
            this.addAttendanceMinuteEntry(meetingHelper);
        } else if ("4".equals(minuteEntryTypeCode)) {
            this.addActionItem(meetingHelper);
        } else if ("3".equals(minuteEntryTypeCode)) {
            this.resetActionItemFields(meetingHelper);
        } else {
            this.resetProtocolFields(meetingHelper);
            this.resetActionItemFields(meetingHelper);
        }
        meetingHelper.getCommitteeSchedule().getCommitteeScheduleMinutes().add(meetingHelper.getNewCommitteeScheduleMinute());
        meetingHelper.setNewCommitteeScheduleMinute((CommitteeScheduleMinuteBase<?, ?>)this.getNewCommitteeScheduleMinuteInstanceHook());
    }

    protected abstract CSM getNewCommitteeScheduleMinuteInstanceHook();

    protected Integer getNextMinuteEntryNumber(CS commonCommitteeSchedule) {
        Integer nextMinuteEntryNumber = ((CommitteeScheduleBase)commonCommitteeSchedule).getCommitteeScheduleMinutes().size();
        for (CommitteeScheduleMinuteBase committeeScheduleMinute : ((CommitteeScheduleBase)commonCommitteeSchedule).getCommitteeScheduleMinutes()) {
            if (committeeScheduleMinute.getEntryNumber() <= nextMinuteEntryNumber) continue;
            nextMinuteEntryNumber = committeeScheduleMinute.getEntryNumber();
        }
        return nextMinuteEntryNumber + 1;
    }

    protected void addAttendanceMinuteEntry(MeetingHelperBase meetingHelper) {
        if (meetingHelper.getNewCommitteeScheduleMinute().isGenerateAttendance() && meetingHelper.isJsDisabled()) {
            meetingHelper.getNewCommitteeScheduleMinute().setMinuteEntry(this.generateAttendanceComment(meetingHelper.getMemberPresentBeans(), meetingHelper.getOtherPresentBeans(), meetingHelper.getCommitteeSchedule()));
        }
        this.resetProtocolFields(meetingHelper);
        this.resetActionItemFields(meetingHelper);
    }

    protected String generateAttendanceComment(List<MemberPresentBean> memberPresentBeans, List<OtherPresentBeanBase> otherPresentBeans, CS commonCommitteeSchedule) {
        Object comment = "";
        String eol = System.getProperty("line.separator");
        for (MemberPresentBean memberPresentBean : memberPresentBeans) {
            if (StringUtils.isNotBlank((CharSequence)comment)) {
                comment = (String)comment + eol;
            }
            comment = (String)comment + memberPresentBean.getAttendance().getPersonName();
            if (!StringUtils.isNotBlank((CharSequence)memberPresentBean.getAttendance().getAlternateFor())) continue;
            comment = (String)comment + " Alternate For: " + this.getAlternateForName(commonCommitteeSchedule, memberPresentBean.getAttendance().getAlternateFor());
        }
        for (OtherPresentBeanBase otherPresentBean : otherPresentBeans) {
            if (StringUtils.isNotBlank((CharSequence)comment)) {
                comment = (String)comment + eol;
            }
            comment = (String)comment + otherPresentBean.getAttendance().getPersonName() + " Guest ";
        }
        return comment;
    }

    protected String getAlternateForName(CS commonCommitteeSchedule, String alternateFor) {
        String personName = "";
        for (CommitteeMembershipBase committeeMembership : ((CommitteeBase)((CommitteeScheduleBase)commonCommitteeSchedule).getParentCommittee()).getCommitteeMemberships()) {
            if ((!StringUtils.isNotBlank((CharSequence)committeeMembership.getPersonId()) || !committeeMembership.getPersonId().equals(alternateFor)) && (!StringUtils.isBlank((CharSequence)committeeMembership.getPersonId()) || !committeeMembership.getRolodexId().toString().equals(alternateFor))) continue;
            personName = committeeMembership.getPersonName();
            break;
        }
        return personName;
    }

    protected void addActionItem(MeetingHelperBase meetingHelper) {
        if (meetingHelper.getNewCommitteeScheduleMinute().getCommScheduleActItemsIdFk() != null) {
            meetingHelper.getNewCommitteeScheduleMinute().setCommScheduleActItem(this.getActionItem(meetingHelper.getNewCommitteeScheduleMinute().getCommScheduleActItemsIdFk(), meetingHelper.getCommitteeSchedule().getCommScheduleActItems()));
        }
        this.resetProtocolFields(meetingHelper);
    }

    protected void resetProtocolFields(MeetingHelperBase meetingHelper) {
        meetingHelper.getNewCommitteeScheduleMinute().setProtocolIdFk(null);
        meetingHelper.getNewCommitteeScheduleMinute().setProtocolNumber(null);
        meetingHelper.getNewCommitteeScheduleMinute().setProtocol(null);
    }

    protected void resetActionItemFields(MeetingHelperBase meetingHelper) {
        meetingHelper.getNewCommitteeScheduleMinute().setCommScheduleActItemsIdFk(null);
        meetingHelper.getNewCommitteeScheduleMinute().setCommScheduleActItem(null);
    }

    protected CommScheduleActItemBase getActionItem(Long commScheduleActItemsIdFk, List<CommScheduleActItemBase> commScheduleActItems) {
        CommScheduleActItemBase actionItem = null;
        for (CommScheduleActItemBase commScheduleActItem : commScheduleActItems) {
            if (!commScheduleActItem.getCommScheduleActItemsId().equals(commScheduleActItemsIdFk)) continue;
            actionItem = commScheduleActItem;
            break;
        }
        return actionItem;
    }

    @Override
    public void deleteCommitteeScheduleMinute(CS committeeSchedule, List<CSM> deletedCommitteeScheduleMinutes, int itemNumber) {
        CommitteeScheduleMinuteBase committeeScheduleMinute = (CommitteeScheduleMinuteBase)((CommitteeScheduleBase)committeeSchedule).getCommitteeScheduleMinutes().get(itemNumber);
        if (committeeScheduleMinute.getCommScheduleMinutesId() != null) {
            deletedCommitteeScheduleMinutes.add(committeeScheduleMinute);
        }
        ((CommitteeScheduleBase)committeeSchedule).getCommitteeScheduleMinutes().remove(itemNumber);
    }

    @Override
    public void moveupCommitteeScheduleMinute(CS committeeSchedule, int itemNumber) {
        CommitteeScheduleMinuteBase minuteBeingMoved = (CommitteeScheduleMinuteBase)((CommitteeScheduleBase)committeeSchedule).getCommitteeScheduleMinutes().get(itemNumber);
        CommitteeScheduleMinuteBase minuteAbove = (CommitteeScheduleMinuteBase)((CommitteeScheduleBase)committeeSchedule).getCommitteeScheduleMinutes().get(itemNumber - 1);
        if (minuteBeingMoved != null && minuteAbove != null) {
            Integer temp = minuteAbove.getEntryNumber();
            minuteAbove.setEntryNumber(minuteBeingMoved.getEntryNumber());
            minuteBeingMoved.setEntryNumber(temp);
        }
    }

    @Override
    public void movedownCommitteeScheduleMinute(CS committeeSchedule, int itemNumber) {
        CommitteeScheduleMinuteBase minuteBeingMoved = (CommitteeScheduleMinuteBase)((CommitteeScheduleBase)committeeSchedule).getCommitteeScheduleMinutes().get(itemNumber);
        CommitteeScheduleMinuteBase minuteBelow = (CommitteeScheduleMinuteBase)((CommitteeScheduleBase)committeeSchedule).getCommitteeScheduleMinutes().get(itemNumber + 1);
        if (minuteBeingMoved != null && minuteBelow != null) {
            Integer temp = minuteBelow.getEntryNumber();
            minuteBelow.setEntryNumber(minuteBeingMoved.getEntryNumber());
            minuteBeingMoved.setEntryNumber(temp);
        }
    }

    @Override
    public void populateFormHelper(MeetingHelperBase meetingHelper, CS commSchedule, int lineNumber) {
        for (ProtocolSubmissionLiteBase protocolSubmission : ((CommitteeScheduleBase)commSchedule).getLatestProtocolSubmissions()) {
            ProtocolSubmittedBean protocolSubmittedBean = new ProtocolSubmittedBean();
            protocolSubmittedBean.setPersonId(protocolSubmission.getPiPersonId());
            protocolSubmittedBean.setPersonName(protocolSubmission.getPiPersonName());
            protocolSubmittedBean.setRolodexId(protocolSubmission.getPiRolodexId());
            meetingHelper.getProtocolSubmittedBeans().add(protocolSubmittedBean);
        }
        if (((CommitteeScheduleBase)commSchedule).getCommitteeScheduleAttendances().isEmpty() && !((CommitteeBase)((CommitteeScheduleBase)commSchedule).getParentCommittee()).getCommitteeMemberships().isEmpty()) {
            this.initAttendance(meetingHelper.getMemberAbsentBeans(), commSchedule);
        } else {
            this.populateAttendanceToForm(meetingHelper, ((CommitteeBase)((CommitteeScheduleBase)commSchedule).getParentCommittee()).getCommitteeMemberships(), commSchedule);
        }
        meetingHelper.setAgendaGenerationDate(this.getAgendaGenerationDate(((CommitteeScheduleBase)commSchedule).getId()));
        meetingHelper.setCommitteeSchedule((CommitteeScheduleBase<?, ?, ?, ?>)commSchedule);
        meetingHelper.setTabLabel(this.getMeetingTabTitle(meetingHelper.getCommitteeSchedule(), lineNumber));
        meetingHelper.setScheduleAgendas(this.getAgenda(((CommitteeScheduleBase)commSchedule).getId()));
        meetingHelper.setMinuteDocs(this.getMinuteDoc(((CommitteeScheduleBase)commSchedule).getId()));
        meetingHelper.setCorrespondences(this.getCorrespondences(commSchedule));
    }

    protected String getMeetingTabTitle(CS commonCommitteeSchedule, int lineNumber) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
        return ((CommitteeBase)((CommitteeScheduleBase)commonCommitteeSchedule).getParentCommittee()).getCommitteeName() + " #" + lineNumber + " Meeting " + dateFormat.format(((CommitteeScheduleBase)commonCommitteeSchedule).getScheduledDate());
    }

    protected void populateAttendanceToForm(MeetingHelperBase meetingHelper, List<CommitteeMembershipBase> committeeMemberships, CS commSchedule) {
        this.populatePresentBean(meetingHelper, committeeMemberships, commSchedule);
        this.populateMemberAbsentBean(meetingHelper, committeeMemberships, commSchedule);
    }

    protected void populatePresentBean(MeetingHelperBase meetingHelper, List<CommitteeMembershipBase> committeeMemberships, CS commSchedule) {
        meetingHelper.setOtherPresentBeans(new ArrayList<OtherPresentBeanBase>());
        meetingHelper.setMemberPresentBeans(new ArrayList<MemberPresentBean>());
        for (CommitteeScheduleAttendanceBase committeeScheduleAttendance : ((CommitteeScheduleBase)commSchedule).getCommitteeScheduleAttendances()) {
            this.getRoleName(committeeScheduleAttendance, committeeMemberships, ((CommitteeScheduleBase)commSchedule).getScheduledDate());
            if (committeeScheduleAttendance.getGuestFlag()) {
                OtherPresentBeanBase otherPresentBean = this.getNewOtherPresentBeanInstanceHook();
                otherPresentBean.setAttendance(committeeScheduleAttendance);
                otherPresentBean.setMember(this.isActiveMember(committeeScheduleAttendance, committeeMemberships, ((CommitteeScheduleBase)commSchedule).getScheduledDate()));
                if (StringUtils.isBlank((CharSequence)committeeScheduleAttendance.getRoleName())) {
                    committeeScheduleAttendance.setRoleName("Guest");
                }
                meetingHelper.getOtherPresentBeans().add(otherPresentBean);
                otherPresentBean.setAttendance(committeeScheduleAttendance);
                continue;
            }
            MemberPresentBean memberPresentBean = new MemberPresentBean();
            memberPresentBean.setAttendance(committeeScheduleAttendance);
            meetingHelper.getMemberPresentBeans().add(memberPresentBean);
        }
    }

    protected void populateMemberAbsentBean(MeetingHelperBase meetingHelper, List<CommitteeMembershipBase> committeeMemberships, CS commSchedule) {
        meetingHelper.setMemberAbsentBeans(new ArrayList<MemberAbsentBean>());
        committeeMemberships.forEach(committeeMembership -> {
            if (!this.isInMemberPresent(meetingHelper.getMemberPresentBeans(), (CommitteeMembershipBase)committeeMembership) && !this.isInOtherPresent(meetingHelper.getOtherPresentBeans(), (CommitteeMembershipBase)committeeMembership)) {
                MemberAbsentBean memberAbsentBean = new MemberAbsentBean();
                CommitteeScheduleAttendanceBase attendance = this.getNewCommitteeScheduleAttendanceInstanceHook();
                attendance.setRoleName(this.getRoleNameForMembership((CommitteeMembershipBase)committeeMembership, commSchedule.getScheduledDate()));
                if (StringUtils.isBlank((CharSequence)committeeMembership.getPersonId())) {
                    attendance.setPersonId(committeeMembership.getRolodexId().toString());
                } else {
                    attendance.setPersonId(committeeMembership.getPersonId());
                }
                if (this.isActiveMemberAbsent(attendance, (CommitteeMembershipBase)committeeMembership, commSchedule.getScheduledDate())) {
                    attendance.setPersonName(committeeMembership.getPersonName());
                    attendance.setAlternateFlag(false);
                    attendance.setNonEmployeeFlag(StringUtils.isBlank((CharSequence)committeeMembership.getPersonId()));
                    memberAbsentBean.setAttendance(attendance);
                    meetingHelper.getMemberAbsentBeans().add(memberAbsentBean);
                }
            }
        });
    }

    protected abstract CommitteeScheduleAttendanceBase getNewCommitteeScheduleAttendanceInstanceHook();

    protected void initAttendance(List<MemberAbsentBean> memberAbsentBeans, CS commSchedule) {
        List<CommitteeMembershipBase> committeeMemberships = ((CommitteeBase)((CommitteeScheduleBase)commSchedule).getParentCommittee()).getCommitteeMemberships();
        committeeMemberships.forEach(committeeMembership -> {
            if (this.isActiveMembership((CommitteeMembershipBase)committeeMembership, commSchedule.getScheduledDate())) {
                CommitteeScheduleAttendanceBase committeeScheduleAttendance = this.getNewCommitteeScheduleAttendanceInstanceHook();
                if (StringUtils.isBlank((CharSequence)committeeMembership.getPersonId())) {
                    committeeScheduleAttendance.setPersonId(committeeMembership.getRolodexId().toString());
                    committeeScheduleAttendance.setNonEmployeeFlag(true);
                } else {
                    committeeScheduleAttendance.setPersonId(committeeMembership.getPersonId());
                    committeeScheduleAttendance.setNonEmployeeFlag(false);
                }
                committeeScheduleAttendance.setPersonName(committeeMembership.getPersonName());
                if (this.isAlternate((CommitteeMembershipBase)committeeMembership, commSchedule.getScheduledDate())) {
                    committeeScheduleAttendance.setAlternateFlag(true);
                } else {
                    committeeScheduleAttendance.setAlternateFlag(false);
                }
                MemberAbsentBean memberAbsentBean = new MemberAbsentBean();
                committeeScheduleAttendance.setRoleName(this.getRoleNameForMembership((CommitteeMembershipBase)committeeMembership, commSchedule.getScheduledDate()));
                memberAbsentBean.setAttendance(committeeScheduleAttendance);
                memberAbsentBeans.add(memberAbsentBean);
            }
        });
    }

    protected boolean isInMemberPresent(List<MemberPresentBean> memberPresentBeans, CommitteeMembershipBase committeeMembership) {
        boolean isPresent = false;
        for (MemberPresentBean memberPresentBean : memberPresentBeans) {
            if (memberPresentBean.getAttendance().getNonEmployeeFlag() && StringUtils.isBlank((CharSequence)committeeMembership.getPersonId()) && memberPresentBean.getAttendance().getPersonId().equals(committeeMembership.getRolodexId().toString())) {
                isPresent = true;
                break;
            }
            if (memberPresentBean.getAttendance().getNonEmployeeFlag() || !StringUtils.isNotBlank((CharSequence)committeeMembership.getPersonId()) || !memberPresentBean.getAttendance().getPersonId().equals(committeeMembership.getPersonId())) continue;
            isPresent = true;
            break;
        }
        return isPresent;
    }

    protected boolean isInOtherPresent(List<OtherPresentBeanBase> otherPresentBeans, CommitteeMembershipBase committeeMembership) {
        boolean isPresent = false;
        for (OtherPresentBeanBase otherPresentBean : otherPresentBeans) {
            if (otherPresentBean.getAttendance().getNonEmployeeFlag() && StringUtils.isBlank((CharSequence)committeeMembership.getPersonId()) && otherPresentBean.getAttendance().getPersonId().equals(committeeMembership.getRolodexId().toString())) {
                isPresent = true;
                break;
            }
            if (otherPresentBean.getAttendance().getNonEmployeeFlag() || !StringUtils.isNotBlank((CharSequence)committeeMembership.getPersonId()) || !otherPresentBean.getAttendance().getPersonId().equals(committeeMembership.getPersonId())) continue;
            isPresent = true;
            break;
        }
        return isPresent;
    }

    private void refreshAndSaveSchedule(CS committeeSchedule) {
        ArrayList<CommitteeScheduleMinuteBase> preRefreshMinutes = new ArrayList<CommitteeScheduleMinuteBase>();
        int nextEntry = 0;
        for (CommitteeScheduleMinuteBase minute : ((CommitteeScheduleBase)committeeSchedule).getCommitteeScheduleMinutes()) {
            minute.setEntryNumber(nextEntry++);
            preRefreshMinutes.add(minute);
        }
        committeeSchedule.refreshReferenceObject(COMMITTEE_SCHEDULE_MINUTES_REF_ID);
        ArrayList<CommitteeScheduleMinuteBase> newlyAddedMinutes = new ArrayList<CommitteeScheduleMinuteBase>();
        block1: for (CommitteeScheduleMinuteBase formMinute : preRefreshMinutes) {
            if (null == formMinute.getCommScheduleMinutesId()) {
                newlyAddedMinutes.add(formMinute);
                continue;
            }
            for (CommitteeScheduleMinuteBase oldMinute : ((CommitteeScheduleBase)committeeSchedule).getCommitteeScheduleMinutes()) {
                if (!formMinute.getCommScheduleMinutesId().equals(oldMinute.getCommScheduleMinutesId()) || !this.importantChanges(oldMinute, formMinute)) continue;
                oldMinute.setMinuteEntry(formMinute.getMinuteEntry());
                oldMinute.setFinalFlag(formMinute.isFinal());
                oldMinute.setPrivateCommentFlag(formMinute.getPrivateCommentFlag());
                oldMinute.setEntryNumber(formMinute.getEntryNumber());
                continue block1;
            }
        }
        ((CommitteeScheduleBase)committeeSchedule).getCommitteeScheduleMinutes().addAll(newlyAddedMinutes);
        committeeSchedule.refreshReferenceObject(PROTOCOL_SUBMISSIONS_REF_ID);
        this.businessObjectService.save(committeeSchedule);
    }

    private boolean importantChanges(CSM oldMinute, CSM newMinute) {
        return ((CommitteeScheduleMinuteBase)oldMinute).getPrivateCommentFlag() != ((CommitteeScheduleMinuteBase)newMinute).getPrivateCommentFlag() || ((CommitteeScheduleMinuteBase)oldMinute).isFinal() != ((CommitteeScheduleMinuteBase)newMinute).isFinal() || !StringUtils.equals((CharSequence)((CommitteeScheduleMinuteBase)oldMinute).getMinuteEntry(), (CharSequence)((CommitteeScheduleMinuteBase)newMinute).getMinuteEntry()) || !((CommitteeScheduleMinuteBase)oldMinute).getEntryNumber().equals(((CommitteeScheduleMinuteBase)newMinute).getEntryNumber());
    }
}

