/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.org.audit;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.api.org.audit.OrganizationAuditContract;
import org.kuali.coeus.common.framework.org.Organization;
import org.kuali.coeus.common.framework.org.audit.OrganizationAuditAcceptedType;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;

@Entity
@Table(name="ORGANIZATION_AUDIT")
@IdClass(value=OrganizationAuditId.class)
public class OrganizationAudit
extends KcPersistableBusinessObjectBase
implements OrganizationAuditContract {
    private static final String ACCEPTED = "1";
    @Id
    @Column(name="FISCAL_YEAR")
    private String fiscalYear;
    @Id
    @Column(name="ORGANIZATION_ID")
    private String organizationId;
    @Column(name="AUDIT_ACCEPTED")
    private String auditAcceptedCode;
    @Column(name="AUDIT_COMMENT")
    private String auditComment;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="ORGANIZATION_ID", referencedColumnName="ORGANIZATION_ID", insertable=false, updatable=false)
    private Organization organization;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="AUDIT_ACCEPTED", referencedColumnName="CODE", insertable=false, updatable=false)
    private OrganizationAuditAcceptedType auditAcceptedType;

    public String getFiscalYear() {
        return this.fiscalYear;
    }

    public void setFiscalYear(String fiscalYear) {
        this.fiscalYear = fiscalYear;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public boolean getAuditAccepted() {
        return ACCEPTED.equals(this.getAuditAcceptedCode());
    }

    public String getAuditAcceptedCode() {
        return this.auditAcceptedCode;
    }

    public void setAuditAcceptedCode(String auditAcceptedCode) {
        this.auditAcceptedCode = auditAcceptedCode;
    }

    public OrganizationAuditAcceptedType getAuditAcceptedType() {
        return this.auditAcceptedType;
    }

    public void setAuditAcceptedType(OrganizationAuditAcceptedType auditAcceptedType) {
        this.auditAcceptedType = auditAcceptedType;
    }

    public String getAuditComment() {
        return this.auditComment;
    }

    public void setAuditComment(String auditComment) {
        this.auditComment = auditComment;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public static final class OrganizationAuditId
    implements Serializable,
    Comparable<OrganizationAuditId> {
        private String fiscalYear;
        private String organizationId;

        public String getFiscalYear() {
            return this.fiscalYear;
        }

        public void setFiscalYear(String fiscalYear) {
            this.fiscalYear = fiscalYear;
        }

        public String getOrganizationId() {
            return this.organizationId;
        }

        public void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("fiscalYear", (Object)this.fiscalYear).append("organizationId", (Object)this.organizationId).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            OrganizationAuditId rhs = (OrganizationAuditId)other;
            return new EqualsBuilder().append((Object)this.fiscalYear, (Object)rhs.fiscalYear).append((Object)this.organizationId, (Object)rhs.organizationId).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.fiscalYear).append((Object)this.organizationId).toHashCode();
        }

        @Override
        public int compareTo(OrganizationAuditId other) {
            return new CompareToBuilder().append((Object)this.fiscalYear, (Object)other.fiscalYear).append((Object)this.organizationId, (Object)other.organizationId).toComparison();
        }
    }
}

