/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.unit;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.kuali.coeus.common.api.unit.UnitContract;
import org.kuali.coeus.common.framework.org.Organization;
import org.kuali.coeus.common.framework.unit.admin.UnitAdministrator;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@Entity
@Table(name="UNIT")
public class Unit
extends KcPersistableBusinessObjectBase
implements MutableInactivatable,
UnitContract {
    private static final long serialVersionUID = 7170184898996866958L;
    @Id
    @Column(name="UNIT_NUMBER")
    private String unitNumber;
    @Column(name="PARENT_UNIT_NUMBER")
    private String parentUnitNumber;
    @Column(name="ORGANIZATION_ID")
    private String organizationId;
    @Column(name="UNIT_NAME")
    private String unitName;
    @Transient
    private String code;
    @Column(name="ACTIVE_FLAG")
    @Convert(converter=BooleanYNConverter.class)
    private boolean active;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="PARENT_UNIT_NUMBER", referencedColumnName="UNIT_NUMBER", insertable=false, updatable=false)
    private Unit parentUnit;
    @OneToMany(mappedBy="unit")
    @OrderBy(value="unitNumber")
    private List<UnitAdministrator> unitAdministrators = new ArrayList<UnitAdministrator>();
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="ORGANIZATION_ID", referencedColumnName="ORGANIZATION_ID", insertable=false, updatable=false)
    private Organization organization;

    public String getUnitNumber() {
        return this.unitNumber;
    }

    public void setUnitNumber(String unitNumber) {
        this.unitNumber = unitNumber;
    }

    public String getParentUnitNumber() {
        return this.parentUnitNumber;
    }

    public void setParentUnitNumber(String parentUnitNumber) {
        this.parentUnitNumber = parentUnitNumber;
    }

    public String getOrganizationId() {
        if (this.organizationId == null && this.getParentUnit() != null && this.getParentUnit().getUnitNumber() != null) {
            return this.getParentUnit().getOrganizationId();
        }
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public Organization getOrganization() {
        if (this.organization == null && this.getParentUnit() != null && this.getParentUnit().getUnitNumber() != null) {
            return this.getParentUnit().getOrganization();
        }
        return this.organization;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public Unit getParentUnit() {
        return this.parentUnit;
    }

    public void setParentUnit(Unit parentUnit) {
        this.parentUnit = parentUnit;
    }

    public List<UnitAdministrator> getUnitAdministrators() {
        return this.unitAdministrators;
    }

    public void setUnitAdministrators(List<UnitAdministrator> unitAdministrators) {
        this.unitAdministrators = unitAdministrators;
    }

    public String getOrganizationIdForMaintenance() {
        return this.organizationId;
    }

    public void setOrganizationIdForMaintenance(String organizationIdForMaintenance) {
        this.organizationId = organizationIdForMaintenance;
    }

    public boolean isParentUnit(Unit parentCandidate) {
        if (this.getParentUnitNumber() != null) {
            if (this.getParentUnitNumber().equals(parentCandidate.getUnitNumber())) {
                return true;
            }
            return this.getParentUnit().isParentUnit(parentCandidate);
        }
        return false;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getUnitAdministrators());
        return managedLists;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.unitNumber == null ? 0 : this.unitNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Unit)) {
            return false;
        }
        Unit other = (Unit)obj;
        return !(this.unitNumber == null ? other.unitNumber != null : !this.unitNumber.equals(other.unitNumber));
    }
}

