/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.custom.arg.ArgValueLookup;
import org.kuali.coeus.common.questionnaire.api.core.QuestionAnswerService;
import org.kuali.coeus.common.questionnaire.api.core.QuestionnaireContract;
import org.kuali.coeus.common.questionnaire.api.question.QuestionContract;
import org.kuali.coeus.common.questionnaire.framework.answer.Answer;
import org.kuali.coeus.common.questionnaire.framework.core.Questionnaire;
import org.kuali.coeus.common.questionnaire.framework.question.Question;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="questionAnswerService")
public class QuestionAnswerServiceImpl
implements QuestionAnswerService {
    private static final Logger LOG = LogManager.getLogger(QuestionAnswerServiceImpl.class);
    private static final String SUPPORTED_LOOKUP_CLASS = ArgValueLookup.class.getName();
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;

    public String getAnswerDescription(Long answerId) {
        if (answerId == null) {
            throw new IllegalArgumentException("answerId is null");
        }
        Answer answer = (Answer)this.businessObjectService.findByPrimaryKey(Answer.class, Collections.singletonMap("id", answerId));
        String lookupClass = answer.getQuestion().getLookupClass();
        if (!SUPPORTED_LOOKUP_CLASS.equals(lookupClass)) {
            throw new UnsupportedOperationException("Answer description retrieval not supported.  Answer id: answerId");
        }
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("argumentName", answer.getQuestion().getLookupReturn());
        criteria.put("value", answer.getAnswer());
        Collection avls = this.businessObjectService.findMatching(ArgValueLookup.class, criteria);
        if (avls != null && avls.size() > 1) {
            LOG.warn("multiple arg value lookup results exist for argumentName: " + answer.getQuestion().getLookupReturn() + " and value: " + answer.getAnswer());
        }
        return avls != null && !avls.isEmpty() ? ((ArgValueLookup)avls.iterator().next()).getDescription() : null;
    }

    public boolean isAnswerDescriptionRetrievalSupported(Long answerId) {
        if (answerId == null) {
            throw new IllegalArgumentException("answerId is null");
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("id", answerId);
        criteria.put("question.lookupClass", SUPPORTED_LOOKUP_CLASS);
        return this.businessObjectService.countMatching(Answer.class, criteria) > 0;
    }

    public QuestionnaireContract findQuestionnaireById(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        return (QuestionnaireContract)this.businessObjectService.findByPrimaryKey(Questionnaire.class, Collections.singletonMap("id", id));
    }

    public QuestionContract findQuestionById(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        return (QuestionContract)this.businessObjectService.findByPrimaryKey(Question.class, Collections.singletonMap("id", id));
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

