/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.config.module.RunMode;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.resourceloader.ResourceLoader;
import org.kuali.rice.core.framework.config.module.ModuleConfigurer;
import org.kuali.rice.core.framework.resourceloader.RiceResourceLoaderFactory;
import org.kuali.rice.core.framework.resourceloader.SpringResourceLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.springframework.web.servlet.DispatcherServlet;

public class KcConfigurer
extends ModuleConfigurer {
    private static final String ADDITIONAL_SPRING_FILES = ".additionalSpringFiles";
    private static final String KC_PREFIX = "kc.";
    private static final String SPRING_SECURITY_FILTER_PROXY = ".springSecurityFilterProxy";
    private static final String SPRING_SECURITY_FILTER_CHAIN = "springSecurityFilterChain";
    protected final Logger LOG = LogManager.getLogger(KcConfigurer.class);
    private String bootstrapSpringFile;
    private String dispatchServletName;
    private List<String> dispatchServletMappings = new ArrayList<String>();
    private List<String> filtersToMap = new ArrayList<String>();
    private String moduleTitle;
    private boolean enableSpringSecurity;
    private boolean mapFilters = true;
    private ResourceLoader rootResourceLoader;

    public KcConfigurer() {
        this.setValidRunModes(Collections.singletonList(RunMode.LOCAL));
    }

    public KcConfigurer(String moduleName, String moduleTitle) {
        super(moduleName);
        this.moduleTitle = moduleTitle;
    }

    public List<String> getPrimarySpringFiles() {
        return Collections.singletonList(this.bootstrapSpringFile);
    }

    public List<String> getAdditionalSpringFiles() {
        String files = ConfigContext.getCurrentContextConfig().getProperty(KC_PREFIX + this.getModuleName() + ADDITIONAL_SPRING_FILES);
        return files == null ? Collections.emptyList() : this.parseFileList(files);
    }

    public RunMode getRunMode() {
        try {
            return super.getRunMode();
        }
        catch (ConfigurationException e) {
            this.LOG.info("Assuming LOCAL mode for " + this.getModuleName() + " as one wasn't provided.", (Throwable)e);
            return RunMode.LOCAL;
        }
    }

    protected ResourceLoader createResourceLoader(ServletContext servletContext, List<String> files, String moduleName) {
        this.rootResourceLoader = RiceResourceLoaderFactory.createRootRiceResourceLoader((ServletContext)servletContext, files, (String)this.getModuleName());
        return this.rootResourceLoader;
    }

    protected void doAdditionalModuleStartLogic() throws Exception {
        if (StringUtils.isNotBlank((CharSequence)this.dispatchServletName)) {
            DispatcherServlet loaderServlet = new DispatcherServlet((WebApplicationContext)((SpringResourceLoader)this.rootResourceLoader.getResourceLoaders().get(0)).getContext());
            ServletRegistration.Dynamic registration = this.getServletContext().addServlet(this.dispatchServletName, (Servlet)loaderServlet);
            registration.addMapping(new String[]{"/" + this.dispatchServletName + "/*"});
            if (this.dispatchServletMappings != null) {
                this.dispatchServletMappings.stream().map(mapping -> "/" + mapping + "/*").forEach(arg_0 -> KcConfigurer.lambda$doAdditionalModuleStartLogic$1((ServletRegistration)registration, arg_0));
            }
            if (this.mapFilters) {
                for (String filterName : this.filtersToMap) {
                    FilterRegistration filter = this.getServletContext().getFilterRegistration(filterName);
                    filter.addMappingForServletNames(null, true, new String[]{this.dispatchServletName});
                }
            }
            if (this.enableSpringSecurity) {
                DelegatingFilterProxy filterProxy = new DelegatingFilterProxy(SPRING_SECURITY_FILTER_CHAIN, (WebApplicationContext)((SpringResourceLoader)this.rootResourceLoader.getResourceLoaders().get(0)).getContext());
                FilterRegistration.Dynamic securityFilter = this.getServletContext().addFilter(KC_PREFIX + this.getModuleName() + SPRING_SECURITY_FILTER_PROXY, (Filter)filterProxy);
                securityFilter.addMappingForServletNames(null, true, new String[]{this.dispatchServletName});
            }
        }
    }

    public void setModuleName(String moduleName) {
        super.setModuleName(moduleName);
    }

    public String getBootstrapSpringFile() {
        return this.bootstrapSpringFile;
    }

    public void setBootstrapSpringFile(String bootstrapSpringFile) {
        this.bootstrapSpringFile = bootstrapSpringFile;
    }

    public String getDispatchServletName() {
        return this.dispatchServletName;
    }

    public void setDispatchServletName(String dispatchServletName) {
        this.dispatchServletName = dispatchServletName;
    }

    public List<String> getFiltersToMap() {
        return this.filtersToMap;
    }

    public void setFiltersToMap(List<String> filtersToMap) {
        this.filtersToMap = filtersToMap;
    }

    public ResourceLoader getRootResourceLoader() {
        return this.rootResourceLoader;
    }

    protected void setRootResourceLoader(ResourceLoader rootResourceLoader) {
        this.rootResourceLoader = rootResourceLoader;
    }

    public String getModuleTitle() {
        return this.moduleTitle;
    }

    public void setModuleTitle(String moduleTitle) {
        this.moduleTitle = moduleTitle;
    }

    public boolean isEnableSpringSecurity() {
        return this.enableSpringSecurity;
    }

    public void setEnableSpringSecurity(boolean enableSpringSecurity) {
        this.enableSpringSecurity = enableSpringSecurity;
    }

    public List<String> getDispatchServletMappings() {
        return this.dispatchServletMappings;
    }

    public void setDispatchServletMappings(List<String> dispatchServletMappings) {
        this.dispatchServletMappings = dispatchServletMappings;
    }

    public boolean isMapFilters() {
        return this.mapFilters;
    }

    public void setMapFilters(boolean mapFilters) {
        this.mapFilters = mapFilters;
    }

    public ServletContext getServletContext() {
        return super.getServletContext();
    }

    private static /* synthetic */ void lambda$doAdditionalModuleStartLogic$1(ServletRegistration rec$, String xva$0) {
        rec$.addMapping(new String[]{xva$0});
    }
}

