/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.controller.rest;

import java.beans.PropertyEditor;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.coeus.sys.framework.controller.rest.SimpleCrudRestControllerBase;
import org.kuali.coeus.sys.framework.controller.rest.editor.CustomSqlDateEditor;
import org.kuali.coeus.sys.framework.controller.rest.editor.CustomSqlTimestampEditor;
import org.kuali.coeus.sys.framework.rest.UnprocessableEntityException;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.TypeMismatchException;

public class SimpleCrudMapBasedRestController<T>
extends SimpleCrudRestControllerBase<T, Map<String, Object>> {
    private static final Collection<String> IGNORED_FIELDS = Stream.of("versionNumber", "objectId", "updateUser", "updateTimestamp").collect(Collectors.toList());
    private List<String> exposedProperties;

    @Override
    protected Object getPropertyValueFromDto(String propertyName, Map<String, Object> dataObject) {
        return dataObject.get(propertyName);
    }

    @Override
    protected Map<String, Object> convertDataObjectToDto(T dataObject) {
        BeanWrapper beanWrapper = this.getRestBeanWrapperFactory().newInstance(dataObject);
        return this.createMapFromPropsOnBean(beanWrapper);
    }

    @Override
    protected T convertDtoToDataObject(Map<String, Object> input) {
        Object newDataObject = this.getNewDataObject();
        BeanWrapper beanWrapper = this.getRestBeanWrapperFactory().newInstance(newDataObject);
        beanWrapper.setAutoGrowNestedPaths(true);
        beanWrapper.registerCustomEditor(Timestamp.class, (PropertyEditor)new CustomSqlTimestampEditor());
        beanWrapper.registerCustomEditor(Date.class, (PropertyEditor)new CustomSqlDateEditor());
        try {
            this.getExposedProperties().forEach(name -> {
                Object val = input.get(name);
                if (val != null || !this.isPrimitive((String)name)) {
                    beanWrapper.setPropertyValue(name, this.translateValue((String)name, val != null ? val.toString() : null));
                }
            });
        }
        catch (IllegalArgumentException e) {
            this.getExposedProperties().forEach(name -> beanWrapper.setPropertyValue(name, input.get(name)));
        }
        catch (TypeMismatchException e) {
            throw new UnprocessableEntityException(e.getMessage(), e);
        }
        return (T)beanWrapper.getWrappedInstance();
    }

    @Override
    protected void updateDataObjectFromDto(T existingDataObject, Map<String, Object> input) {
        BeanWrapper beanWrapper = this.getRestBeanWrapperFactory().newInstance(existingDataObject);
        beanWrapper.setAutoGrowNestedPaths(true);
        try {
            this.getExposedProperties().forEach(name -> beanWrapper.setPropertyValue(name, input.get(name)));
        }
        catch (TypeMismatchException e) {
            throw new UnprocessableEntityException(e.getMessage(), e);
        }
    }

    @Override
    protected void mergeDataObjectFromDto(T existingDataObject, Map<String, Object> input) {
        BeanWrapper beanWrapper = this.getRestBeanWrapperFactory().newInstance(existingDataObject);
        beanWrapper.setAutoGrowNestedPaths(true);
        try {
            input.forEach((arg_0, arg_1) -> ((BeanWrapper)beanWrapper).setPropertyValue(arg_0, arg_1));
        }
        catch (TypeMismatchException e) {
            throw new UnprocessableEntityException(e.getMessage(), e);
        }
    }

    @Override
    protected List<String> getListOfTrackedProperties() {
        return this.getExposedProperties().stream().filter(p -> !"_primaryKey".equals(p)).collect(Collectors.toList());
    }

    @Override
    protected Map<String, Object> convertObjectToDto(Object o) {
        return (Map)o;
    }

    protected Map<String, Object> createMapFromPropsOnBean(BeanWrapper beanWrapper) {
        Map<String, Object> map = this.getExposedProperties().stream().map(name -> org.kuali.coeus.sys.framework.util.CollectionUtils.entry(name, beanWrapper.getPropertyValue(name))).collect(org.kuali.coeus.sys.framework.util.CollectionUtils.nullSafeEntriesToMap());
        map.put("_primaryKey", this.primaryKeyToString(this.getPrimaryKeyIncomingObject(map)));
        return map;
    }

    @Override
    public List<String> getExposedProperties() {
        if (CollectionUtils.isEmpty(this.exposedProperties)) {
            this.exposedProperties = this.getDefaultProperties();
        }
        return this.exposedProperties;
    }

    public void setExposedProperties(List<String> exposedProperties) {
        this.exposedProperties = exposedProperties;
    }

    public List<String> getDefaultProperties() {
        List<String> fields = this.getPersistenceVerificationService().persistableFields(this.getDataObjectClazz());
        return fields.stream().filter(field -> !IGNORED_FIELDS.contains(field)).collect(Collectors.toList());
    }
}

