/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.bo.AbstractPerson;
import org.kuali.kra.workflow.AbstractProjectPersonDerivedRoleTypeServiceImpl;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class AwardInvestigatorDerivedRoleTypeServiceImpl
extends AbstractProjectPersonDerivedRoleTypeServiceImpl {
    protected List<String> requiredAttributes = new ArrayList<String>();
    private AwardService awardService;
    private ParameterService parameterService;

    public AwardInvestigatorDerivedRoleTypeServiceImpl() {
        this.requiredAttributes.add("award");
    }

    @Override
    protected List<? extends AbstractPerson> getPersons(Map<String, String> qualification) {
        String awardIdStr = qualification.get("award");
        if (StringUtils.isNotBlank((CharSequence)awardIdStr) && awardIdStr.matches("\\d+")) {
            Long awardId = Long.valueOf(awardIdStr);
            Award award = this.getAwardService().getAward(awardId);
            return this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "All", "Include_Derived_Unit_Contacts") != false ? Stream.of(Optional.ofNullable(award.getProjectPersons()).orElse(Collections.emptyList()), Optional.ofNullable(award.getAwardUnitContacts()).orElse(Collections.emptyList())).flatMap(Collection::stream).collect(Collectors.toList()) : award.getProjectPersons();
        }
        return new ArrayList();
    }

    protected AwardService getAwardService() {
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

