/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kuali.coeus.sys.framework.util.ValuesFinderUtils;
import org.kuali.kra.award.home.ValidAwardBasisPayment;
import org.kuali.kra.award.home.ValidBasisMethodPayment;
import org.kuali.kra.award.service.AwardPaymentAndInvoicesService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardPaymentAndInvoicesServiceImpl
implements AwardPaymentAndInvoicesService {
    static final String AWARDTYPECODE = "awardTypeCode";
    static final String VALIDAWARDBASISPAYMENT_ID = "validAwardBasisPaymentId";
    static final String BASISOFPAYMENTCODE = "basisOfPaymentCode";
    static final String METHODOFPAYMENTCODE = "methodOfPaymentCode";
    private static final String AWARDBASISOFPAYMENT_CODE = "basisOfPaymentCode";
    private static final String AWARDMETHODOFPAYMENT_CODE = "methodOfPaymentCode";
    BusinessObjectService businessObjectService;

    @Override
    public String getEncodedValidAwardBasisPaymentsByAwardTypeCode(Integer awardTypeCode) {
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        results.add(ValuesFinderUtils.getSelectOption());
        List<ValidAwardBasisPayment> found = this.getValidAwardBasisPaymentsByAwardTypeCode(awardTypeCode);
        for (ValidAwardBasisPayment current : found) {
            current.refresh();
            results.add((KeyValue)new ConcreteKeyValue(current.getBasisOfPaymentCode(), current.getBasisOfPayment().getDescription()));
        }
        return ValuesFinderUtils.processKeyValueList(results);
    }

    @Override
    public String getEncodedValidBasisMethodPaymentsByBasisCode(String basisOfPaymentCode) {
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        results.add(ValuesFinderUtils.getSelectOption());
        List<ValidBasisMethodPayment> found = this.getValidBasisMethodPaymentByBasisCode(basisOfPaymentCode);
        for (ValidBasisMethodPayment current : found) {
            current.refresh();
            results.add((KeyValue)new ConcreteKeyValue(current.getMethodOfPaymentCode(), current.getMethodOfPayment().getDescription()));
        }
        return ValuesFinderUtils.processKeyValueList(results);
    }

    @Override
    public List<ValidAwardBasisPayment> getValidAwardBasisPaymentsByAwardTypeCode(Integer awardTypeCode) {
        ArrayList<ValidAwardBasisPayment> results = new ArrayList<ValidAwardBasisPayment>(this.businessObjectService.findMatchingOrderBy(ValidAwardBasisPayment.class, Collections.singletonMap(AWARDTYPECODE, awardTypeCode), VALIDAWARDBASISPAYMENT_ID, true));
        return results;
    }

    @Override
    public List<ValidBasisMethodPayment> getValidBasisMethodPaymentByBasisCode(String basisOfPaymentCode) {
        ArrayList<ValidBasisMethodPayment> results = new ArrayList<ValidBasisMethodPayment>(this.businessObjectService.findMatchingOrderBy(ValidBasisMethodPayment.class, Collections.singletonMap("basisOfPaymentCode", basisOfPaymentCode), "methodOfPaymentCode", true));
        return results;
    }

    @Override
    public ValidAwardBasisPayment getValidAwardBasisPayment(Integer validAwardBasisPaymentId) {
        ValidAwardBasisPayment vBasisPayment = (ValidAwardBasisPayment)this.businessObjectService.findByPrimaryKey(ValidAwardBasisPayment.class, Collections.singletonMap(VALIDAWARDBASISPAYMENT_ID, validAwardBasisPaymentId));
        return vBasisPayment;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

