/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.service.impl;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.service.AwardHierarchyUIService;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.StringUtils;

public class AwardHierarchyUIServiceImpl
implements AwardHierarchyUIService {
    private static final String FIELD_NAME_PARENT_AWARD_NUMBER = "parentAwardNumber";
    private static final String FIELD_NAME_AWARD_NUMBER = "awardNumber";
    private static final String DATE_FORMAT_MM_DD_YYYY = "MM/dd/yyyy";
    private static final String LAST_5_CHARS_OF_ROOT = "00001";
    private static final String COLUMN_CODE = "%3A";
    private static final String DOC_FINAL_STATUS_CODE = "F";
    private static final String DOC_NON_FINAL_STATUS_CODE = "N";
    private BusinessObjectService businessObjectService;
    private AwardHierarchyService awardHierarchyService;
    private Map<String, AwardHierarchyNode> awardHierarchyNodes = new HashMap<String, AwardHierarchyNode>();

    AwardHierarchyUIServiceImpl() {
    }

    @Override
    public String getRootAwardNode(String awardNumber, String currentAwardNumber, String currentSequenceNumber) throws ParseException {
        AwardHierarchyNode awardNode;
        if (this.canUseExistingTMSessionObject(awardNumber)) {
            this.awardHierarchyNodes = ((TimeAndMoneyDocument)GlobalVariables.getUserSession().retrieveObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY")).getAwardHierarchyNodes();
            awardNode = this.awardHierarchyNodes.get(awardNumber);
        } else {
            AwardHierarchy hierarchy = this.awardHierarchyService.loadAwardHierarchy(awardNumber);
            if (hierarchy == null) {
                hierarchy = AwardHierarchy.createRootNode(currentAwardNumber);
            }
            awardNode = this.awardHierarchyService.createAwardHierarchyNode(hierarchy, currentAwardNumber, currentSequenceNumber);
        }
        return "[" + this.buildJavascriptRecord(awardNumber, awardNode) + "]";
    }

    @Override
    public AwardHierarchyNode getRootAwardNode(Award award) {
        String awardNumber = award.getAwardNumber();
        AwardHierarchy hierarchy = this.awardHierarchyService.loadAwardHierarchy(awardNumber);
        AwardHierarchyNode awardNode = this.awardHierarchyService.createAwardHierarchyNode(hierarchy, null, null);
        return awardNode;
    }

    protected String buildJavascriptRecord(String awardNumber, AwardHierarchyNode aNode) {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT_MM_DD_YYYY);
        Formatter formatter = Formatter.getFormatter(ScaleTwoDecimal.class);
        sb.append("{");
        this.appendJson(sb, FIELD_NAME_AWARD_NUMBER, awardNumber);
        sb.append(",");
        this.appendJson(sb, "accountNumber", aNode.getAccountNumber());
        sb.append(",");
        this.appendJson(sb, "principalInvestigatorName", aNode.getPrincipalInvestigatorName());
        sb.append(",");
        this.appendJson(sb, "leadUnitName", aNode.getLeadUnitName());
        sb.append(",");
        String titleCleaned = aNode.getTitle().replaceAll("[\\r\\n]", " ");
        titleCleaned = titleCleaned.replaceAll(">", " > ");
        titleCleaned = titleCleaned.replaceAll("<", " < ");
        this.appendJson(sb, "title", titleCleaned);
        sb.append(",");
        this.appendJson(sb, "awardId", aNode.getAwardId().toString());
        sb.append(",");
        this.appendJson(sb, "awardDocumentNumber", aNode.getAwardDocumentNumber());
        sb.append(",");
        this.appendJson(sb, "awardDocumentFinalStatus", aNode.isAwardDocumentFinalStatus());
        sb.append(",");
        this.appendJson(sb, "projectStartDate", aNode.getProjectStartDate(), df);
        sb.append(",");
        this.appendJson(sb, "currentFundEffectiveDate", aNode.getCurrentFundEffectiveDate(), df);
        sb.append(",");
        this.appendJson(sb, "obligationExpirationDate", aNode.getObligationExpirationDate(), df);
        sb.append(",");
        this.appendJson(sb, "finalExpirationDate", aNode.getFinalExpirationDate(), df);
        sb.append(",");
        this.appendJson(sb, "amountObligatedToDate", (String)formatter.format((Object)aNode.getAmountObligatedToDate()));
        sb.append(",");
        this.appendJson(sb, "anticipatedTotalAmount", (String)formatter.format((Object)aNode.getAnticipatedTotalAmount()));
        sb.append(",");
        this.appendJson(sb, "obliDistributableAmount", (String)formatter.format((Object)aNode.getObliDistributableAmount()));
        sb.append(",");
        this.appendJson(sb, "antDistributableAmount", (String)formatter.format((Object)aNode.getAntDistributableAmount()));
        sb.append(",");
        this.appendJson(sb, "distributedObligatedAmount", (String)formatter.format((Object)aNode.getAmountObligatedToDate().subtract((AbstractDecimal)aNode.getObliDistributableAmount())));
        sb.append(",");
        this.appendJson(sb, "distributedAnticipatedAmount", (String)formatter.format((Object)aNode.getAnticipatedTotalAmount().subtract((AbstractDecimal)aNode.getAntDistributableAmount())));
        sb.append(",");
        this.appendJson(sb, "awardStatusCode", aNode.getAwardStatusCode().toString());
        sb.append(",");
        this.appendJson(sb, "obligatedTotalDirect", (String)formatter.format((Object)aNode.getObligatedTotalDirect()));
        sb.append(",");
        this.appendJson(sb, "obligatedTotalIndirect", (String)formatter.format((Object)aNode.getObligatedTotalIndirect()));
        sb.append(",");
        this.appendJson(sb, "anticipatedTotalDirect", (String)formatter.format((Object)aNode.getAnticipatedTotalDirect()));
        sb.append(",");
        this.appendJson(sb, "anticipatedTotalIndirect", (String)formatter.format((Object)aNode.getAnticipatedTotalIndirect()));
        sb.append(",");
        this.appendJson(sb, "hasChildren", aNode.getHasChildren());
        sb.append("}");
        return sb.toString();
    }

    protected String buildCompleteRecord(String awardNumber, AwardHierarchyNode aNode) throws ParseException {
        StringBuilder sb = new StringBuilder();
        if (aNode != null) {
            SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT_MM_DD_YYYY);
            Formatter formatter = Formatter.getFormatter(ScaleTwoDecimal.class);
            sb.append(awardNumber);
            this.appendString(aNode.getAccountNumber(), sb, COLUMN_CODE);
            this.appendString(aNode.getPrincipalInvestigatorName(), sb, ":");
            this.appendString(aNode.getLeadUnitName(), sb, ":");
            this.appendDate(aNode.getCurrentFundEffectiveDate(), sb);
            this.appendDate(aNode.getObligationExpirationDate(), sb);
            this.appendDate(aNode.getFinalExpirationDate(), sb);
            sb.append(" ").append(COLUMN_CODE).append(" ").append(formatter.format((Object)aNode.getAmountObligatedToDate()));
            sb.append(" ").append(COLUMN_CODE).append(" ").append(formatter.format((Object)aNode.getAnticipatedTotalAmount()));
            sb.append(" ").append(COLUMN_CODE).append(" ").append(formatter.format((Object)aNode.getObliDistributableAmount()));
            sb.append(" ").append(COLUMN_CODE).append(" ").append(formatter.format((Object)aNode.getAntDistributableAmount()));
            sb.append(" ").append(COLUMN_CODE).append(" ").append(formatter.format((Object)aNode.getAmountObligatedToDate().subtract((AbstractDecimal)aNode.getObliDistributableAmount())));
            sb.append(" ").append(COLUMN_CODE).append(" ").append(formatter.format((Object)aNode.getAnticipatedTotalAmount().subtract((AbstractDecimal)aNode.getAntDistributableAmount())));
            sb.append(" ").append(COLUMN_CODE).append(" ").append(aNode.getAwardStatusCode());
            sb.append(" ").append(COLUMN_CODE).append(" ").append(formatter.format((Object)aNode.getObligatedTotalDirect()));
            sb.append(" ").append(COLUMN_CODE).append(" ").append(formatter.format((Object)aNode.getObligatedTotalIndirect()));
            sb.append(" ").append(COLUMN_CODE).append(" ").append(formatter.format((Object)aNode.getAnticipatedTotalDirect()));
            sb.append(" ").append(COLUMN_CODE).append(" ").append(formatter.format((Object)aNode.getAnticipatedTotalIndirect()));
            this.appendDate(aNode.getProjectStartDate(), sb);
            sb.append(" ").append(COLUMN_CODE).append(" ").append(aNode.getTitle());
            sb.append(" ").append(COLUMN_CODE).append(" ").append(aNode.getAwardId());
            sb.append(" ").append(COLUMN_CODE).append(" ").append(aNode.getAwardDocumentNumber());
            if (aNode.isAwardDocumentFinalStatus().booleanValue()) {
                sb.append(" ").append(COLUMN_CODE).append(" ").append(DOC_FINAL_STATUS_CODE);
            } else {
                sb.append(" ").append(COLUMN_CODE).append(" ").append(DOC_NON_FINAL_STATUS_CODE);
            }
            sb.append(" ").append(COLUMN_CODE).append(" ");
        }
        return sb.toString();
    }

    @Override
    public String getAwardRecord(Award award) throws ParseException {
        String awardNumber = award.getAwardNumber();
        return this.buildCompleteRecord(awardNumber, this.getAwardHierarchyNodes(award.getAwardNumber(), award.getAwardNumber(), award.getSequenceNumber().toString()).get(awardNumber));
    }

    protected void appendString(String str, StringBuilder sb, String delimiter) {
        if (str != null) {
            sb.append(" ").append(delimiter).append(" ").append(str);
        } else {
            sb.append(" ").append(delimiter).append(" ").append("");
        }
    }

    protected void appendJson(StringBuilder sb, String key, String value) {
        sb.append("\"");
        sb.append(key);
        sb.append("\":\"");
        if (value == null) {
            sb.append("");
        } else {
            sb.append(this.escapeJsonString(value));
        }
        sb.append("\"");
    }

    protected String escapeJsonString(String input) {
        if (input != null) {
            input = input.replaceAll("\\\\", "\\\\\\\\");
            input = input.replaceAll("\"", "\\\\\"");
        }
        return input;
    }

    protected void appendJson(StringBuilder sb, String key, Boolean value) {
        sb.append("\"");
        sb.append(key);
        sb.append("\":");
        if (value == null) {
            sb.append(Boolean.FALSE.toString());
        } else {
            sb.append(value.toString());
        }
    }

    protected void appendJson(StringBuilder sb, String key, Date value, SimpleDateFormat formater) {
        sb.append("\"");
        sb.append(key);
        sb.append("\":\"");
        if (value != null) {
            sb.append(formater.format(value));
        }
        sb.append("\"");
    }

    protected void appendDate(Date date, StringBuilder sb) {
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT_MM_DD_YYYY);
        sb.append(" ").append(COLUMN_CODE).append(" ");
        if (date != null) {
            sb.append(df.format(date));
        } else {
            sb.append("&nbsp;");
        }
    }

    @Override
    public String getSubAwardHierarchiesForTreeView(String awardNumber, String currentAwardNumber, String currentSequenceNumber) throws ParseException {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (AwardHierarchy ah : this.getChildrenNodes(awardNumber)) {
            AwardHierarchyNode aNode = this.getAwardHierarchyNode(ah.getAwardNumber(), currentAwardNumber, currentSequenceNumber, ah);
            sb.append(this.buildJavascriptRecord(ah.getAwardNumber(), aNode));
            sb.append(",");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getSubAwardHierarchiesForTreeViewTandM(String awardNumber, String currentAwardNumber, String currentSequenceNumber) throws ParseException {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Map<String, AwardHierarchyNode> awarHierarchyNodes = this.getAwardHierarchyNodes(awardNumber, currentAwardNumber, currentSequenceNumber);
        for (AwardHierarchy ah : this.getChildrenNodes(awardNumber)) {
            AwardHierarchyNode aNode = awarHierarchyNodes.get(ah.getAwardNumber());
            sb.append(this.buildJavascriptRecord(ah.getAwardNumber(), aNode));
            sb.append(",");
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    protected List<AwardHierarchy> getChildrenNodes(String awardNumber) {
        ArrayList<AwardHierarchy> awardHierarchyList = new ArrayList<AwardHierarchy>();
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(FIELD_NAME_PARENT_AWARD_NUMBER, awardNumber);
        fieldValues.put("active", Boolean.TRUE);
        awardHierarchyList.addAll(this.businessObjectService.findMatchingOrderBy(AwardHierarchy.class, fieldValues, FIELD_NAME_AWARD_NUMBER, true));
        return awardHierarchyList;
    }

    protected boolean canUseExistingTMSessionObject(String awardNumber) {
        String sessionObjectKey = GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY";
        String prefix = null;
        TimeAndMoneyDocument tmDocFromSession = (TimeAndMoneyDocument)GlobalVariables.getUserSession().retrieveObject(sessionObjectKey);
        if (tmDocFromSession == null) {
            return false;
        }
        Map<String, AwardHierarchyNode> tmpNodes = tmDocFromSession.getAwardHierarchyNodes();
        if (tmpNodes != null && CollectionUtils.isNotEmpty(tmpNodes.keySet())) {
            for (String tempAwardNumber : tmpNodes.keySet()) {
                prefix = tempAwardNumber.substring(0, tempAwardNumber.indexOf("-"));
                if (StringUtils.startsWithIgnoreCase((String)awardNumber, (String)prefix)) continue;
                return false;
            }
        }
        return true;
    }

    protected AwardHierarchyNode getAwardHierarchyNode(String awardNumber, String currentAwardNumber, String currentSequenceNumber, AwardHierarchy hierarchy) {
        AwardHierarchyNode returnVal;
        if (this.canUseExistingTMSessionObject(awardNumber)) {
            this.awardHierarchyNodes = ((TimeAndMoneyDocument)GlobalVariables.getUserSession().retrieveObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY")).getAwardHierarchyNodes();
            returnVal = this.awardHierarchyNodes.get(awardNumber);
        } else {
            returnVal = this.awardHierarchyService.createAwardHierarchyNode(hierarchy, currentAwardNumber, currentSequenceNumber);
        }
        return returnVal;
    }

    protected Map<String, AwardHierarchyNode> getAwardHierarchyNodes(String awardNumber, String currentAwardNumber, String currentSequenceNumber) {
        if (this.awardHierarchyNodes == null || this.awardHierarchyNodes.size() == 0 || StringUtils.endsWithIgnoreCase((String)LAST_5_CHARS_OF_ROOT, (String)awardNumber.substring(8))) {
            if (this.canUseExistingTMSessionObject(awardNumber)) {
                this.awardHierarchyNodes = ((TimeAndMoneyDocument)GlobalVariables.getUserSession().retrieveObject(GlobalVariables.getUserSession().getKualiSessionId() + "TIME_AND_MONEY")).getAwardHierarchyNodes();
            } else {
                Map<String, AwardHierarchy> awardHierarchyItems = this.awardHierarchyService.getAwardHierarchy(awardNumber, new ArrayList<String>());
                this.awardHierarchyService.populateAwardHierarchyNodes(awardHierarchyItems, this.awardHierarchyNodes, currentAwardNumber, currentSequenceNumber);
            }
        }
        return this.awardHierarchyNodes;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setAwardHierarchyNodes(Map<String, AwardHierarchyNode> awardHierarchyNodes) {
        this.awardHierarchyNodes = awardHierarchyNodes;
    }

    public AwardHierarchyService getAwardHierarchyService() {
        return this.awardHierarchyService;
    }

    public void setAwardHierarchyService(AwardHierarchyService awardHierarchyService) {
        this.awardHierarchyService = awardHierarchyService;
    }
}

