/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.submit;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.upload.FormFile;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.committee.impl.service.CommitteeServiceBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.IacucProtocolFinderDao;
import org.kuali.kra.iacuc.actions.IacucProtocolSubmissionDoc;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolSubmission;
import org.kuali.kra.iacuc.committee.service.IacucCommitteeService;
import org.kuali.kra.protocol.actions.notify.ProtocolActionAttachment;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class IacucProtocolSubmissionBuilder {
    private static final Logger LOG = LogManager.getLogger(IacucProtocolSubmissionBuilder.class);
    private static final String NEXT_SUBMISSION_NUMBER_KEY = "submissionNumber";
    private static final String NEXT_SUBMISSION_DOCUMENT_ID_KEY = "submissionDocId";
    private IacucProtocolSubmission protocolSubmission;
    private List<ProtocolActionAttachment> actionAttachments = new ArrayList<ProtocolActionAttachment>();

    public IacucProtocolSubmissionBuilder(IacucProtocol protocol, String submissionTypeCode) {
        this.protocolSubmission = new IacucProtocolSubmission();
        this.protocolSubmission.setProtocol(protocol);
        this.protocolSubmission.setProtocolId(protocol.getProtocolId());
        this.protocolSubmission.setProtocolNumber(protocol.getProtocolNumber());
        this.protocolSubmission.setSequenceNumber(protocol.getSequenceNumber());
        this.protocolSubmission.setSubmissionNumber(this.getNextSubmissionNumber(protocol));
        this.protocolSubmission.setSubmissionDate(new Date(System.currentTimeMillis()));
        this.protocolSubmission.setSubmissionTypeCode(submissionTypeCode);
        IacucProtocolSubmission oldSubmission = protocol.getIacucProtocolSubmission();
        this.setValuesFromOldSubmission(this.protocolSubmission, oldSubmission);
        this.protocolSubmission.setSubmissionStatusCode("100");
    }

    private Integer getNextSubmissionNumber(IacucProtocol protocol) {
        Integer nextSubmissionNumber;
        if (protocol.isAmendment() || protocol.isRenewal() || protocol.isFYI()) {
            String origProtocolNumber = protocol.getProtocolNumber();
            String protocolNumber = origProtocolNumber.substring(0, 10);
            IacucProtocol origProtocol = (IacucProtocol)this.getProtocolFinderDao().findCurrentProtocolByNumber(protocolNumber);
            nextSubmissionNumber = origProtocol.getNextValue(NEXT_SUBMISSION_NUMBER_KEY);
            this.getBusinessObjectService().save(origProtocol.getProtocolDocument().getDocumentNextvalues());
        } else {
            nextSubmissionNumber = protocol.getNextValue(NEXT_SUBMISSION_NUMBER_KEY);
        }
        LOG.info("nextsubmissionnumber " + protocol.getProtocolId() + " " + (CollectionUtils.isEmpty(protocol.getProtocolSubmissions()) ? 0 : protocol.getProtocolSubmissions().size()) + "-" + nextSubmissionNumber);
        return nextSubmissionNumber;
    }

    private IacucProtocolFinderDao getProtocolFinderDao() {
        return KcServiceLocator.getService(IacucProtocolFinderDao.class);
    }

    private void setValuesFromOldSubmission(IacucProtocolSubmission newSubmission, IacucProtocolSubmission oldSubmission) {
        if (oldSubmission != null) {
            this.protocolSubmission.setSubmissionTypeQualifierCode(oldSubmission.getSubmissionTypeQualifierCode());
            this.protocolSubmission.setComments(oldSubmission.getComments());
            this.protocolSubmission.setYesVoteCount(oldSubmission.getYesVoteCount());
            this.protocolSubmission.setNoVoteCount(oldSubmission.getNoVoteCount());
            this.protocolSubmission.setAbstainerCount(oldSubmission.getAbstainerCount());
            this.protocolSubmission.setAbstainers(oldSubmission.getAbstainers());
            this.protocolSubmission.setRecusedCount(oldSubmission.getRecusedCount());
            this.protocolSubmission.setRecusers(oldSubmission.getRecusers());
            this.protocolSubmission.setVotingComments(oldSubmission.getVotingComments());
            this.protocolSubmission.setBillable(oldSubmission.isBillable());
        } else {
            this.protocolSubmission.setAbstainerCount(0);
            this.protocolSubmission.setRecusedCount(0);
            this.protocolSubmission.setBillable(false);
        }
    }

    public IacucProtocolSubmission create() {
        this.protocolSubmission.setSubmissionDate(new Date(System.currentTimeMillis()));
        this.getBusinessObjectService().save((PersistableBusinessObject)this.protocolSubmission);
        this.protocolSubmission.getProtocol().getProtocolSubmissions().add(this.protocolSubmission);
        this.saveAttachments();
        return this.protocolSubmission;
    }

    public void setSubmissionTypeQualifierCode(String submissionTypeQualifierCode) {
        this.protocolSubmission.setSubmissionTypeQualifierCode(submissionTypeQualifierCode);
    }

    public void setProtocolReviewTypeCode(String protocolReviewTypeCode) {
        this.protocolSubmission.setProtocolReviewTypeCode(protocolReviewTypeCode);
    }

    public void setSubmissionStatus(String submissionStatusCode) {
        this.protocolSubmission.setSubmissionStatusCode(submissionStatusCode);
    }

    public void setComments(String comments) {
        this.protocolSubmission.setComments(comments);
    }

    public void setCommittee(String committeeId) {
        Object committee = this.getCommitteeService().getCommitteeById(committeeId);
        if (committee != null) {
            this.protocolSubmission.setCommitteeId(((CommitteeBase)committee).getCommitteeId());
            this.protocolSubmission.setCommitteeIdFk(((CommitteeBase)committee).getId());
            this.protocolSubmission.setCommittee((CommitteeBase)committee);
        }
    }

    public void setSchedule(String scheduleId) {
        if (this.protocolSubmission.getCommittee() != null) {
            Object schedule = this.getCommitteeService().getCommitteeSchedule(this.protocolSubmission.getCommittee(), scheduleId);
            if (schedule != null) {
                this.protocolSubmission.setScheduleId(((CommitteeScheduleBase)schedule).getScheduleId());
                this.protocolSubmission.setScheduleIdFk(((CommitteeScheduleBase)schedule).getId());
                this.protocolSubmission.setCommitteeSchedule((CommitteeScheduleBase)schedule);
            } else {
                this.clearCommScheduleDataFromPreviousSubmission();
            }
        } else {
            this.clearCommScheduleDataFromPreviousSubmission();
        }
    }

    private void clearCommScheduleDataFromPreviousSubmission() {
        this.protocolSubmission.setScheduleId(null);
        this.protocolSubmission.setScheduleIdFk(null);
        this.protocolSubmission.setCommitteeSchedule(null);
    }

    private void saveAttachments() {
        for (ProtocolActionAttachment attachment : this.actionAttachments) {
            this.saveAttachment(attachment.getFile(), attachment.getDescription());
        }
    }

    private void saveAttachment(FormFile file, String description) {
        try {
            byte[] data = file.getFileData();
            if (data.length > 0) {
                IacucProtocolSubmissionDoc submissionDoc = IacucProtocolSubmissionBuilder.createProtocolSubmissionDoc(this.protocolSubmission, file.getFileName(), file.getContentType(), data, description);
                this.getBusinessObjectService().save((PersistableBusinessObject)submissionDoc);
            }
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static IacucProtocolSubmissionDoc createProtocolSubmissionDoc(IacucProtocolSubmission submission, String fileName, String contentType, byte[] document, String description) {
        IacucProtocolSubmissionDoc submissionDoc = new IacucProtocolSubmissionDoc();
        submissionDoc.setProtocolNumber(submission.getProtocolNumber());
        submissionDoc.setSequenceNumber(submission.getSequenceNumber());
        submissionDoc.setSubmissionNumber(submission.getSubmissionNumber());
        submissionDoc.setProtocolId(submission.getProtocolId());
        submissionDoc.setSubmissionIdFk(submission.getSubmissionId());
        submissionDoc.setProtocol(submission.getProtocol());
        submissionDoc.setProtocolSubmission(submission);
        submissionDoc.setDocumentId(submission.getProtocol().getNextValue(NEXT_SUBMISSION_DOCUMENT_ID_KEY));
        submissionDoc.setFileName(fileName);
        submissionDoc.setDocument(document);
        submissionDoc.setDescription(description);
        submissionDoc.setContentType(contentType);
        return submissionDoc;
    }

    private CommitteeServiceBase getCommitteeService() {
        return KcServiceLocator.getService(IacucCommitteeService.class);
    }

    private BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    public List<ProtocolActionAttachment> getActionAttachments() {
        return this.actionAttachments;
    }

    public void setActionAttachments(List<ProtocolActionAttachment> actionAttachments) {
        this.actionAttachments = actionAttachments;
    }
}

