/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.committee.print.service.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.kuali.coeus.common.committee.impl.print.CommitteeReportType;
import org.kuali.coeus.common.committee.impl.print.ScheduleTemplatePrintBase;
import org.kuali.coeus.common.committee.impl.print.TemplatePrintBase;
import org.kuali.coeus.common.framework.print.AbstractPrint;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.Printable;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.common.impl.print.PrintingServiceImpl;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.committee.print.IacucCommitteeFutureScheduledMeetingsPrint;
import org.kuali.kra.iacuc.committee.print.IacucCommitteeRosterPrint;
import org.kuali.kra.iacuc.committee.print.IacucCommitteeTemplatePrint;
import org.kuali.kra.iacuc.committee.print.IacucProtocolBatchCorrespondencePrint;
import org.kuali.kra.iacuc.committee.print.IacucProtocolCorrespondenceTemplatePrint;
import org.kuali.kra.iacuc.committee.print.IacucScheduleTemplatePrint;
import org.kuali.kra.iacuc.committee.print.service.IacucCommitteePrintingService;

public class IacucCommitteePrintingServiceImpl
extends PrintingServiceImpl
implements IacucCommitteePrintingService {
    private static final String ERROR_MESSAGE = "Unknown report type specified";
    private IacucCommitteeTemplatePrint committeeTemplatePrint;
    private ScheduleTemplatePrintBase scheduleTemplatePrint;
    private IacucProtocolCorrespondenceTemplatePrint protocolCorrespondenceTemplatePrint;
    private IacucProtocolBatchCorrespondencePrint protocolBatchCorrespondencePrint;
    private IacucCommitteeRosterPrint committeeRosterPrint;
    private IacucCommitteeFutureScheduledMeetingsPrint committeeFutureScheduledMeetingsPrint;

    @Override
    public AbstractPrint getCommitteePrintable(CommitteeReportType reportType, String committeeId) {
        AbstractPrint printable = null;
        switch (reportType) {
            case COMMITTEE_TEMPLATE: {
                printable = this.getCommitteeTemplatePrint();
                break;
            }
            case SCHEDULE_TEMPLATE: {
                printable = this.getScheduleTemplatePrint();
                break;
            }
            case PROTOCOL_CORRESPONDENCE_TEMPLATE: {
                printable = this.getProtocolCorrespondenceTemplatePrint();
                break;
            }
            case ROSTER: {
                printable = this.getCommitteeRosterPrint();
                break;
            }
            case FUTURE_SCHEDULED_MEETINGS: {
                printable = this.getCommitteeFutureScheduledMeetingsPrint();
                break;
            }
            case PROTOCOL_BATCH_CORRESPONDENCE: {
                printable = this.getProtocolBatchCorrespondencePrint();
                break;
            }
            default: {
                throw new IllegalArgumentException(ERROR_MESSAGE);
            }
        }
        if (printable instanceof TemplatePrintBase) {
            TemplatePrintBase printBase = printable;
            printBase.setCommitteeId(committeeId);
        }
        return printable;
    }

    @Override
    public AttachmentDataSource print(List<Printable> printableArtifactList) throws PrintingException {
        AttachmentDataSource attachmentDataSource = super.print(printableArtifactList);
        String fileName = "CommitteeReport.pdf";
        try {
            attachmentDataSource.setName(URLEncoder.encode(fileName, StandardCharsets.UTF_8.name()));
        }
        catch (UnsupportedEncodingException e) {
            attachmentDataSource.setName(fileName);
        }
        attachmentDataSource.setType("application/pdf");
        return attachmentDataSource;
    }

    public IacucCommitteeTemplatePrint getCommitteeTemplatePrint() {
        return this.committeeTemplatePrint;
    }

    public void setCommitteeTemplatePrint(IacucCommitteeTemplatePrint committeeTemplatePrint) {
        this.committeeTemplatePrint = committeeTemplatePrint;
    }

    public ScheduleTemplatePrintBase getScheduleTemplatePrint() {
        if (this.scheduleTemplatePrint == null) {
            this.scheduleTemplatePrint = KcServiceLocator.getService(IacucScheduleTemplatePrint.class);
        }
        return this.scheduleTemplatePrint;
    }

    public void setScheduleTemplatePrint(ScheduleTemplatePrintBase scheduleTemplatePrint) {
        this.scheduleTemplatePrint = scheduleTemplatePrint;
    }

    public IacucProtocolCorrespondenceTemplatePrint getProtocolCorrespondenceTemplatePrint() {
        return this.protocolCorrespondenceTemplatePrint;
    }

    public void setProtocolCorrespondenceTemplatePrint(IacucProtocolCorrespondenceTemplatePrint protocolCorrespondenceTemplatePrint) {
        this.protocolCorrespondenceTemplatePrint = protocolCorrespondenceTemplatePrint;
    }

    public IacucCommitteeRosterPrint getCommitteeRosterPrint() {
        return this.committeeRosterPrint;
    }

    public void setCommitteeRosterPrint(IacucCommitteeRosterPrint committeeRosterPrint) {
        this.committeeRosterPrint = committeeRosterPrint;
    }

    public IacucCommitteeFutureScheduledMeetingsPrint getCommitteeFutureScheduledMeetingsPrint() {
        return this.committeeFutureScheduledMeetingsPrint;
    }

    public void setCommitteeFutureScheduledMeetingsPrint(IacucCommitteeFutureScheduledMeetingsPrint committeeFutureScheduledMeetingsPrint) {
        this.committeeFutureScheduledMeetingsPrint = committeeFutureScheduledMeetingsPrint;
    }

    public void setProtocolBatchCorrespondencePrint(IacucProtocolBatchCorrespondencePrint protocolBatchCorrespondencePrint) {
        this.protocolBatchCorrespondencePrint = protocolBatchCorrespondencePrint;
    }

    public IacucProtocolBatchCorrespondencePrint getProtocolBatchCorrespondencePrint() {
        return this.protocolBatchCorrespondencePrint;
    }
}

