/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.personnel;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.iacuc.IacucPersonTraining;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.iacuc.procedures.IacucProcedurePersonResponsible;
import org.kuali.kra.iacuc.procedures.IacucProtocolProcedureService;
import org.kuali.kra.iacuc.procedures.IacucProtocolSpeciesStudyGroup;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;

public class IacucProtocolPerson
extends ProtocolPersonBase {
    private static final long serialVersionUID = 6676849646094141708L;
    private String procedureQualificationDescription;
    private List<IacucPersonTraining> iacucPersonTrainings;
    private static final String PERSON_TRAINED_TRUE = "Yes";
    private static final String PERSON_TRAINED_FALSE = "No";
    private List<IacucProcedurePersonResponsible> iacucProcedurePersonResponsibleList;
    private List<IacucProtocolSpeciesStudyGroup> procedureDetails;
    private boolean allProceduresSelected;

    public IacucProtocolPerson() {
        this.setIacucPersonTrainings(new ArrayList<IacucPersonTraining>());
    }

    @Override
    protected String getModuleNamespace() {
        return "KC-IACUC";
    }

    public IacucProtocol getIacucProtocol() {
        return (IacucProtocol)this.getProtocol();
    }

    public String getProcedureQualificationDescription() {
        return this.procedureQualificationDescription;
    }

    public void setProcedureQualificationDescription(String procedureQualificationDescription) {
        this.procedureQualificationDescription = procedureQualificationDescription;
    }

    public List<IacucPersonTraining> getIacucPersonTrainings() {
        return this.iacucPersonTrainings;
    }

    public void setIacucPersonTrainings(List<IacucPersonTraining> iacucPersonTrainings) {
        this.iacucPersonTrainings = iacucPersonTrainings;
    }

    public String getPersonTrainedStatus() {
        return this.getIacucPersonTrainings().size() > 0 ? PERSON_TRAINED_TRUE : PERSON_TRAINED_FALSE;
    }

    protected void postLoad() {
        super.postLoad();
        this.setIacucPersonTrainings(this.getIacucProtocolProcedureService().getIacucPersonTrainingDetails(this.getPersonId()));
    }

    @Override
    protected void postPersist() {
        super.postPersist();
        this.setIacucPersonTrainings(this.getIacucProtocolProcedureService().getIacucPersonTrainingDetails(this.getPersonId()));
    }

    protected IacucProtocolProcedureService getIacucProtocolProcedureService() {
        return (IacucProtocolProcedureService)KcServiceLocator.getService("iacucProtocolProcedureService");
    }

    public List<IacucProtocolSpeciesStudyGroup> getProcedureDetails() {
        return this.procedureDetails;
    }

    public void setProcedureDetails(List<IacucProtocolSpeciesStudyGroup> procedureDetails) {
        this.procedureDetails = procedureDetails;
    }

    public boolean isAllProceduresSelected() {
        return this.allProceduresSelected;
    }

    public void setAllProceduresSelected(boolean allProceduresSelected) {
        this.allProceduresSelected = allProceduresSelected;
    }

    public List<IacucProcedurePersonResponsible> getIacucProcedurePersonResponsibleList() {
        return this.iacucProcedurePersonResponsibleList;
    }

    public void setIacucProcedurePersonResponsibleList(List<IacucProcedurePersonResponsible> iacucProcedurePersonResponsibleList) {
        this.iacucProcedurePersonResponsibleList = iacucProcedurePersonResponsibleList;
    }
}

