/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.coi.framework.ProjectRetrievalService;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.notification.impl.NotificationRenderer;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.print.QuestionnairePrintingService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.committee.bo.CommitteeBatchCorrespondenceDetail;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolFinderDao;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.actions.IrbProtocolActionRequestService;
import org.kuali.kra.irb.actions.ProtocolSubmissionBeanBase;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewService;
import org.kuali.kra.irb.actions.notification.ProtocolNotificationRequestBean;
import org.kuali.kra.irb.actions.request.ProtocolRequestBean;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.irb.correspondence.ProtocolCorrespondence;
import org.kuali.kra.irb.notification.IRBNotificationContext;
import org.kuali.kra.irb.notification.IRBNotificationRenderer;
import org.kuali.kra.irb.notification.IRBProtocolNotification;
import org.kuali.kra.irb.onlinereview.ProtocolOnlineReviewService;
import org.kuali.kra.irb.personnel.ProtocolPersonTrainingService;
import org.kuali.kra.irb.personnel.ProtocolPersonnelService;
import org.kuali.kra.protocol.ProtocolActionBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.kra.protocol.notification.ProtocolNotification;
import org.kuali.kra.protocol.notification.ProtocolNotificationContextBase;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

public abstract class ProtocolAction
extends ProtocolActionBase {
    public static final String PROTOCOL_NAME_HOOK = "protocol";
    public static final String PROTOCOL_QUESTIONNAIRE_HOOK = "questionnaire";
    public static final String PROTOCOL_PERSONNEL_HOOK = "personnel";
    public static final String PROTOCOL_SPECIAL_REVIEW_HOOK = "specialReview";
    public static final String PROTOCOL_NOTE_ATTACHMENT_HOOK = "noteAndAttachment";
    public static final String PROTOCOL_ACTIONS_HOOK = "protocolActions";
    public static final String PROTOCOL_ONLINE_REVIEW_HOOK = "onlineReview";
    public static final String PROTOCOL_PERMISSIONS_HOOK = "permissions";
    public static final String PROTOCOL_CUSTOM_DATA_HOOK = "customData";
    public static final String PROTOCOL_MEDUSA = "medusa";
    public static final String PROTOCOL_HISTORY_HOOK = "protocolHistory";
    private static final Logger LOG = LogManager.getLogger(ProtocolAction.class);
    private static final String PROTOCOL_NUMBER = "protocolNumber";
    private static final String SUBMISSION_NUMBER = "submissionNumber";
    private static final String SUFFIX_T = "T";
    private static final String NOT_FOUND_SELECTION = "The attachment was not found for selection ";
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;
    public static final String TEMPLATE = "template";
    public static final String SEQUENCE_NUMBER = "sequenceNumber";
    private transient ProjectRetrievalService projectRetrievalService;
    private transient ProtocolAmendRenewService protocolAmendRenewService;

    protected ProtocolSubmissionBeanBase getSubmissionBean(ActionForm form, String submissionActionType) {
        ProtocolRequestBean submissionBean = null;
        submissionBean = "116".equals(submissionActionType) ? ((ProtocolForm)form).getActionHelper().getProtocolNotifyIrbBean() : ((ProtocolForm)form).getActionHelper().getRequestBean(submissionActionType);
        return submissionBean;
    }

    @Override
    public ActionForward customData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ((ProtocolForm)form).getCustomDataHelper().prepareCustomData();
        return this.branchToPanelOrNotificationEditor(mapping, (ProtocolFormBase)form, this.getCustomDataForwardNameHook());
    }

    public ActionForward medusa(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (protocolForm.getProtocolDocument().getDocumentNumber() == null) {
            this.loadDocument((KualiDocumentFormBase)protocolForm);
        }
        protocolForm.getMedusaBean().setMedusaViewRadio("0");
        protocolForm.getMedusaBean().setModuleName("irb");
        protocolForm.getMedusaBean().setModuleIdentifier(protocolForm.getProtocolDocument().getProtocol().getProtocolId());
        protocolForm.getMedusaBean().generateParentNodes();
        return this.branchToPanelOrNotificationEditor(mapping, protocolForm, PROTOCOL_MEDUSA);
    }

    @Override
    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String docIdRequestParameter;
        ActionForward forward = null;
        ProtocolForm protocolForm = (ProtocolForm)form;
        String command = protocolForm.getCommand();
        if (command.startsWith("displayDocSearchViewdetailId")) {
            String detailId = command.substring("displayDocSearchViewdetailId".length());
            protocolForm.setDetailId(detailId);
            this.viewBatchCorrespondence(mapping, (ActionForm)protocolForm, request, response);
            return RESPONSE_ALREADY_HANDLED;
        }
        if ("displayActionListInlineView".equals(command)) {
            docIdRequestParameter = request.getParameter("docId");
            Document retrievedDocument = KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
            protocolForm.setDocument(retrievedDocument);
            request.setAttribute("docId", (Object)docIdRequestParameter);
            forward = mapping.findForward("copyProposal");
            forward = new ActionForward(forward.getPath() + "?docId=" + docIdRequestParameter);
        } else if (PROTOCOL_ACTIONS_HOOK.equals(command) || PROTOCOL_ONLINE_REVIEW_HOOK.equals(command)) {
            docIdRequestParameter = request.getParameter("docId");
            Document retrievedDocument = KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
            protocolForm.setDocument(retrievedDocument);
            request.setAttribute("docId", (Object)docIdRequestParameter);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
        } else {
            forward = super.docHandler(mapping, form, request, response);
        }
        if ("initiate".equals(protocolForm.getCommand())) {
            protocolForm.getProtocolDocument().initialize();
        } else {
            protocolForm.initialize();
        }
        String protocolNumber = protocolForm.getProtocolDocument().getProtocol().getProtocolNumber();
        if (protocolNumber != null) {
            this.getProtocolAmendRenewService().refreshCacheForProtocol(protocolNumber);
        }
        if (PROTOCOL_ACTIONS_HOOK.equals(command)) {
            forward = this.protocolActions(mapping, (ActionForm)protocolForm, request, response);
        }
        if (PROTOCOL_ONLINE_REVIEW_HOOK.equals(command)) {
            forward = this.onlineReview(mapping, (ActionForm)protocolForm, request, response);
        }
        if (PROTOCOL_HISTORY_HOOK.equals(command)) {
            forward = this.protocolHistory(mapping, (ActionForm)protocolForm, request, response);
        }
        return forward;
    }

    @Override
    protected String getProtocolHistoryForwardNameHook() {
        return PROTOCOL_HISTORY_HOOK;
    }

    @Override
    protected ProtocolPersonTrainingService getProtocolPersonTrainingService() {
        return (ProtocolPersonTrainingService)KcServiceLocator.getService("protocolPersonTrainingService");
    }

    @Override
    protected ProtocolPersonnelService getProtocolPersonnelService() {
        return (ProtocolPersonnelService)KcServiceLocator.getService("protocolPersonnelService");
    }

    protected ProtocolOnlineReviewService getProtocolOnlineReviewService() {
        return KcServiceLocator.getService(ProtocolOnlineReviewService.class);
    }

    public ActionForward printSubmissionQuestionnaireAnswer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Protocol protocol;
        ActionForward forward = mapping.findForward("basic");
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        AnswerHeader answerHeader = this.getAnswerHeader(request);
        reportParameters.put("questionnaireSeqId", answerHeader.getQuestionnaire().getQuestionnaireSeqIdAsInteger());
        reportParameters.put(TEMPLATE, answerHeader.getQuestionnaire().getTemplate());
        if ("2".equals(answerHeader.getModuleSubItemCode())) {
            reportParameters.put(PROTOCOL_NUMBER, answerHeader.getModuleItemKey());
            reportParameters.put(SUBMISSION_NUMBER, answerHeader.getModuleSubItemKey());
            protocol = this.getProtocolFinder().findCurrentProtocolByNumber(this.getProtocolNumber(answerHeader));
        } else {
            HashMap<String, String> keyValues = new HashMap<String, String>();
            keyValues.put(PROTOCOL_NUMBER, answerHeader.getModuleItemKey());
            keyValues.put(SEQUENCE_NUMBER, answerHeader.getModuleSubItemKey());
            protocol = (Protocol)((List)this.getBusinessObjectService().findMatching(Protocol.class, keyValues)).get(0);
        }
        AttachmentDataSource dataStream = this.getQuestionnairePrintingService().printQuestionnaireAnswer(protocol, reportParameters);
        if (dataStream.getData() != null) {
            this.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    private AnswerHeader getAnswerHeader(HttpServletRequest request) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("id", Integer.toString(this.getSelectedLine(request)));
        return (AnswerHeader)this.getBusinessObjectService().findByPrimaryKey(AnswerHeader.class, fieldValues);
    }

    @Override
    protected QuestionnairePrintingService getQuestionnairePrintingService() {
        return KcServiceLocator.getService(QuestionnairePrintingService.class);
    }

    private String getProtocolNumber(AnswerHeader answerHeader) {
        String protocolNumber = answerHeader.getModuleItemKey();
        if (protocolNumber.endsWith(SUFFIX_T)) {
            protocolNumber = protocolNumber.substring(0, protocolNumber.length() - 1);
        }
        return protocolNumber;
    }

    private ProtocolFinderDao getProtocolFinder() {
        return KcServiceLocator.getService(ProtocolFinderDao.class);
    }

    private void viewBatchCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        HashMap<String, Object> primaryKeys = new HashMap<String, Object>();
        primaryKeys.put("committeeBatchCorrespondenceDetailId", protocolForm.getDetailId());
        CommitteeBatchCorrespondenceDetail batchCorrespondenceDetail = (CommitteeBatchCorrespondenceDetail)this.getBusinessObjectService().findByPrimaryKey(CommitteeBatchCorrespondenceDetail.class, primaryKeys);
        primaryKeys.clear();
        primaryKeys.put("id", batchCorrespondenceDetail.getProtocolCorrespondenceId());
        ProtocolCorrespondence attachment = (ProtocolCorrespondence)this.getBusinessObjectService().findByPrimaryKey(ProtocolCorrespondence.class, primaryKeys);
        if (attachment == null) {
            LOG.info("The attachment was not found for selection detailID: " + protocolForm.getDetailId());
        } else {
            this.streamToResponse(attachment.getCorrespondence(), StringUtils.replace((String)attachment.getProtocolCorrespondenceType().getDescription(), (String)" ", (String)"") + ".pdf", "application/pdf", response);
        }
    }

    @Override
    protected void sendNotification(ProtocolFormBase protocolForm) {
        Protocol protocol = (Protocol)protocolForm.getProtocolDocument().getProtocol();
        IRBNotificationRenderer renderer = new IRBNotificationRenderer(protocol);
        IRBNotificationContext context = new IRBNotificationContext(protocol, "320", "Created", (NotificationRenderer)renderer);
        KcNotificationService notificationService = KcServiceLocator.getService(KcNotificationService.class);
        notificationService.sendNotificationAndPersist(context, new IRBProtocolNotification(), protocol);
    }

    @Override
    protected String getProtocolForwardNameHook() {
        return PROTOCOL_NAME_HOOK;
    }

    @Override
    protected String getQuestionnaireForwardNameHook() {
        return PROTOCOL_QUESTIONNAIRE_HOOK;
    }

    @Override
    protected String getPersonnelForwardNameHook() {
        return PROTOCOL_PERSONNEL_HOOK;
    }

    @Override
    protected String getNoteAndAttachmentForwardNameHook() {
        return PROTOCOL_NOTE_ATTACHMENT_HOOK;
    }

    @Override
    protected String getProtocolActionsForwardNameHook() {
        return PROTOCOL_ACTIONS_HOOK;
    }

    @Override
    protected String getProtocolOnlineReviewForwardNameHook() {
        return PROTOCOL_ONLINE_REVIEW_HOOK;
    }

    @Override
    protected String getProtocolPermissionsForwardNameHook() {
        return PROTOCOL_PERMISSIONS_HOOK;
    }

    @Override
    protected String getSpecialReviewForwardNameHook() {
        return PROTOCOL_SPECIAL_REVIEW_HOOK;
    }

    @Override
    protected String getCustomDataForwardNameHook() {
        return PROTOCOL_CUSTOM_DATA_HOOK;
    }

    @Override
    protected ProtocolNotification getProtocolNotificationHook() {
        return new IRBProtocolNotification();
    }

    @Override
    protected ProtocolTaskBase createNewModifyProtocolTaskInstanceHook(ProtocolBase protocol) {
        return new ProtocolTask("modifyProtocol", (Protocol)protocol);
    }

    @Override
    protected void initialDocumentSaveAddRolesHook(String userId, ProtocolBase protocol) {
        KcAuthorizationService kraAuthService = this.getKraAuthorizationService();
        kraAuthService.addDocumentLevelRole(userId, "Protocol Aggregator", protocol);
        kraAuthService.addDocumentLevelRole(userId, "ProtocolApprover", protocol);
    }

    @Override
    protected String getProtocolOnlineReviewMappingNameHoook() {
        return PROTOCOL_ONLINE_REVIEW_HOOK;
    }

    @Override
    protected String getProtocolActionsMappingNameHoook() {
        return PROTOCOL_ACTIONS_HOOK;
    }

    @Override
    protected String getProtocolNotificationEditorHook() {
        return "protocolNotificationEditor";
    }

    @Override
    protected ProtocolNotificationContextBase getProtocolInitialSaveNotificationContextHook(ProtocolBase protocol) {
        IRBNotificationRenderer renderer = new IRBNotificationRenderer((Protocol)protocol);
        return new IRBNotificationContext((Protocol)protocol, "320", "Protocol Created", renderer, PROTOCOL_NAME_HOOK);
    }

    protected IrbProtocolActionRequestService getProtocolActionRequestService() {
        return KcServiceLocator.getService(IrbProtocolActionRequestService.class);
    }

    protected ProtocolCorrespondence getProtocolCorrespondence(ProtocolForm protocolForm, String forwardName, ProtocolNotificationRequestBean notificationRequestBean, boolean holdingPage) {
        boolean result = false;
        HashMap<String, Long> keyValues = new HashMap<String, Long>();
        keyValues.put("actionIdFk", protocolForm.getProtocolDocument().getProtocol().getLastProtocolAction().getProtocolActionId());
        List correspondences = (List)this.getBusinessObjectService().findMatching(ProtocolCorrespondence.class, keyValues);
        if (correspondences.isEmpty()) {
            return null;
        }
        ProtocolCorrespondence correspondence = (ProtocolCorrespondence)correspondences.get(0);
        correspondence.setForwardName(forwardName);
        correspondence.setNotificationRequestBean(notificationRequestBean);
        correspondence.setHoldingPage(holdingPage);
        return correspondence;
    }

    @Override
    public void postSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.postSave(mapping, form, request, response);
        ProtocolForm protocolForm = (ProtocolForm)form;
        String lastProtocolActionTypeCode = protocolForm.getProtocolDocument().getProtocol().getLastProtocolAction().getProtocolActionTypeCode();
        ProtocolCorrespondence protocolCorrespondence = this.getProtocolCorrespondence(protocolForm, "", null, false);
        if (protocolCorrespondence == null && lastProtocolActionTypeCode.equalsIgnoreCase("100")) {
            this.getProtocolActionRequestService().createProtocol(protocolForm);
        }
    }

    @Override
    public ProjectRetrievalService getProjectRetrievalService() {
        if (this.projectRetrievalService == null) {
            this.projectRetrievalService = (ProjectRetrievalService)KcServiceLocator.getService("irbProjectRetrievalService");
        }
        return this.projectRetrievalService;
    }

    public void setProjectRetrievalService(ProjectRetrievalService projectRetrievalService) {
        this.projectRetrievalService = projectRetrievalService;
    }

    public ProtocolAmendRenewService getProtocolAmendRenewService() {
        if (this.protocolAmendRenewService == null) {
            this.protocolAmendRenewService = (ProtocolAmendRenewService)KcServiceLocator.getService("protocolAmendRenewService");
        }
        return this.protocolAmendRenewService;
    }

    public void setProtocolAmendRenewService(ProtocolAmendRenewService protocolAmendRenewService) {
        this.protocolAmendRenewService = protocolAmendRenewService;
    }
}

