/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions.history;

import java.util.Date;
import org.kuali.coeus.sys.framework.rule.KcBusinessRule;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.irb.actions.history.ProtocolHistoryFilterDatesEvent;

public class ProtocolHistoryFilterDatesRule
extends KcTransactionalDocumentRuleBase
implements KcBusinessRule<ProtocolHistoryFilterDatesEvent> {
    private static final String BEGINNING_ON_DATE = "Beginning On Date";
    private static final String ENDING_ON_DATE = "Ending On Date";

    @Override
    public boolean processRules(ProtocolHistoryFilterDatesEvent event) {
        boolean isValid = true;
        Date startDate = event.getStartDate();
        Date endDate = event.getEndDate();
        if (startDate == null) {
            this.reportError("actionHelper.filteredHistoryStartDate", "error.required", BEGINNING_ON_DATE);
            isValid = false;
        }
        if (endDate == null) {
            this.reportError("actionHelper.filteredHistoryEndDate", "error.required", ENDING_ON_DATE);
            isValid = false;
        }
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            this.reportError("actionHelper.filteredHistoryStartDate", "error.start.date.after.end.date", BEGINNING_ON_DATE, ENDING_ON_DATE);
            isValid = false;
        }
        return isValid;
    }
}

