/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.kim.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeMembershipBase;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public class ActiveCommitteeMemberOnIacucProtocolDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    protected List<String> requiredAttributes = new ArrayList<String>();

    public ActiveCommitteeMemberOnIacucProtocolDerivedRoleTypeServiceImpl() {
        this.requiredAttributes.add("protocol");
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        CommitteeBase committee;
        ProtocolBase protocol;
        this.validateRequiredAttributesAgainstReceived(qualification);
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        String protocolNumber = qualification.get("protocol");
        if (StringUtils.isNotBlank((CharSequence)protocolNumber) && (protocol = this.getProtocolByNumber(protocolNumber)) != null && protocol.getProtocolSubmission() != null && (committee = protocol.getProtocolSubmission().getCommittee()) != null) {
            for (CommitteeMembershipBase membership : committee.getCommitteeMemberships()) {
                if (membership.getPersonId() == null || !membership.isActive() || !this.isMemberInProtocol(protocol, membership.getPersonId())) continue;
                members.add(RoleMembership.Builder.create(null, null, (String)membership.getPersonId(), (MemberType)MemberType.PRINCIPAL, null).build());
            }
        }
        return members;
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        CommitteeBase committee;
        ProtocolBase protocol;
        this.validateRequiredAttributesAgainstReceived(qualification);
        String protocolNumber = qualification.get("protocol");
        if (StringUtils.isNotBlank((CharSequence)protocolNumber) && (protocol = this.getProtocolByNumber(protocolNumber)) != null && protocol.getProtocolSubmission() != null && (committee = protocol.getProtocolSubmission().getCommittee()) != null) {
            for (CommitteeMembershipBase membership : committee.getCommitteeMemberships()) {
                if (membership.getPersonId() == null || !StringUtils.equals((CharSequence)principalId, (CharSequence)membership.getPersonId())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMemberInProtocol(ProtocolBase protocol, String memberPersonId) {
        List<ProtocolPersonBase> protocolPersons = protocol.getProtocolPersons();
        for (ProtocolPersonBase protocolPerson : protocolPersons) {
            if (!protocolPerson.getPersonId().equalsIgnoreCase(memberPersonId)) continue;
            return true;
        }
        return false;
    }

    private ProtocolBase getProtocolByNumber(String protocolNumber) {
        HashMap<String, String> keymap = new HashMap<String, String>();
        keymap.put("protocolNumber", protocolNumber);
        return (ProtocolBase)this.getBusinessObjectService().findByPrimaryKey(IacucProtocol.class, keymap);
    }

    public boolean dynamicRoleMembership(String namespaceCode, String roleName) {
        super.dynamicRoleMembership(namespaceCode, roleName);
        return true;
    }
}

