/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.auth;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.auth.SystemAuthorizationService;
import org.kuali.coeus.common.framework.auth.perm.KcAuthorizationService;
import org.kuali.coeus.common.framework.auth.perm.Permissionable;
import org.kuali.kra.protocol.auth.UnitAclLoadService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.type.KimType;

public class UnitAclLoadServiceImpl
implements UnitAclLoadService {
    private KcAuthorizationService kraAuthorizationService;
    private RoleService roleManagementService;
    private SystemAuthorizationService systemAuthorizationService;

    public void setKraAuthorizationService(KcAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    public void setRoleManagementService(RoleService roleManagementService) {
        this.roleManagementService = roleManagementService;
    }

    public void setSystemAuthorizationService(SystemAuthorizationService systemAuthorizationService) {
        this.systemAuthorizationService = systemAuthorizationService;
    }

    @Override
    public void loadUnitAcl(Permissionable permissionable, String creatorPrincipalId) {
        HashMap<CallSite, String> roleIdMap = new HashMap<CallSite, String>();
        Collection<RoleMembership> kraRoleTemplates = this.getDocumentDefaultAcl(permissionable.getLeadUnitNumber(), permissionable.getDocumentRoleTypeCode());
        for (RoleMembership kraRoleTemplate : kraRoleTemplates) {
            String key;
            String personId = kraRoleTemplate.getMemberId();
            if (personId == null || StringUtils.equals((CharSequence)personId, (CharSequence)creatorPrincipalId) || !StringUtils.isEmpty((CharSequence)((CharSequence)roleIdMap.get(key = kraRoleTemplate.getRoleId() + "|" + personId)))) continue;
            Role role = this.roleManagementService.getRole(kraRoleTemplate.getRoleId());
            roleIdMap.put((CallSite)((Object)key), role.getName());
            this.kraAuthorizationService.addDocumentLevelRole(personId, role.getName(), permissionable);
        }
    }

    protected Collection<RoleMembership> getDocumentDefaultAcl(String unitNumber, String documentTypeCode) {
        HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
        qualifiedRoleAttributes.put("unitNumber", unitNumber);
        ArrayList<String> roleIds = new ArrayList<String>();
        List<Role> roles = this.systemAuthorizationService.getRoles(documentTypeCode);
        for (Role role : roles) {
            if (!this.isAccessListRole(role)) continue;
            roleIds.add(role.getId());
        }
        List membershipInfoList = this.roleManagementService.getRoleMembers(roleIds, new HashMap(qualifiedRoleAttributes));
        return membershipInfoList;
    }

    protected boolean isAccessListRole(Role role) {
        KimType type = this.systemAuthorizationService.getKimTypeInfoForRole(role);
        return !StringUtils.startsWith((CharSequence)type.getName(), (CharSequence)"Derived Role") && !StringUtils.startsWith((CharSequence)type.getName(), (CharSequence)"Default");
    }
}

