/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.noteattachment;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentService;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentTypeBase;
import org.kuali.kra.protocol.noteattachment.TypedAttachment;
import org.kuali.rice.kns.service.DictionaryValidationService;

public abstract class ProtocolAttachmentBaseRuleHelper {
    private static final String OTHER_TYPE_CODE = "9";
    private final ProtocolAttachmentService attachmentService;
    private final DictionaryValidationService validationService;
    private ErrorReporter errorReporter;
    private String propertyPrefix;

    protected ProtocolAttachmentBaseRuleHelper(ProtocolAttachmentService attachmentService, DictionaryValidationService validationService) {
        if (attachmentService == null) {
            throw new IllegalArgumentException("the attachmentService is null");
        }
        if (validationService == null) {
            throw new IllegalArgumentException("the validationService is null");
        }
        this.attachmentService = attachmentService;
        this.validationService = validationService;
    }

    protected ProtocolAttachmentBaseRuleHelper(String aPropertyPrefix, ProtocolAttachmentService attachmentService, DictionaryValidationService validationService) {
        if (attachmentService == null) {
            throw new IllegalArgumentException("the attachmentService is null");
        }
        if (validationService == null) {
            throw new IllegalArgumentException("the validationService is null");
        }
        this.attachmentService = attachmentService;
        this.validationService = validationService;
        this.resetPropertyPrefix(aPropertyPrefix);
    }

    public void resetPropertyPrefix(String aPropertyPrefix) {
        if (aPropertyPrefix == null) {
            throw new IllegalArgumentException("propertyPrefix is null");
        }
        this.propertyPrefix = aPropertyPrefix;
    }

    public <T extends ProtocolAttachmentBase> boolean validDescriptionWhenRequired(T attachment) {
        if (attachment.getType() == null || attachment.getType().getCode() == null) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)attachment.getDescription()) && OTHER_TYPE_CODE.equals(attachment.getType().getCode())) {
            ProtocolAttachmentTypeBase type = this.attachmentService.getTypeFromCode(attachment.getType().getCode());
            this.getErrorReporter().reportError(this.propertyPrefix + "." + TypedAttachment.PropertyName.DESCRIPTION, "error.protocolAttachment.description.required", type != null ? type.getDescription() : "");
            return false;
        }
        return true;
    }

    public <T extends ProtocolAttachmentBase> boolean validTypeForGroup(T attachment) {
        if (attachment.getType() == null || attachment.getType().getCode() == null) {
            return true;
        }
        for (ProtocolAttachmentTypeBase type : this.attachmentService.getTypesForGroup(attachment.getGroupCode())) {
            if (type == null || !attachment.getType().getCode().equals(type.getCode())) continue;
            return true;
        }
        ProtocolAttachmentTypeBase type = this.attachmentService.getTypeFromCode(attachment.getType().getCode());
        this.getErrorReporter().reportError(this.propertyPrefix + "." + TypedAttachment.PropertyName.TYPE_CODE, "error.protocolAttachment.invalid.type", type != null ? type.getDescription() : "");
        return false;
    }

    boolean validFile(ProtocolAttachmentBase attachmentBase) {
        boolean valid;
        if (attachmentBase.getFile() == null) {
            valid = false;
            this.getErrorReporter().reportError(this.propertyPrefix + ".newFile", "error.protocolAttachment.missing.file", new String[0]);
        } else {
            valid = this.validationService.isBusinessObjectValid((Object)attachmentBase.getFile(), this.propertyPrefix);
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validPrimitiveFields(ProtocolAttachmentBase attachmentBase) {
        Long oldFileId = attachmentBase.getFileId();
        try {
            attachmentBase.setFileId(0L);
            boolean bl = this.validationService.isBusinessObjectValid((Object)attachmentBase, this.propertyPrefix);
            return bl;
        }
        finally {
            attachmentBase.setFileId(oldFileId);
        }
    }

    public ErrorReporter getErrorReporter() {
        if (this.errorReporter == null) {
            this.errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        }
        return this.errorReporter;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }
}

