/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.subawardrule;

import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.custom.KcDocumentBaseAuditRule;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.rule.KcDocumentEventBaseExtension;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.subaward.bo.HumanDataExchangeAgreement;
import org.kuali.kra.subaward.bo.PteSend;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardAmountInfo;
import org.kuali.kra.subaward.bo.SubAwardCloseout;
import org.kuali.kra.subaward.bo.SubAwardContact;
import org.kuali.kra.subaward.bo.SubAwardFfataReporting;
import org.kuali.kra.subaward.bo.SubAwardFundingSource;
import org.kuali.kra.subaward.bo.SubAwardReports;
import org.kuali.kra.subaward.bo.SubAwardTemplateInfo;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.subaward.subawardrule.AddSubAwardAttachmentRule;
import org.kuali.kra.subaward.subawardrule.SubAwardAmountInfoRule;
import org.kuali.kra.subaward.subawardrule.SubAwardAuditRule;
import org.kuali.kra.subaward.subawardrule.SubAwardCloseoutRule;
import org.kuali.kra.subaward.subawardrule.SubAwardContactRule;
import org.kuali.kra.subaward.subawardrule.SubAwardFfataReportingRule;
import org.kuali.kra.subaward.subawardrule.SubAwardFinancialAuditRule;
import org.kuali.kra.subaward.subawardrule.SubAwardFundingSourceRule;
import org.kuali.kra.subaward.subawardrule.SubAwardRule;
import org.kuali.kra.subaward.subawardrule.SubAwardTemplateInfoRule;
import org.kuali.kra.subaward.subawardrule.events.AddSubAwardAttachmentEvent;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class SubAwardDocumentRule
extends KcTransactionalDocumentRuleBase
implements SubAwardRule,
SubAwardAmountInfoRule,
SubAwardContactRule,
SubAwardCloseoutRule,
SubAwardFundingSourceRule,
DocumentAuditRule,
AddSubAwardAttachmentRule,
SubAwardTemplateInfoRule,
SubAwardFfataReportingRule {
    private static final String STATUS_CODE = ".statusCode";
    private static final String SUBAWARD_TYPE_CODE = ".subAwardTypeCode";
    private static final String REQUISITIONER = ".requisitionerUserName";
    private static final String REQUISITIONER_UNIT = ".requisitionerUnit";
    private static final String PURCHASE_ORDER_NUM = ".purchaseOrderNum";
    private static final String SUBCONTRACTOR_ID = ".organizationId";
    private static final String NEW_SUBAWARD = "document.subAwardList[0]";
    private static final String SUBAWARD_START_DATE = ".startDate";
    private static final String SITEINVESTIGATOR = ".siteInvestigatorId";
    private static final String AMOUNT_INFO_OBLIGATED_AMOUNT = "newSubAwardAmountInfo.obligatedChange";
    private static final String AMOUNT_INFO_OBLIGATED_DIRECT_AMOUNT = "newSubAwardAmountInfo.obligatedChangeDirect";
    private static final String AMOUNT_INFO_ANTICIPATED_AMOUNT = "newSubAwardAmountInfo.anticipatedChange";
    private static final String ROLODEX_ID = "newSubAwardContact.rolodex.fullName";
    private static final String CONTACT_TYPE_CODE = "newSubAwardContact.contactTypeCode";
    private static final String CLOSEOUT_TYPE_CODE = "newSubAwardCloseout.closeoutTypeCode";
    private static final String DATE_REQUESTED = "newSubAwardCloseout.dateRequested";
    private static final String DATE_FLLOWUP = "newSubAwardCloseout.dateFollowup";
    private static final String REPORT_TYPE = "subAwardAttachmentFormBean.newReport.subAwardReportTypeCode";
    static final String AWARD_NUMBER = "newSubAwardFundingSource.award.awardNumber";
    private static final String AMOUNT_PERIOD_OF_PERFORMANCE_START_DATE = "newSubAwardAmountInfo.periodofPerformanceStartDate";
    private static final String DESCRIPTION = ".description";
    private static final String SUB_AWARD_ATTACHMENT_TYPE_CODE_PROP = ".subAwardAttachmentTypeCode";
    private static final String NEW_SUB_AWARD_FFATA_REPORTING = "newSubAwardFfataReporting";
    private static final String OTHER_TRANSACTION_DESCRIPTION = "newSubAwardFfataReporting.otherTransactionDescription";
    private static final String DATE_SUBMITTED = "newSubAwardFfataReporting.dateSubmitted";
    private static final String UNIT_NUMBER = "unitNumber";
    private static final String NEW_SUB_AWARD_AMOUNT_INFO = "newSubAwardAmountInfo";
    private static final String SUB_AWARD_ATTACHMENT_TYPE_CODE = "subAwardAttachmentFormBean.newAttachment.subAwardAttachmentTypeCode";
    private static final String NEW_ATTACHMENT_NEW_FILE = "subAwardAttachmentFormBean.newAttachment.newFile";
    private static final String NEW_ATTACHMENT_DESCRIPTION = "subAwardAttachmentFormBean.newAttachment.description";
    private static final String CARRY_FORWARD_REQUESTS_SENT_TO = "document.subAwardList[0].subAwardTemplateInfo[0].carryForwardRequestsSentTo";
    private static final String EMAIL_DIFF = "document.subAwardList[0].subAwardTemplateInfo[0].invoiceEmailDifferent";
    private static final String MPI_LEADERSHIP_PLAN = "document.subAwardList[0].subAwardTemplateInfo[0].mpiLeadershipPlan";
    private static final Logger LOG = LogManager.getLogger(SubAwardDocumentRule.class);
    public static final String ANIMAL_PTE_SEND_CD = "document.subAwardList[0].subAwardTemplateInfo[0].animalPteSendCd";
    public static final String ERROR_REQUIRED_ANIMAL_PTE_SEND_CD = "error.required.subaward.templateinfo.animalPteSendCd";
    public static final String ANIMAL_PTE_NR_CD = "document.subAwardList[0].subAwardTemplateInfo[0].animalPteNrCd";
    public static final String ERROR_REQUIRED_ANIMAL_PTE_NR_CD = "error.required.subaward.templateinfo.animalPteNrCd";
    public static final String HUMAN_PTE_SEND_CD = "document.subAwardList[0].subAwardTemplateInfo[0].humanPteSendCd";
    public static final String ERROR_REQUIRED_HUMAN_PTE_SEND_CD = "error.required.subaward.templateinfo.humanPteSendCd";
    public static final String HUMAN_PTE_NR_CD = "document.subAwardList[0].subAwardTemplateInfo[0].humanPteNrCd";
    public static final String ERROR_REQUIRED_HUMAN_PTE_NR_CD = "error.required.subaward.templateinfo.humanPteNrCd";
    public static final String HUMAN_DATA_EXCHANGE_AGREE_CD = "document.subAwardList[0].subAwardTemplateInfo[0].humanDataExchangeAgreeCd";
    public static final String HUMAN_DATA_EXCHANGE_TERMS_CD = "document.subAwardList[0].subAwardTemplateInfo[0].humanDataExchangeTermsCd";
    private AwardService awardService;
    private ParameterService parameterService;

    @Override
    public boolean processAddSubAwardBusinessRules(SubAward subAward) {
        return this.processSaveSubAwardBusinessRules(subAward, NEW_SUBAWARD);
    }

    protected boolean processSaveSubAwardBusinessRules(SubAward subAward, String propertyPrefix) {
        Unit leadUnit;
        boolean rulePassed = true;
        if (subAward.getOrganizationId() == null) {
            rulePassed = false;
            this.reportError(propertyPrefix + SUBCONTRACTOR_ID, "error.required.subrecipient.id", new String[0]);
        }
        if (subAward.getStatusCode() == null) {
            rulePassed = false;
            this.reportError(propertyPrefix + STATUS_CODE, "error.required.statuscode", new String[0]);
        }
        if (subAward.getSubAwardTypeCode() == null) {
            rulePassed = false;
            this.reportError(propertyPrefix + SUBAWARD_TYPE_CODE, "error.required.subaward.typecode", new String[0]);
        }
        if (subAward.getRequisitionerId() == null) {
            rulePassed = false;
            if (subAward.getRequisitionerUserName() == null) {
                this.reportError(propertyPrefix + REQUISITIONER, "error.required.requisitioner", new String[0]);
            } else {
                this.reportError(propertyPrefix + REQUISITIONER, "error.invalid.requisitioner", subAward.getRequisitionerUserName());
            }
        }
        if (subAward.getRequisitionerUnit() != null && (leadUnit = (Unit)this.getBusinessObjectService().findByPrimaryKey(Unit.class, Collections.singletonMap(UNIT_NUMBER, subAward.getRequisitionerUnit()))) == null) {
            this.reportError(propertyPrefix + REQUISITIONER_UNIT, "error.required.requisitioner.unit", new String[0]);
        }
        if (subAward.getPurchaseOrderNum() == null) {
            rulePassed = false;
            this.reportError(propertyPrefix + PURCHASE_ORDER_NUM, "error.required.purchase.order.num", new String[0]);
        }
        if (subAward.getStartDate() != null && subAward.getEndDate() != null && subAward.getStartDate().after(subAward.getEndDate())) {
            rulePassed = false;
            this.reportError(propertyPrefix + SUBAWARD_START_DATE, "subaward.error.end.date.greater.than.start", new String[0]);
        }
        if (subAward.getSiteInvestigator() == null && subAward.getSiteInvestigatorId() != null) {
            rulePassed = false;
            this.reportError(propertyPrefix + SITEINVESTIGATOR, "error.invalid.siteinvestigator.id", subAward.getSiteInvestigatorId());
        }
        if (subAward.getOrganizationId() != null && subAward.getOrganization() == null) {
            rulePassed = false;
            this.reportError(propertyPrefix + SUBCONTRACTOR_ID, "error.invalid.subrecipient.id", subAward.getOrganizationId());
        }
        return rulePassed;
    }

    @Override
    public boolean processAddSubAwardAmountInfoBusinessRules(SubAwardAmountInfo amountInfo, SubAward subAward) {
        boolean rulePassed = this.getDictionaryValidationService().isBusinessObjectValid((Object)amountInfo, NEW_SUB_AWARD_AMOUNT_INFO);
        boolean isCostSplitEnabled = this.isCostSplitEnabled();
        if (!isCostSplitEnabled) {
            if (amountInfo.getObligatedChange() == null) {
                rulePassed = false;
                this.reportError(AMOUNT_INFO_OBLIGATED_AMOUNT, "subaward.error.obligated.change.missing", new String[0]);
            }
            if (amountInfo.getAnticipatedChange() == null) {
                rulePassed = false;
                this.reportError(AMOUNT_INFO_ANTICIPATED_AMOUNT, "subaward.error.anticipated.change.missing", new String[0]);
            }
        } else {
            if (amountInfo.getObligatedChangeDirect() == null || amountInfo.getObligatedChangeDirect().isZero()) {
                this.reportError(AMOUNT_INFO_OBLIGATED_DIRECT_AMOUNT, "subaward.error.obligated.amount.less.than.zero", new String[0]);
            }
            if (amountInfo.getObligatedChangeIndirect() == null || amountInfo.getObligatedChangeIndirect().isZero()) {
                this.reportError(AMOUNT_INFO_OBLIGATED_AMOUNT, "subaward.error.obligated.amount.less.than.zero", new String[0]);
            }
            if (amountInfo.getAnticipatedChangeDirect() == null || amountInfo.getAnticipatedChangeDirect().isZero()) {
                this.reportError(AMOUNT_INFO_OBLIGATED_AMOUNT, "subaward.error.obligated.amount.less.than.zero", new String[0]);
            }
            if (amountInfo.getAnticipatedChangeIndirect() == null || amountInfo.getAnticipatedChangeIndirect().isZero()) {
                this.reportError(AMOUNT_INFO_OBLIGATED_AMOUNT, "subaward.error.obligated.amount.less.than.zero", new String[0]);
            }
        }
        ScaleTwoDecimal obligatedAmount = subAward.getTotalObligatedAmount();
        if (!isCostSplitEnabled) {
            obligatedAmount = amountInfo.getObligatedChange() != null ? (ScaleTwoDecimal)obligatedAmount.add((AbstractDecimal)amountInfo.getObligatedChange()) : obligatedAmount;
        } else {
            obligatedAmount = amountInfo.getObligatedChangeDirect() != null ? (ScaleTwoDecimal)obligatedAmount.add((AbstractDecimal)amountInfo.getObligatedChangeDirect()) : obligatedAmount;
            ScaleTwoDecimal scaleTwoDecimal = obligatedAmount = amountInfo.getObligatedChangeIndirect() != null ? (ScaleTwoDecimal)obligatedAmount.add((AbstractDecimal)amountInfo.getObligatedChangeIndirect()) : obligatedAmount;
        }
        if (obligatedAmount.isNegative()) {
            rulePassed = false;
            this.reportError(AMOUNT_INFO_OBLIGATED_AMOUNT, "subaward.error.obligated.amount.less.than.zero", new String[0]);
        }
        ScaleTwoDecimal anticipatedAmount = subAward.getTotalAnticipatedAmount();
        if (!isCostSplitEnabled) {
            anticipatedAmount = amountInfo.getAnticipatedChange() != null ? (ScaleTwoDecimal)anticipatedAmount.add((AbstractDecimal)amountInfo.getAnticipatedChange()) : anticipatedAmount;
        } else {
            anticipatedAmount = amountInfo.getAnticipatedChangeDirect() != null ? (ScaleTwoDecimal)anticipatedAmount.add((AbstractDecimal)amountInfo.getAnticipatedChangeDirect()) : anticipatedAmount;
            ScaleTwoDecimal scaleTwoDecimal = anticipatedAmount = amountInfo.getAnticipatedChangeIndirect() != null ? (ScaleTwoDecimal)anticipatedAmount.add((AbstractDecimal)amountInfo.getAnticipatedChangeIndirect()) : anticipatedAmount;
        }
        if (anticipatedAmount.isNegative()) {
            rulePassed = false;
            this.reportError(AMOUNT_INFO_ANTICIPATED_AMOUNT, "subaward.error.anticipated.amount.less.than.zero", new String[0]);
        }
        if (obligatedAmount.isGreaterThan((AbstractDecimal)anticipatedAmount)) {
            rulePassed = false;
            this.reportError(AMOUNT_INFO_ANTICIPATED_AMOUNT, "subaward.error.obligated.amount.greater.than.anticipated.amount", new String[0]);
        }
        if (obligatedAmount.isLessThan((AbstractDecimal)subAward.getTotalAmountReleased())) {
            rulePassed = false;
            this.reportError(AMOUNT_INFO_OBLIGATED_AMOUNT, "subaward.error.oblig.amount.greater.than.amount.released", new String[0]);
        }
        if (amountInfo.getPeriodofPerformanceStartDate() != null && amountInfo.getPeriodofPerformanceEndDate() != null && amountInfo.getPeriodofPerformanceStartDate().after(amountInfo.getPeriodofPerformanceEndDate())) {
            rulePassed = false;
            this.reportError(AMOUNT_PERIOD_OF_PERFORMANCE_START_DATE, "subaward.error.period.of.performance.startdate.should.greater.than.period.of.performance.enddate", new String[0]);
        }
        return rulePassed;
    }

    public boolean isCostSplitEnabled() {
        return this.getParameterService().getParameterValueAsBoolean("KC-SUBAWARD", "All", "Enable_Subaward_DC_IDC");
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    @Override
    public boolean processAddSubAwardContactBusinessRules(SubAwardContact subAwardContact, SubAward subAward) {
        boolean rulePassed = true;
        if (subAwardContact == null || subAwardContact.getRolodexId() == null) {
            rulePassed = false;
            this.reportError(ROLODEX_ID, "error.required.subaward.contact.rolodex.id", new String[0]);
        }
        if (subAwardContact == null || subAwardContact.getContactTypeCode() == null) {
            rulePassed = false;
            this.reportError(CONTACT_TYPE_CODE, "error.required.subaward.contact.contact.type.code", new String[0]);
        }
        for (SubAwardContact contact : subAward.getSubAwardContactsList()) {
            if (subAwardContact == null || !Objects.equals(contact.getRolodexId(), subAwardContact.getRolodexId()) || !Objects.equals(contact.getContactTypeCode(), subAwardContact.getContactTypeCode())) continue;
            rulePassed = false;
            String contactName = contact.getRolodex().getFullName();
            if (contactName == null) {
                contactName = contact.getRolodex().getOrganization();
            }
            this.reportError(ROLODEX_ID, "error.subAwardSponsorContact.person.exists", contactName);
        }
        return rulePassed;
    }

    @Override
    public boolean processAddSubAwardCloseoutBusinessRules(SubAwardCloseout subAwardCloseout) {
        return this.processSaveSubAwardCloseoutBusinessRules(subAwardCloseout);
    }

    protected boolean processSaveSubAwardCloseoutBusinessRules(SubAwardCloseout subAwardCloseout) {
        boolean rulePassed = true;
        if (subAwardCloseout == null || subAwardCloseout.getCloseoutTypeCode() == null) {
            rulePassed = false;
            this.reportError(CLOSEOUT_TYPE_CODE, "error.required.subaward.closeout.closeout.type.code", new String[0]);
        }
        if (subAwardCloseout == null || subAwardCloseout.getDateRequested() == null) {
            rulePassed = false;
            this.reportError(DATE_REQUESTED, "error.required.subaward.closeout.date.requested", new String[0]);
        }
        if (subAwardCloseout == null || subAwardCloseout.getDateFollowup() == null) {
            rulePassed = false;
            this.reportError(DATE_FLLOWUP, "error.required.subaward.closeout.date.followup", new String[0]);
        }
        return rulePassed;
    }

    @Override
    public boolean processAddSubAwardFundingSourceBusinessRules(SubAwardFundingSource subAwardFundingSource, SubAward subAward) {
        return this.processSaveSubAwardFundingSourceBusinessRules(subAwardFundingSource, subAward);
    }

    protected boolean processSaveSubAwardFundingSourceBusinessRules(SubAwardFundingSource subAwardFundingSource, SubAward subAward) {
        if (subAwardFundingSource == null || subAwardFundingSource.getAwardId() == null) {
            this.reportError(AWARD_NUMBER, "error.required.subaward.funding.source.award.number", new String[0]);
            return false;
        }
        Award fundingSourceAward = this.getAwardService().getAward(subAwardFundingSource.getAwardId());
        if (fundingSourceAward == null) {
            this.reportError(AWARD_NUMBER, "error.required.subaward.funding.source.award.number", new String[0]);
            return false;
        }
        for (SubAwardFundingSource fundingSource : subAward.getSubAwardFundingSourceList()) {
            Award award = this.getAwardService().getAward(fundingSource.getAwardId());
            if (!StringUtils.equals((CharSequence)fundingSourceAward.getAwardNumber(), (CharSequence)award.getAwardNumber())) continue;
            this.reportError(AWARD_NUMBER, "error.required.subaward.funding.source.award.number.duplicate", award.getAwardNumber());
            return false;
        }
        return true;
    }

    public boolean processRunAuditBusinessRules(Document document) {
        boolean retval = new KcDocumentBaseAuditRule().processRunAuditBusinessRules(document);
        retval &= new SubAwardAuditRule().processRunAuditBusinessRules(document);
        return retval &= new SubAwardFinancialAuditRule().processRunAuditBusinessRules(document);
    }

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        return document instanceof SubAwardDocument;
    }

    public boolean processRules(KcDocumentEventBaseExtension event) {
        return event.getRule().processRules(event);
    }

    @Override
    public boolean processsAddSubawardAttachmentRule(AddSubAwardAttachmentEvent event) {
        boolean valid = true;
        if (event.getSubAwardAttachments().getSubAwardAttachmentTypeCode() == null) {
            valid = false;
            LOG.debug("error.Subaward.attachment.typeRequired");
            this.reportError(SUB_AWARD_ATTACHMENT_TYPE_CODE, "error.Subaward.attachment.typeRequired", new String[0]);
        }
        if (StringUtils.isBlank((CharSequence)event.getSubAwardAttachments().getNewFile().getFileName())) {
            valid = false;
            LOG.debug("error.Subaward.attachment.fileRequired");
            this.reportError(NEW_ATTACHMENT_NEW_FILE, "error.Subaward.attachment.fileRequired", new String[0]);
        }
        if (StringUtils.isBlank((CharSequence)event.getSubAwardAttachments().getDescription())) {
            valid = false;
            LOG.debug("error.Subaward.attachment.descriptionRequired");
            this.reportError(NEW_ATTACHMENT_DESCRIPTION, "error.Subaward.attachment.descriptionRequired", new String[0]);
        }
        return valid;
    }

    @Override
    public boolean processApplySubawardAttachmentModificationRule(AddSubAwardAttachmentEvent event) {
        boolean valid = true;
        if (event.getSubAwardAttachments().getSubAwardAttachmentTypeCode() == null) {
            valid = false;
            LOG.debug("error.Subaward.attachment.typeRequired");
            this.reportError(event.getErrorPathPrefix() + SUB_AWARD_ATTACHMENT_TYPE_CODE_PROP, "error.Subaward.attachment.typeRequired", new String[0]);
        }
        if (StringUtils.isBlank((CharSequence)event.getSubAwardAttachments().getDescription())) {
            valid = false;
            LOG.debug("error.Subaward.attachment.descriptionRequired");
            this.reportError(event.getErrorPathPrefix() + DESCRIPTION, "error.Subaward.attachment.descriptionRequired", new String[0]);
        }
        return valid;
    }

    public boolean processsAddSubawardReportRule(SubAwardReports subAwardReports) {
        boolean valid = true;
        if (subAwardReports == null || subAwardReports.getSubAwardReportTypeCode() == null) {
            valid = false;
            this.reportError(REPORT_TYPE, "error.required.subaward.report.type.code", new String[0]);
        }
        return valid;
    }

    @Override
    public boolean processAddSubAwardTemplateInfoBusinessRules(SubAward subAward) {
        return this.processSaveSubAwardTemplateInfoBusinessRules(subAward);
    }

    protected boolean processSaveSubAwardTemplateInfoBusinessRules(SubAward subAward) {
        boolean rulePassed = true;
        boolean fdpEnabled = this.getParameterService().getParameterValueAsBoolean("KC-SUBAWARD", "All", "Enable_Subaward_FDP");
        for (SubAwardTemplateInfo subAwardTemplateInfo : subAward.getSubAwardTemplateInfo()) {
            if (subAwardTemplateInfo.getInvoicesEmailed() != null && !subAwardTemplateInfo.getInvoicesEmailed().booleanValue() && subAwardTemplateInfo.getInvoiceEmailDifferent() != null && subAwardTemplateInfo.getInvoiceEmailDifferent().booleanValue()) {
                rulePassed = false;
                this.reportError(EMAIL_DIFF, "error.subaward.invoiceEmailDifferent.yes", new String[0]);
            }
            if (fdpEnabled && "N".equalsIgnoreCase(subAwardTemplateInfo.getAutomaticCarryForward()) && subAwardTemplateInfo.getCarryForwardRequestsSentTo() == null) {
                rulePassed = false;
                this.reportError(CARRY_FORWARD_REQUESTS_SENT_TO, "error.required.subaward.templateinfo.carryForwardRequestsSentTo", new String[0]);
            }
            if (fdpEnabled && subAwardTemplateInfo.getMpiAward() != null && subAwardTemplateInfo.getMpiAward().booleanValue() && subAwardTemplateInfo.getMpiLeadershipPlan() == null) {
                rulePassed = false;
                this.reportError(MPI_LEADERSHIP_PLAN, "error.required.subaward.templateinfo.mpiLeadershipPlan", new String[0]);
            }
            if (fdpEnabled && subAwardTemplateInfo.getAnimalFlag() != null && subAwardTemplateInfo.getAnimalFlag().booleanValue()) {
                if (StringUtils.isBlank((CharSequence)subAwardTemplateInfo.getAnimalPteSendCd())) {
                    rulePassed = false;
                    this.reportError(ANIMAL_PTE_SEND_CD, ERROR_REQUIRED_ANIMAL_PTE_SEND_CD, new String[0]);
                } else if (PteSend.NOT_REQUIRED.getCode().equals(subAwardTemplateInfo.getAnimalPteSendCd()) && StringUtils.isBlank((CharSequence)subAwardTemplateInfo.getAnimalPteNrCd())) {
                    rulePassed = false;
                    this.reportError(ANIMAL_PTE_NR_CD, ERROR_REQUIRED_ANIMAL_PTE_NR_CD, new String[0]);
                }
            }
            if (!fdpEnabled || subAwardTemplateInfo.getHumanFlag() == null || !subAwardTemplateInfo.getHumanFlag().booleanValue()) continue;
            if (StringUtils.isBlank((CharSequence)subAwardTemplateInfo.getHumanPteSendCd())) {
                rulePassed = false;
                this.reportError(HUMAN_PTE_SEND_CD, ERROR_REQUIRED_HUMAN_PTE_SEND_CD, new String[0]);
            } else if (PteSend.NOT_REQUIRED.getCode().equals(subAwardTemplateInfo.getHumanPteSendCd()) && StringUtils.isBlank((CharSequence)subAwardTemplateInfo.getHumanPteNrCd())) {
                rulePassed = false;
                this.reportError(HUMAN_PTE_NR_CD, ERROR_REQUIRED_HUMAN_PTE_NR_CD, new String[0]);
            }
            if (StringUtils.isBlank((CharSequence)subAwardTemplateInfo.getHumanDataExchangeAgreeCd())) {
                rulePassed = false;
                this.reportError(HUMAN_DATA_EXCHANGE_AGREE_CD, "error.required.subaward.templateinfo.humanDataExchangeAgreeCd", new String[0]);
                continue;
            }
            if (HumanDataExchangeAgreement.NOT_APPLICABLE.getCode().equals(subAwardTemplateInfo.getHumanDataExchangeAgreeCd()) || !StringUtils.isBlank((CharSequence)subAwardTemplateInfo.getHumanDataExchangeTermsCd())) continue;
            rulePassed = false;
            this.reportError(HUMAN_DATA_EXCHANGE_TERMS_CD, "error.required.subaward.templateinfo.humanDataExchangeTermsCd", new String[0]);
        }
        return rulePassed;
    }

    @Override
    public boolean processAddSubAwardFfataReportingBusinessRules(SubAwardFfataReporting subAwardFfataReporting, SubAward subAward) {
        boolean valid = this.getDictionaryValidationService().isBusinessObjectValid((Object)subAwardFfataReporting, NEW_SUB_AWARD_FFATA_REPORTING);
        if (subAwardFfataReporting.getSubAwardAmountInfoId() != null == StringUtils.isNotBlank((CharSequence)subAwardFfataReporting.getOtherTransactionDescription())) {
            this.reportError(OTHER_TRANSACTION_DESCRIPTION, "error.subaward.fftata.reporting.transaction.other.desc", new String[0]);
            valid = false;
        }
        if (subAwardFfataReporting.getSubAwardAmountInfoId() != null && (subAwardFfataReporting.getDateSubmitted() == null || subAwardFfataReporting.getSubAwardAmountInfo() != null && subAwardFfataReporting.getSubAwardAmountInfo().getEffectiveDate().after(subAwardFfataReporting.getDateSubmitted()))) {
            this.reportError(DATE_SUBMITTED, "error.subaward.fftata.reporting.submitted.date", new String[0]);
            valid = false;
        }
        return valid;
    }

    public AwardService getAwardService() {
        if (this.awardService == null) {
            this.awardService = KcServiceLocator.getService(AwardService.class);
        }
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }
}

