/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.web.struts.action;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.subaward.SubAwardForm;
import org.kuali.kra.subaward.bo.SubAward;
import org.kuali.kra.subaward.bo.SubAwardAmountInfo;
import org.kuali.kra.subaward.bo.SubAwardAmountReleased;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.subaward.service.SubAwardService;
import org.kuali.kra.subaward.subawardrule.SubAwardDocumentRule;
import org.kuali.kra.subaward.web.struts.action.SubAwardAction;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.rules.rule.event.SaveDocumentEvent;

public class SubAwardFinancialAction
extends SubAwardAction {
    private static final String LINE_NUMBER = "line";

    public ActionForward addAmountInfo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAward subAward;
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardAmountInfo amountInfo = subAwardForm.getNewSubAwardAmountInfo();
        if (new SubAwardDocumentRule().processAddSubAwardAmountInfoBusinessRules(amountInfo, subAward = subAwardForm.getSubAwardDocument().getSubAward())) {
            this.addAmountInfoToSubAward(subAwardForm.getSubAwardDocument().getSubAward(), amountInfo);
            subAwardForm.setNewSubAwardAmountInfo(new SubAwardAmountInfo());
        }
        KcServiceLocator.getService(SubAwardService.class).calculateAmountInfo(subAwardForm.getSubAwardDocument().getSubAward());
        return mapping.findForward("financial");
    }

    boolean addAmountInfoToSubAward(SubAward subAward, SubAwardAmountInfo amountInfo) {
        amountInfo.setSubAward(subAward);
        amountInfo.populateAttachment();
        subAward.getAllSubAwardAmountInfos().add(amountInfo);
        subAward.getSubAwardAmountInfoList().add(amountInfo);
        this.saveSubAwardAmountInfo(amountInfo);
        return true;
    }

    protected void saveSubAwardAmountInfo(SubAwardAmountInfo amountInfo) {
        this.getBusinessObjectService().save((PersistableBusinessObject)amountInfo);
    }

    public ActionForward deleteAmountInfo(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        int selectedLineNumber = this.getSelectedLine(request);
        SubAwardAmountInfo subAwardAmountInfo = subAwardDocument.getSubAward().getSubAwardAmountInfoList().get(selectedLineNumber);
        subAwardAmountInfo.setFileName(null);
        subAwardAmountInfo.setMimeType(null);
        subAwardAmountInfo.setFileDataId(null);
        this.saveSubAwardAmountInfo(subAwardAmountInfo);
        return mapping.findForward("financial");
    }

    public ActionForward addAmountReleased(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAward subAward = subAwardForm.getSubAwardDocument().getSubAward();
        if (this.getKualiRuleService().applyRules((DocumentEvent)new SaveDocumentEvent("document", (Document)subAward.getSubAwardDocument()))) {
            this.save(mapping, (ActionForm)subAwardForm, request, response);
            String backUrl = URLEncoder.encode(this.buildActionUrl(subAward.getSubAwardDocument().getDocumentNumber(), "financial", "SubAwardDocument"), StandardCharsets.UTF_8.name());
            response.sendRedirect("kr/maintenance.do?businessObjectClassName=" + SubAwardAmountReleased.class.getName() + "&methodToCall=start&subAwardId=" + subAward.getSubAwardId() + "&subAwardCode=" + subAward.getSubAwardCode() + "&sequenceNumber=" + subAward.getSequenceNumber() + "&backLocation=" + backUrl);
        }
        return null;
    }

    public ActionForward openAmountReleased(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAward subAward = subAwardForm.getSubAwardDocument().getSubAward();
        Integer invoiceIdx = request.getParameter(LINE_NUMBER) != null ? Integer.valueOf(Integer.parseInt(request.getParameter(LINE_NUMBER))) : this.getInvoiceIndex(request);
        SubAwardAmountReleased invoice = subAward.getSubAwardAmountReleasedList().get(invoiceIdx);
        String backUrl = URLEncoder.encode(this.buildActionUrl(subAward.getSubAwardDocument().getDocumentNumber(), "financial", "SubAwardDocument"), StandardCharsets.UTF_8.name());
        response.sendRedirect("kr/maintenance.do?methodToCall=docHandler&docId=" + invoice.getDocumentNumber() + "&command=displayDocSearchView&backLocation=" + backUrl);
        return null;
    }

    public ActionForward downloadHistoryOfChangesAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        String amountInfoIdStr = request.getParameter(LINE_NUMBER);
        Integer amountInfoId = amountInfoIdStr == null ? 0 : Integer.parseInt(amountInfoIdStr);
        SubAwardAmountInfo subAwardAmountInfo = subAwardDocument.getSubAward().getAllSubAwardAmountInfos().stream().filter(amountInfo -> amountInfoId.equals(amountInfo.getSubAwardAmountInfoId())).findFirst().orElse(null);
        if (subAwardAmountInfo != null && subAwardAmountInfo.getDocument() != null) {
            this.streamToResponse(subAwardAmountInfo.getDocument(), SubAwardFinancialAction.getValidHeaderString(subAwardAmountInfo.getFileName()), SubAwardFinancialAction.getValidHeaderString(subAwardAmountInfo.getType()), response);
        }
        return null;
    }

    public ActionForward replaceHistoryOfChangesAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        SubAwardAmountInfo subAwardAmountInfo = subAwardDocument.getSubAward().getSubAwardAmountInfoList().get(this.getSelectedLine(request));
        subAwardAmountInfo.populateAttachment();
        this.saveSubAwardAmountInfo(subAwardAmountInfo);
        return mapping.findForward("basic");
    }

    public ActionForward downloadInvoiceAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        Integer invoiceIndex = this.getInvoiceIndex(request);
        SubAwardAmountReleased subAwardAmountReleased = subAwardDocument.getSubAward().getSubAwardAmountReleasedList().get(invoiceIndex);
        if (subAwardAmountReleased.getDocument() != null) {
            this.streamToResponse(subAwardAmountReleased.getData(), SubAwardFinancialAction.getValidHeaderString(subAwardAmountReleased.getName()), SubAwardFinancialAction.getValidHeaderString(subAwardAmountReleased.getType()), response);
        }
        return null;
    }

    protected Integer getInvoiceIndex(HttpServletRequest request) {
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            return Integer.parseInt(StringUtils.substringBetween((String)parameterName, (String)".invoiceIndex", (String)"."));
        }
        return null;
    }

    public ActionForward replaceInvoiceAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SubAwardForm subAwardForm = (SubAwardForm)form;
        SubAwardDocument subAwardDocument = subAwardForm.getSubAwardDocument();
        SubAwardAmountReleased subAwardAmountReleased = subAwardDocument.getSubAward().getSubAwardAmountReleasedList().get(this.getSelectedLine(request));
        subAwardAmountReleased.populateAttachment();
        if (subAwardAmountReleased.getSubAward() != null) {
            this.getBusinessObjectService().save((PersistableBusinessObject)subAwardAmountReleased);
        }
        return mapping.findForward("basic");
    }
}

