/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.timeandmoney.transactions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.history.TransactionDetail;
import org.kuali.kra.timeandmoney.service.ActivePendingTransactionsService;
import org.kuali.kra.timeandmoney.transactions.AddTransactionRuleEvent;
import org.kuali.kra.timeandmoney.transactions.AwardAmountTransaction;
import org.kuali.kra.timeandmoney.transactions.PendingTransaction;
import org.kuali.kra.timeandmoney.transactions.TransactionRule;
import org.kuali.kra.timeandmoney.transactions.TransactionRuleEvent;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.util.GlobalVariables;

public class TransactionRuleImpl
extends KcTransactionalDocumentRuleBase
implements TransactionRule {
    private static final String SOURCE_AWARD_PROPERTY = "sourceAwardNumber";
    private static final String OBLIGATED_AMOUNT_PROPERTY = "obligatedAmount";
    private static final String ANTICIPATED_AMOUNT_PROPERTY = "anticipatedAmount";
    private static final String DESTINATION_AWARD_PROPERTY = "destinationAwardNumber";
    private static final String CURRENT_FUND_EFFECTIVE_DATE = "currentFundEffectiveDate";
    private static final String SOURCE_AWARD_ERROR_PARM = "Source Award (Source Award)";
    private static final String DESTINATION_AWARD_ERROR_PARM = "Destination Award (Destination Award)";
    private static final String TOTALS = "totals";
    private static final String TIME_AND_MONEY_TRANSACTION = "timeAndMoneyTransaction";
    private static final String NEW_AWARD_AMOUNT_TRANSACTION = "newAwardAmountTransaction";
    private static final String TRANSACTION_TYPE_CODE = ".transactionTypeCode";
    private ParameterService parameterService;

    @Override
    public boolean processPendingTransactionBusinessRules(TransactionRuleEvent event) {
        return this.processCommonValidations(event);
    }

    @Override
    public boolean processAddPendingTransactionBusinessRules(AddTransactionRuleEvent event) {
        boolean valid;
        boolean bl = valid = this.areRequiredFieldsComplete(event.getPendingTransactionItemForValidation()) && this.sourceAndDestinationAwardsAreDifferent(event.getPendingTransactionItemForValidation());
        if (valid) {
            event.getTimeAndMoneyDocument().add(event.getPendingTransactionItemForValidation());
            List<Award> awards = this.processTransactions(event.getTimeAndMoneyDocument());
            event.getTimeAndMoneyDocument().getPendingTransactions().remove(event.getPendingTransactionItemForValidation());
            Award award = this.getLastSourceAwardReferenceInAwards(awards, event.getPendingTransactionItemForValidation().getSourceAwardNumber());
            if (award == null) {
                award = this.getLastTargetAwardReferenceInAwards(awards, event.getPendingTransactionItemForValidation().getDestinationAwardNumber());
            }
            if (award != null) {
                valid &= this.validateSourceObligatedFunds(event.getPendingTransactionItemForValidation(), award);
                valid &= this.validateSourceAnticipatedFunds(event.getPendingTransactionItemForValidation(), award);
                valid &= this.validateAwardTotalCostLimit(event.getPendingTransactionItemForValidation(), award);
                boolean validSourceAwardDestinationAward = this.processCommonValidations(event);
                valid &= validSourceAwardDestinationAward;
                if (validSourceAwardDestinationAward) {
                    valid &= this.validateAnticipatedGreaterThanObligated(event, award);
                    valid &= this.validateObligatedDateIsSet(event, award);
                }
                for (Award curAward : awards) {
                    curAward.refreshReferenceObject("awardAmountInfos");
                }
            }
        }
        return valid;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public boolean isDirectIndirectViewEnabled() {
        boolean returnValue = false;
        String directIndirectEnabledValue = this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "ENABLE_AWD_ANT_OBL_DIRECT_INDIRECT_COST");
        if (directIndirectEnabledValue.equals("1")) {
            returnValue = true;
        }
        return returnValue;
    }

    private boolean validateAnticipatedGreaterThanObligated(AddTransactionRuleEvent event, Award activeAward) {
        boolean valid = true;
        AwardAmountInfo awardAmountInfo = activeAward.getLastAwardAmountInfo();
        if (((ScaleTwoDecimal)awardAmountInfo.getAnticipatedTotalAmount().subtract((AbstractDecimal)awardAmountInfo.getAmountObligatedToDate())).isNegative()) {
            this.reportError(OBLIGATED_AMOUNT_PROPERTY, "error.total.amount.invalid", activeAward.getAwardNumber());
            valid = false;
        }
        return valid;
    }

    private boolean validateObligatedDateIsSet(AddTransactionRuleEvent event, Award activeAward) {
        boolean valid = true;
        AwardAmountInfo awardAmountInfo = activeAward.getAwardAmountInfos().get(activeAward.getAwardAmountInfos().size() - 1);
        if (awardAmountInfo.getAmountObligatedToDate().isPositive() && (awardAmountInfo.getCurrentFundEffectiveDate() == null || awardAmountInfo.getObligationExpirationDate() == null)) {
            this.reportError(CURRENT_FUND_EFFECTIVE_DATE, "error.date.not.set", activeAward.getAwardNumber());
            valid = false;
        }
        return valid;
    }

    private List<Award> processTransactions(TimeAndMoneyDocument timeAndMoneyDocument) {
        HashMap<String, AwardAmountTransaction> awardAmountTransactionItems = new HashMap<String, AwardAmountTransaction>();
        ArrayList<Award> awardItems = new ArrayList<Award>();
        ArrayList<TransactionDetail> transactionDetailItems = new ArrayList<TransactionDetail>();
        ActivePendingTransactionsService service = KcServiceLocator.getService(ActivePendingTransactionsService.class);
        service.processTransactionsForAddRuleProcessing(timeAndMoneyDocument, timeAndMoneyDocument.getAwardAmountTransactions().get(0), awardAmountTransactionItems, awardItems, transactionDetailItems);
        return awardItems;
    }

    private Award getLastSourceAwardReferenceInAwards(List<Award> awards, String sourceAwardNumber) {
        Award returnAward = null;
        for (Award award : awards) {
            if (award.getAwardNumber() != sourceAwardNumber) continue;
            returnAward = award;
        }
        if (returnAward == null) {
            returnAward = this.getAwardVersionService().getWorkingAwardVersion(sourceAwardNumber);
        }
        return returnAward;
    }

    private Award getLastTargetAwardReferenceInAwards(List<Award> awards, String targetAwardNumber) {
        Award returnAward = null;
        for (Award award : awards) {
            if (award.getAwardNumber() != targetAwardNumber) continue;
            returnAward = award;
        }
        if (returnAward == null) {
            returnAward = this.getAwardVersionService().getWorkingAwardVersion(targetAwardNumber);
        }
        return returnAward;
    }

    private boolean validateSourceObligatedFunds(PendingTransaction pendingTransaction, Award award) {
        AwardAmountInfo awardAmountInfo = award.getLastAwardAmountInfo();
        boolean valid = true;
        if (awardAmountInfo.getObliDistributableAmount().isNegative()) {
            this.reportError(OBLIGATED_AMOUNT_PROPERTY, "error.obligated.amount.invalid", new String[0]);
            valid = false;
        }
        return valid;
    }

    private boolean validateSourceAnticipatedFunds(PendingTransaction pendingTransaction, Award award) {
        AwardAmountInfo awardAmountInfo = award.getLastAwardAmountInfo();
        boolean valid = true;
        if (awardAmountInfo.getAntDistributableAmount().isNegative()) {
            this.reportError(ANTICIPATED_AMOUNT_PROPERTY, "error.anticipated.amount.invalid", new String[0]);
            valid = false;
        }
        return valid;
    }

    private boolean validateAwardTotalCostLimit(PendingTransaction pendingTransaction, Award award) {
        AwardAmountInfo awardAmountInfo = award.getLastAwardAmountInfo();
        ScaleTwoDecimal obliDistributableAmount = (ScaleTwoDecimal)awardAmountInfo.getObliDistributableAmount().subtract((AbstractDecimal)pendingTransaction.getObligatedAmount());
        if (award.getTotalCostBudgetLimit() != null && award.getTotalCostBudgetLimit().isGreaterThan((AbstractDecimal)obliDistributableAmount)) {
            this.reportWarning(OBLIGATED_AMOUNT_PROPERTY, "warning.transaction.obligated.less.than.limit", award.getAwardNumber());
        }
        return true;
    }

    private boolean processCommonValidations(TransactionRuleEvent event) {
        PendingTransaction pendingTransactionItem = event.getPendingTransactionItemForValidation();
        List<PendingTransaction> items = event.getTimeAndMoneyDocument().getPendingTransactions();
        return this.isUnique(items, pendingTransactionItem) && this.sourceAndDestinationAwardsAreDifferent(pendingTransactionItem) && this.enforcePositiveAmounts(pendingTransactionItem);
    }

    boolean enforcePositiveAmounts(PendingTransaction pendingTransactionItem) {
        boolean valid = true;
        if (pendingTransactionItem.getAnticipatedAmount().isNegative() || pendingTransactionItem.getObligatedAmount().isNegative() || pendingTransactionItem.getAnticipatedDirectAmount().isNegative() || pendingTransactionItem.getAnticipatedIndirectAmount().isNegative() || pendingTransactionItem.getObligatedDirectAmount().isNegative() || pendingTransactionItem.getObligatedIndirectAmount().isNegative()) {
            this.reportError(TIME_AND_MONEY_TRANSACTION, "error.transaction.amounts.negative", new String[0]);
            valid = false;
        }
        return valid;
    }

    boolean sourceAndDestinationAwardsAreDifferent(PendingTransaction pendingTransactionItem) {
        boolean srcAndDestinationAwardsAreDifferent;
        boolean bl = srcAndDestinationAwardsAreDifferent = !StringUtils.equalsIgnoreCase((CharSequence)pendingTransactionItem.getSourceAwardNumber(), (CharSequence)pendingTransactionItem.getDestinationAwardNumber());
        if (!srcAndDestinationAwardsAreDifferent) {
            this.reportError("pendingTransactionItems", "error.awardPendingTransaction.sourceAndDestinationAreSame", SOURCE_AWARD_PROPERTY);
        }
        return srcAndDestinationAwardsAreDifferent;
    }

    boolean isUnique(List<PendingTransaction> pendingTransactionItems, PendingTransaction pendingTransactionItem) {
        PendingTransaction listItem;
        boolean duplicateFound = false;
        Iterator<PendingTransaction> iterator = pendingTransactionItems.iterator();
        while (iterator.hasNext() && !(duplicateFound = pendingTransactionItem != (listItem = iterator.next()) && listItem.equals(pendingTransactionItem))) {
        }
        if (duplicateFound && !this.hasDuplicateErrorBeenReported()) {
            this.reportError("pendingTransactionItems", "error.awardPendingTransaction.notunique", SOURCE_AWARD_PROPERTY);
        }
        return !duplicateFound;
    }

    boolean areRequiredFieldsComplete(PendingTransaction pendingTransactionItem) {
        boolean itemValid = this.isSourceAwardFieldComplete(pendingTransactionItem);
        return itemValid &= this.isDestinationAwardFieldComplete(pendingTransactionItem);
    }

    protected boolean isSourceAwardFieldComplete(PendingTransaction pendingTransactionItem) {
        boolean itemValid;
        boolean bl = itemValid = pendingTransactionItem.getSourceAwardNumber() != null;
        if (!itemValid) {
            this.reportError(SOURCE_AWARD_PROPERTY, "error.required", SOURCE_AWARD_ERROR_PARM);
        }
        return itemValid;
    }

    protected boolean isDestinationAwardFieldComplete(PendingTransaction pendingTransactionItem) {
        boolean itemValid;
        boolean bl = itemValid = pendingTransactionItem.getDestinationAwardNumber() != null;
        if (!itemValid) {
            this.reportError(DESTINATION_AWARD_PROPERTY, "error.required", DESTINATION_AWARD_ERROR_PARM);
        }
        return itemValid;
    }

    private boolean hasDuplicateErrorBeenReported() {
        return GlobalVariables.getMessageMap().containsMessageKey("error.awardPendingTransaction.notunique");
    }

    public AwardVersionService getAwardVersionService() {
        return KcServiceLocator.getService(AwardVersionService.class);
    }

    public boolean processParameterEnabledRules(AwardHierarchyNode awardHierarchyNode, AwardAmountInfo aai, TimeAndMoneyDocument doc) {
        boolean valid = true;
        ScaleTwoDecimal obligatedDirectChange = (ScaleTwoDecimal)awardHierarchyNode.getObligatedTotalDirect().subtract((AbstractDecimal)aai.getObligatedTotalDirect());
        ScaleTwoDecimal obligatedIndirectChange = (ScaleTwoDecimal)awardHierarchyNode.getObligatedTotalIndirect().subtract((AbstractDecimal)aai.getObligatedTotalIndirect());
        ScaleTwoDecimal anticipatedDirectChange = (ScaleTwoDecimal)awardHierarchyNode.getAnticipatedTotalDirect().subtract((AbstractDecimal)aai.getAnticipatedTotalDirect());
        ScaleTwoDecimal anticipatedIndirectChange = (ScaleTwoDecimal)awardHierarchyNode.getAnticipatedTotalIndirect().subtract((AbstractDecimal)aai.getAnticipatedTotalIndirect());
        boolean obligatedTotalChanged = ((ScaleTwoDecimal)awardHierarchyNode.getObligatedTotalDirect().add((AbstractDecimal)awardHierarchyNode.getObligatedTotalIndirect())).isNonZero();
        boolean anticipatedTotalChanged = ((ScaleTwoDecimal)awardHierarchyNode.getAnticipatedTotalDirect().add((AbstractDecimal)awardHierarchyNode.getAnticipatedTotalIndirect())).isNonZero();
        if (obligatedTotalChanged || anticipatedTotalChanged) {
            ScaleTwoDecimal obligatedNetEffect = (ScaleTwoDecimal)awardHierarchyNode.getObligatedTotalDirect().add((AbstractDecimal)awardHierarchyNode.getObligatedTotalIndirect());
            ScaleTwoDecimal anticipatedNetEffect = (ScaleTwoDecimal)awardHierarchyNode.getAnticipatedTotalDirect().add((AbstractDecimal)awardHierarchyNode.getAnticipatedTotalIndirect());
            if (obligatedNetEffect.isNegative() && anticipatedNetEffect.isPositive() || obligatedNetEffect.isPositive() && anticipatedNetEffect.isNegative()) {
                this.reportError(TOTALS, "error.net.totals.transaction", new String[0]);
                valid = false;
            }
        }
        if ((obligatedDirectChange.isPositive() && obligatedIndirectChange.isNegative() || obligatedDirectChange.isNegative() && obligatedIndirectChange.isPositive()) && obligatedTotalChanged || (anticipatedDirectChange.isPositive() && anticipatedIndirectChange.isNegative() || anticipatedDirectChange.isNegative() && anticipatedIndirectChange.isPositive()) && anticipatedTotalChanged) {
            this.reportError(TIME_AND_MONEY_TRANSACTION, "error.net.totals.transaction", new String[0]);
            valid = false;
        }
        valid &= this.validateAwardTotalCostLimit(awardHierarchyNode, aai.getAward());
        if (!doc.isInitialSave() && doc.getAwardAmountTransactions().size() > 0 && doc.getAwardAmountTransactions().get(0).getTransactionTypeCode() == null) {
            valid = false;
            this.reportError("newAwardAmountTransaction.transactionTypeCode", "error.transaction.type.code.required", new String[0]);
        }
        ScaleTwoDecimal obligatedTotal = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal anticipatedTotal = ScaleTwoDecimal.ZERO;
        obligatedTotal = (ScaleTwoDecimal)obligatedTotal.add((AbstractDecimal)awardHierarchyNode.getObligatedTotalDirect());
        obligatedTotal = (ScaleTwoDecimal)obligatedTotal.add((AbstractDecimal)awardHierarchyNode.getObligatedTotalIndirect());
        anticipatedTotal = (ScaleTwoDecimal)anticipatedTotal.add((AbstractDecimal)awardHierarchyNode.getAnticipatedTotalDirect());
        if (obligatedTotal.isGreaterThan((AbstractDecimal)(anticipatedTotal = (ScaleTwoDecimal)anticipatedTotal.add((AbstractDecimal)awardHierarchyNode.getAnticipatedTotalIndirect())))) {
            this.reportError(TIME_AND_MONEY_TRANSACTION, "error.anticipated.amount", new String[0]);
            valid = false;
        }
        if (awardHierarchyNode.getAmountObligatedToDate().isLessThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            this.reportError(TIME_AND_MONEY_TRANSACTION, "error.award.obligated.negative", new String[0]);
            valid = false;
        }
        return valid;
    }

    public boolean processParameterDisabledRules(AwardHierarchyNode awardHierarchyNode, AwardAmountInfo aai, TimeAndMoneyDocument doc) {
        boolean valid = true;
        ScaleTwoDecimal obligatedChange = (ScaleTwoDecimal)awardHierarchyNode.getAmountObligatedToDate().subtract((AbstractDecimal)aai.getAmountObligatedToDate());
        ScaleTwoDecimal anticipatedChange = (ScaleTwoDecimal)awardHierarchyNode.getAnticipatedTotalAmount().subtract((AbstractDecimal)aai.getAnticipatedTotalAmount());
        if (obligatedChange.isPositive() && anticipatedChange.isNegative() || obligatedChange.isNegative() && anticipatedChange.isPositive()) {
            this.reportError(TIME_AND_MONEY_TRANSACTION, "error.net.totals.transaction", new String[0]);
            valid = false;
        }
        if (awardHierarchyNode.getAmountObligatedToDate().isGreaterThan((AbstractDecimal)awardHierarchyNode.getAnticipatedTotalAmount())) {
            this.reportError(TIME_AND_MONEY_TRANSACTION, "error.anticipated.amount", new String[0]);
            valid = false;
        }
        if (awardHierarchyNode.getAmountObligatedToDate().isLessThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            this.reportError(TIME_AND_MONEY_TRANSACTION, "error.award.obligated.negative", new String[0]);
            valid = false;
        }
        if (awardHierarchyNode.getAnticipatedTotalAmount().isLessThan((AbstractDecimal)ScaleTwoDecimal.ZERO)) {
            this.reportError(TIME_AND_MONEY_TRANSACTION, "error.award.anticipated.negative", new String[0]);
            valid = false;
        }
        valid &= this.validateAwardTotalCostLimit(awardHierarchyNode, aai.getAward());
        if (!doc.isInitialSave() && doc.getAwardAmountTransactions().size() > 0 && doc.getAwardAmountTransactions().get(0).getTransactionTypeCode() == null) {
            valid = false;
            this.reportError("newAwardAmountTransaction.transactionTypeCode", "error.transaction.type.code.required", new String[0]);
        }
        return valid;
    }

    protected boolean validateAwardTotalCostLimit(AwardHierarchyNode awardHierarchyNode, Award award) {
        if (award.getTotalCostBudgetLimit() != null && award.getTotalCostBudgetLimit().isGreaterThan((AbstractDecimal)awardHierarchyNode.getObliDistributableAmount())) {
            this.reportWarning(TIME_AND_MONEY_TRANSACTION, "warning.transaction.obligated.less.than.limit", award.getAwardNumber());
        }
        return true;
    }
}

