/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.engine.transition;

import java.util.ArrayList;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.RouteHelper;
import org.kuali.rice.kew.engine.node.Branch;
import org.kuali.rice.kew.engine.node.ProcessResult;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.engine.node.SplitNode;
import org.kuali.rice.kew.engine.node.SplitResult;
import org.kuali.rice.kew.engine.transition.Transition;
import org.kuali.rice.kew.engine.transition.TransitionEngine;

public class SplitTransitionEngine
extends TransitionEngine {
    @Override
    public ProcessResult isComplete(RouteContext context) throws Exception {
        SplitNode node = (SplitNode)this.getNode(context.getNodeInstance().getRouteNode(), SplitNode.class);
        return node.process(context, this.getRouteHelper());
    }

    @Override
    public Transition transitionFrom(RouteContext context, ProcessResult processResult) throws Exception {
        RouteNodeInstance splitInstance = context.getNodeInstance();
        ArrayList<RouteNodeInstance> nextNodeInstances = new ArrayList<RouteNodeInstance>();
        SplitResult result = (SplitResult)processResult;
        for (String branchName : result.getBranchNames()) {
            for (RouteNode routeNode : splitInstance.getRouteNode().getNextNodes()) {
                if (routeNode.getBranch() == null || !routeNode.getBranch().getName().equals(branchName)) continue;
                nextNodeInstances.add(SplitTransitionEngine.createSplitChild(branchName, routeNode, splitInstance));
            }
        }
        return new Transition(nextNodeInstances);
    }

    public static RouteNodeInstance createSplitChild(String branchName, RouteNode routeNode, RouteNodeInstance splitInstance) {
        RouteHelper routeHelper = new RouteHelper();
        RouteNodeInstance nextNodeInstance = routeHelper.getNodeFactory().createRouteNodeInstance(splitInstance.getDocumentId(), routeNode);
        Branch branch = routeHelper.getNodeFactory().createBranch(branchName, splitInstance.getBranch(), nextNodeInstance);
        branch.setSplitNode(splitInstance);
        nextNodeInstance.setBranch(branch);
        nextNodeInstance.setProcess(splitInstance.getProcess());
        return nextNodeInstance;
    }
}

