/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.postgresql;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.dbsupport.SqlStatementBuilder;
import org.flywaydb.core.internal.dbsupport.postgresql.PostgreSQLSchema;
import org.flywaydb.core.internal.dbsupport.postgresql.PostgreSQLSqlStatementBuilder;
import org.flywaydb.core.internal.util.StringUtils;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

public class PostgreSQLDbSupport
extends DbSupport {
    public PostgreSQLDbSupport(Connection connection) {
        super(new JdbcTemplate(connection, 0));
    }

    @Override
    public String getDbName() {
        return "postgresql";
    }

    @Override
    public String getCurrentUserFunction() {
        return "current_user";
    }

    @Override
    protected String doGetCurrentSchema() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT current_schema()", new String[0]);
    }

    @Override
    protected void doSetCurrentSchema(Schema schema) throws SQLException {
        if (schema == null) {
            this.jdbcTemplate.execute("SELECT set_config('search_path', '', false)", new Object[0]);
            return;
        }
        String searchPath = this.jdbcTemplate.queryForString("SHOW search_path", new String[0]);
        if (StringUtils.hasText(searchPath)) {
            this.jdbcTemplate.execute("SET search_path = " + schema + "," + searchPath, new Object[0]);
        } else {
            this.jdbcTemplate.execute("SET search_path = " + schema, new Object[0]);
        }
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "TRUE";
    }

    @Override
    public String getBooleanFalse() {
        return "FALSE";
    }

    @Override
    public SqlStatementBuilder createSqlStatementBuilder() {
        return new PostgreSQLSqlStatementBuilder();
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + StringUtils.replaceAll(identifier, "\"", "\"\"") + "\"";
    }

    @Override
    public Schema getSchema(String name) {
        return new PostgreSQLSchema(this.jdbcTemplate, this, name);
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public void executePgCopy(Connection connection, String sql) throws SQLException {
        int split = sql.indexOf(";");
        String statement = sql.substring(0, split);
        String data = sql.substring(split + 1).trim();
        CopyManager copyManager = new CopyManager((BaseConnection)connection.unwrap(Connection.class));
        try {
            copyManager.copyIn(statement, (Reader)new StringReader(data));
        }
        catch (IOException e) {
            throw new SQLException("Unable to execute COPY operation", e);
        }
    }
}

