/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krms.api.repository.RuleRepositoryService;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeRuleEntry;
import org.kuali.rice.krms.api.repository.agenda.AgendaTreeSubAgendaEntry;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.context.ContextSelectionCriteria;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.AgendaItemBo;
import org.kuali.rice.krms.impl.repository.ContextBo;
import org.kuali.rice.krms.impl.repository.RuleBo;

public class RuleRepositoryServiceImpl
implements RuleRepositoryService {
    protected DataObjectService dataObjectService;

    public ContextDefinition selectContext(ContextSelectionCriteria contextSelectionCriteria) {
        if (contextSelectionCriteria == null) {
            throw new RiceIllegalArgumentException("selection criteria is null");
        }
        if (StringUtils.isBlank((String)contextSelectionCriteria.getNamespaceCode())) {
            throw new RiceIllegalArgumentException("selection criteria namespaceCode is null or blank");
        }
        QueryByCriteria queryCriteria = this.buildQuery(contextSelectionCriteria);
        QueryResults results = this.getDataObjectService().findMatching(ContextBo.class, queryCriteria);
        List resultBos = results.getResults();
        ContextDefinition result = null;
        if (!CollectionUtils.isEmpty((Collection)resultBos)) {
            if (resultBos.size() == 1) {
                ContextBo bo = (ContextBo)resultBos.iterator().next();
                return ContextBo.to(bo);
            }
            throw new RiceIllegalArgumentException("Ambiguous context qualifiers, can not select more than one context.");
        }
        return result;
    }

    public AgendaTreeDefinition getAgendaTree(String agendaId) {
        if (StringUtils.isBlank((String)agendaId)) {
            throw new RiceIllegalArgumentException("agenda id is null or blank");
        }
        AgendaBo agendaBo = (AgendaBo)this.getDataObjectService().find(AgendaBo.class, (Object)agendaId);
        if (agendaBo == null) {
            return null;
        }
        String agendaItemId = agendaBo.getFirstItemId();
        AgendaTreeDefinition.Builder myBuilder = AgendaTreeDefinition.Builder.create();
        myBuilder.setAgendaId(agendaId);
        if (agendaItemId != null) {
            myBuilder = this.walkAgendaItemTree(agendaItemId, myBuilder);
        }
        return myBuilder.build();
    }

    public List<AgendaTreeDefinition> getAgendaTrees(List<String> agendaIds) {
        ArrayList<AgendaTreeDefinition> agendaTrees = new ArrayList<AgendaTreeDefinition>();
        if (agendaIds == null) {
            return agendaTrees;
        }
        for (String agendaId : agendaIds) {
            if (this.getAgendaTree(agendaId) == null) continue;
            agendaTrees.add(this.getAgendaTree(agendaId));
        }
        return Collections.unmodifiableList(agendaTrees);
    }

    public RuleDefinition getRule(String ruleId) {
        if (StringUtils.isBlank((String)ruleId)) {
            return null;
        }
        RuleBo bo = (RuleBo)this.getDataObjectService().find(RuleBo.class, (Object)ruleId);
        return RuleBo.to(bo);
    }

    public List<RuleDefinition> getRules(List<String> ruleIds) {
        if (ruleIds == null) {
            throw new RiceIllegalArgumentException("ruleIds must not be null");
        }
        List bos = null;
        if (ruleIds.size() == 0) {
            bos = Collections.emptyList();
        } else {
            QueryByCriteria.Builder qBuilder = QueryByCriteria.Builder.create();
            ArrayList pList = new ArrayList();
            qBuilder.setPredicates(new Predicate[]{PredicateFactory.in((String)"id", (Object[])ruleIds.toArray())});
            QueryResults results = this.getDataObjectService().findMatching(RuleBo.class, qBuilder.build());
            bos = results.getResults();
        }
        ArrayList<RuleDefinition> rules = new ArrayList<RuleDefinition>();
        for (RuleBo bo : bos) {
            RuleDefinition rule = RuleBo.to(bo);
            rules.add(rule);
        }
        return Collections.unmodifiableList(rules);
    }

    private AgendaTreeDefinition.Builder walkAgendaItemTree(String agendaItemId, AgendaTreeDefinition.Builder builder) {
        if (StringUtils.isBlank((String)agendaItemId)) {
            return null;
        }
        AgendaItemBo agendaItemBo = (AgendaItemBo)this.getDataObjectService().find(AgendaItemBo.class, (Object)agendaItemId);
        if (!StringUtils.isBlank((String)agendaItemBo.getRuleId())) {
            AgendaTreeDefinition.Builder myBuilder;
            AgendaTreeRuleEntry.Builder ruleEntryBuilder = AgendaTreeRuleEntry.Builder.create((String)agendaItemBo.getId(), (String)agendaItemBo.getRuleId());
            ruleEntryBuilder.setRuleId(agendaItemBo.getRuleId());
            ruleEntryBuilder.setAgendaItemId(agendaItemBo.getId());
            if (agendaItemBo.getWhenTrueId() != null) {
                myBuilder = AgendaTreeDefinition.Builder.create();
                myBuilder.setAgendaId(agendaItemBo.getAgendaId());
                ruleEntryBuilder.setIfTrue(this.walkAgendaItemTree(agendaItemBo.getWhenTrueId(), myBuilder));
            }
            if (agendaItemBo.getWhenFalseId() != null) {
                myBuilder = AgendaTreeDefinition.Builder.create();
                myBuilder.setAgendaId(agendaItemBo.getAgendaId());
                ruleEntryBuilder.setIfFalse(this.walkAgendaItemTree(agendaItemBo.getWhenFalseId(), myBuilder));
            }
            builder.addRuleEntry(ruleEntryBuilder.build());
        }
        if (!StringUtils.isBlank((String)agendaItemBo.getSubAgendaId())) {
            AgendaTreeSubAgendaEntry.Builder subAgendaEntryBuilder = AgendaTreeSubAgendaEntry.Builder.create((String)agendaItemBo.getId(), (String)agendaItemBo.getSubAgendaId());
            builder.addSubAgendaEntry(subAgendaEntryBuilder.build());
        }
        if (!StringUtils.isBlank((String)agendaItemBo.getAlwaysId())) {
            builder = this.walkAgendaItemTree(agendaItemBo.getAlwaysId(), builder);
        }
        return builder;
    }

    private QueryByCriteria buildQuery(ContextSelectionCriteria selectionCriteria) {
        Predicate p;
        QueryByCriteria.Builder qBuilder = QueryByCriteria.Builder.create();
        ArrayList<Predicate> pList = new ArrayList<Predicate>();
        if (selectionCriteria.getNamespaceCode() != null) {
            p = PredicateFactory.equal((String)"namespace", (Object)selectionCriteria.getNamespaceCode());
            pList.add(p);
        }
        if (selectionCriteria.getName() != null) {
            p = PredicateFactory.equal((String)"name", (Object)selectionCriteria.getName());
            pList.add(p);
        }
        if (selectionCriteria.getContextQualifiers() != null) {
            for (Map.Entry entry : selectionCriteria.getContextQualifiers().entrySet()) {
                p = PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"attributeBos.attributeDefinition.name", entry.getKey()), PredicateFactory.equal((String)"attributeBos.value", entry.getValue())});
                pList.add(p);
            }
        }
        Predicate[] preds = new Predicate[pList.size()];
        pList.toArray(preds);
        qBuilder.setPredicates(new Predicate[]{PredicateFactory.and((Predicate[])preds)});
        return qBuilder.build();
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KRADServiceLocator.getDataObjectService();
        }
        return this.dataObjectService;
    }
}

