/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.util.ArrayList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.CustomFontCollection;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontCollection;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontInfoConfigurator;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontManagerConfigurator;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.base14.Base14FontCollection;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.render.pdf.PDFRendererConfigurator;
import org.apache.fop.svg.PDFDocumentGraphics2D;

public class PDFDocumentGraphics2DConfigurator {
    public void configure(PDFDocumentGraphics2D graphics, Configuration cfg, boolean useComplexScriptFeatures) throws ConfigurationException {
        PDFDocument pdfDoc = graphics.getPDFDocument();
        pdfDoc.setFilterMap(PDFRendererConfigurator.buildFilterMapFromConfiguration(cfg));
        try {
            FontInfo fontInfo = PDFDocumentGraphics2DConfigurator.createFontInfo(cfg, useComplexScriptFeatures);
            graphics.setFontInfo(fontInfo);
        }
        catch (FOPException e) {
            throw new ConfigurationException("Error while setting up fonts", (Throwable)e);
        }
    }

    public static FontInfo createFontInfo(Configuration cfg, boolean useComplexScriptFeatures) throws FOPException {
        FontInfo fontInfo = new FontInfo();
        boolean strict = false;
        FontResolver fontResolver = FontManager.createMinimalFontResolver(useComplexScriptFeatures);
        FontManager fontManager = new FontManager();
        if (cfg != null) {
            FontManagerConfigurator fmConfigurator = new FontManagerConfigurator(cfg);
            fmConfigurator.configure(fontManager, false);
        }
        ArrayList<FontCollection> fontCollections = new ArrayList<FontCollection>();
        fontCollections.add(new Base14FontCollection(fontManager.isBase14KerningEnabled()));
        if (cfg != null) {
            FontEventListener listener = null;
            FontInfoConfigurator fontInfoConfigurator = new FontInfoConfigurator(cfg, fontManager, fontResolver, listener, false);
            ArrayList<EmbedFontInfo> fontInfoList = new ArrayList<EmbedFontInfo>();
            fontInfoConfigurator.configure(fontInfoList);
            fontCollections.add(new CustomFontCollection(fontResolver, fontInfoList, fontResolver.isComplexScriptFeaturesEnabled()));
        }
        fontManager.setup(fontInfo, fontCollections.toArray(new FontCollection[fontCollections.size()]));
        return fontInfo;
    }
}

