/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.rice.krad.service.impl;

import co.kuali.rice.coreservice.api.attachment.S3FileService;
import co.kuali.rice.krad.service.impl.RiceAttachmentDataToS3Conversion;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.Attachment;
import org.kuali.rice.krad.data.DataObjectService;
import org.quartz.DisallowConcurrentExecution;

@DisallowConcurrentExecution
public class RiceAttachmentDataToS3ConversionImpl
implements RiceAttachmentDataToS3Conversion {
    private static final int MAX_DIR_LEVELS = 6;
    private static final String DELETE_FILE_FROM_FILESYSTEM = "DELETE_FILE_FROM_FILESYSTEM";
    private static final Logger LOG = LogManager.getLogger(RiceAttachmentDataToS3ConversionImpl.class);
    private S3FileService riceS3FileService;
    private ParameterService parameterService;
    private DataObjectService dataObjectService;
    private ConfigurationService kualiConfigurationService;

    @Override
    public void execute() {
        LOG.info("Starting attachment conversion job for file_data to S3");
        if (!this.processRecords()) {
            return;
        }
        List attachments = this.dataObjectService.findAll(Attachment.class).getResults();
        attachments.forEach(attachment -> {
            block14: {
                try {
                    byte[] s3Bytes;
                    File file = new File(this.getDocumentDirectory(attachment.getNote().getRemoteObjectIdentifier()) + File.separator + attachment.getAttachmentIdentifier());
                    if (!file.isFile() || !file.exists()) break block14;
                    byte[] fsBytes = FileUtils.readFileToByteArray((File)file);
                    String fileDataId = attachment.getAttachmentIdentifier();
                    Object s3File = this.riceS3FileService.retrieveFile(fileDataId);
                    if (s3File == null) {
                        Class<?> s3FileClass = Class.forName("co.kuali.coeus.s3.api.S3File");
                        Object newS3File = s3FileClass.newInstance();
                        Method setId = s3FileClass.getMethod("setId", String.class);
                        setId.invoke(newS3File, fileDataId);
                        Method setFileContents = s3FileClass.getMethod("setFileContents", InputStream.class);
                        try (BufferedInputStream stream = new BufferedInputStream(new ByteArrayInputStream(fsBytes));){
                            setFileContents.invoke(newS3File, stream);
                            this.riceS3FileService.createFile(newS3File);
                        }
                        s3Bytes = this.getBytesFromS3File(this.riceS3FileService.retrieveFile(fileDataId));
                    } else {
                        if (LOG.isDebugEnabled()) {
                            Method getFileMetaData = s3File.getClass().getMethod("getFileMetaData", new Class[0]);
                            LOG.debug("data found in S3, existing id: " + fileDataId + " note id " + attachment.getNoteIdentifier() + " metadata: " + getFileMetaData.invoke(s3File, new Object[0]));
                        }
                        s3Bytes = this.getBytesFromS3File(s3File);
                    }
                    if (s3Bytes != null && fsBytes != null) {
                        String dbMD5;
                        String s3MD5 = DigestUtils.md5Hex((byte[])s3Bytes);
                        if (!Objects.equals(s3MD5, dbMD5 = DigestUtils.md5Hex((byte[])fsBytes))) {
                            LOG.error("S3 data MD5: " + s3MD5 + " does not equal DB data MD5: " + dbMD5 + " for id: " + fileDataId + " note id " + attachment.getNoteIdentifier());
                        } else if (this.isDeleteFromFileSystem()) {
                            file.delete();
                        }
                    }
                }
                catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        LOG.info("Finishing attachment conversion job for file_data to S3");
    }

    protected byte[] getBytesFromS3File(Object s3File) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, IOException {
        Method getFileContents = s3File.getClass().getMethod("getFileContents", new Class[0]);
        InputStream fileContents = (InputStream)getFileContents.invoke(s3File, new Object[0]);
        byte[] s3Bytes = IOUtils.toByteArray((InputStream)fileContents);
        return s3Bytes;
    }

    protected String getDocumentDirectory(String objectId) {
        boolean success;
        File documentDirectory = new File(this.getDocumentFileStorageLocation(objectId));
        if (!documentDirectory.exists() && !(success = documentDirectory.mkdirs())) {
            throw new RuntimeException("Could not generate directory for File at: " + documentDirectory.getAbsolutePath());
        }
        return documentDirectory.getAbsolutePath();
    }

    private String getDocumentFileStorageLocation(String objectId) {
        Object location;
        if (StringUtils.isEmpty((String)objectId)) {
            location = this.kualiConfigurationService.getPropertyValueAsString("attachments.pending.directory");
        } else {
            char[] chars = objectId.toUpperCase().replace(" ", "").toCharArray();
            int count = chars.length < 6 ? chars.length : 6;
            StringBuffer prefix = new StringBuffer();
            for (int i = 0; i < count; ++i) {
                prefix.append(File.separator + chars[i]);
            }
            location = this.kualiConfigurationService.getPropertyValueAsString("attachments.directory") + prefix + File.separator + objectId;
        }
        return location;
    }

    protected boolean processRecords() {
        boolean s3DualSaveEnabled;
        boolean s3IntegrationEnabled = this.isS3IntegrationEnabled();
        if (!s3IntegrationEnabled) {
            LOG.info("S3 integration is not enabled.  Records will not be processed");
        }
        if (s3DualSaveEnabled = this.isS3DualSaveEnabled()) {
            LOG.info("S3 dual save is enabled.  Records will not be processed");
        }
        return s3IntegrationEnabled && !s3DualSaveEnabled;
    }

    protected boolean isS3IntegrationEnabled() {
        if (this.parameterService.parameterExists("KR-SYS", "All", "S3_INTEGRATION_ENABLED").booleanValue()) {
            return this.parameterService.getParameterValueAsBoolean("KR-SYS", "All", "S3_INTEGRATION_ENABLED");
        }
        return false;
    }

    protected boolean isS3DualSaveEnabled() {
        return this.parameterService.getParameterValueAsBoolean("KR-SYS", "All", "S3_DUAL_SAVE_ENABLED");
    }

    protected boolean isDeleteFromFileSystem() {
        return this.parameterService.getParameterValueAsBoolean("KR-SYS", "All", DELETE_FILE_FROM_FILESYSTEM);
    }

    public S3FileService getRiceS3FileService() {
        return this.riceS3FileService;
    }

    public void setRiceS3FileService(S3FileService riceS3FileService) {
        this.riceS3FileService = riceS3FileService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public ConfigurationService getKualiConfigurationService() {
        return this.kualiConfigurationService;
    }

    public void setKualiConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }
}

