/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.web.struts.action;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.OptimisticLockException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.RiceConstants;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.action.DocumentActionParameters;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.datadictionary.KNSDocumentEntry;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.document.authorization.DocumentAuthorizer;
import org.kuali.rice.kns.document.authorization.DocumentPresentationController;
import org.kuali.rice.kns.rule.PromptBeforeValidation;
import org.kuali.rice.kns.rule.event.PromptBeforeValidationEvent;
import org.kuali.rice.kns.service.BusinessObjectAuthorizationService;
import org.kuali.rice.kns.service.BusinessObjectMetaDataService;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.kns.service.DocumentHelperService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.struts.action.ActionForwardCallback;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.kns.web.struts.action.PostTransactionActionForward;
import org.kuali.rice.kns.web.struts.form.BlankFormFile;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.kns.web.struts.form.KualiMaintenanceForm;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.UserSessionUtils;
import org.kuali.rice.krad.bo.AdHocRoutePerson;
import org.kuali.rice.krad.bo.AdHocRouteRecipient;
import org.kuali.rice.krad.bo.AdHocRouteWorkgroup;
import org.kuali.rice.krad.bo.Attachment;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.Note;
import org.kuali.rice.krad.datadictionary.DataDictionary;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.exception.DocumentAuthorizationException;
import org.kuali.rice.krad.exception.UnknownDocumentIdException;
import org.kuali.rice.krad.rules.rule.event.AddAdHocRoutePersonEvent;
import org.kuali.rice.krad.rules.rule.event.AddAdHocRouteWorkgroupEvent;
import org.kuali.rice.krad.rules.rule.event.AddNoteEvent;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.rules.rule.event.RouteDocumentEvent;
import org.kuali.rice.krad.rules.rule.event.SendAdHocRequestsEvent;
import org.kuali.rice.krad.service.AttachmentService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.service.NoteService;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.util.NoteType;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.util.SessionTicket;
import org.kuali.rice.krad.util.UrlFactory;
import org.kuali.rice.ksb.api.KsbApiServiceLocator;
import org.springframework.transaction.PlatformTransactionManager;
import org.springmodules.orm.ojb.OjbOperationException;

@Deprecated
public class KualiDocumentActionBase
extends KualiAction {
    private static final Logger LOG = LogManager.getLogger(KualiDocumentActionBase.class);
    protected static final String[] DOCUMENT_LOAD_COMMANDS = new String[]{"displayActionListView", "displayDocSearchView", "displaySuperUserView", "displayHelpDeskActionListView"};
    private DataDictionaryService dataDictionaryService;
    private DocumentHelperService documentHelperService;
    private DocumentService documentService;
    private ConfigurationService kualiConfigurationService;
    private ParameterService parameterService;
    private PessimisticLockService pessimisticLockService;
    private KualiRuleService kualiRuleService;
    private GroupService groupService;
    private AttachmentService attachmentService;
    private NoteService noteService;
    private BusinessObjectAuthorizationService businessObjectAuthorizationService;
    private BusinessObjectService businessObjectService;
    private BusinessObjectMetaDataService businessObjectMetaDataService;
    private EntityManagerFactory entityManagerFactory;
    private PlatformTransactionManager transactionManager;

    @Override
    protected void checkAuthorization(ActionForm form, String methodToCall) throws AuthorizationException {
        if (!(form instanceof KualiDocumentFormBase)) {
            super.checkAuthorization(form, methodToCall);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward returnForward;
        block18: {
            returnForward = mapping.findForward("basic");
            try {
                returnForward = super.execute(mapping, form, request, response);
            }
            catch (OjbOperationException e) {
                OjbOperationException ooe = e;
                Throwable cause = ooe.getCause();
                if (cause instanceof OptimisticLockException) {
                    OptimisticLockException ole = (OptimisticLockException)cause;
                    GlobalVariables.getMessageMap().putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.document.optimisticLockException", new String[0]);
                    this.logOjbOptimisticLockException(ole);
                    break block18;
                }
                throw e;
            }
            finally {
                if (form instanceof KualiDocumentFormBase) {
                    ((KualiDocumentFormBase)form).setMessageMapFromPreviousRequest(GlobalVariables.getMessageMap());
                }
            }
        }
        if (form instanceof KualiDocumentFormBase && ((KualiDocumentFormBase)form).isHasWorkflowDocument()) {
            KualiDocumentFormBase formBase = (KualiDocumentFormBase)form;
            Document document = formBase.getDocument();
            WorkflowDocument workflowDocument = formBase.getDocument().getDocumentHeader().getWorkflowDocument();
            formBase.populateHeaderFields(workflowDocument);
            formBase.setDocId(document.getDocumentNumber());
            if (this.isFormRepresentingLockObject(formBase)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Form " + formBase + " represents a PessimisticLock BO object");
                }
            } else {
                String methodCalledViaDispatch;
                String attachmentEnabled;
                this.populateAuthorizationFields(formBase);
                this.populateAdHocActionRequestCodes(formBase);
                UserSession userSession = (UserSession)request.getSession().getAttribute("UserSession");
                if (WebUtils.isDocumentSession(document, formBase)) {
                    String formKey = formBase.getFormKey();
                    if (StringUtils.isBlank((String)formBase.getFormKey()) || userSession.retrieveObject(formBase.getFormKey()) == null) {
                        formKey = GlobalVariables.getUserSession().addObjectWithGeneratedKey((Object)form);
                        formBase.setFormKey(formKey);
                    }
                }
                request.getSession().setAttribute("documentHttpSessionKey", (Object)document.getDocumentNumber());
                if ("displayActionListView".equals(formBase.getCommand())) {
                    formBase.setReturnToActionList(true);
                }
                if ((attachmentEnabled = this.getKualiConfigurationService().getPropertyValueAsString("enableNoteAttachments")) != null) {
                    DataDictionary dataDictionary = this.getDataDictionaryService().getDataDictionary();
                    DocumentEntry entry = dataDictionary.getDocumentEntry(document.getClass().getName());
                    entry.setAllowsNoteAttachments(Boolean.parseBoolean(attachmentEnabled));
                }
                if (this.exitingDocument()) {
                    request.setAttribute("exitingDocument", (Object)Boolean.TRUE);
                }
                if (StringUtils.isNotBlank((String)(methodCalledViaDispatch = (String)GlobalVariables.getUserSession().retrieveObject("METHOD_TO_CALL_KEYS_METHOD_OBJECT_KEY"))) && this.exitingDocument()) {
                    GlobalVariables.getUserSession().removeObject("METHOD_TO_CALL_KEYS_COMPLETE_OBJECT_KEY");
                    this.attemptLockRelease(document, methodCalledViaDispatch);
                }
                this.setupPessimisticLockMessages(document, request);
                if (!document.getPessimisticLocks().isEmpty()) {
                    String warningMinutes = this.getParameterService().getParameterValueAsString("KR-NS", "Document", "SESSION_TIMEOUT_WARNING_MESSAGE_TIME");
                    request.setAttribute("SESSION_TIMEOUT_WARNING_MINUTES", (Object)warningMinutes);
                    request.setAttribute("SESSION_TIMEOUT_WARNING_MILLISECONDS", (Object)((request.getSession().getMaxInactiveInterval() - Integer.valueOf(warningMinutes) * 60) * 1000));
                }
            }
            List actionRequests = KewApiServiceLocator.getWorkflowDocumentService().getPendingActionRequests(formBase.getDocId());
            formBase.setActionRequests(actionRequests);
        }
        return returnForward;
    }

    protected boolean isFormRepresentingLockObject(KualiDocumentFormBase form) throws Exception {
        KualiMaintenanceForm maintForm;
        if (form instanceof KualiMaintenanceForm && ObjectUtils.isNotNull((maintForm = (KualiMaintenanceForm)form).getBusinessObjectClassName())) {
            return PessimisticLock.class.isAssignableFrom(Class.forName(((KualiMaintenanceForm)form).getBusinessObjectClassName()));
        }
        return false;
    }

    protected void attemptLockRelease(Document document, String methodToCall) {
        if (document != null && !document.getPessimisticLocks().isEmpty()) {
            this.releaseLocks(document, methodToCall);
            document.refreshPessimisticLocks();
        }
    }

    protected void releaseLocks(Document document, String methodToCall) {
        if (document.getLockClearingMethodNames().contains(methodToCall)) {
            this.getPessimisticLockService().releaseAllLocksForUser(document.getPessimisticLocks(), GlobalVariables.getUserSession().getPerson());
        }
    }

    protected void setupPessimisticLockMessages(Document document, HttpServletRequest request) {
        ArrayList<String> lockMessages = new ArrayList<String>();
        for (PessimisticLock lock : document.getPessimisticLocks()) {
            if (lock.isOwnedByUser(GlobalVariables.getUserSession().getPerson())) continue;
            lockMessages.add(this.generatePessimisticLockMessage(lock));
        }
        request.setAttribute("DocumentPessimisticLockMessages", lockMessages);
    }

    protected String generatePessimisticLockMessage(PessimisticLock lock) {
        String descriptor = lock.getLockDescriptor() != null ? lock.getLockDescriptor() : "";
        return "This document currently has a " + descriptor + " lock owned by " + lock.getOwnedByUser().getName() + " as of " + RiceConstants.getDefaultTimeFormat().format(lock.getGeneratedTimestamp()) + " on " + RiceConstants.getDefaultDateFormat().format(lock.getGeneratedTimestamp());
    }

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LOG.debug("docHandler(ActionMapping " + mapping + ", ActionForm " + form + ", HttpServletRequest request, HttpServletResponse response)");
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        String command = kualiDocumentFormBase.getCommand();
        LOG.debug("kualiDocumentFormBase.getCommand()=" + command);
        if (kualiDocumentFormBase.getDocId() != null && this.getDocumentService().getByDocumentHeaderId(kualiDocumentFormBase.getDocId()) == null) {
            ConfigurationService kualiConfigurationService = CoreApiServiceLocator.getKualiConfigurationService();
            StringBuffer sb = new StringBuffer();
            sb.append(kualiConfigurationService.getPropertyValueAsString("krad.url"));
            sb.append(kualiConfigurationService.getPropertyValueAsString("initiated.document.url"));
            response.sendRedirect(sb.toString());
            return new ActionForward("InitiatedDocumentView", sb.toString(), true);
        }
        if (ArrayUtils.contains((Object[])DOCUMENT_LOAD_COMMANDS, (Object)command) && kualiDocumentFormBase.getDocId() != null) {
            this.loadDocument(kualiDocumentFormBase);
        } else if ("initiate".equals(command)) {
            this.createDocument(kualiDocumentFormBase);
        } else {
            LOG.error("docHandler called with invalid parameters");
            LOG.error("mapping = " + mapping);
            LOG.error("kualiDocumentFormBase.getDocId() = " + kualiDocumentFormBase.getDocId());
            LOG.error("command = " + command);
            throw new IllegalArgumentException("docHandler called with invalid parameters");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("kualiDocumentFormBase.getAdditionalScriptFiles(): " + kualiDocumentFormBase.getAdditionalScriptFiles());
        }
        if (kualiDocumentFormBase.getAdditionalScriptFiles().isEmpty()) {
            KNSDocumentEntry docEntry = (KNSDocumentEntry)this.getDataDictionaryService().getDataDictionary().getDocumentEntry(kualiDocumentFormBase.getDocument().getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
            kualiDocumentFormBase.getAdditionalScriptFiles().addAll(docEntry.getWebScriptFiles());
        }
        if ("displaySuperUserView".equalsIgnoreCase(command)) {
            kualiDocumentFormBase.setSuppressAllButtons(true);
        }
        return mapping.findForward("basic");
    }

    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        String docId = kualiDocumentFormBase.getDocId();
        Document doc = null;
        doc = this.getDocumentService().getByDocumentHeaderId(docId);
        if (doc == null) {
            throw new UnknownDocumentIdException("Document no longer exists.  It may have been cancelled before being saved.");
        }
        WorkflowDocument workflowDocument = doc.getDocumentHeader().getWorkflowDocument();
        if (!this.getDocumentHelperService().getDocumentAuthorizer(doc).canOpen(doc, GlobalVariables.getUserSession().getPerson())) {
            throw this.buildAuthorizationException("open", doc);
        }
        if (workflowDocument != doc.getDocumentHeader().getWorkflowDocument()) {
            LOG.warn("Workflow document changed via canOpen check");
            doc.getDocumentHeader().setWorkflowDocument(workflowDocument);
        }
        kualiDocumentFormBase.setDocument(doc);
        WorkflowDocument workflowDoc = doc.getDocumentHeader().getWorkflowDocument();
        kualiDocumentFormBase.setDocTypeName(workflowDoc.getDocumentTypeName());
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)workflowDoc);
    }

    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        Document doc = this.getDocumentService().getNewDocument(kualiDocumentFormBase.getDocTypeName());
        UserSessionUtils.addWorkflowDocument((UserSession)GlobalVariables.getUserSession(), (WorkflowDocument)doc.getDocumentHeader().getWorkflowDocument());
        kualiDocumentFormBase.setDocument(doc);
        kualiDocumentFormBase.setDocTypeName(doc.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
    }

    public ActionForward insertAdHocRoutePerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        Document document = kualiDocumentFormBase.getDocument();
        DocumentAuthorizer documentAuthorizer = this.getDocumentHelperService().getDocumentAuthorizer(document);
        if (!documentAuthorizer.canSendAdHocRequests(document, kualiDocumentFormBase.getNewAdHocRoutePerson().getActionRequested(), GlobalVariables.getUserSession().getPerson())) {
            throw this.buildAuthorizationException("ad-hoc route", document);
        }
        boolean rulePassed = this.getKualiRuleService().applyRules((DocumentEvent)new AddAdHocRoutePersonEvent(document, kualiDocumentFormBase.getNewAdHocRoutePerson()));
        if (rulePassed) {
            kualiDocumentFormBase.getNewAdHocRoutePerson().setId(kualiDocumentFormBase.getNewAdHocRoutePerson().getId());
            kualiDocumentFormBase.getAdHocRoutePersons().add(kualiDocumentFormBase.getNewAdHocRoutePerson());
            AdHocRoutePerson person = new AdHocRoutePerson();
            kualiDocumentFormBase.setNewAdHocRoutePerson(person);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteAdHocRoutePerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        kualiDocumentFormBase.getAdHocRoutePersons().remove(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward insertAdHocRouteWorkgroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        Document document = kualiDocumentFormBase.getDocument();
        DocumentAuthorizer documentAuthorizer = this.getDocumentHelperService().getDocumentAuthorizer(document);
        if (!documentAuthorizer.canSendAdHocRequests(document, kualiDocumentFormBase.getNewAdHocRouteWorkgroup().getActionRequested(), GlobalVariables.getUserSession().getPerson())) {
            throw this.buildAuthorizationException("ad-hoc route", document);
        }
        boolean rulePassed = this.getKualiRuleService().applyRules((DocumentEvent)new AddAdHocRouteWorkgroupEvent(document, kualiDocumentFormBase.getNewAdHocRouteWorkgroup()));
        if (rulePassed) {
            AdHocRouteWorkgroup newWorkgroup = kualiDocumentFormBase.getNewAdHocRouteWorkgroup();
            if (newWorkgroup.getId() == null) {
                newWorkgroup.setId(KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(newWorkgroup.getRecipientNamespaceCode(), newWorkgroup.getRecipientName()).getId());
            }
            kualiDocumentFormBase.getAdHocRouteWorkgroups().add(newWorkgroup);
            AdHocRouteWorkgroup workgroup = new AdHocRouteWorkgroup();
            kualiDocumentFormBase.setNewAdHocRouteWorkgroup(workgroup);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteAdHocRouteWorkgroup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        kualiDocumentFormBase.getAdHocRouteWorkgroups().remove(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward sendAdHocRequests(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        Document document = kualiDocumentFormBase.getDocument();
        boolean rulePassed = this.getKualiRuleService().applyRules((DocumentEvent)new SendAdHocRequestsEvent(document));
        if (rulePassed) {
            this.getDocumentService().sendAdHocRequests(document, kualiDocumentFormBase.getAnnotation(), this.combineAdHocRecipients(kualiDocumentFormBase));
            KNSGlobalVariables.getMessageList().add("message.sendAdHocRequests.successful", new String[0]);
        }
        return mapping.findForward("basic");
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        Document document = kualiDocumentFormBase.getDocument();
        kualiDocumentFormBase.setDocId(document.getDocumentNumber());
        kualiDocumentFormBase.setCommand(DOCUMENT_LOAD_COMMANDS[1]);
        ActionForward actionForward = this.docHandler(mapping, form, request, response);
        KNSGlobalVariables.getMessageList().add("message.document.reloaded", new String[0]);
        return actionForward;
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        this.doProcessingAfterPost(kualiDocumentFormBase, request);
        this.refreshAdHocRoutingWorkgroupLookups(request, kualiDocumentFormBase);
        Document document = kualiDocumentFormBase.getDocument();
        ActionForward forward = this.checkAndWarnAboutSensitiveData(mapping, form, request, response, "documentExplanation", document.getDocumentHeader().getExplanation(), "save", "");
        if (forward != null) {
            return forward;
        }
        document = this.getDocumentService().saveDocument(document);
        ((KualiDocumentFormBase)form).setDocument(document);
        KNSGlobalVariables.getMessageList().add("message.saved", new String[0]);
        kualiDocumentFormBase.setAnnotation("");
        return mapping.findForward("basic");
    }

    protected ActionForward checkAndWarnAboutSensitiveData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String fieldName, String fieldValue, String caller, String context) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        Document document = kualiDocumentFormBase.getDocument();
        boolean containsSensitiveData = KRADUtils.containsSensitiveDataPatternMatch((String)fieldValue);
        boolean warnForSensitiveData = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsBoolean("KR-NS", "All", "SENSITIVE_DATA_PATTERNS_WARNING_IND");
        HashMap<String, String> ticketContext = new HashMap<String, String>();
        ticketContext.put("documentNumber", document.getDocumentNumber());
        ticketContext.put("caller", caller);
        ticketContext.put("name", fieldName);
        boolean questionAsked = GlobalVariables.getUserSession().hasMatchingSessionTicket("SENSITIVE_DATA_QUESTION_SESSION_TICKET", ticketContext);
        if (containsSensitiveData && warnForSensitiveData && !questionAsked) {
            String question = request.getParameter("questionIndex");
            if (question == null || !"DocSensitiveDataQuestion".equals(question)) {
                return this.performQuestionWithoutInput(mapping, form, request, response, "DocSensitiveDataQuestion", this.getKualiConfigurationService().getPropertyValueAsString("document.question.sensitiveData.text"), "confirmationQuestion", caller, context);
            }
            String buttonClicked = request.getParameter("buttonClicked");
            if (question != null && "DocSensitiveDataQuestion".equals(question)) {
                if ("1".equals(buttonClicked)) {
                    return mapping.findForward("basic");
                }
                SessionTicket ticket = new SessionTicket("SENSITIVE_DATA_QUESTION_SESSION_TICKET");
                ticket.setTicketContext(ticketContext);
                GlobalVariables.getUserSession().putSessionTicket(ticket);
            }
        }
        return null;
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        if (this.isFormRepresentingLockObject(kualiDocumentFormBase)) {
            String idValue = request.getParameter("id");
            this.getPessimisticLockService().delete(idValue);
            return this.returnToSender(request, mapping, kualiDocumentFormBase);
        }
        throw this.buildAuthorizationException("delete", kualiDocumentFormBase.getDocument());
    }

    public ActionForward performRouteReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        kualiDocumentFormBase.setDerivedValuesOnForm(request);
        ActionForward preRulesForward = this.promptBeforeValidation(mapping, form, request, response);
        if (preRulesForward != null) {
            return preRulesForward;
        }
        Document document = kualiDocumentFormBase.getDocument();
        if (!kualiDocumentFormBase.getDocumentActions().containsKey("canPerformRouteReport")) {
            throw this.buildAuthorizationException("perform route report", document);
        }
        String backUrlBase = this.getReturnLocation(request, mapping);
        String globalVariableFormKey = GlobalVariables.getUserSession().addObjectWithGeneratedKey((Object)form);
        request.setAttribute("backUrlBase", (Object)backUrlBase);
        ArrayList<ConcreteKeyValue> backFormParameters = new ArrayList<ConcreteKeyValue>();
        backFormParameters.add(new ConcreteKeyValue("methodToCall", "refresh"));
        backFormParameters.add(new ConcreteKeyValue("docFormKey", globalVariableFormKey));
        request.setAttribute("backFormHiddenVariables", backFormParameters);
        request.setAttribute("workflowRouteReportUrl", (Object)(this.getKualiConfigurationService().getPropertyValueAsString("workflow.url") + "/RoutingReport.do"));
        ArrayList<ConcreteKeyValue> generalRouteReportFormParameters = new ArrayList<ConcreteKeyValue>();
        generalRouteReportFormParameters.add(new ConcreteKeyValue("initiatorPrincipalId", document.getDocumentHeader().getWorkflowDocument().getDocument().getInitiatorPrincipalId()));
        generalRouteReportFormParameters.add(new ConcreteKeyValue("documentTypeParam", document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName()));
        String xml = document.getXmlForRouteReport();
        if (LOG.isDebugEnabled()) {
            LOG.debug("XML being used for Routing Report is: " + xml);
        }
        generalRouteReportFormParameters.add(new ConcreteKeyValue("documentContent", xml));
        ArrayList<ConcreteKeyValue> javaScriptFormParameters = new ArrayList<ConcreteKeyValue>();
        javaScriptFormParameters.addAll(generalRouteReportFormParameters);
        javaScriptFormParameters.add(new ConcreteKeyValue("showCloseButton", "showCloseButton"));
        request.setAttribute("javaScriptFormVariables", javaScriptFormParameters);
        ArrayList<ConcreteKeyValue> noJavaScriptFormParameters = new ArrayList<ConcreteKeyValue>();
        noJavaScriptFormParameters.addAll(generalRouteReportFormParameters);
        Properties parameters = new Properties();
        for (KeyValue keyValue : backFormParameters) {
            parameters.put(keyValue.getKey(), keyValue.getValue());
        }
        noJavaScriptFormParameters.add(new ConcreteKeyValue("backUrl", UrlFactory.parameterizeUrl((String)backUrlBase, (Properties)parameters)));
        request.setAttribute("noJavaScriptFormVariables", noJavaScriptFormParameters);
        return mapping.findForward("route_report");
    }

    public ActionForward route(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        this.doProcessingAfterPost(kualiDocumentFormBase, request);
        kualiDocumentFormBase.setDerivedValuesOnForm(request);
        ActionForward preRulesForward = this.promptBeforeValidation(mapping, form, request, response);
        if (preRulesForward != null) {
            return preRulesForward;
        }
        Document document = kualiDocumentFormBase.getDocument();
        ActionForward forward = this.checkAndWarnAboutSensitiveData(mapping, form, request, response, "documentExplanation", document.getDocumentHeader().getExplanation(), "route", "");
        if (forward != null) {
            return forward;
        }
        document = this.getDocumentService().routeDocument(document, kualiDocumentFormBase.getAnnotation(), this.combineAdHocRecipients(kualiDocumentFormBase));
        kualiDocumentFormBase.setDocument(document);
        KNSGlobalVariables.getMessageList().add("message.route.successful", new String[0]);
        kualiDocumentFormBase.setAnnotation("");
        return mapping.findForward("basic");
    }

    public ActionForward blanketApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        this.doProcessingAfterPost(kualiDocumentFormBase, request);
        boolean hasPendingAdhocForCompletion = this.hasPendingAdhocForCompletion(kualiDocumentFormBase);
        if (hasPendingAdhocForCompletion) {
            GlobalVariables.getMessageMap().putError("newAdHocRouteWorkgroup", "error.adhoc.complete.blanket.approve.not.allowed", new String[0]);
            return mapping.findForward("basic");
        }
        kualiDocumentFormBase.setDerivedValuesOnForm(request);
        ActionForward preRulesForward = this.promptBeforeValidation(mapping, form, request, response);
        if (preRulesForward != null) {
            return preRulesForward;
        }
        Document document = kualiDocumentFormBase.getDocument();
        ActionForward forward = this.checkAndWarnAboutSensitiveData(mapping, form, request, response, "documentExplanation", document.getDocumentHeader().getExplanation(), "blanketApprove", "");
        if (forward != null) {
            return forward;
        }
        document = this.getDocumentService().blanketApproveDocument(document, kualiDocumentFormBase.getAnnotation(), this.combineAdHocRecipients(kualiDocumentFormBase));
        kualiDocumentFormBase.setDocument(document);
        KNSGlobalVariables.getMessageList().add("message.route.approved", new String[0]);
        kualiDocumentFormBase.setAnnotation("");
        return this.returnToSender(request, mapping, kualiDocumentFormBase);
    }

    public ActionForward approve(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        this.doProcessingAfterPost(kualiDocumentFormBase, request);
        kualiDocumentFormBase.setDerivedValuesOnForm(request);
        ActionForward preRulesForward = this.promptBeforeValidation(mapping, form, request, response);
        if (preRulesForward != null) {
            return preRulesForward;
        }
        Document document = kualiDocumentFormBase.getDocument();
        ActionForward forward = this.checkAndWarnAboutSensitiveData(mapping, form, request, response, "documentExplanation", document.getDocumentHeader().getExplanation(), "approve", "");
        if (forward != null) {
            return forward;
        }
        document = this.getDocumentService().approveDocument(document, kualiDocumentFormBase.getAnnotation(), this.combineAdHocRecipients(kualiDocumentFormBase));
        kualiDocumentFormBase.setDocument(document);
        KNSGlobalVariables.getMessageList().add("message.route.approved", new String[0]);
        kualiDocumentFormBase.setAnnotation("");
        return this.returnToSender(request, mapping, kualiDocumentFormBase);
    }

    public ActionForward disapprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReasonPrompt prompt = new ReasonPrompt("DocDisapprove", "document.question.disapprove.text", "confirmationQuestion", "error.document.disapprove.reasonRequired", "disapprove", "1", "message.disapprove.noteTextIntro");
        ReasonPrompt.Response resp = prompt.ask(mapping, form, request, response);
        if (resp.forward != null) {
            return resp.forward;
        }
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        this.doProcessingAfterPost(kualiDocumentFormBase, request);
        Document document = kualiDocumentFormBase.getDocument();
        document = this.getDocumentService().disapproveDocument(document, resp.reason);
        kualiDocumentFormBase.setDocument(document);
        KNSGlobalVariables.getMessageList().add("message.route.disapproved", new String[0]);
        kualiDocumentFormBase.setAnnotation("");
        return this.returnToSender(request, mapping, kualiDocumentFormBase);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (question == null) {
            return this.performQuestionWithoutInput(mapping, form, request, response, "DocCancel", this.getKualiConfigurationService().getPropertyValueAsString("document.question.cancel.text"), "confirmationQuestion", "cancel", "");
        }
        String buttonClicked = request.getParameter("buttonClicked");
        if ("DocCancel".equals(question) && "1".equals(buttonClicked)) {
            return mapping.findForward("basic");
        }
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        this.doProcessingAfterPost(kualiDocumentFormBase, request);
        boolean docExists = this.getDocumentService().documentExists(kualiDocumentFormBase.getDocId());
        if (docExists) {
            Document document = kualiDocumentFormBase.getDocument();
            document = this.getDocumentService().cancelDocument(document, kualiDocumentFormBase.getAnnotation());
            kualiDocumentFormBase.setDocument(document);
        }
        return this.returnToSender(request, mapping, kualiDocumentFormBase);
    }

    public ActionForward recall(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReasonPrompt prompt = new ReasonPrompt("DocRecall", "document.question.recall.text", "recallQuestion", "error.document.recall.reasonRequired", "recall", null, "message.recall.noteTextIntro");
        ReasonPrompt.Response resp = prompt.ask(mapping, form, request, response);
        if (resp.forward != null) {
            return resp.forward;
        }
        boolean cancel = !"DocRecall".equals(resp.question) || !"0".equals(resp.button);
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        this.doProcessingAfterPost(kualiDocumentFormBase, request);
        Document document = kualiDocumentFormBase.getDocument();
        document = this.getDocumentService().recallDocument(document, resp.reason, cancel);
        kualiDocumentFormBase.setDocument(document);
        return mapping.findForward("basic");
    }

    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase docForm = (KualiDocumentFormBase)form;
        this.doProcessingAfterPost(docForm, request);
        Document document = docForm.getDocument();
        if (this.canSave(form)) {
            Object question = this.getQuestion(request);
            if (question == null) {
                this.saveUnconvertedValuesToSession(request, docForm);
                return this.performQuestionWithoutInput(mapping, form, request, response, "DocSaveBeforeClose", this.getKualiConfigurationService().getPropertyValueAsString("document.question.saveBeforeClose.text"), "confirmationQuestion", "close", "");
            }
            String buttonClicked = request.getParameter("buttonClicked");
            Map<String, Object> unconvertedValues = this.restoreUnconvertedValuesFromSession(request, docForm);
            if ("DocSaveBeforeClose".equals(question) && "0".equals(buttonClicked)) {
                ActionForward forward;
                if (MapUtils.isNotEmpty(unconvertedValues)) {
                    for (Map.Entry<String, Object> entry : unconvertedValues.entrySet()) {
                        docForm.populateForProperty(entry.getKey(), entry.getValue(), unconvertedValues);
                    }
                }
                if ((forward = this.checkAndWarnAboutSensitiveData(mapping, form, request, response, "documentExplanation", document.getDocumentHeader().getExplanation(), "save", "")) != null) {
                    return forward;
                }
                docForm.getDocument().getDocumentHeader().getWorkflowDocument().refresh();
                if (!docForm.getDocument().getDocumentHeader().getWorkflowDocument().isApproved()) {
                    document = this.getDocumentService().saveDocument(document);
                    docForm.setDocument(document);
                }
            }
        }
        return this.returnToSender(request, mapping, docForm);
    }

    private void saveUnconvertedValuesToSession(HttpServletRequest request, KualiDocumentFormBase docForm) {
        if (MapUtils.isNotEmpty((Map)docForm.getUnconvertedValues())) {
            request.getSession().setAttribute(this.getUnconvertedValuesSessionAttributeKey(docForm), new HashMap(docForm.getUnconvertedValues()));
        }
    }

    private Map<String, Object> restoreUnconvertedValuesFromSession(HttpServletRequest request, KualiDocumentFormBase docForm) {
        Map unconvertedValues = (Map)request.getSession().getAttribute(this.getUnconvertedValuesSessionAttributeKey(docForm));
        if (MapUtils.isNotEmpty((Map)unconvertedValues)) {
            request.getSession().removeAttribute(this.getUnconvertedValuesSessionAttributeKey(docForm));
            docForm.setUnconvertedValues(unconvertedValues);
        }
        return unconvertedValues;
    }

    private String getUnconvertedValuesSessionAttributeKey(KualiDocumentFormBase docForm) {
        return "preCloseUnconvertedValues." + docForm.getDocId();
    }

    protected boolean canSave(ActionForm form) {
        KualiDocumentFormBase docForm = (KualiDocumentFormBase)form;
        Document document = docForm.getDocument();
        return document.getDocumentHeader().getWorkflowDocument().isValidAction(ActionType.SAVE);
    }

    protected Object getQuestion(HttpServletRequest request) {
        return request.getParameter("questionIndex");
    }

    public ActionForward fyi(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        this.doProcessingAfterPost(kualiDocumentFormBase, request);
        Document document = kualiDocumentFormBase.getDocument();
        document = this.getDocumentService().clearDocumentFyi(document, this.combineAdHocRecipients(kualiDocumentFormBase));
        kualiDocumentFormBase.setDocument(document);
        KNSGlobalVariables.getMessageList().add("message.route.fyied", new String[0]);
        kualiDocumentFormBase.setAnnotation("");
        return this.returnToSender(request, mapping, kualiDocumentFormBase);
    }

    public ActionForward acknowledge(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        this.doProcessingAfterPost(kualiDocumentFormBase, request);
        Document document = kualiDocumentFormBase.getDocument();
        document = this.getDocumentService().acknowledgeDocument(document, kualiDocumentFormBase.getAnnotation(), this.combineAdHocRecipients(kualiDocumentFormBase));
        kualiDocumentFormBase.setDocument(document);
        KNSGlobalVariables.getMessageList().add("message.route.acknowledged", new String[0]);
        kualiDocumentFormBase.setAnnotation("");
        return this.returnToSender(request, mapping, kualiDocumentFormBase);
    }

    public ActionForward supervisorFunctions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        String workflowSuperUserUrl = this.getKualiConfigurationService().getPropertyValueAsString("workflow.url") + "/SuperUser.do?methodToCall=displaySuperUserDocument&documentId=" + kualiDocumentFormBase.getDocument().getDocumentHeader().getDocumentNumber();
        response.sendRedirect(workflowSuperUserUrl);
        return null;
    }

    protected List<AdHocRouteRecipient> combineAdHocRecipients(KualiDocumentFormBase kualiDocumentFormBase) {
        ArrayList<AdHocRouteRecipient> adHocRecipients = new ArrayList<AdHocRouteRecipient>();
        adHocRecipients.addAll(kualiDocumentFormBase.getAdHocRoutePersons());
        adHocRecipients.addAll(kualiDocumentFormBase.getAdHocRouteWorkgroups());
        return adHocRecipients;
    }

    @Override
    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiForm = (KualiDocumentFormBase)form;
        kualiForm.setDerivedValuesOnForm(request);
        super.refresh(mapping, form, request, response);
        this.refreshAdHocRoutingWorkgroupLookups(request, kualiForm);
        return mapping.findForward("basic");
    }

    protected void refreshAdHocRoutingWorkgroupLookups(HttpServletRequest request, KualiDocumentFormBase kualiForm) throws WorkflowException {
        Enumeration i = request.getParameterNames();
        while (i.hasMoreElements()) {
            Group group;
            String parameterName = (String)i.nextElement();
            if (parameterName.equals("newAdHocRouteWorkgroup.recipientName") && !"".equals(request.getParameter(parameterName))) {
                Group group2;
                String namespace = "KUALI";
                if (request.getParameter("newAdHocRouteWorkgroup.recipientNamespaceCode") != null && !"".equals(request.getParameter("newAdHocRouteWorkgroup.recipientNamespaceCode").trim())) {
                    namespace = request.getParameter("newAdHocRouteWorkgroup.recipientNamespaceCode").trim();
                }
                if ((group2 = this.getGroupService().getGroupByNamespaceCodeAndName(namespace, request.getParameter(parameterName))) != null) {
                    kualiForm.getNewAdHocRouteWorkgroup().setId(group2.getId());
                    kualiForm.getNewAdHocRouteWorkgroup().setRecipientName(group2.getName());
                    kualiForm.getNewAdHocRouteWorkgroup().setRecipientNamespaceCode(group2.getNamespaceCode());
                } else {
                    GlobalVariables.getMessageMap().putError("newAdHocRouteWorkgroup.recipientNamespaceCode", "error.adhoc.invalid.workgroupNamespaceCode", new String[0]);
                    return;
                }
            }
            if (!parameterName.startsWith("adHocRouteWorkgroup[") || "".equals(request.getParameter(parameterName)) || !parameterName.endsWith(".recipientName")) continue;
            int lineNumber = Integer.parseInt(StringUtils.substringBetween((String)parameterName, (String)"[", (String)"]"));
            String namespaceParam = "adHocRouteWorkgroup[" + lineNumber + "].recipientNamespaceCode";
            String namespace = "KUALI";
            if (request.getParameter(namespaceParam) != null && !"".equals(request.getParameter(namespaceParam).trim())) {
                namespace = request.getParameter(namespaceParam).trim();
            }
            if ((group = this.getGroupService().getGroupByNamespaceCodeAndName(namespace, request.getParameter(parameterName))) != null) {
                kualiForm.getAdHocRouteWorkgroup(lineNumber).setId(group.getId());
                kualiForm.getAdHocRouteWorkgroup(lineNumber).setRecipientName(group.getName());
                kualiForm.getAdHocRouteWorkgroup(lineNumber).setRecipientNamespaceCode(group.getNamespaceCode());
                continue;
            }
            GlobalVariables.getMessageMap().putError(namespaceParam, "error.adhoc.invalid.workgroupNamespaceCode", new String[0]);
            return;
        }
    }

    public ActionForward cancelBOAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase documentForm = (KualiDocumentFormBase)form;
        documentForm.setAttachmentFile(new BlankFormFile());
        Note note = documentForm.getNewNote();
        note.removeAttachment();
        documentForm.setNewNote(note);
        return mapping.findForward("basic");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void streamToResponse(byte[] fileContents, String fileName, String fileContentType, HttpServletResponse response) throws Exception {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream(fileContents.length);
            baos.write(fileContents);
            WebUtils.saveMimeOutputStreamAsFile(response, fileContentType, baos, fileName);
        }
        finally {
            try {
                if (baos != null) {
                    baos.close();
                    baos = null;
                }
            }
            catch (IOException ioEx) {
                LOG.error("Error while downloading attachment");
                throw new RuntimeException("IOException occurred while downloading attachment", ioEx);
            }
        }
    }

    public ActionForward downloadBOAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase documentForm = (KualiDocumentFormBase)form;
        int attachmentIndex = this.selectedAttachmentIndex(request);
        if (attachmentIndex >= 0) {
            Note note = documentForm.getDocument().getNote(attachmentIndex);
            Attachment attachment = note.getAttachment();
            attachment.setNote(note);
            documentForm.copyPopulateEditablePropertiesToActionEditableProperties();
            WebUtils.saveMimeInputStreamAsFile(response, attachment.getAttachmentMimeTypeCode(), attachment.getAttachmentContents(), attachment.getAttachmentFileName(), attachment.getAttachmentFileSize().intValue());
            return null;
        }
        return mapping.findForward("basic");
    }

    protected int selectedAttachmentIndex(HttpServletRequest request) {
        int attachmentIndex = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            String attachmentIndexParam = StringUtils.substringBetween((String)parameterName, (String)".attachment[", (String)"].");
            try {
                attachmentIndex = Integer.parseInt(attachmentIndexParam);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return attachmentIndex;
    }

    public ActionForward insertBONote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person kualiUser;
        String topicText;
        DataDictionary dataDictionary;
        DocumentEntry entry;
        DocumentAuthorizer documentAuthorizer;
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        Document document = kualiDocumentFormBase.getDocument();
        Note newNote = kualiDocumentFormBase.getNewNote();
        newNote.setNotePostedTimestampToCurrent();
        String attachmentTypeCode = null;
        FormFile attachmentFile = kualiDocumentFormBase.getAttachmentFile();
        if (attachmentFile == null) {
            GlobalVariables.getMessageMap().putError(String.format("%s.%s", "newNote", "attachmentFile"), "error.uploadFile.null", new String[0]);
        }
        if (newNote.getAttachment() != null) {
            attachmentTypeCode = newNote.getAttachment().getAttachmentTypeCode();
        }
        if (!(documentAuthorizer = this.getDocumentHelperService().getDocumentAuthorizer(document)).canAddNoteAttachment(document, attachmentTypeCode, GlobalVariables.getUserSession().getPerson())) {
            throw this.buildAuthorizationException("annotate", document);
        }
        Attachment attachment = null;
        if (attachmentFile != null && !StringUtils.isBlank((String)attachmentFile.getFileName())) {
            if (attachmentFile.getFileSize() == 0) {
                GlobalVariables.getMessageMap().putError(String.format("%s.%s", "newNote", "attachmentFile"), "error.uploadFile.empty", new String[]{attachmentFile.getFileName()});
            } else {
                String attachmentType = null;
                Attachment newAttachment = kualiDocumentFormBase.getNewNote().getAttachment();
                if (newAttachment != null) {
                    attachmentType = newAttachment.getAttachmentTypeCode();
                }
                attachment = this.getAttachmentService().createAttachment(document.getNoteTarget(), attachmentFile.getFileName(), attachmentFile.getContentType(), attachmentFile.getFileSize(), attachmentFile.getInputStream(), attachmentType);
            }
        }
        if ((entry = (dataDictionary = this.getDataDictionaryService().getDataDictionary()).getDocumentEntry(document.getClass().getName())) != null && entry.getDisplayTopicFieldInNotes() && StringUtils.isBlank((String)(topicText = kualiDocumentFormBase.getNewNote().getNoteTopicText()))) {
            GlobalVariables.getMessageMap().putError(String.format("%s.%s", "newNote", "noteTopicText"), "error.required", new String[]{"Note Topic (Note Topic)"});
        }
        if ((kualiUser = GlobalVariables.getUserSession().getPerson()) == null) {
            throw new IllegalStateException("Current UserSession has a null Person.");
        }
        Note tmpNote = this.getNoteService().createNote(newNote, document.getNoteTarget(), kualiUser.getPrincipalId());
        ActionForward forward = this.checkAndWarnAboutSensitiveData(mapping, form, request, response, "note", tmpNote.getNoteText(), "insertBONote", "");
        if (forward != null) {
            return forward;
        }
        boolean rulePassed = this.getKualiRuleService().applyRules((DocumentEvent)new AddNoteEvent(document, tmpNote));
        if (rulePassed) {
            tmpNote.refresh();
            DocumentHeader documentHeader = document.getDocumentHeader();
            document.addNote(tmpNote);
            if (!(documentHeader.getWorkflowDocument().isInitiated() || !StringUtils.isNotEmpty((String)document.getNoteTarget().getObjectId()) || document instanceof MaintenanceDocument && NoteType.BUSINESS_OBJECT.getCode().equals(tmpNote.getNoteTypeCode()))) {
                tmpNote = this.getNoteService().save(tmpNote);
            }
            if (attachment != null) {
                tmpNote.addAttachment(attachment);
                if (!(documentHeader.getWorkflowDocument().isInitiated() || !StringUtils.isNotEmpty((String)document.getNoteTarget().getObjectId()) || document instanceof MaintenanceDocument && NoteType.BUSINESS_OBJECT.getCode().equals(tmpNote.getNoteTypeCode()))) {
                    tmpNote = this.getNoteService().save(tmpNote);
                }
            }
            if (!documentHeader.getWorkflowDocument().isInitiated() && document instanceof MaintenanceDocument && NoteType.BUSINESS_OBJECT.getCode().equals(tmpNote.getNoteTypeCode())) {
                this.getDocumentService().saveDocument(document);
            }
            kualiDocumentFormBase.setNewNote(new Note());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteBONote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String authorUniversalIdentifier;
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        Document document = kualiDocumentFormBase.getDocument();
        Note newNote = kualiDocumentFormBase.getNewNote();
        Note note = document.getNote(this.getLineToDelete(request));
        Attachment attachment = note.getAttachment();
        String attachmentTypeCode = null;
        if (attachment != null) {
            attachmentTypeCode = attachment.getAttachmentTypeCode();
        }
        if (!WebUtils.canDeleteNoteAttachment(document, attachmentTypeCode, authorUniversalIdentifier = note.getAuthorUniversalIdentifier())) {
            throw this.buildAuthorizationException("annotate", document);
        }
        if (attachment != null) {
            if (note.getNoteIdentifier() != null) {
                attachment.refreshNonUpdateableReferences();
            }
            this.getAttachmentService().deleteAttachmentContents(attachment);
        }
        this.getNoteService().deleteNote(note);
        document.removeNote(note);
        if (!document.getDocumentHeader().getWorkflowDocument().isInitiated() && document instanceof MaintenanceDocument && NoteType.BUSINESS_OBJECT.getCode().equals(note.getNoteTypeCode())) {
            this.getDocumentService().saveDocument(document);
        }
        return mapping.findForward("basic");
    }

    protected String determineNoteWorkflowNotificationAction(HttpServletRequest request, KualiDocumentFormBase kualiDocumentFormBase, Note note) {
        return this.getParameterService().getParameterValueAsString("KR-NS", "Document", "SEND_NOTE_WORKFLOW_NOTIFICATION_ACTIONS");
    }

    public ActionForward sendNoteWorkflowNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        Document document = kualiDocumentFormBase.getDocument();
        Note note = document.getNote(this.getSelectedLine(request));
        if (StringUtils.isBlank((String)note.getAdHocRouteRecipient().getId())) {
            GlobalVariables.getMessageMap().putError("newDocumentNote", "error.send.note.notification.recipient", new String[0]);
            return mapping.findForward("basic");
        }
        note.getAdHocRouteRecipient().setActionRequested(this.determineNoteWorkflowNotificationAction(request, kualiDocumentFormBase, note));
        boolean rulePassed = this.getKualiRuleService().applyRules((DocumentEvent)new AddAdHocRoutePersonEvent("newDocumentNote", document, (AdHocRoutePerson)note.getAdHocRouteRecipient()));
        if (!rulePassed) {
            return mapping.findForward("basic");
        }
        if (!document.getDocumentHeader().getWorkflowDocument().isInitiated()) {
            this.getDocumentService().sendNoteRouteNotification(document, note, GlobalVariables.getUserSession().getPerson());
            KNSGlobalVariables.getMessageList().add("message.send.note.notification.successful", new String[0]);
        } else {
            GlobalVariables.getMessageMap().putError("newDocumentNote", "error.send.note.notification.docStatus", new String[0]);
        }
        return mapping.findForward("basic");
    }

    private final void logOjbOptimisticLockException(OptimisticLockException e) {
        if (LOG.isInfoEnabled()) {
            StringBuilder message = new StringBuilder("caught OptimisticLockException, caused by ");
            Object sourceObject = e.getSourceObject();
            String infix = null;
            try {
                infix = sourceObject.toString();
            }
            catch (Exception e2) {
                infix = sourceObject.getClass().getName();
            }
            message.append(infix);
            if (sourceObject instanceof Versioned) {
                Versioned persistableObject = (Versioned)sourceObject;
                message.append(" [versionNumber = ").append(persistableObject.getVersionNumber()).append("]");
            }
            LOG.info(message.toString(), (Throwable)e);
        }
    }

    public ActionForward promptBeforeValidation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.promptBeforeValidation(mapping, form, request, response, "route");
    }

    public ActionForward promptBeforeValidation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String methodToCall) throws Exception {
        PromptBeforeValidationEvent event;
        PromptBeforeValidation promptBeforeValidation;
        boolean continueRoute;
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        Class<? extends PromptBeforeValidation> promptBeforeValidationClass = this.getDataDictionaryService().getPromptBeforeValidationClass(kualiDocumentFormBase.getDocTypeName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("PromptBeforeValidationClass: " + promptBeforeValidationClass);
        }
        if (promptBeforeValidationClass != null && !(continueRoute = (promptBeforeValidation = promptBeforeValidationClass.newInstance()).processPrompts(form, request, event = new PromptBeforeValidationEvent("Pre Maint route Check", "", kualiDocumentFormBase.getDocument())))) {
            if (event.isPerformQuestion()) {
                return super.performQuestionWithoutInput(mapping, kualiDocumentFormBase, request, response, event.getQuestionId(), event.getQuestionText(), event.getQuestionType(), methodToCall, event.getQuestionContext());
            }
            ActionForward actionForward = mapping.findForward(event.getActionForwardName());
            if (actionForward == null) {
                throw new RuntimeException("No ActionForwardName defined on this Event, no further actions will be processed.");
            }
            return actionForward;
        }
        return null;
    }

    protected DocumentAuthorizationException buildAuthorizationException(String action, Document document) {
        return new DocumentAuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), action, document.getDocumentNumber());
    }

    protected boolean exitingDocument() {
        String methodCalledViaDispatch = (String)GlobalVariables.getUserSession().retrieveObject("METHOD_TO_CALL_KEYS_METHOD_OBJECT_KEY");
        String methodCompleted = (String)GlobalVariables.getUserSession().retrieveObject("METHOD_TO_CALL_KEYS_COMPLETE_OBJECT_KEY");
        return StringUtils.isNotEmpty((String)methodCompleted) && StringUtils.isNotEmpty((String)methodCalledViaDispatch) && methodCompleted.startsWith(methodCalledViaDispatch);
    }

    protected void setupDocumentExit() {
        String methodCalledViaDispatch = (String)GlobalVariables.getUserSession().retrieveObject("METHOD_TO_CALL_KEYS_METHOD_OBJECT_KEY");
        if (StringUtils.isNotEmpty((String)methodCalledViaDispatch)) {
            GlobalVariables.getUserSession().addObject("METHOD_TO_CALL_KEYS_COMPLETE_OBJECT_KEY", (Object)(methodCalledViaDispatch + "_EXITING"));
        }
    }

    protected ActionForward returnToSender(HttpServletRequest request, ActionMapping mapping, KualiDocumentFormBase form) {
        ActionForward dest;
        if (form.isReturnToActionList()) {
            String workflowBase = this.getKualiConfigurationService().getPropertyValueAsString("workflow.url");
            String actionListUrl = workflowBase + "/ActionList.do";
            dest = new ActionForward(actionListUrl, true);
        } else {
            dest = StringUtils.isNotBlank((String)form.getBackLocation()) ? new ActionForward(form.getBackLocation(), true) : new ActionForward("/portal.do", true);
        }
        this.setupDocumentExit();
        return dest;
    }

    protected void populateAuthorizationFields(KualiDocumentFormBase formBase) {
        if (formBase.isFormDocumentInitialized()) {
            Document document = formBase.getDocument();
            Person user = GlobalVariables.getUserSession().getPerson();
            DocumentPresentationController documentPresentationController = KNSServiceLocator.getDocumentHelperService().getDocumentPresentationController(document);
            DocumentAuthorizer documentAuthorizer = this.getDocumentHelperService().getDocumentAuthorizer(document);
            Set documentActions = documentPresentationController.getDocumentActions(document);
            documentActions = documentAuthorizer.getDocumentActions(document, user, documentActions);
            if (this.getDataDictionaryService().getDataDictionary().getDocumentEntry(document.getClass().getName()).getUsePessimisticLocking()) {
                documentActions = this.getPessimisticLockService().getDocumentActions(document, user, documentActions);
            }
            formBase.setDocumentActions(this.convertSetToMap(documentActions));
        }
    }

    protected void populateAdHocActionRequestCodes(KualiDocumentFormBase formBase) {
        Document document = formBase.getDocument();
        DocumentAuthorizer documentAuthorizer = this.getDocumentHelperService().getDocumentAuthorizer(document);
        HashMap<String, String> adHocActionRequestCodes = new HashMap<String, String>();
        if (documentAuthorizer.canSendAdHocRequests(document, "F", GlobalVariables.getUserSession().getPerson())) {
            adHocActionRequestCodes.put("F", "FYI");
        }
        if (!document.getDocumentHeader().getWorkflowDocument().isFinal() && documentAuthorizer.canSendAdHocRequests(document, "K", GlobalVariables.getUserSession().getPerson())) {
            adHocActionRequestCodes.put("K", "ACKNOWLEDGE");
        }
        if (!document.getDocumentHeader().getWorkflowDocument().isApproved() && !document.getDocumentHeader().getWorkflowDocument().isProcessed() && !document.getDocumentHeader().getWorkflowDocument().isFinal() && documentAuthorizer.canSendAdHocRequests(document, "A", GlobalVariables.getUserSession().getPerson())) {
            adHocActionRequestCodes.put("A", "APPROVE");
        }
        if ((document.getDocumentHeader().getWorkflowDocument().isInitiated() || document.getDocumentHeader().getWorkflowDocument().isSaved()) && documentAuthorizer.canSendAdHocRequests(document, "C", GlobalVariables.getUserSession().getPerson())) {
            adHocActionRequestCodes.put("C", "COMPLETE");
        }
        formBase.setAdHocActionRequestCodes(adHocActionRequestCodes);
    }

    protected Map convertSetToMap(Set s) {
        HashMap map = new HashMap();
        for (Object key : s) {
            map.put(key, "true");
        }
        return map;
    }

    protected DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KNSServiceLocator.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }

    protected DocumentHelperService getDocumentHelperService() {
        if (this.documentHelperService == null) {
            this.documentHelperService = KNSServiceLocator.getDocumentHelperService();
        }
        return this.documentHelperService;
    }

    protected DocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = KRADServiceLocatorWeb.getDocumentService();
        }
        return this.documentService;
    }

    protected ConfigurationService getKualiConfigurationService() {
        if (this.kualiConfigurationService == null) {
            this.kualiConfigurationService = CoreApiServiceLocator.getKualiConfigurationService();
        }
        return this.kualiConfigurationService;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = CoreFrameworkServiceLocator.getParameterService();
        }
        return this.parameterService;
    }

    protected PessimisticLockService getPessimisticLockService() {
        if (this.pessimisticLockService == null) {
            this.pessimisticLockService = KRADServiceLocatorWeb.getPessimisticLockService();
        }
        return this.pessimisticLockService;
    }

    protected KualiRuleService getKualiRuleService() {
        if (this.kualiRuleService == null) {
            this.kualiRuleService = KRADServiceLocatorWeb.getKualiRuleService();
        }
        return this.kualiRuleService;
    }

    protected GroupService getGroupService() {
        if (this.groupService == null) {
            this.groupService = KimApiServiceLocator.getGroupService();
        }
        return this.groupService;
    }

    protected AttachmentService getAttachmentService() {
        if (this.attachmentService == null) {
            this.attachmentService = KRADServiceLocator.getAttachmentService();
        }
        return this.attachmentService;
    }

    protected NoteService getNoteService() {
        if (this.noteService == null) {
            this.noteService = KRADServiceLocator.getNoteService();
        }
        return this.noteService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KNSServiceLocator.getBusinessObjectService();
        }
        return this.businessObjectService;
    }

    @Override
    protected BusinessObjectAuthorizationService getBusinessObjectAuthorizationService() {
        if (this.businessObjectAuthorizationService == null) {
            this.businessObjectAuthorizationService = KNSServiceLocator.getBusinessObjectAuthorizationService();
        }
        return this.businessObjectAuthorizationService;
    }

    public BusinessObjectMetaDataService getBusinessObjectMetaDataService() {
        if (this.businessObjectMetaDataService == null) {
            this.businessObjectMetaDataService = KNSServiceLocator.getBusinessObjectMetaDataService();
        }
        return this.businessObjectMetaDataService;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        if (this.entityManagerFactory == null) {
            this.entityManagerFactory = KRADServiceLocator.getApplicationEntityManagerFactory();
        }
        return this.entityManagerFactory;
    }

    @Override
    public ActionForward hideAllTabs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (form instanceof KualiDocumentFormBase) {
            WebUtils.reuseErrorMapFromPreviousRequest((KualiDocumentFormBase)form);
        }
        return super.hideAllTabs(mapping, form, request, response);
    }

    @Override
    public ActionForward showAllTabs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (form instanceof KualiDocumentFormBase) {
            WebUtils.reuseErrorMapFromPreviousRequest((KualiDocumentFormBase)form);
        }
        return super.showAllTabs(mapping, form, request, response);
    }

    @Override
    public ActionForward toggleTab(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (form instanceof KualiDocumentFormBase) {
            WebUtils.reuseErrorMapFromPreviousRequest((KualiDocumentFormBase)form);
        }
        return super.toggleTab(mapping, form, request, response);
    }

    @Override
    protected void doProcessingAfterPost(KualiForm form, HttpServletRequest request) {
        super.doProcessingAfterPost(form, request);
        if (form instanceof KualiDocumentFormBase) {
            Document document = ((KualiDocumentFormBase)form).getDocument();
            this.getBusinessObjectService().linkUserFields(document);
        }
    }

    public ActionForward takeSuperUserActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        KualiDocumentFormBase documentForm = (KualiDocumentFormBase)form;
        if (StringUtils.isBlank((String)documentForm.getSuperUserAnnotation())) {
            GlobalVariables.getMessageMap().putErrorForSectionId("superuser.errors", "superuser.takeactions.annotation.missing", new String[]{""});
            return mapping.findForward("basic");
        }
        if (documentForm.getSelectedActionRequests().isEmpty()) {
            GlobalVariables.getMessageMap().putErrorForSectionId("superuser.errors", "superuser.takeactions.none.selected", new String[]{""});
            return mapping.findForward("basic");
        }
        if (!documentForm.isStateAllowsApproveSingleActionRequest()) {
            GlobalVariables.getMessageMap().putErrorForSectionId("superuser.errors", "superuser.takeactions.not.allowed", new String[]{""});
            return mapping.findForward("basic");
        }
        for (String actionRequestId : documentForm.getSelectedActionRequests()) {
            ActionRequest actionRequest = null;
            for (ActionRequest pendingActionRequest : documentForm.getActionRequests()) {
                if (!StringUtils.equals((String)pendingActionRequest.getId(), (String)actionRequestId)) continue;
                actionRequest = pendingActionRequest;
                break;
            }
            if (actionRequest == null) continue;
            if (StringUtils.equals((String)actionRequest.getActionRequested().getCode(), (String)ActionRequestType.COMPLETE.getCode()) || StringUtils.equals((String)actionRequest.getActionRequested().getCode(), (String)ActionRequestType.APPROVE.getCode())) {
                Document document = documentForm.getDocument();
                document = this.getDocumentService().validateAndPersistDocument(document, (DocumentEvent)new RouteDocumentEvent(document));
                documentForm.setDocument(document);
                if (documentForm.getDocumentActions().containsKey("canSave")) {
                    documentForm.getDocumentActions().remove("canSave");
                }
            }
            WorkflowDocumentActionsService documentActions = this.getWorkflowDocumentActionsService(documentForm.getWorkflowDocument().getDocumentTypeId());
            DocumentActionParameters parameters = DocumentActionParameters.create((String)documentForm.getDocId(), (String)GlobalVariables.getUserSession().getPrincipalId(), (String)documentForm.getSuperUserAnnotation());
            documentActions.superUserTakeRequestedAction(parameters, true, actionRequestId);
            String messageString = StringUtils.equals((String)actionRequest.getActionRequested().getCode(), (String)ActionRequestType.ACKNOWLEDGE.getCode()) ? "general.routing.superuser.actionRequestAcknowledged" : (StringUtils.equals((String)actionRequest.getActionRequested().getCode(), (String)ActionRequestType.FYI.getCode()) ? "general.routing.superuser.actionRequestFYI" : (StringUtils.equals((String)actionRequest.getActionRequested().getCode(), (String)ActionRequestType.COMPLETE.getCode()) ? "general.routing.superuser.actionRequestCompleted" : (StringUtils.equals((String)actionRequest.getActionRequested().getCode(), (String)ActionRequestType.APPROVE.getCode()) ? "general.routing.superuser.actionRequestApproved" : "general.routing.superuser.actionRequestApproved")));
            GlobalVariables.getMessageMap().putInfo("document", messageString, new String[]{documentForm.getDocId(), actionRequestId});
        }
        documentForm.setSuperUserAnnotation("");
        return new PostTransactionActionForward(mapping.findForward("basic"), new ActionForwardCallback(){

            @Override
            public ActionForward callback(HttpServletRequest request, HttpServletResponse response, ActionForm form, ActionMapping mapping) {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                KualiDocumentFormBase documentForm = (KualiDocumentFormBase)form;
                documentForm.populate(request);
                documentForm.getDocument().getDocumentHeader().getWorkflowDocument().refresh();
                if (documentForm.getDocument().getDocumentHeader().getWorkflowDocument().isApproved() || documentForm.getDocument().getDocumentHeader().getWorkflowDocument().isCanceled()) {
                    documentForm.getDocumentActions().remove("canSave");
                }
                return mapping.findForward("basic");
            }
        });
    }

    public ActionForward superUserDisapprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        KualiDocumentFormBase documentForm = (KualiDocumentFormBase)form;
        if (StringUtils.isBlank((String)documentForm.getSuperUserAnnotation())) {
            GlobalVariables.getMessageMap().putErrorForSectionId("superuser.errors", "superuser.disapprove.annotation.missing", new String[]{""});
            return mapping.findForward("basic");
        }
        if (!documentForm.getSelectedActionRequests().isEmpty()) {
            GlobalVariables.getMessageMap().putErrorForSectionId("superuser.errors", "superuser.disapprove.when.actions.checked", new String[]{""});
            return mapping.findForward("basic");
        }
        if (!documentForm.isStateAllowsApproveOrDisapprove()) {
            GlobalVariables.getMessageMap().putErrorForSectionId("superuser.errors", "superuser.disapprove.not.allowed", new String[]{""});
            return mapping.findForward("basic");
        }
        WorkflowDocumentActionsService documentActions = this.getWorkflowDocumentActionsService(documentForm.getWorkflowDocument().getDocumentTypeId());
        DocumentActionParameters parameters = DocumentActionParameters.create((String)documentForm.getDocId(), (String)GlobalVariables.getUserSession().getPrincipalId(), (String)documentForm.getSuperUserAnnotation());
        documentActions.superUserDisapprove(parameters, true);
        GlobalVariables.getMessageMap().putInfo("document", "general.routing.superuser.disapproved", new String[]{documentForm.getDocId()});
        documentForm.setSuperUserAnnotation("");
        return mapping.findForward("basic");
    }

    public ActionForward superUserApprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        KualiDocumentFormBase documentForm = (KualiDocumentFormBase)form;
        if (StringUtils.isBlank((String)documentForm.getSuperUserAnnotation())) {
            GlobalVariables.getMessageMap().putErrorForSectionId("superuser.errors", "superuser.approve.annotation.missing", new String[]{""});
            return mapping.findForward("basic");
        }
        if (!documentForm.getSelectedActionRequests().isEmpty()) {
            GlobalVariables.getMessageMap().putErrorForSectionId("superuser.errors", "superuser.approve.when.actions.checked", new String[]{""});
            return mapping.findForward("basic");
        }
        if (!documentForm.isStateAllowsApproveOrDisapprove()) {
            GlobalVariables.getMessageMap().putErrorForSectionId("superuser.errors", "superuser.approve.not.allowed", new String[]{""});
            return mapping.findForward("basic");
        }
        WorkflowDocumentActionsService documentActions = this.getWorkflowDocumentActionsService(documentForm.getWorkflowDocument().getDocumentTypeId());
        DocumentActionParameters parameters = DocumentActionParameters.create((String)documentForm.getDocId(), (String)GlobalVariables.getUserSession().getPrincipalId(), (String)documentForm.getSuperUserAnnotation());
        documentActions.superUserBlanketApprove(parameters, true);
        GlobalVariables.getMessageMap().putInfo("document", "general.routing.superuser.approved", new String[]{documentForm.getDocId()});
        documentForm.setSuperUserAnnotation("");
        return mapping.findForward("basic");
    }

    private WorkflowDocumentActionsService getWorkflowDocumentActionsService(String documentTypeId) {
        DocumentType documentType = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeById(documentTypeId);
        String applicationId = documentType.getApplicationId();
        QName serviceName = new QName("http://rice.kuali.org/kew/v2_0", "workflowDocumentActionsService");
        WorkflowDocumentActionsService service = (WorkflowDocumentActionsService)KsbApiServiceLocator.getServiceBus().getService(serviceName, applicationId);
        if (service == null) {
            service = KewApiServiceLocator.getWorkflowDocumentActionsService();
        }
        return service;
    }

    public ActionForward complete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
        this.doProcessingAfterPost(kualiDocumentFormBase, request);
        kualiDocumentFormBase.setDerivedValuesOnForm(request);
        ActionForward preRulesForward = this.promptBeforeValidation(mapping, form, request, response);
        if (preRulesForward != null) {
            return preRulesForward;
        }
        Document document = kualiDocumentFormBase.getDocument();
        document = this.getDocumentService().completeDocument(document, kualiDocumentFormBase.getAnnotation(), this.combineAdHocRecipients(kualiDocumentFormBase));
        kualiDocumentFormBase.setDocument(document);
        KNSGlobalVariables.getMessageList().add("message.route.successful", new String[0]);
        kualiDocumentFormBase.setAnnotation("");
        return mapping.findForward("basic");
    }

    protected boolean hasPendingAdhocForCompletion(KualiDocumentFormBase kualiDocumentFormBase) {
        List<AdHocRouteRecipient> adHocRecipients = this.combineAdHocRecipients(kualiDocumentFormBase);
        for (AdHocRouteRecipient receipients : adHocRecipients) {
            String actionRequestedCode = receipients.getActionRequested();
            if (!"C".equals(actionRequestedCode)) continue;
            return true;
        }
        return false;
    }

    private class ReasonPrompt {
        final String questionId;
        final String questionTextKey;
        final String questionType;
        final String missingReasonKey;
        final String questionCallerMapping;
        final String abortButton;
        final String noteIntroKey;

        private ReasonPrompt(String questionId, String questionTextKey, String questionType, String missingReasonKey, String questionCallerMapping, String abortButton, String noteIntroKey) {
            this.questionId = questionId;
            this.questionTextKey = questionTextKey;
            this.questionType = questionType;
            this.questionCallerMapping = questionCallerMapping;
            this.abortButton = abortButton;
            this.noteIntroKey = noteIntroKey;
            this.missingReasonKey = missingReasonKey;
        }

        public Response ask(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
            String context;
            String question = request.getParameter("questionIndex");
            String reason = request.getParameter("reason");
            if (StringUtils.isBlank((String)reason) && (context = request.getParameter("context")) != null && StringUtils.contains((String)context, (String)"reason=")) {
                reason = StringUtils.substringAfter((String)context, (String)"reason=");
            }
            Object disapprovalNoteText = "";
            if (question == null) {
                return new Response(question, KualiDocumentActionBase.this.performQuestionWithInput(mapping, form, request, response, this.questionId, KualiDocumentActionBase.this.getKualiConfigurationService().getPropertyValueAsString(this.questionTextKey), this.questionType, this.questionCallerMapping, ""));
            }
            String buttonClicked = request.getParameter("buttonClicked");
            if (this.questionId.equals(question) && this.abortButton != null && this.abortButton.equals(buttonClicked)) {
                return new Response(question, mapping.findForward("basic"));
            }
            Object introNoteMessage = "";
            if (this.noteIntroKey != null) {
                introNoteMessage = KualiDocumentActionBase.this.getKualiConfigurationService().getPropertyValueAsString(this.noteIntroKey) + " ";
            }
            disapprovalNoteText = (String)introNoteMessage + reason;
            boolean warnForSensitiveData = CoreFrameworkServiceLocator.getParameterService().getParameterValueAsBoolean("KR-NS", "All", "SENSITIVE_DATA_PATTERNS_WARNING_IND");
            if (warnForSensitiveData) {
                String context2 = "reason=" + reason;
                ActionForward forward = KualiDocumentActionBase.this.checkAndWarnAboutSensitiveData(mapping, form, request, response, "reason", (String)disapprovalNoteText, this.questionCallerMapping, context2);
                if (forward != null) {
                    return new Response(question, forward);
                }
            } else if (KRADUtils.containsSensitiveDataPatternMatch((String)disapprovalNoteText)) {
                return new Response(question, KualiDocumentActionBase.this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, this.questionId, KualiDocumentActionBase.this.getKualiConfigurationService().getPropertyValueAsString(this.questionTextKey), this.questionType, this.questionCallerMapping, "", reason, "error.document.fieldContainsPossibleSensitiveData", "reason", "reason"));
            }
            int disapprovalNoteTextLength = ((String)disapprovalNoteText).length();
            int noteTextMaxLength = KualiDocumentActionBase.this.getDataDictionaryService().getAttributeMaxLength(Note.class, "noteText");
            if (StringUtils.isBlank((String)reason) || disapprovalNoteTextLength > noteTextMaxLength) {
                if (reason == null) {
                    reason = "";
                }
                return new Response(question, KualiDocumentActionBase.this.performQuestionWithInputAgainBecauseOfErrors(mapping, form, request, response, this.questionId, KualiDocumentActionBase.this.getKualiConfigurationService().getPropertyValueAsString(this.questionTextKey), this.questionType, this.questionCallerMapping, "", reason, this.missingReasonKey, "reason", Integer.toString(noteTextMaxLength)));
            }
            return new Response(question, (String)disapprovalNoteText, buttonClicked);
        }

        private class Response {
            final String question;
            final ActionForward forward;
            final String reason;
            final String button;

            Response(String question, ActionForward forward) {
                this(question, forward, null, null);
            }

            Response(String question, String reason, String button) {
                this(question, null, reason, button);
            }

            private Response(String question, ActionForward forward, String reason, String button) {
                this.question = question;
                this.forward = forward;
                this.reason = reason;
                this.button = button;
            }
        }
    }
}

