/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.directwebremoting.dwrp.FileUpload;
import org.directwebremoting.event.SessionProgressListener;
import org.directwebremoting.extend.FormField;
import org.directwebremoting.extend.ServerException;
import org.directwebremoting.extend.SimpleInputStreamFactory;

public class CommonsFileUpload
implements FileUpload {
    private long fileUploadMaxBytes = 0L;
    public static final String PROGRESS_LISTENER = "PROGRESS_LISTENER";
    private static final int DEFAULT_SIZE_THRESHOLD = 262144;

    public boolean isMultipartContent(HttpServletRequest req) {
        return ServletFileUpload.isMultipartContent((HttpServletRequest)req);
    }

    @Override
    public Map<String, FormField> parseRequest(HttpServletRequest req) throws ServerException {
        HttpSession session;
        File location = new File(System.getProperty("java.io.tmpdir"));
        DiskFileItemFactory itemFactory = new DiskFileItemFactory(262144, location);
        ServletFileUpload fileUploader = new ServletFileUpload((FileItemFactory)itemFactory);
        if (this.getFileUploadMaxBytes() > 0L) {
            fileUploader.setFileSizeMax(this.getFileUploadMaxBytes());
        }
        if ((session = req.getSession(false)) != null) {
            fileUploader.setProgressListener((ProgressListener)new SessionProgressListener());
            session.setAttribute(PROGRESS_LISTENER, (Object)fileUploader.getProgressListener());
        }
        try {
            HashMap<String, FormField> map = new HashMap<String, FormField>();
            List fileItems = fileUploader.parseRequest(req);
            for (FileItem fileItem : fileItems) {
                FormField formField;
                if (fileItem.isFormField()) {
                    formField = new FormField(fileItem.getString());
                } else {
                    SimpleInputStreamFactory inFactory = new SimpleInputStreamFactory(fileItem.getInputStream());
                    formField = new FormField(fileItem.getName(), fileItem.getContentType(), fileItem.getSize(), inFactory);
                }
                map.put(fileItem.getFieldName(), formField);
            }
            return map;
        }
        catch (FileUploadBase.FileSizeLimitExceededException fsle) {
            throw new ServerException("One or more files is larger (" + fsle.getActualSize() + " bytes) than the configured limit (" + fsle.getPermittedSize() + " bytes).");
        }
        catch (IOException ex) {
            throw new ServerException("Upload failed: " + ex.getMessage(), ex);
        }
        catch (FileUploadException ex) {
            throw new ServerException("Upload failed: " + ex.getMessage(), ex);
        }
    }

    public long getFileUploadMaxBytes() {
        return this.fileUploadMaxBytes;
    }

    public void setFileUploadMaxBytes(long fileUploadMaxBytes) {
        this.fileUploadMaxBytes = fileUploadMaxBytes;
    }
}

