/*
 * Decompiled with CFR 0.152.
 */
package com.codiform.moo.translator;

import com.codiform.moo.configuration.Configuration;
import com.codiform.moo.session.TranslationSource;
import java.lang.reflect.Array;

public class ArrayTranslator {
    private Configuration configuration;

    public ArrayTranslator(Configuration configuration) {
        this.configuration = configuration;
    }

    public <T> T[] translate(Object[] sourceArray, Class<T> destinationClass, TranslationSource translationSource) {
        T[] destinationArray = this.createDestinationArray(destinationClass, sourceArray.length);
        for (int index = 0; index < sourceArray.length; ++index) {
            destinationArray[index] = translationSource.getTranslation(sourceArray[index], destinationClass);
        }
        return destinationArray;
    }

    public <T> T[] defensiveCopy(T[] value) {
        if (this.configuration.isPerformingDefensiveCopies()) {
            return (Object[])value.clone();
        }
        return value;
    }

    public <T> T[] copyTo(Object[] sourceArray, Class<T> destinationClass) {
        Object[] destinationArray = this.createDestinationArray(destinationClass, sourceArray.length);
        this.copy(sourceArray, destinationArray);
        return destinationArray;
    }

    private void copy(Object[] sourceArray, Object[] destinationArray) {
        System.arraycopy(sourceArray, 0, destinationArray, 0, sourceArray.length);
    }

    private <T> T[] createDestinationArray(Class<T> destinationClass, int length) {
        return (Object[])Array.newInstance(destinationClass, length);
    }
}

