/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.persistence.jta;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class KualiTransactionInterceptor
extends TransactionInterceptor {
    private static final Logger LOG = LogManager.getLogger(KualiTransactionInterceptor.class);

    protected TransactionAspectSupport.TransactionInfo createTransactionIfNecessary(PlatformTransactionManager tm, TransactionAttribute txAttr, String joinpointIdentification) {
        TransactionStatus txStatus;
        TransactionAspectSupport.TransactionInfo txInfo = super.createTransactionIfNecessary(tm, txAttr, joinpointIdentification);
        if (LOG.isDebugEnabled() && txInfo != null && (txStatus = txInfo.getTransactionStatus()) != null) {
            DefaultTransactionStatus dtxStatus;
            if (txStatus.isNewTransaction()) {
                LOG.debug("creating explicit transaction for " + txInfo.getJoinpointIdentification());
            } else if (txStatus instanceof DefaultTransactionStatus && (dtxStatus = (DefaultTransactionStatus)txStatus).isNewSynchronization()) {
                LOG.debug("creating implicit transaction for " + txInfo.getJoinpointIdentification());
            }
        }
        return txInfo;
    }

    protected void completeTransactionAfterThrowing(TransactionAspectSupport.TransactionInfo txInfo, Throwable ex) {
        TransactionStatus txStatus;
        if (txInfo.getTransactionAttribute().rollbackOn(ex)) {
            LOG.fatal("Exception caught by Transaction Interceptor, this will cause a rollback at the end of the transaction.", ex);
        }
        if (LOG.isDebugEnabled() && txInfo != null && (txStatus = txInfo.getTransactionStatus()) != null) {
            DefaultTransactionStatus dtxStatus;
            if (txStatus.isNewTransaction()) {
                LOG.debug("closing explicit transaction for " + txInfo.getJoinpointIdentification());
            } else if (txStatus instanceof DefaultTransactionStatus && (dtxStatus = (DefaultTransactionStatus)txStatus).isNewSynchronization()) {
                LOG.debug("closing implicit transaction for " + txInfo.getJoinpointIdentification());
            }
        }
        super.completeTransactionAfterThrowing(txInfo, ex);
    }

    protected void commitTransactionAfterReturning(TransactionAspectSupport.TransactionInfo txInfo) {
        TransactionStatus txStatus;
        if (LOG.isDebugEnabled() && txInfo != null && (txStatus = txInfo.getTransactionStatus()) != null) {
            DefaultTransactionStatus dtxStatus;
            if (txStatus.isNewTransaction()) {
                LOG.debug("committing explicit transaction for " + txInfo.getJoinpointIdentification());
            } else if (txStatus instanceof DefaultTransactionStatus && (dtxStatus = (DefaultTransactionStatus)txStatus).isNewSynchronization()) {
                LOG.debug("committing implicit transaction for " + txInfo.getJoinpointIdentification());
            }
        }
        super.commitTransactionAfterReturning(txInfo);
    }
}

