/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.DictionaryBeanProcessor;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.TypedStringValue;

public abstract class DictionaryBeanProcessorBase
implements DictionaryBeanProcessor {
    protected Class<?> getBeanClass(BeanDefinition beanDefinition, ConfigurableListableBeanFactory beanFactory) {
        BeanDefinition parentBeanDefinition;
        if (StringUtils.isNotBlank((String)beanDefinition.getBeanClassName())) {
            try {
                return Class.forName(beanDefinition.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        if (StringUtils.isNotBlank((String)beanDefinition.getParentName()) && (parentBeanDefinition = beanFactory.getBeanDefinition(beanDefinition.getParentName())) != null) {
            return this.getBeanClass(parentBeanDefinition, beanFactory);
        }
        return null;
    }

    protected String getStringValue(Object value) {
        if (value instanceof TypedStringValue) {
            TypedStringValue typedStringValue = (TypedStringValue)value;
            return typedStringValue.getValue();
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    protected void applyPropertyValueToBean(String propertyPath, String propertyValue, BeanDefinition beanDefinition) {
        this.applyPropertyValueToBean(propertyPath, propertyValue, beanDefinition.getPropertyValues());
    }

    protected void applyPropertyValueToBean(String propertyPath, String propertyValue, MutablePropertyValues pvs) {
        pvs.addPropertyValue(propertyPath, (Object)propertyValue);
    }

    protected BeanDefinition getPropertyValueBeanDefinition(PropertyValue propertyValue) {
        BeanDefinition beanDefinition = null;
        Object value = propertyValue.getValue();
        if (value instanceof BeanDefinition || value instanceof BeanDefinitionHolder) {
            beanDefinition = propertyValue instanceof BeanDefinition ? (BeanDefinition)propertyValue : ((BeanDefinitionHolder)value).getBeanDefinition();
        }
        return beanDefinition;
    }

    protected boolean isGeneratedBeanName(String beanName) {
        return StringUtils.isNotBlank((String)beanName) && (StringUtils.contains((String)beanName, (String)"$") || StringUtils.contains((String)beanName, (String)"#"));
    }

    protected DataDictionaryService getDataDictionaryService() {
        return KRADServiceLocatorWeb.getDataDictionaryService();
    }
}

