/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.control;

import java.util.List;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.control.ControlBase;
import org.kuali.rice.krad.uif.control.ValueConfiguredControl;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.util.ComponentFactory;
import org.kuali.rice.krad.uif.util.LifecycleElement;

@BeanTag(name="checkboxControl", parent="Uif-CheckboxControl")
public class CheckboxControl
extends ControlBase
implements ValueConfiguredControl {
    private static final long serialVersionUID = -1397028958569144230L;
    private String value;
    private String checkboxLabel;
    private boolean checked;
    private Message richLabelMessage;
    private List<Component> inlineComponents;

    @Override
    public void performApplyModel(Object model, LifecycleElement parent) {
        super.performApplyModel(model, parent);
        if (this.richLabelMessage == null) {
            Message message = ComponentFactory.getMessage();
            message.setMessageText(this.checkboxLabel);
            message.setInlineComponents(this.inlineComponents);
            message.setRenderWrapperTag(false);
            this.setRichLabelMessage(message);
        }
    }

    @Override
    @BeanTagAttribute
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @BeanTagAttribute
    public String getCheckboxLabel() {
        return this.checkboxLabel;
    }

    public void setCheckboxLabel(String checkboxLabel) {
        this.checkboxLabel = checkboxLabel;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public boolean isChecked() {
        return this.checked;
    }

    @BeanTagAttribute
    public Message getRichLabelMessage() {
        return this.richLabelMessage;
    }

    public void setRichLabelMessage(Message richLabelMessage) {
        this.richLabelMessage = richLabelMessage;
    }

    @BeanTagAttribute
    public List<Component> getInlineComponents() {
        return this.inlineComponents;
    }

    public void setInlineComponents(List<Component> inlineComponents) {
        this.inlineComponents = inlineComponents;
    }

    @Override
    public void completeValidation(ValidationTrace tracer) {
        tracer.addBean(this);
        super.completeValidation(tracer.getCopy());
    }
}

