/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine;

import java.util.List;
import org.kuali.rice.krms.api.engine.ExecutionEnvironment;
import org.kuali.rice.krms.framework.engine.Action;
import org.kuali.rice.krms.framework.engine.Proposition;
import org.kuali.rice.krms.framework.engine.ResultLogger;
import org.kuali.rice.krms.framework.engine.Rule;
import org.kuali.rice.krms.framework.engine.result.BasicResult;

public class BasicRule
implements Rule {
    private static final ResultLogger LOG = ResultLogger.getInstance();
    private String name;
    private Proposition proposition;
    private List<Action> actions;

    public BasicRule(String name, Proposition proposition, List<Action> actions) {
        if (proposition == null) {
            throw new IllegalArgumentException("Proposition cannot be null.");
        }
        this.name = name;
        this.proposition = proposition;
        this.actions = actions;
    }

    public BasicRule(Proposition proposition, List<Action> actions) {
        this(null, proposition, actions);
    }

    @Override
    public boolean evaluate(ExecutionEnvironment environment) {
        boolean result = this.proposition.evaluate(environment).getResult();
        if (this.actions != null) {
            for (Action action : this.actions) {
                if (!this.shouldExecuteAction(result)) continue;
                action.execute(environment);
            }
        }
        if (LOG.isEnabled(environment)) {
            LOG.logResult(new BasicResult("Rule Evaluated", this, environment, result));
        }
        return result;
    }

    protected boolean shouldExecuteAction(boolean ruleExecutionResult) {
        return ruleExecutionResult;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

