/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.framework.engine;

public enum CollectionOperator {
    ONE_OR_MORE(false){

        @Override
        public boolean reduce(boolean elementResult, boolean collatedResult) {
            return elementResult || collatedResult;
        }

        @Override
        public boolean shortCircuit(boolean collatedResult) {
            return collatedResult;
        }
    }
    ,
    ALL(true){

        @Override
        public boolean reduce(boolean elementResult, boolean collatedResult) {
            return elementResult && collatedResult;
        }

        @Override
        public boolean shortCircuit(boolean collatedResult) {
            return !collatedResult;
        }
    }
    ,
    NONE(true){

        @Override
        public boolean reduce(boolean elementResult, boolean collatedResult) {
            return !elementResult && collatedResult;
        }

        @Override
        public boolean shortCircuit(boolean collatedResult) {
            return !collatedResult;
        }
    };

    private final boolean initialCollationResult;

    private CollectionOperator(boolean initialCollationResult) {
        this.initialCollationResult = initialCollationResult;
    }

    public abstract boolean reduce(boolean var1, boolean var2);

    public abstract boolean shortCircuit(boolean var1);

    public boolean getInitialCollatedResult() {
        return this.initialCollationResult;
    }
}

