/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.annotation.support;

import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.handler.annotation.DestinationVariable;
import org.springframework.messaging.handler.annotation.support.AbstractNamedValueMethodArgumentResolver;

public class DestinationVariableMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver {
    public static final String DESTINATION_TEMPLATE_VARIABLES_HEADER = DestinationVariableMethodArgumentResolver.class.getSimpleName() + ".templateVariables";

    public DestinationVariableMethodArgumentResolver(ConversionService cs) {
        super(cs, null);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(DestinationVariable.class);
    }

    @Override
    protected AbstractNamedValueMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        DestinationVariable annotation = (DestinationVariable)parameter.getParameterAnnotation(DestinationVariable.class);
        return new DestinationVariableNamedValueInfo(annotation);
    }

    @Override
    protected Object resolveArgumentInternal(MethodParameter parameter, Message<?> message, String name) throws Exception {
        Map vars = (Map)message.getHeaders().get(DESTINATION_TEMPLATE_VARIABLES_HEADER);
        return vars != null ? (String)vars.get(name) : null;
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter, Message<?> message) {
        throw new MessageHandlingException(message, "Missing path template variable '" + name + "' for method parameter type [" + parameter.getParameterType() + "]");
    }

    private static class DestinationVariableNamedValueInfo
    extends AbstractNamedValueMethodArgumentResolver.NamedValueInfo {
        private DestinationVariableNamedValueInfo(DestinationVariable annotation) {
            super(annotation.value(), true, "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
        }
    }
}

