/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.data;

import java.util.Arrays;
import org.jrobin.core.Util;

class Normalizer {
    private final long[] timestamps;
    final int count;
    final long step;

    Normalizer(long[] timestamps) {
        this.timestamps = timestamps;
        this.step = timestamps[1] - timestamps[0];
        this.count = timestamps.length;
    }

    double[] normalize(long[] rawTimestamps, double[] rawValues) {
        int rawCount = rawTimestamps.length;
        long rawStep = rawTimestamps[1] - rawTimestamps[0];
        if (rawCount == this.count && rawStep == this.step && rawTimestamps[0] == this.timestamps[0]) {
            return Normalizer.getCopyOf(rawValues);
        }
        double[] values = new double[this.count];
        Arrays.fill(values, Double.NaN);
        int rawSeg = 0;
        int seg = 0;
        while (rawSeg < rawCount && seg < this.count) {
            double rawValue = rawValues[rawSeg];
            if (!Double.isNaN(rawValue)) {
                long rawLeft = rawTimestamps[rawSeg] - rawStep;
                while (seg < this.count && rawLeft >= this.timestamps[seg]) {
                    ++seg;
                }
                boolean overlap = true;
                int fillSeg = seg;
                while (overlap && fillSeg < this.count) {
                    long t2;
                    long left = this.timestamps[fillSeg] - this.step;
                    long t1 = Math.max(rawLeft, left);
                    if (t1 < (t2 = Math.min(rawTimestamps[rawSeg], this.timestamps[fillSeg]))) {
                        values[fillSeg] = Util.sum(values[fillSeg], (double)(t2 - t1) * rawValues[rawSeg]);
                    } else {
                        overlap = false;
                    }
                    ++fillSeg;
                }
            }
            ++rawSeg;
        }
        int seg2 = 0;
        while (seg2 < this.count) {
            int n = seg2++;
            values[n] = values[n] / (double)this.step;
        }
        return values;
    }

    private static double[] getCopyOf(double[] rawValues) {
        int n = rawValues.length;
        double[] values = new double[n];
        System.arraycopy(rawValues, 0, values, 0, n);
        return values;
    }
}

