/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.inspector;

import java.io.File;
import java.io.IOException;
import javax.swing.table.AbstractTableModel;
import org.jrobin.core.Datasource;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.inspector.InspectorModel;
import org.jrobin.inspector.Util;

class DatasourceTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Object[] DESCRIPTIONS = new Object[]{"name", "type", "heartbeat", "min value", "max value", "last value", "accum. value", "NaN seconds"};
    private static final String[] COLUMN_NAMES = new String[]{"description", "value"};
    private File file;
    private Object[] values;
    private int dsIndex = -1;

    DatasourceTableModel() {
    }

    public int getRowCount() {
        return DESCRIPTIONS.length;
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return DESCRIPTIONS[rowIndex];
        }
        if (columnIndex == 1) {
            if (this.values != null) {
                return this.values[rowIndex];
            }
            return "--";
        }
        return null;
    }

    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    void setFile(File newFile) {
        this.file = newFile;
        this.setIndex(-1);
    }

    void setIndex(int newDsIndex) {
        if (this.dsIndex != newDsIndex) {
            this.dsIndex = newDsIndex;
            this.values = null;
            if (this.dsIndex >= 0) {
                try {
                    RrdDb rrd = new RrdDb(this.file.getAbsolutePath(), true);
                    try {
                        Datasource ds = rrd.getDatasource(this.dsIndex);
                        this.values = new Object[]{ds.getDsName(), ds.getDsType(), "" + ds.getHeartbeat(), InspectorModel.formatDouble(ds.getMinValue()), InspectorModel.formatDouble(ds.getMaxValue()), InspectorModel.formatDouble(ds.getLastValue()), InspectorModel.formatDouble(ds.getAccumValue()), "" + ds.getNanSeconds()};
                    }
                    finally {
                        rrd.close();
                    }
                }
                catch (IOException e) {
                    Util.error(null, e);
                }
                catch (RrdException e) {
                    Util.error(null, e);
                }
            }
            this.fireTableDataChanged();
        }
    }
}

