--
-- Kuali Coeus, a comprehensive research administration system for higher education.
-- 
-- Copyright 2005-2015 Kuali, Inc.
-- 
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as
-- published by the Free Software Foundation, either version 3 of the
-- License, or (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU Affero General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
--


-----------------------------------------------------------------------------
-- ABSTRACT_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'ABSTRACT_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE ABSTRACT_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE ABSTRACT_TYPE
(
      ABSTRACT_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE ABSTRACT_TYPE
    ADD CONSTRAINT ABSTRACT_TYPEP1
PRIMARY KEY (ABSTRACT_TYPE_CODE);







-----------------------------------------------------------------------------
-- ACCOUNT_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'ACCOUNT_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE ACCOUNT_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE ACCOUNT_TYPE
(
      ACCOUNT_TYPE_CODE NUMBER(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE ACCOUNT_TYPE
    ADD CONSTRAINT ACCOUNT_TYPEP1
PRIMARY KEY (ACCOUNT_TYPE_CODE);







-----------------------------------------------------------------------------
-- ACTIVITY_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'ACTIVITY_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE ACTIVITY_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE ACTIVITY_TYPE
(
      ACTIVITY_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
        , HIGHER_EDUCATION_FUNCTION_CODE VARCHAR2(20)
    

);

ALTER TABLE ACTIVITY_TYPE
    ADD CONSTRAINT ACTIVITY_TYPEP1
PRIMARY KEY (ACTIVITY_TYPE_CODE);







-----------------------------------------------------------------------------
-- AFFILIATION_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AFFILIATION_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AFFILIATION_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AFFILIATION_TYPE
(
      VER_NBR NUMBER(8) default 1 NOT NULL
        , AFFILIATION_TYPE_CODE NUMBER(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
        , ACTIVE_FLAG CHAR(1) NOT NULL
    

);

ALTER TABLE AFFILIATION_TYPE
    ADD CONSTRAINT AFFILIATION_TYPEP1
PRIMARY KEY (AFFILIATION_TYPE_CODE);







-----------------------------------------------------------------------------
-- APPOINTMENT_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'APPOINTMENT_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE APPOINTMENT_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE APPOINTMENT_TYPE
(
      APPOINTMENT_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , DURATION NUMBER(2) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE APPOINTMENT_TYPE
    ADD CONSTRAINT APPOINTMENT_TYPEP1
PRIMARY KEY (APPOINTMENT_TYPE_CODE);







-----------------------------------------------------------------------------
-- ARG_VALUE_LOOKUP
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'ARG_VALUE_LOOKUP';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE ARG_VALUE_LOOKUP CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE ARG_VALUE_LOOKUP
(
      ARG_VALUE_LOOKUP_ID NUMBER(12)
        , ARGUMENT_NAME VARCHAR2(30) NOT NULL
        , VALUE VARCHAR2(200) NOT NULL
        , DESCRIPTION VARCHAR2(200)
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE ARG_VALUE_LOOKUP
    ADD CONSTRAINT ARG_VALUE_LOOKUPP1
PRIMARY KEY (ARG_VALUE_LOOKUP_ID);


CREATE INDEX UQ_ARG_VALUE_LOOKUP 
  ON ARG_VALUE_LOOKUP 
  (ARGUMENT_NAME, VALUE);





-----------------------------------------------------------------------------
-- ATTACHMENT_FILE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'ATTACHMENT_FILE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE ATTACHMENT_FILE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE ATTACHMENT_FILE
(
      FILE_ID NUMBER(22)
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , FILE_NAME VARCHAR2(150) NOT NULL
        , CONTENT_TYPE VARCHAR2(255) NOT NULL
        , FILE_DATA BLOB NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE ATTACHMENT_FILE
    ADD CONSTRAINT ATTACHMENT_FILEP1
PRIMARY KEY (FILE_ID);







-----------------------------------------------------------------------------
-- AWARD
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD
(
      CLOSEOUT_DATE DATE
        , TRANSACTION_TYPE_CODE VARCHAR2(3)
        , NOTICE_DATE DATE
        , LEAD_UNIT_NUMBER VARCHAR2(8)
        , ACTIVITY_TYPE_CODE NUMBER(3) NOT NULL
        , AWARD_TYPE_CODE NUMBER(3) NOT NULL
        , PRIME_SPONSOR_CODE VARCHAR2(6)
        , CFDA_NUMBER VARCHAR2(6)
        , METHOD_OF_PAYMENT_CODE VARCHAR2(3)
        , DFAFS_NUMBER VARCHAR2(20)
        , PRE_AWARD_AUTHORIZED_AMOUNT NUMBER(12,2)
        , PRE_AWARD_EFFECTIVE_DATE DATE
        , PROCUREMENT_PRIORITY_CODE VARCHAR2(6)
        , PROPOSAL_NUMBER VARCHAR2(8)
        , SPECIAL_EB_RATE_OFF_CAMPUS NUMBER(5,2)
        , SPECIAL_EB_RATE_ON_CAMPUS NUMBER(5,2)
        , SUB_PLAN_FLAG VARCHAR2(1)
        , TITLE VARCHAR2(200) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , PRE_AWARD_IN_AUTHORIZED_AMOUNT NUMBER(12,2)
        , ARCHIVE_LOCATION VARCHAR2(50)
        , PRE_AWARD_INST_EFFECTIVE_DATE DATE
        , BASIS_OF_PAYMENT_CODE VARCHAR2(3)
        , AWARD_ID NUMBER(22)
        , DOCUMENT_NUMBER VARCHAR2(10) NOT NULL
        , AWARD_NUMBER VARCHAR2(12) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , SPONSOR_CODE VARCHAR2(6) NOT NULL
        , STATUS_CODE NUMBER(3) NOT NULL
        , TEMPLATE_CODE NUMBER(5)
        , ACCOUNT_NUMBER VARCHAR2(7)
        , APPRVD_EQUIPMENT_INDICATOR VARCHAR2(2) NOT NULL
        , APPRVD_FOREIGN_TRIP_INDICATOR VARCHAR2(2) NOT NULL
        , APPRVD_SUBCONTRACT_INDICATOR VARCHAR2(2) NOT NULL
        , AWARD_EFFECTIVE_DATE DATE
        , AWARD_EXECUTION_DATE DATE
        , BEGIN_DATE DATE
        , COST_SHARING_INDICATOR VARCHAR2(2) NOT NULL
        , IDC_INDICATOR VARCHAR2(2) NOT NULL
        , MODIFICATION_NUMBER VARCHAR2(50)
        , NSF_CODE VARCHAR2(15)
        , PAYMENT_SCHEDULE_INDICATOR VARCHAR2(2) NOT NULL
        , SCIENCE_CODE_INDICATOR VARCHAR2(2) NOT NULL
        , SPECIAL_REVIEW_INDICATOR VARCHAR2(2) NOT NULL
        , SPONSOR_AWARD_NUMBER VARCHAR2(70)
        , TRANSFER_SPONSOR_INDICATOR VARCHAR2(2) NOT NULL
        , ACCOUNT_TYPE_CODE NUMBER(3)
        , OBJ_ID VARCHAR2(36)
        , FIN_ACCOUNT_DOC_NBR VARCHAR2(20)
        , FIN_ACCOUNT_CREATION_DATE DATE
    

);

ALTER TABLE AWARD
    ADD CONSTRAINT AWARDP1
PRIMARY KEY (AWARD_ID);







-----------------------------------------------------------------------------
-- AWARD_AMOUNT_INFO
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_AMOUNT_INFO';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_AMOUNT_INFO CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_AMOUNT_INFO
(
      ANTICIPATED_CHANGE_DIRECT NUMBER(12,2)
        , ANTICIPATED_CHANGE_INDIRECT NUMBER(12,2)
        , ANTICIPATED_TOTAL_DIRECT NUMBER(12,2)
        , ANTICIPATED_TOTAL_INDIRECT NUMBER(12,2)
        , OBLIGATED_TOTAL_DIRECT NUMBER(12,2)
        , OBLIGATED_TOTAL_INDIRECT NUMBER(12,2)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , TNM_DOCUMENT_NUMBER VARCHAR2(10)
        , AWARD_AMOUNT_INFO_ID NUMBER(12)
        , AWARD_ID NUMBER(22) NOT NULL
        , AWARD_NUMBER VARCHAR2(12) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , ANTICIPATED_TOTAL_AMOUNT NUMBER(12,2)
        , ANT_DISTRIBUTABLE_AMOUNT NUMBER(12,2)
        , FINAL_EXPIRATION_DATE DATE
        , CURRENT_FUND_EFFECTIVE_DATE DATE
        , AMOUNT_OBLIGATED_TO_DATE NUMBER(12,2)
        , OBLI_DISTRIBUTABLE_AMOUNT NUMBER(12,2)
        , OBLIGATION_EXPIRATION_DATE DATE
        , TRANSACTION_ID NUMBER(10)
        , ENTRY_TYPE CHAR(1)
        , EOM_PROCESS_FLAG CHAR(1)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , ANTICIPATED_CHANGE NUMBER(12,2)
        , OBLIGATED_CHANGE NUMBER(12,2)
        , OBLIGATED_CHANGE_DIRECT NUMBER(12,2)
        , OBLIGATED_CHANGE_INDIRECT NUMBER(12,2)
        , OBJ_ID VARCHAR2(36)
        , ORIGINATING_AWARD_VERSION NUMBER(4)
    

);

ALTER TABLE AWARD_AMOUNT_INFO
    ADD CONSTRAINT AWARD_AMOUNT_INFOP1
PRIMARY KEY (AWARD_AMOUNT_INFO_ID);







-----------------------------------------------------------------------------
-- AWARD_AMOUNT_TRANSACTION
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_AMOUNT_TRANSACTION';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_AMOUNT_TRANSACTION CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_AMOUNT_TRANSACTION
(
      AWARD_AMOUNT_TRANSACTION_ID NUMBER(12)
        , AWARD_NUMBER VARCHAR2(12) NOT NULL
        , TRANSACTION_ID VARCHAR2(10) NOT NULL
        , TRANSACTION_TYPE_CODE NUMBER(3)
        , NOTICE_DATE DATE
        , COMMENTS VARCHAR2(2000)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_AMOUNT_TRANSACTION
    ADD CONSTRAINT AWARD_AMOUNT_TRANSACTIONP1
PRIMARY KEY (AWARD_AMOUNT_TRANSACTION_ID);


CREATE INDEX UQ_AWARD_AMOUNT_TRANSACTIONS 
  ON AWARD_AMOUNT_TRANSACTION 
  (AWARD_NUMBER, TRANSACTION_ID);





-----------------------------------------------------------------------------
-- AWARD_AMT_FNA_DISTRIBUTION
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_AMT_FNA_DISTRIBUTION';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_AMT_FNA_DISTRIBUTION CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_AMT_FNA_DISTRIBUTION
(
      AWARD_AMT_FNA_DISTRIBUTION_ID NUMBER(8)
        , AWARD_ID NUMBER(22)
        , AWARD_NUMBER VARCHAR2(12)
        , SEQUENCE_NUMBER NUMBER(8)
        , AMOUNT_SEQUENCE_NUMBER NUMBER(4)
        , BUDGET_PERIOD NUMBER(3)
        , START_DATE DATE
        , END_DATE DATE
        , DIRECT_COST NUMBER(12,2)
        , INDIRECT_COST NUMBER(12,2)
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1
        , AWARD_AMOUNT_INFO_ID NUMBER(8)
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE AWARD_AMT_FNA_DISTRIBUTION
    ADD CONSTRAINT AWARD_AMT_FNA_DISTRIBUTIONP1
PRIMARY KEY (AWARD_AMT_FNA_DISTRIBUTION_ID);


CREATE INDEX U_AWARD_AMT_FNA_DISTRIBUTION 
  ON AWARD_AMT_FNA_DISTRIBUTION 
  (AWARD_AMT_FNA_DISTRIBUTION_ID, AWARD_NUMBER, SEQUENCE_NUMBER, BUDGET_PERIOD);





-----------------------------------------------------------------------------
-- AWARD_APPROVED_EQUIPMENT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_APPROVED_EQUIPMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_APPROVED_EQUIPMENT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_APPROVED_EQUIPMENT
(
      AWARD_APPROVED_EQUIPMENT_ID NUMBER(22)
        , AWARD_ID NUMBER(22) NOT NULL
        , AWARD_NUMBER VARCHAR2(12) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , ITEM VARCHAR2(100) NOT NULL
        , VENDOR VARCHAR2(50)
        , MODEL VARCHAR2(50)
        , AMOUNT NUMBER(12,2) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_APPROVED_EQUIPMENT
    ADD CONSTRAINT AWARD_APPROVED_EQUIPMENTP1
PRIMARY KEY (AWARD_APPROVED_EQUIPMENT_ID);







-----------------------------------------------------------------------------
-- AWARD_APPROVED_FOREIGN_TRAVEL
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_APPROVED_FOREIGN_TRAVEL';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_APPROVED_FOREIGN_TRAVEL CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_APPROVED_FOREIGN_TRAVEL
(
      AWARD_APPR_FORN_TRAVEL_ID NUMBER(22)
        , AWARD_ID NUMBER(22) NOT NULL
        , AWARD_NUMBER VARCHAR2(12) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , PERSON_ID VARCHAR2(40)
        , ROLODEX_ID NUMBER(6)
        , TRAVELER_NAME VARCHAR2(90)
        , DESTINATION VARCHAR2(30) NOT NULL
        , START_DATE DATE NOT NULL
        , END_DATE DATE
        , AMOUNT NUMBER(12,2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_APPROVED_FOREIGN_TRAVEL
    ADD CONSTRAINT AWARD_APPROVED_FOREIGN_TRAVP1
PRIMARY KEY (AWARD_APPR_FORN_TRAVEL_ID);







-----------------------------------------------------------------------------
-- AWARD_APPROVED_SUBAWARDS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_APPROVED_SUBAWARDS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_APPROVED_SUBAWARDS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_APPROVED_SUBAWARDS
(
      AWARD_APPROVED_SUBAWARD_ID NUMBER(8)
        , AWARD_ID NUMBER(22)
        , AWARD_NUMBER VARCHAR2(12)
        , SEQUENCE_NUMBER NUMBER(8)
        , ORGANIZATION_NAME VARCHAR2(60)
        , AMOUNT NUMBER(12,2)
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1
        , ORGANIZATION_ID VARCHAR2(8)
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE AWARD_APPROVED_SUBAWARDS
    ADD CONSTRAINT AWARD_APPROVED_SUBAWARDSP1
PRIMARY KEY (AWARD_APPROVED_SUBAWARD_ID);







-----------------------------------------------------------------------------
-- AWARD_ATTACHMENT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_ATTACHMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_ATTACHMENT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_ATTACHMENT
(
      AWARD_ATTACHMENT_ID NUMBER(12)
        , AWARD_ID NUMBER(22) NOT NULL
        , AWARD_NUMBER VARCHAR2(20) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , TYPE_CODE VARCHAR2(3) NOT NULL
        , DOCUMENT_ID NUMBER(4) NOT NULL
        , FILE_ID NUMBER(22) NOT NULL
        , DESCRIPTION VARCHAR2(200)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_ATTACHMENT
    ADD CONSTRAINT AWARD_ATTACHMENTP1
PRIMARY KEY (AWARD_ATTACHMENT_ID);







-----------------------------------------------------------------------------
-- AWARD_ATTACHMENT_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_ATTACHMENT_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_ATTACHMENT_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_ATTACHMENT_TYPE
(
      TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(300) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_ATTACHMENT_TYPE
    ADD CONSTRAINT AWARD_ATTACHMENT_TYPEP1
PRIMARY KEY (TYPE_CODE);







-----------------------------------------------------------------------------
-- AWARD_BASIS_OF_PAYMENT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_BASIS_OF_PAYMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_BASIS_OF_PAYMENT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_BASIS_OF_PAYMENT
(
      VER_NBR NUMBER(8) default 1 NOT NULL
        , BASIS_OF_PAYMENT_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_BASIS_OF_PAYMENT
    ADD CONSTRAINT AWARD_BASIS_OF_PAYMENTP1
PRIMARY KEY (BASIS_OF_PAYMENT_CODE);







-----------------------------------------------------------------------------
-- AWARD_BUDGET_DETAILS_EXT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_BUDGET_DETAILS_EXT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_BUDGET_DETAILS_EXT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_BUDGET_DETAILS_EXT
(
      BUDGET_DETAILS_ID NUMBER(12)
        , OBLIGATED_AMOUNT NUMBER(12)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE AWARD_BUDGET_DETAILS_EXT
    ADD CONSTRAINT AWARD_BUDGET_DETAILS_EXTP1
PRIMARY KEY (BUDGET_DETAILS_ID);







-----------------------------------------------------------------------------
-- AWARD_BUDGET_EXT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_BUDGET_EXT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_BUDGET_EXT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_BUDGET_EXT
(
      BUDGET_ID NUMBER(12)
        , AWARD_BUDGET_STATUS_CODE VARCHAR2(3) NOT NULL
        , AWARD_BUDGET_TYPE_CODE VARCHAR2(3) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBLIGATED_AMOUNT NUMBER(12,2)
        , BUDGET_INITIATOR VARCHAR2(60)
        , DESCRIPTION VARCHAR2(255)
        , DOCUMENT_NUMBER NUMBER(10)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_BUDGET_EXT
    ADD CONSTRAINT AWARD_BUDGET_EXTP1
PRIMARY KEY (BUDGET_ID);







-----------------------------------------------------------------------------
-- AWARD_BUDGET_PERIOD_EXT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_BUDGET_PERIOD_EXT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_BUDGET_PERIOD_EXT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_BUDGET_PERIOD_EXT
(
      BUDGET_PERIOD_NUMBER NUMBER(12)
        , OBLIGATED_AMOUNT NUMBER(12)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE AWARD_BUDGET_PERIOD_EXT
    ADD CONSTRAINT AWARD_BUDGET_PERIOD_EXTP1
PRIMARY KEY (BUDGET_PERIOD_NUMBER);







-----------------------------------------------------------------------------
-- AWARD_BUDGET_STATUS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_BUDGET_STATUS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_BUDGET_STATUS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_BUDGET_STATUS
(
      AWARD_BUDGET_STATUS_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_BUDGET_STATUS
    ADD CONSTRAINT AWARD_BUDGET_STATUSP1
PRIMARY KEY (AWARD_BUDGET_STATUS_CODE);







-----------------------------------------------------------------------------
-- AWARD_BUDGET_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_BUDGET_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_BUDGET_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_BUDGET_TYPE
(
      AWARD_BUDGET_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_BUDGET_TYPE
    ADD CONSTRAINT AWARD_BUDGET_TYPEP1
PRIMARY KEY (AWARD_BUDGET_TYPE_CODE);







-----------------------------------------------------------------------------
-- AWARD_CLOSEOUT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_CLOSEOUT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_CLOSEOUT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_CLOSEOUT
(
      AWARD_CLOSEOUT_ID NUMBER(12)
        , AWARD_ID NUMBER(22) NOT NULL
        , AWARD_NUMBER VARCHAR2(12) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , CLOSEOUT_REPORT_CODE VARCHAR2(3) NOT NULL
        , CLOSEOUT_REPORT_NAME VARCHAR2(100) NOT NULL
        , DUE_DATE DATE
        , FINAL_SUBMISSION_DATE DATE
        , MULTIPLE CHAR(1)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_CLOSEOUT
    ADD CONSTRAINT AWARD_CLOSEOUTP1
PRIMARY KEY (AWARD_CLOSEOUT_ID);







-----------------------------------------------------------------------------
-- AWARD_COMMENT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_COMMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_COMMENT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_COMMENT
(
      AWARD_COMMENT_ID NUMBER(8)
        , AWARD_ID NUMBER(22)
        , AWARD_NUMBER VARCHAR2(12)
        , SEQUENCE_NUMBER NUMBER(8)
        , COMMENT_TYPE_CODE VARCHAR2(3)
        , CHECKLIST_PRINT_FLAG VARCHAR2(1)
        , COMMENTS CLOB
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE AWARD_COMMENT
    ADD CONSTRAINT AWARD_COMMENTP1
PRIMARY KEY (AWARD_COMMENT_ID);







-----------------------------------------------------------------------------
-- AWARD_COST_SHARE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_COST_SHARE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_COST_SHARE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_COST_SHARE
(
      VERIFICATION_DATE DATE
        , COST_SHARE_MET NUMBER(12,2)
        , AWARD_COST_SHARE_ID NUMBER(8)
        , AWARD_ID NUMBER(22)
        , AWARD_NUMBER VARCHAR2(12)
        , SEQUENCE_NUMBER NUMBER(8)
        , FISCAL_YEAR VARCHAR2(4)
        , COST_SHARE_PERCENTAGE NUMBER(5,2)
        , COST_SHARE_TYPE_CODE NUMBER(3)
        , SOURCE VARCHAR2(32)
        , DESTINATION VARCHAR2(32)
        , COMMITMENT_AMOUNT NUMBER(12,2)
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE AWARD_COST_SHARE
    ADD CONSTRAINT AWARD_COST_SHAREP1
PRIMARY KEY (AWARD_COST_SHARE_ID);


CREATE INDEX U_AWARD_COST_SHARE 
  ON AWARD_COST_SHARE 
  (AWARD_NUMBER, SEQUENCE_NUMBER, FISCAL_YEAR, COST_SHARE_TYPE_CODE, SOURCE, DESTINATION);





-----------------------------------------------------------------------------
-- AWARD_CUSTOM_DATA
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_CUSTOM_DATA';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_CUSTOM_DATA CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_CUSTOM_DATA
(
      AWARD_CUSTOM_DATA_ID NUMBER(8)
        , AWARD_ID NUMBER(22)
        , AWARD_NUMBER VARCHAR2(12)
        , SEQUENCE_NUMBER NUMBER(8)
        , CUSTOM_ATTRIBUTE_ID NUMBER(12)
        , VALUE VARCHAR2(2000)
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE AWARD_CUSTOM_DATA
    ADD CONSTRAINT AWARD_CUSTOM_DATAP1
PRIMARY KEY (AWARD_CUSTOM_DATA_ID);







-----------------------------------------------------------------------------
-- AWARD_DOCUMENT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_DOCUMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_DOCUMENT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_DOCUMENT
(
      DOCUMENT_NUMBER VARCHAR2(10)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_DOCUMENT
    ADD CONSTRAINT AWARD_DOCUMENTP1
PRIMARY KEY (DOCUMENT_NUMBER);







-----------------------------------------------------------------------------
-- AWARD_EXEMPT_NUMBER
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_EXEMPT_NUMBER';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_EXEMPT_NUMBER CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_EXEMPT_NUMBER
(
      AWARD_EXEMPT_NUMBER_ID NUMBER(12)
        , AWARD_SPECIAL_REVIEW_ID NUMBER(12) NOT NULL
        , EXEMPTION_TYPE_CODE VARCHAR2(3) NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_EXEMPT_NUMBER
    ADD CONSTRAINT AWARD_EXEMPT_NUMBERP1
PRIMARY KEY (AWARD_EXEMPT_NUMBER_ID);







-----------------------------------------------------------------------------
-- AWARD_FUNDING_PROPOSALS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_FUNDING_PROPOSALS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_FUNDING_PROPOSALS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_FUNDING_PROPOSALS
(
      AWARD_FUNDING_PROPOSAL_ID NUMBER(22)
        , AWARD_ID NUMBER(22) NOT NULL
        , PROPOSAL_ID NUMBER(22) NOT NULL
        , UPDATE_TIMESTAMP TIMESTAMP NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , ACTIVE CHAR(1)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_FUNDING_PROPOSALS
    ADD CONSTRAINT AWARD_FUNDING_PROPOSALSP1
PRIMARY KEY (AWARD_FUNDING_PROPOSAL_ID);


CREATE INDEX U_AWD_FUND_PROP 
  ON AWARD_FUNDING_PROPOSALS 
  (AWARD_ID, PROPOSAL_ID);





-----------------------------------------------------------------------------
-- AWARD_HIERARCHY
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_HIERARCHY';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_HIERARCHY CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_HIERARCHY
(
      AWARD_HIERARCHY_ID NUMBER(22)
        , ROOT_AWARD_NUMBER VARCHAR2(12) NOT NULL
        , AWARD_NUMBER VARCHAR2(12) NOT NULL
        , PARENT_AWARD_NUMBER VARCHAR2(12) NOT NULL
        , ORIGINATING_AWARD_NUMBER VARCHAR2(12) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_HIERARCHY
    ADD CONSTRAINT AWARD_HIERARCHYP1
PRIMARY KEY (AWARD_HIERARCHY_ID);


CREATE INDEX UQ_AWD_HIER_AWARD_NBR 
  ON AWARD_HIERARCHY 
  (AWARD_NUMBER);





-----------------------------------------------------------------------------
-- AWARD_IDC_RATE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_IDC_RATE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_IDC_RATE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_IDC_RATE
(
      AWARD_NUMBER VARCHAR2(12) NOT NULL
        , SEQUENCE_NUMBER NUMBER(8) NOT NULL
        , AWARD_IDC_RATE_ID NUMBER(12)
        , AWARD_ID NUMBER(22) NOT NULL
        , APPLICABLE_IDC_RATE NUMBER(5,2) NOT NULL
        , IDC_RATE_TYPE_CODE NUMBER(3) NOT NULL
        , FISCAL_YEAR VARCHAR2(4) NOT NULL
        , ON_CAMPUS_FLAG VARCHAR2(1) NOT NULL
        , UNDERRECOVERY_OF_IDC NUMBER(12,2)
        , SOURCE_ACCOUNT VARCHAR2(32)
        , DESTINATION_ACCOUNT VARCHAR2(32)
        , START_DATE DATE NOT NULL
        , END_DATE DATE
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_IDC_RATE
    ADD CONSTRAINT AWARD_IDC_RATEP1
PRIMARY KEY (AWARD_IDC_RATE_ID);







-----------------------------------------------------------------------------
-- AWARD_METHOD_OF_PAYMENT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_METHOD_OF_PAYMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_METHOD_OF_PAYMENT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_METHOD_OF_PAYMENT
(
      VER_NBR NUMBER(8) default 1 NOT NULL
        , METHOD_OF_PAYMENT_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_METHOD_OF_PAYMENT
    ADD CONSTRAINT AWARD_METHOD_OF_PAYMENTP1
PRIMARY KEY (METHOD_OF_PAYMENT_CODE);







-----------------------------------------------------------------------------
-- AWARD_NOTEPAD
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_NOTEPAD';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_NOTEPAD CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_NOTEPAD
(
      AWARD_NOTEPAD_ID NUMBER(12)
        , AWARD_NUMBER VARCHAR2(12) NOT NULL
        , ENTRY_NUMBER NUMBER(4) NOT NULL
        , COMMENTS CLOB NOT NULL
        , RESTRICTED_VIEW CHAR(1) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , CREATE_TIMESTAMP DATE NOT NULL
        , NOTE_TOPIC VARCHAR2(60) NOT NULL
        , AWARD_ID NUMBER(22) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_NOTEPAD
    ADD CONSTRAINT AWARD_NOTEPADP1
PRIMARY KEY (AWARD_NOTEPAD_ID);


CREATE INDEX UQ_AWARD_NOTEPAD 
  ON AWARD_NOTEPAD 
  (AWARD_NUMBER, ENTRY_NUMBER);





-----------------------------------------------------------------------------
-- AWARD_PAYMENT_SCHEDULE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_PAYMENT_SCHEDULE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_PAYMENT_SCHEDULE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_PAYMENT_SCHEDULE
(
      AWARD_PAYMENT_SCHEDULE_ID NUMBER(12)
        , AWARD_ID NUMBER(22) NOT NULL
        , AWARD_NUMBER VARCHAR2(12) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , DUE_DATE DATE
        , AMOUNT NUMBER(12,2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , SUBMIT_DATE DATE
        , SUBMITTED_BY VARCHAR2(9)
        , INVOICE_NUMBER VARCHAR2(10)
        , STATUS_DESCRIPTION VARCHAR2(50)
        , STATUS VARCHAR2(5)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_PAYMENT_SCHEDULE
    ADD CONSTRAINT AWARD_PAYMENT_SCHEDULEP1
PRIMARY KEY (AWARD_PAYMENT_SCHEDULE_ID);







-----------------------------------------------------------------------------
-- AWARD_PERSONS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_PERSONS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_PERSONS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_PERSONS
(
      KEY_PERSON_PROJECT_ROLE VARCHAR2(60)
        , AWARD_PERSON_ID NUMBER(22)
        , AWARD_ID NUMBER(22) NOT NULL
        , AWARD_NUMBER VARCHAR2(12) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , PERSON_ID VARCHAR2(40)
        , ROLODEX_ID NUMBER(6)
        , FULL_NAME VARCHAR2(90)
        , CONTACT_ROLE_CODE VARCHAR2(12) NOT NULL
        , ACADEMIC_YEAR_EFFORT NUMBER(5,2)
        , CALENDAR_YEAR_EFFORT NUMBER(5,2)
        , SUMMER_EFFORT NUMBER(5,2)
        , TOTAL_EFFORT NUMBER(5,2)
        , FACULTY_FLAG CHAR(1) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE AWARD_PERSONS
    ADD CONSTRAINT AWARD_PERSONSP1
PRIMARY KEY (AWARD_PERSON_ID);







-----------------------------------------------------------------------------
-- AWARD_PERSON_CREDIT_SPLITS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_PERSON_CREDIT_SPLITS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_PERSON_CREDIT_SPLITS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_PERSON_CREDIT_SPLITS
(
      AWARD_PERSON_CREDIT_SPLIT_ID NUMBER(22)
        , AWARD_PERSON_ID NUMBER(22) NOT NULL
        , INV_CREDIT_TYPE_CODE VARCHAR2(3) NOT NULL
        , CREDIT NUMBER(5,2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE AWARD_PERSON_CREDIT_SPLITS
    ADD CONSTRAINT AWARD_PERSON_CREDIT_SPLITSP1
PRIMARY KEY (AWARD_PERSON_CREDIT_SPLIT_ID);


CREATE INDEX UNQ_AP_CREDIT_SPLIT 
  ON AWARD_PERSON_CREDIT_SPLITS 
  (AWARD_PERSON_ID, INV_CREDIT_TYPE_CODE);





-----------------------------------------------------------------------------
-- AWARD_PERSON_UNITS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_PERSON_UNITS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_PERSON_UNITS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_PERSON_UNITS
(
      AWARD_PERSON_UNIT_ID NUMBER(22)
        , AWARD_PERSON_ID NUMBER(22) NOT NULL
        , UNIT_NUMBER VARCHAR2(8) NOT NULL
        , LEAD_UNIT_FLAG CHAR(1) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE AWARD_PERSON_UNITS
    ADD CONSTRAINT AWARD_PERSON_UNITSP1
PRIMARY KEY (AWARD_PERSON_UNIT_ID);







-----------------------------------------------------------------------------
-- AWARD_PERS_UNIT_CRED_SPLITS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_PERS_UNIT_CRED_SPLITS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_PERS_UNIT_CRED_SPLITS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_PERS_UNIT_CRED_SPLITS
(
      APU_CREDIT_SPLIT_ID NUMBER(22)
        , AWARD_PERSON_UNIT_ID NUMBER(22) NOT NULL
        , INV_CREDIT_TYPE_CODE VARCHAR2(3) NOT NULL
        , CREDIT NUMBER(5,2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE AWARD_PERS_UNIT_CRED_SPLITS
    ADD CONSTRAINT AWARD_PERS_UNIT_CRED_SPLITSP1
PRIMARY KEY (APU_CREDIT_SPLIT_ID);


CREATE INDEX UNQ_APU_CREDIT_SPLIT 
  ON AWARD_PERS_UNIT_CRED_SPLITS 
  (AWARD_PERSON_UNIT_ID, INV_CREDIT_TYPE_CODE);





-----------------------------------------------------------------------------
-- AWARD_REPORT_TERMS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_REPORT_TERMS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_REPORT_TERMS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_REPORT_TERMS
(
      AWARD_REPORT_TERMS_ID NUMBER(12)
        , AWARD_ID NUMBER(22) NOT NULL
        , AWARD_NUMBER VARCHAR2(12) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , REPORT_CLASS_CODE VARCHAR2(3) NOT NULL
        , REPORT_CODE VARCHAR2(3) NOT NULL
        , FREQUENCY_CODE VARCHAR2(3)
        , FREQUENCY_BASE_CODE VARCHAR2(3)
        , OSP_DISTRIBUTION_CODE VARCHAR2(3)
        , DUE_DATE DATE
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_REPORT_TERMS
    ADD CONSTRAINT AWARD_REPORT_TERMSP1
PRIMARY KEY (AWARD_REPORT_TERMS_ID);







-----------------------------------------------------------------------------
-- AWARD_REP_TERMS_RECNT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_REP_TERMS_RECNT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_REP_TERMS_RECNT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_REP_TERMS_RECNT
(
      CONTACT_ID NUMBER(12)
        , AWARD_REP_TERMS_RECNT_ID NUMBER(12)
        , AWARD_REPORT_TERMS_ID NUMBER(12) NOT NULL
        , CONTACT_TYPE_CODE VARCHAR2(3) NOT NULL
        , ROLODEX_ID NUMBER(6) NOT NULL
        , NUMBER_OF_COPIES NUMBER(2)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_REP_TERMS_RECNT
    ADD CONSTRAINT AWARD_REP_TERMS_RECNTP1
PRIMARY KEY (AWARD_REP_TERMS_RECNT_ID);







-----------------------------------------------------------------------------
-- AWARD_SCIENCE_KEYWORD
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_SCIENCE_KEYWORD';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_SCIENCE_KEYWORD CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_SCIENCE_KEYWORD
(
      AWARD_SCIENCE_KEYWORD_ID NUMBER(12)
        , AWARD_ID NUMBER(22) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , SCIENCE_KEYWORD_CODE VARCHAR2(15) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_SCIENCE_KEYWORD
    ADD CONSTRAINT AWARD_SCIENCE_KEYWORDP1
PRIMARY KEY (AWARD_SCIENCE_KEYWORD_ID);







-----------------------------------------------------------------------------
-- AWARD_SPECIAL_REVIEW
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_SPECIAL_REVIEW';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_SPECIAL_REVIEW CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_SPECIAL_REVIEW
(
      EXPIRATION_DATE DATE
        , AWARD_SPECIAL_REVIEW_ID NUMBER(12)
        , AWARD_ID NUMBER(22) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , SPECIAL_REVIEW_NUMBER NUMBER(3) NOT NULL
        , SPECIAL_REVIEW_CODE NUMBER(3) NOT NULL
        , APPROVAL_TYPE_CODE NUMBER(3) NOT NULL
        , PROTOCOL_NUMBER VARCHAR2(20)
        , APPLICATION_DATE DATE
        , APPROVAL_DATE DATE
        , COMMENTS CLOB
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_SPECIAL_REVIEW
    ADD CONSTRAINT AWARD_SPECIAL_REVIEWP1
PRIMARY KEY (AWARD_SPECIAL_REVIEW_ID);







-----------------------------------------------------------------------------
-- AWARD_SPONSOR_CONTACTS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_SPONSOR_CONTACTS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_SPONSOR_CONTACTS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_SPONSOR_CONTACTS
(
      AWARD_SPONSOR_CONTACT_ID NUMBER(22)
        , AWARD_ID NUMBER(22) NOT NULL
        , AWARD_NUMBER VARCHAR2(12) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , ROLODEX_ID NUMBER(6)
        , FULL_NAME VARCHAR2(90)
        , CONTACT_ROLE_CODE VARCHAR2(12) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE AWARD_SPONSOR_CONTACTS
    ADD CONSTRAINT AWARD_SPONSOR_CONTACTSP1
PRIMARY KEY (AWARD_SPONSOR_CONTACT_ID);







-----------------------------------------------------------------------------
-- AWARD_SPONSOR_TERM
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_SPONSOR_TERM';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_SPONSOR_TERM CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_SPONSOR_TERM
(
      AWARD_SPONSOR_TERM_ID NUMBER(8)
        , AWARD_ID NUMBER(22)
        , AWARD_NUMBER VARCHAR2(12)
        , SEQUENCE_NUMBER NUMBER(8)
        , SPONSOR_TERM_ID NUMBER(12)
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE AWARD_SPONSOR_TERM
    ADD CONSTRAINT AWARD_SPONSOR_TERMP1
PRIMARY KEY (AWARD_SPONSOR_TERM_ID);


CREATE INDEX U_AWARD_SPONSOR_TERM 
  ON AWARD_SPONSOR_TERM 
  (SPONSOR_TERM_ID, AWARD_ID);





-----------------------------------------------------------------------------
-- AWARD_STATUS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_STATUS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_STATUS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_STATUS
(
      VER_NBR NUMBER(8) default 1 NOT NULL
        , STATUS_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_STATUS
    ADD CONSTRAINT AWARD_STATUSP1
PRIMARY KEY (STATUS_CODE);







-----------------------------------------------------------------------------
-- AWARD_TEMPLATE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_TEMPLATE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_TEMPLATE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_TEMPLATE
(
      AWARD_TEMPLATE_CODE NUMBER(5)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , STATUS_CODE VARCHAR2(3) NOT NULL
        , PRIME_SPONSOR_CODE CHAR(6)
        , BASIS_OF_PAYMENT_CODE VARCHAR2(3) NOT NULL
        , METHOD_OF_PAYMENT_CODE VARCHAR2(3) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_TEMPLATE
    ADD CONSTRAINT AWARD_TEMPLATEP1
PRIMARY KEY (AWARD_TEMPLATE_CODE);







-----------------------------------------------------------------------------
-- AWARD_TEMPLATE_COMMENTS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_TEMPLATE_COMMENTS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_TEMPLATE_COMMENTS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_TEMPLATE_COMMENTS
(
      AWARD_TEMPLATE_COMMENTS_ID NUMBER(12)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , AWARD_TEMPLATE_CODE NUMBER(5) NOT NULL
        , COMMENT_TYPE_CODE VARCHAR2(3) NOT NULL
        , CHECKLIST_PRINT_FLAG CHAR(1) NOT NULL
        , COMMENTS CLOB
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_TEMPLATE_COMMENTS
    ADD CONSTRAINT AWARD_TEMPLATE_COMMENTSP1
PRIMARY KEY (AWARD_TEMPLATE_COMMENTS_ID);


CREATE INDEX UQ_AWARD_TEMPLATE_COMMENTS 
  ON AWARD_TEMPLATE_COMMENTS 
  (AWARD_TEMPLATE_CODE, COMMENT_TYPE_CODE);





-----------------------------------------------------------------------------
-- AWARD_TEMPLATE_CONTACT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_TEMPLATE_CONTACT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_TEMPLATE_CONTACT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_TEMPLATE_CONTACT
(
      AWARD_TEMPLATE_CONTACT_ID NUMBER(12)
        , AWARD_TEMPLATE_CODE NUMBER(5) NOT NULL
        , CONTACT_TYPE_CODE VARCHAR2(3) NOT NULL
        , ROLODEX_ID NUMBER(6) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_TEMPLATE_CONTACT
    ADD CONSTRAINT AWARD_TEMPLATE_CONTACTP1
PRIMARY KEY (AWARD_TEMPLATE_CONTACT_ID);


CREATE INDEX UQ_AWARD_TEMPLATE_CONTACT 
  ON AWARD_TEMPLATE_CONTACT 
  (AWARD_TEMPLATE_CODE, CONTACT_TYPE_CODE, ROLODEX_ID);





-----------------------------------------------------------------------------
-- AWARD_TEMPLATE_REPORT_TERMS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_TEMPLATE_REPORT_TERMS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_TEMPLATE_REPORT_TERMS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_TEMPLATE_REPORT_TERMS
(
      TEMPLATE_REPORT_TERMS_ID NUMBER(12)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , AWARD_TEMPLATE_CODE NUMBER(5) NOT NULL
        , REPORT_CLASS_CODE VARCHAR2(3) NOT NULL
        , REPORT_CODE VARCHAR2(3) NOT NULL
        , FREQUENCY_CODE VARCHAR2(3) NOT NULL
        , FREQUENCY_BASE_CODE VARCHAR2(3) NOT NULL
        , OSP_DISTRIBUTION_CODE VARCHAR2(3) NOT NULL
        , DUE_DATE DATE
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_TEMPLATE_REPORT_TERMS
    ADD CONSTRAINT AWARD_TEMPLATE_REPORT_TERMSP1
PRIMARY KEY (TEMPLATE_REPORT_TERMS_ID);







-----------------------------------------------------------------------------
-- AWARD_TEMPLATE_TERMS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_TEMPLATE_TERMS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_TEMPLATE_TERMS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_TEMPLATE_TERMS
(
      AWARD_TEMPLATE_TERMS_ID NUMBER(12)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , AWARD_TEMPLATE_CODE NUMBER(5) NOT NULL
        , SPONSOR_TERM_ID NUMBER(12) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_TEMPLATE_TERMS
    ADD CONSTRAINT AWARD_TEMPLATE_TERMSP1
PRIMARY KEY (AWARD_TEMPLATE_TERMS_ID);







-----------------------------------------------------------------------------
-- AWARD_TEMPL_REP_TERMS_RECNT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_TEMPL_REP_TERMS_RECNT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_TEMPL_REP_TERMS_RECNT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_TEMPL_REP_TERMS_RECNT
(
      TEMPL_REP_TERMS_RECNT_ID NUMBER(12)
        , TEMPLATE_REPORT_TERMS_ID NUMBER(12) NOT NULL
        , CONTACT_TYPE_CODE VARCHAR2(3) NOT NULL
        , ROLODEX_ID NUMBER(6) NOT NULL
        , NUMBER_OF_COPIES NUMBER(2)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_TEMPL_REP_TERMS_RECNT
    ADD CONSTRAINT AWARD_TEMPL_REP_TERMS_RECNTP1
PRIMARY KEY (TEMPL_REP_TERMS_RECNT_ID);







-----------------------------------------------------------------------------
-- AWARD_TRANSACTION_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_TRANSACTION_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_TRANSACTION_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_TRANSACTION_TYPE
(
      AWARD_TRANSACTION_TYPE_CODE NUMBER(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , SHOW_IN_ACTION_SUMMARY VARCHAR2(1) default 'Y' NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_TRANSACTION_TYPE
    ADD CONSTRAINT AWARD_TRANSACTION_TYPEP1
PRIMARY KEY (AWARD_TRANSACTION_TYPE_CODE);







-----------------------------------------------------------------------------
-- AWARD_TRANSFERRING_SPONSOR
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_TRANSFERRING_SPONSOR';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_TRANSFERRING_SPONSOR CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_TRANSFERRING_SPONSOR
(
      AWARD_TRANSFERRING_SPONSOR_ID NUMBER(12)
        , AWARD_ID NUMBER(22) NOT NULL
        , AWARD_NUMBER VARCHAR2(12) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , SPONSOR_CODE CHAR(6) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_TRANSFERRING_SPONSOR
    ADD CONSTRAINT AWARD_TRANSFERRING_SPONSORP1
PRIMARY KEY (AWARD_TRANSFERRING_SPONSOR_ID);


CREATE INDEX UQ_AWARD_TRANSFERRING_SPONSOR 
  ON AWARD_TRANSFERRING_SPONSOR 
  (AWARD_NUMBER, SEQUENCE_NUMBER, SPONSOR_CODE);





-----------------------------------------------------------------------------
-- AWARD_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_TYPE
(
      AWARD_TYPE_CODE NUMBER(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE AWARD_TYPE
    ADD CONSTRAINT AWARD_TYPEP1
PRIMARY KEY (AWARD_TYPE_CODE);







-----------------------------------------------------------------------------
-- AWARD_UNIT_CONTACTS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWARD_UNIT_CONTACTS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWARD_UNIT_CONTACTS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWARD_UNIT_CONTACTS
(
      AWARD_UNIT_CONTACT_ID NUMBER(22)
        , AWARD_ID NUMBER(22) NOT NULL
        , AWARD_NUMBER VARCHAR2(12) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , PERSON_ID VARCHAR2(40)
        , FULL_NAME VARCHAR2(90)
        , UNIT_ADMINISTRATOR_TYPE_CODE VARCHAR2(3)
        , UNIT_CONTACT_TYPE VARCHAR2(13) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
        , UNIT_ADMINISTRATOR_UNIT_NUMBER VARCHAR2(12)
    

);

ALTER TABLE AWARD_UNIT_CONTACTS
    ADD CONSTRAINT AWARD_UNIT_CONTACTSP1
PRIMARY KEY (AWARD_UNIT_CONTACT_ID);







-----------------------------------------------------------------------------
-- AWD_BGT_DET_CAL_AMTS_EXT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWD_BGT_DET_CAL_AMTS_EXT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWD_BGT_DET_CAL_AMTS_EXT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWD_BGT_DET_CAL_AMTS_EXT
(
      BUDGET_DETAILS_CAL_AMTS_ID NUMBER(12)
        , OBLIGATED_AMOUNT NUMBER(12)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE AWD_BGT_DET_CAL_AMTS_EXT
    ADD CONSTRAINT AWD_BGT_DET_CAL_AMTS_EXTP1
PRIMARY KEY (BUDGET_DETAILS_CAL_AMTS_ID);







-----------------------------------------------------------------------------
-- AWD_BUDGET_PER_CAL_AMTS_EXT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWD_BUDGET_PER_CAL_AMTS_EXT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWD_BUDGET_PER_CAL_AMTS_EXT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWD_BUDGET_PER_CAL_AMTS_EXT
(
      BUDGET_PERSONNEL_CAL_AMTS_ID NUMBER(12)
        , OBLIGATED_AMOUNT NUMBER(12)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE AWD_BUDGET_PER_CAL_AMTS_EXT
    ADD CONSTRAINT AWD_BUDGET_PER_CAL_AMTS_EXTP1
PRIMARY KEY (BUDGET_PERSONNEL_CAL_AMTS_ID);







-----------------------------------------------------------------------------
-- AWD_BUDGET_PER_DET_EXT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'AWD_BUDGET_PER_DET_EXT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE AWD_BUDGET_PER_DET_EXT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE AWD_BUDGET_PER_DET_EXT
(
      BUDGET_PERSONNEL_DETAILS_ID NUMBER(12)
        , OBLIGATED_AMOUNT NUMBER(12)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE AWD_BUDGET_PER_DET_EXT
    ADD CONSTRAINT AWD_BUDGET_PER_DET_EXTP1
PRIMARY KEY (BUDGET_PERSONNEL_DETAILS_ID);







-----------------------------------------------------------------------------
-- BATCH_CORRESPONDENCE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BATCH_CORRESPONDENCE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BATCH_CORRESPONDENCE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BATCH_CORRESPONDENCE
(
      BATCH_CORRESPONDENCE_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , DAYS_TO_EVENT_UI_TEXT VARCHAR2(400) NOT NULL
        , SEND_CORRESPONDENCE VARCHAR2(10) NOT NULL
        , FINAL_ACTION_DAY NUMBER(3)
        , FINAL_ACTION_TYPE_CODE VARCHAR2(3)
        , FINAL_ACTION_CORRESP_TYPE VARCHAR2(3)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE BATCH_CORRESPONDENCE
    ADD CONSTRAINT BATCH_CORRESPONDENCEP1
PRIMARY KEY (BATCH_CORRESPONDENCE_TYPE_CODE);







-----------------------------------------------------------------------------
-- BATCH_CORRESPONDENCE_DETAIL
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BATCH_CORRESPONDENCE_DETAIL';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BATCH_CORRESPONDENCE_DETAIL CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BATCH_CORRESPONDENCE_DETAIL
(
      BATCH_CORRESPONDENCE_DETAIL_ID NUMBER(12)
        , BATCH_CORRESPONDENCE_TYPE_CODE VARCHAR2(3) NOT NULL
        , PROTO_CORRESP_TYPE_CODE VARCHAR2(3) NOT NULL
        , DAYS_TO_EVENT NUMBER(3) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE BATCH_CORRESPONDENCE_DETAIL
    ADD CONSTRAINT BATCH_CORRESPONDENCE_DETAILP1
PRIMARY KEY (BATCH_CORRESPONDENCE_DETAIL_ID);







-----------------------------------------------------------------------------
-- BUDGET
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET
(
      BUDGET_ID NUMBER(12)
        , BUDGET_JUSTIFICATION CLOB
        , ON_OFF_CAMPUS_FLAG VARCHAR2(1) default 'D' NOT NULL
        , PROPOSAL_NUMBER VARCHAR2(12)
        , VERSION_NUMBER NUMBER(3)
        , DOCUMENT_NUMBER NUMBER(10) NOT NULL
        , START_DATE DATE NOT NULL
        , END_DATE DATE NOT NULL
        , TOTAL_COST NUMBER(12,2)
        , TOTAL_DIRECT_COST NUMBER(12,2)
        , TOTAL_INDIRECT_COST NUMBER(12,2)
        , COST_SHARING_AMOUNT NUMBER(12,2)
        , UNDERRECOVERY_AMOUNT NUMBER(12,2)
        , RESIDUAL_FUNDS NUMBER(12,2)
        , TOTAL_COST_LIMIT NUMBER(12,2)
        , OH_RATE_CLASS_CODE VARCHAR2(3) NOT NULL
        , OH_RATE_TYPE_CODE VARCHAR2(3)
        , COMMENTS CLOB
        , FINAL_VERSION_FLAG CHAR(1)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , UR_RATE_CLASS_CODE VARCHAR2(3) default '1' NOT NULL
        , MODULAR_BUDGET_FLAG VARCHAR2(1) default 'N' NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE BUDGET
    ADD CONSTRAINT BUDGETP1
PRIMARY KEY (BUDGET_ID);


CREATE INDEX PK_BUDGET_KRA 
  ON BUDGET 
  (PROPOSAL_NUMBER, VERSION_NUMBER);





-----------------------------------------------------------------------------
-- BUDGET_CATEGORY
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_CATEGORY';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_CATEGORY CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_CATEGORY
(
      BUDGET_CATEGORY_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , CATEGORY_TYPE VARCHAR2(3)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE BUDGET_CATEGORY
    ADD CONSTRAINT BUDGET_CATEGORYP1
PRIMARY KEY (BUDGET_CATEGORY_CODE);







-----------------------------------------------------------------------------
-- BUDGET_CATEGORY_MAPPING
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_CATEGORY_MAPPING';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_CATEGORY_MAPPING CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_CATEGORY_MAPPING
(
      MAPPING_NAME VARCHAR2(100)
        , TARGET_CATEGORY_CODE VARCHAR2(15)
        , COEUS_CATEGORY_CODE NUMBER(3)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE BUDGET_CATEGORY_MAPPING
    ADD CONSTRAINT BUDGET_CATEGORY_MAPPINGP1
PRIMARY KEY (MAPPING_NAME,TARGET_CATEGORY_CODE,COEUS_CATEGORY_CODE);







-----------------------------------------------------------------------------
-- BUDGET_CATEGORY_MAPS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_CATEGORY_MAPS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_CATEGORY_MAPS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_CATEGORY_MAPS
(
      MAPPING_NAME VARCHAR2(100)
        , TARGET_CATEGORY_CODE VARCHAR2(15)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , CATEGORY_TYPE CHAR(200)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE BUDGET_CATEGORY_MAPS
    ADD CONSTRAINT BUDGET_CATEGORY_MAPSP1
PRIMARY KEY (MAPPING_NAME,TARGET_CATEGORY_CODE);







-----------------------------------------------------------------------------
-- BUDGET_CATEGORY_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_CATEGORY_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_CATEGORY_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_CATEGORY_TYPE
(
      BUDGET_CATEGORY_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , SORT_ID NUMBER(2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE BUDGET_CATEGORY_TYPE
    ADD CONSTRAINT BUDGET_CATEGORY_TYPEP1
PRIMARY KEY (BUDGET_CATEGORY_TYPE_CODE);







-----------------------------------------------------------------------------
-- BUDGET_DETAILS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_DETAILS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_DETAILS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_DETAILS
(
      BUDGET_PERIOD_NUMBER NUMBER(12) NOT NULL
        , GROUP_NAME VARCHAR2(25)
        , BUDGET_ID NUMBER(12)
        , HIERARCHY_PROPOSAL_NUMBER VARCHAR2(12)
        , HIDE_IN_HIERARCHY CHAR(1) default 'N' NOT NULL
        , PROPOSAL_NUMBER VARCHAR2(12)
        , VERSION_NUMBER NUMBER(3)
        , BUDGET_PERIOD NUMBER(3) NOT NULL
        , LINE_ITEM_NUMBER NUMBER(3) NOT NULL
        , BUDGET_CATEGORY_CODE NUMBER(3) NOT NULL
        , COST_ELEMENT VARCHAR2(8) NOT NULL
        , LINE_ITEM_DESCRIPTION VARCHAR2(80)
        , BASED_ON_LINE_ITEM NUMBER(3)
        , LINE_ITEM_SEQUENCE NUMBER(3)
        , START_DATE DATE NOT NULL
        , END_DATE DATE NOT NULL
        , LINE_ITEM_COST NUMBER(12,2)
        , COST_SHARING_AMOUNT NUMBER(12,2)
        , UNDERRECOVERY_AMOUNT NUMBER(12,2)
        , ON_OFF_CAMPUS_FLAG CHAR(1) NOT NULL
        , APPLY_IN_RATE_FLAG CHAR(1) NOT NULL
        , BUDGET_JUSTIFICATION CLOB
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , QUANTITY NUMBER(4)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , BUDGET_DETAILS_ID NUMBER(12)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE BUDGET_DETAILS
    ADD CONSTRAINT BUDGET_DETAILSP1
PRIMARY KEY (BUDGET_DETAILS_ID);


CREATE INDEX PK_BUDGET_DETAILS_KRA 
  ON BUDGET_DETAILS 
  (PROPOSAL_NUMBER, VERSION_NUMBER, BUDGET_PERIOD, LINE_ITEM_NUMBER);





-----------------------------------------------------------------------------
-- BUDGET_DETAILS_CAL_AMTS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_DETAILS_CAL_AMTS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_DETAILS_CAL_AMTS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_DETAILS_CAL_AMTS
(
      BUDGET_ID NUMBER(12)
        , BUDGET_PERIOD_NUMBER NUMBER(12)
        , PROPOSAL_NUMBER VARCHAR2(12)
        , VERSION_NUMBER NUMBER(3)
        , BUDGET_PERIOD NUMBER(3) NOT NULL
        , LINE_ITEM_NUMBER NUMBER(3) NOT NULL
        , RATE_CLASS_CODE VARCHAR2(3) NOT NULL
        , RATE_TYPE_CODE VARCHAR2(3) NOT NULL
        , APPLY_RATE_FLAG CHAR(1) NOT NULL
        , CALCULATED_COST NUMBER(12,2)
        , CALCULATED_COST_SHARING NUMBER(12,2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1
        , BUDGET_DETAILS_CAL_AMTS_ID NUMBER(12)
        , BUDGET_DETAILS_ID NUMBER(12)
        , OBJ_ID VARCHAR2(36)
        , RATE_TYPE_DESCRIPTION VARCHAR2(200)
    

);

ALTER TABLE BUDGET_DETAILS_CAL_AMTS
    ADD CONSTRAINT BUDGET_DETAILS_CAL_AMTSP1
PRIMARY KEY (BUDGET_DETAILS_CAL_AMTS_ID);


CREATE INDEX PK_BUDGET_DETAILS_CAL_AMTS_KRA 
  ON BUDGET_DETAILS_CAL_AMTS 
  (PROPOSAL_NUMBER, VERSION_NUMBER, BUDGET_PERIOD, LINE_ITEM_NUMBER, RATE_CLASS_CODE, RATE_TYPE_CODE);





-----------------------------------------------------------------------------
-- BUDGET_DOCUMENT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_DOCUMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_DOCUMENT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_DOCUMENT
(
      DOCUMENT_NUMBER VARCHAR2(10)
        , PARENT_DOCUMENT_KEY VARCHAR2(10)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , PARENT_DOCUMENT_TYPE_CODE VARCHAR2(10)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE BUDGET_DOCUMENT
    ADD CONSTRAINT BUDGET_DOCUMENTP1
PRIMARY KEY (DOCUMENT_NUMBER);







-----------------------------------------------------------------------------
-- BUDGET_MODULAR
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_MODULAR';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_MODULAR CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_MODULAR
(
      BUDGET_PERIOD_NUMBER NUMBER(12)
        , BUDGET_ID NUMBER(12)
        , PROPOSAL_NUMBER VARCHAR2(8)
        , VERSION_NUMBER NUMBER(3)
        , BUDGET_PERIOD NUMBER(3) NOT NULL
        , DIRECT_COST_LESS_CONSOR_FNA NUMBER(12,2)
        , CONSORTIUM_FNA NUMBER(12,2)
        , TOTAL_DIRECT_COST NUMBER(12,2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE BUDGET_MODULAR
    ADD CONSTRAINT BUDGET_MODULARP1
PRIMARY KEY (BUDGET_PERIOD_NUMBER);







-----------------------------------------------------------------------------
-- BUDGET_MODULAR_IDC
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_MODULAR_IDC';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_MODULAR_IDC CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_MODULAR_IDC
(
      BUDGET_PERIOD_NUMBER NUMBER(12)
        , BUDGET_ID NUMBER(12)
        , PROPOSAL_NUMBER VARCHAR2(8)
        , VERSION_NUMBER NUMBER(3)
        , BUDGET_PERIOD NUMBER(3) NOT NULL
        , RATE_NUMBER NUMBER(3)
        , DESCRIPTION VARCHAR2(64)
        , IDC_RATE NUMBER(5,2)
        , IDC_BASE NUMBER(12,2)
        , FUNDS_REQUESTED NUMBER(12,2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE BUDGET_MODULAR_IDC
    ADD CONSTRAINT BUDGET_MODULAR_IDCP1
PRIMARY KEY (BUDGET_PERIOD_NUMBER,RATE_NUMBER);







-----------------------------------------------------------------------------
-- BUDGET_PERIODS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_PERIODS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_PERIODS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_PERIODS
(
      BUDGET_ID NUMBER(12)
        , BUDGET_PERIOD_NUMBER NUMBER(12)
        , PROPOSAL_NUMBER VARCHAR2(12)
        , VERSION_NUMBER NUMBER(3)
        , BUDGET_PERIOD NUMBER(3) NOT NULL
        , START_DATE DATE NOT NULL
        , END_DATE DATE NOT NULL
        , TOTAL_COST NUMBER(12,2)
        , TOTAL_DIRECT_COST NUMBER(12,2)
        , TOTAL_INDIRECT_COST NUMBER(12,2)
        , COST_SHARING_AMOUNT NUMBER(12,2)
        , UNDERRECOVERY_AMOUNT NUMBER(12,2)
        , TOTAL_COST_LIMIT NUMBER(12,2)
        , COMMENTS CLOB
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE BUDGET_PERIODS
    ADD CONSTRAINT BUDGET_PERIODSP1
PRIMARY KEY (BUDGET_PERIOD_NUMBER);


CREATE INDEX PK_BUDGET_PERIODS_KRA 
  ON BUDGET_PERIODS 
  (VERSION_NUMBER, BUDGET_PERIOD, PROPOSAL_NUMBER);





-----------------------------------------------------------------------------
-- BUDGET_PERIOD_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_PERIOD_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_PERIOD_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_PERIOD_TYPE
(
      BUDGET_PERIOD_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE BUDGET_PERIOD_TYPE
    ADD CONSTRAINT BUDGET_PERIOD_TYPEP1
PRIMARY KEY (BUDGET_PERIOD_TYPE_CODE);







-----------------------------------------------------------------------------
-- BUDGET_PERSONNEL_CAL_AMTS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_PERSONNEL_CAL_AMTS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_PERSONNEL_CAL_AMTS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_PERSONNEL_CAL_AMTS
(
      BUDGET_PERIOD_NUMBER NUMBER(12)
        , BUDGET_ID NUMBER(12)
        , PROPOSAL_NUMBER VARCHAR2(12)
        , VERSION_NUMBER NUMBER(3)
        , BUDGET_PERIOD NUMBER(3) NOT NULL
        , LINE_ITEM_NUMBER NUMBER(3) NOT NULL
        , PERSON_NUMBER NUMBER(3) NOT NULL
        , RATE_CLASS_CODE VARCHAR2(3) NOT NULL
        , RATE_TYPE_CODE VARCHAR2(3) NOT NULL
        , APPLY_RATE_FLAG CHAR(1) NOT NULL
        , CALCULATED_COST NUMBER(12,2)
        , CALCULATED_COST_SHARING NUMBER(12,2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1
        , BUDGET_PERSONNEL_CAL_AMTS_ID NUMBER(12)
        , BUDGET_PERSONNEL_DETAILS_ID NUMBER(12)
        , OBJ_ID VARCHAR2(36)
        , RATE_TYPE_DESCRIPTION VARCHAR2(200)
    

);

ALTER TABLE BUDGET_PERSONNEL_CAL_AMTS
    ADD CONSTRAINT BUDGET_PERSONNEL_CAL_AMTSP1
PRIMARY KEY (BUDGET_PERSONNEL_CAL_AMTS_ID);


CREATE INDEX PK_BUDGET_PERS_CAL_AMTS_KRA 
  ON BUDGET_PERSONNEL_CAL_AMTS 
  (PROPOSAL_NUMBER, VERSION_NUMBER, BUDGET_PERIOD, LINE_ITEM_NUMBER, PERSON_NUMBER, RATE_CLASS_CODE, RATE_TYPE_CODE);





-----------------------------------------------------------------------------
-- BUDGET_PERSONNEL_DETAILS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_PERSONNEL_DETAILS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_PERSONNEL_DETAILS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_PERSONNEL_DETAILS
(
      PERSON_SEQUENCE_NUMBER NUMBER(3)
        , BUDGET_PERIOD_NUMBER NUMBER(12)
        , BUDGET_ID NUMBER(12)
        , LINE_ITEM_NUMBER NUMBER(3) NOT NULL
        , PERSON_NUMBER NUMBER(3) NOT NULL
        , PERSON_ID VARCHAR2(40) NOT NULL
        , JOB_CODE VARCHAR2(6) NOT NULL
        , START_DATE DATE NOT NULL
        , END_DATE DATE NOT NULL
        , PERIOD_TYPE VARCHAR2(2)
        , LINE_ITEM_DESCRIPTION VARCHAR2(80)
        , SEQUENCE_NUMBER NUMBER(3)
        , SALARY_REQUESTED NUMBER(12,2)
        , PERCENT_CHARGED NUMBER(5,2)
        , PERCENT_EFFORT NUMBER(5,2)
        , COST_SHARING_PERCENT NUMBER(5,2)
        , COST_SHARING_AMOUNT NUMBER(12,2)
        , UNDERRECOVERY_AMOUNT NUMBER(12,2)
        , ON_OFF_CAMPUS_FLAG CHAR(1) NOT NULL
        , APPLY_IN_RATE_FLAG CHAR(1) NOT NULL
        , BUDGET_JUSTIFICATION CLOB
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , PROPOSAL_NUMBER VARCHAR2(12)
        , VERSION_NUMBER NUMBER(3)
        , BUDGET_PERIOD NUMBER(3) NOT NULL
        , BUDGET_PERSONNEL_DETAILS_ID NUMBER(12)
        , BUDGET_DETAILS_ID NUMBER(12)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE BUDGET_PERSONNEL_DETAILS
    ADD CONSTRAINT BUDGET_PERSONNEL_DETAILSP1
PRIMARY KEY (BUDGET_PERSONNEL_DETAILS_ID);







-----------------------------------------------------------------------------
-- BUDGET_PERSONS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_PERSONS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_PERSONS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_PERSONS
(
      PERSON_SEQUENCE_NUMBER NUMBER(3)
        , ROLODEX_ID NUMBER(6)
        , APPOINTMENT_TYPE_CODE VARCHAR2(3)
        , BUDGET_ID NUMBER(12)
        , TBN_ID VARCHAR2(9)
        , HIERARCHY_PROPOSAL_NUMBER VARCHAR2(12)
        , HIDE_IN_HIERARCHY CHAR(1) default 'N' NOT NULL
        , PROPOSAL_NUMBER VARCHAR2(12)
        , VERSION_NUMBER NUMBER(3)
        , PERSON_ID VARCHAR2(40)
        , JOB_CODE VARCHAR2(6)
        , EFFECTIVE_DATE DATE NOT NULL
        , CALCULATION_BASE NUMBER(12,2)
        , PERSON_NAME VARCHAR2(90)
        , NON_EMPLOYEE_FLAG VARCHAR2(1) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE BUDGET_PERSONS
    ADD CONSTRAINT BUDGET_PERSONSP1
PRIMARY KEY (PERSON_SEQUENCE_NUMBER,BUDGET_ID);







-----------------------------------------------------------------------------
-- BUDGET_PER_DET_RATE_AND_BASE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_PER_DET_RATE_AND_BASE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_PER_DET_RATE_AND_BASE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_PER_DET_RATE_AND_BASE
(
      BUDGET_ID NUMBER(12)
        , PROPOSAL_NUMBER VARCHAR2(12)
        , VERSION_NUMBER NUMBER(3)
        , BUDGET_PERIOD NUMBER(3) NOT NULL
        , LINE_ITEM_NUMBER NUMBER(3) NOT NULL
        , PERSON_NUMBER NUMBER(3) NOT NULL
        , RATE_NUMBER NUMBER(3) NOT NULL
        , PERSON_ID VARCHAR2(40) NOT NULL
        , START_DATE DATE NOT NULL
        , END_DATE DATE NOT NULL
        , RATE_CLASS_CODE VARCHAR2(3) NOT NULL
        , RATE_TYPE_CODE VARCHAR2(3) NOT NULL
        , ON_OFF_CAMPUS_FLAG VARCHAR2(1) NOT NULL
        , APPLIED_RATE NUMBER(5,2) NOT NULL
        , SALARY_REQUESTED NUMBER(12,2)
        , BASE_COST_SHARING NUMBER(14,2)
        , CALCULATED_COST NUMBER(12,2)
        , CALCULATED_COST_SHARING NUMBER(12,2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1
        , UNDERRECOVERY_AMOUNT NUMBER(12,2)
        , BUDGET_PERIOD_NUMBER NUMBER(12)
        , BGT_PER_DET_RATE_AND_BASE_ID NUMBER(12)
        , BUDGET_PERSONNEL_DETAILS_ID NUMBER(12)
        , BUDGET_PERSONNEL_CAL_AMTS_ID NUMBER(12)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE BUDGET_PER_DET_RATE_AND_BASE
    ADD CONSTRAINT BUDGET_PER_DET_RATE_AND_BASP1
PRIMARY KEY (BGT_PER_DET_RATE_AND_BASE_ID);







-----------------------------------------------------------------------------
-- BUDGET_PROJECT_INCOME
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_PROJECT_INCOME';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_PROJECT_INCOME CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_PROJECT_INCOME
(
      BUDGET_ID NUMBER(12)
        , BUDGET_PERIOD_NUMBER NUMBER(12) NOT NULL
        , PROPOSAL_NUMBER VARCHAR2(12)
        , BUDGET_VERSION_NUMBER NUMBER(3)
        , PROJECT_INCOME_ID NUMBER(5)
        , BUDGET_PERIOD NUMBER(3) NOT NULL
        , AMOUNT NUMBER(12,2) NOT NULL
        , DESCRIPTION VARCHAR2(2000) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , HIERARCHY_PROPOSAL_NUMBER VARCHAR2(12)
        , HIDE_IN_HIERARCHY CHAR(1) default 'N' NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE BUDGET_PROJECT_INCOME
    ADD CONSTRAINT BUDGET_PROJECT_INCOMEP1
PRIMARY KEY (BUDGET_ID,PROJECT_INCOME_ID);







-----------------------------------------------------------------------------
-- BUDGET_RATE_AND_BASE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_RATE_AND_BASE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_RATE_AND_BASE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_RATE_AND_BASE
(
      BUDGET_PERIOD_NUMBER NUMBER(12)
        , BUDGET_ID NUMBER(12)
        , PROPOSAL_NUMBER VARCHAR2(12)
        , VERSION_NUMBER NUMBER(22)
        , BUDGET_PERIOD NUMBER(3) NOT NULL
        , LINE_ITEM_NUMBER NUMBER(3) NOT NULL
        , RATE_NUMBER NUMBER(3) NOT NULL
        , START_DATE DATE NOT NULL
        , END_DATE DATE NOT NULL
        , RATE_CLASS_CODE VARCHAR2(3) NOT NULL
        , RATE_TYPE_CODE VARCHAR2(3) NOT NULL
        , ON_OFF_CAMPUS_FLAG CHAR(1) NOT NULL
        , APPLIED_RATE NUMBER(5,2) NOT NULL
        , BASE_COST NUMBER(14,2)
        , BASE_COST_SHARING NUMBER(14,2)
        , CALCULATED_COST NUMBER(14,2)
        , CALCULATED_COST_SHARING NUMBER(14,2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1
        , BUDGET_RATE_AND_BASE_ID NUMBER(12)
        , BUDGET_DETAILS_CAL_AMTS_ID NUMBER(12)
        , BUDGET_DETAILS_ID NUMBER(12)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE BUDGET_RATE_AND_BASE
    ADD CONSTRAINT BUDGET_RATE_AND_BASEP1
PRIMARY KEY (BUDGET_RATE_AND_BASE_ID);


CREATE INDEX PK_BUDGET_RATE_AND_BASE_KRA 
  ON BUDGET_RATE_AND_BASE 
  (PROPOSAL_NUMBER, VERSION_NUMBER, BUDGET_PERIOD, LINE_ITEM_NUMBER, RATE_NUMBER, RATE_CLASS_CODE, RATE_TYPE_CODE);





-----------------------------------------------------------------------------
-- BUDGET_STATUS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_STATUS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_STATUS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_STATUS
(
      BUDGET_STATUS_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE BUDGET_STATUS
    ADD CONSTRAINT BUDGET_STATUSP1
PRIMARY KEY (BUDGET_STATUS_CODE);







-----------------------------------------------------------------------------
-- BUDGET_SUB_AWARDS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_SUB_AWARDS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_SUB_AWARDS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_SUB_AWARDS
(
      PROPOSAL_NUMBER VARCHAR2(12)
        , VERSION_NUMBER NUMBER(3)
        , SUB_AWARD_NUMBER NUMBER(3)
        , ORGANIZATION_NAME VARCHAR2(60) NOT NULL
        , SUB_AWARD_STATUS_CODE NUMBER(3) NOT NULL
        , SUB_AWARD_XFD_FILE_NAME VARCHAR2(256) NOT NULL
        , COMMENTS VARCHAR2(2000)
        , XFD_UPDATE_USER VARCHAR2(60)
        , XFD_UPDATE_TIMESTAMP DATE
        , TRANSLATION_COMMENTS VARCHAR2(2000)
        , XML_UPDATE_USER VARCHAR2(60)
        , XML_UPDATE_TIMESTAMP DATE
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , BUDGET_ID NUMBER(12)
        , HIERARCHY_PROPOSAL_NUMBER VARCHAR2(12)
        , HIDE_IN_HIERARCHY CHAR(1) default 'N' NOT NULL
        , OBJ_ID VARCHAR2(36)
        , SUB_AWARD_XFD_FILE BLOB NOT NULL
        , SUB_AWARD_XML_FILE CLOB NOT NULL
        , NAMESPACE VARCHAR2(200)
        , FORM_NAME VARCHAR2(100)
    

);

ALTER TABLE BUDGET_SUB_AWARDS
    ADD CONSTRAINT BUDGET_SUB_AWARDSP1
PRIMARY KEY (SUB_AWARD_NUMBER,BUDGET_ID);


CREATE INDEX PK_BUDGET_SUB_AWARDS_KRA 
  ON BUDGET_SUB_AWARDS 
  (PROPOSAL_NUMBER, VERSION_NUMBER, SUB_AWARD_NUMBER);





-----------------------------------------------------------------------------
-- BUDGET_SUB_AWARD_ATT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_SUB_AWARD_ATT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_SUB_AWARD_ATT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_SUB_AWARD_ATT
(
      PROPOSAL_NUMBER VARCHAR2(12)
        , VERSION_NUMBER NUMBER(3)
        , SUB_AWARD_NUMBER NUMBER(3) NOT NULL
        , CONTENT_ID VARCHAR2(350) NOT NULL
        , CONTENT_TYPE VARCHAR2(255)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , BUDGET_ID NUMBER(12)
        , SUB_AWARD_ATTACHMENT_ID NUMBER(12)
        , ATTACHMENT BLOB NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE BUDGET_SUB_AWARD_ATT
    ADD CONSTRAINT BUDGET_SUB_AWARD_ATTP1
PRIMARY KEY (SUB_AWARD_ATTACHMENT_ID);







-----------------------------------------------------------------------------
-- BUDGET_SUB_AWARD_FILES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'BUDGET_SUB_AWARD_FILES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE BUDGET_SUB_AWARD_FILES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE BUDGET_SUB_AWARD_FILES
(
      BUDGET_ID NUMBER(12)
        , PROPOSAL_NUMBER VARCHAR2(12)
        , VERSION_NUMBER NUMBER(3)
        , SUB_AWARD_NUMBER NUMBER(3)
        , SUB_AWARD_XFD_FILE_NAME VARCHAR2(256) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
        , SUB_AWARD_XFD_FILE BLOB NOT NULL
        , SUB_AWARD_XML_FILE CLOB NOT NULL
    

);

ALTER TABLE BUDGET_SUB_AWARD_FILES
    ADD CONSTRAINT BUDGET_SUB_AWARD_FILESP1
PRIMARY KEY (BUDGET_ID,SUB_AWARD_NUMBER);







-----------------------------------------------------------------------------
-- CARRIER_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'CARRIER_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE CARRIER_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE CARRIER_TYPE
(
      CARRIER_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE CARRIER_TYPE
    ADD CONSTRAINT CARRIER_TYPEP1
PRIMARY KEY (CARRIER_TYPE_CODE);







-----------------------------------------------------------------------------
-- CLOSEOUT_REPORT_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'CLOSEOUT_REPORT_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE CLOSEOUT_REPORT_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE CLOSEOUT_REPORT_TYPE
(
      CLOSEOUT_REPORT_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE CLOSEOUT_REPORT_TYPE
    ADD CONSTRAINT CLOSEOUT_REPORT_TYPEP1
PRIMARY KEY (CLOSEOUT_REPORT_CODE);







-----------------------------------------------------------------------------
-- COEUS_MODULE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COEUS_MODULE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COEUS_MODULE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COEUS_MODULE
(
      MODULE_CODE NUMBER(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE COEUS_MODULE
    ADD CONSTRAINT COEUS_MODULEP1
PRIMARY KEY (MODULE_CODE);







-----------------------------------------------------------------------------
-- COEUS_SUB_MODULE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COEUS_SUB_MODULE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COEUS_SUB_MODULE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COEUS_SUB_MODULE
(
      COEUS_SUB_MODULE_ID NUMBER(12)
        , MODULE_CODE NUMBER(3) NOT NULL
        , SUB_MODULE_CODE NUMBER(3) NOT NULL
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE COEUS_SUB_MODULE
    ADD CONSTRAINT COEUS_SUB_MODULEP1
PRIMARY KEY (COEUS_SUB_MODULE_ID);


CREATE INDEX UQ_COEUS_SUB_MODULE 
  ON COEUS_SUB_MODULE 
  (MODULE_CODE, SUB_MODULE_CODE);





-----------------------------------------------------------------------------
-- COMMENT_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COMMENT_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COMMENT_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COMMENT_TYPE
(
      COMMENT_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200)
        , TEMPLATE_FLAG VARCHAR2(1)
        , CHECKLIST_FLAG VARCHAR2(1)
        , AWARD_COMMENT_SCREEN_FLAG VARCHAR2(1)
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE COMMENT_TYPE
    ADD CONSTRAINT COMMENT_TYPEP1
PRIMARY KEY (COMMENT_TYPE_CODE);







-----------------------------------------------------------------------------
-- COMMITTEE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COMMITTEE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COMMITTEE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COMMITTEE
(
      ID NUMBER(12)
        , DOCUMENT_NUMBER NUMBER(10) NOT NULL
        , COMMITTEE_ID VARCHAR2(15) NOT NULL
        , COMMITTEE_NAME VARCHAR2(60) NOT NULL
        , HOME_UNIT_NUMBER VARCHAR2(8) NOT NULL
        , DESCRIPTION VARCHAR2(2000)
        , SCHEDULE_DESCRIPTION VARCHAR2(2000)
        , COMMITTEE_TYPE_CODE VARCHAR2(3) NOT NULL
        , MINIMUM_MEMBERS_REQUIRED NUMBER(3)
        , MAX_PROTOCOLS NUMBER(4)
        , ADV_SUBMISSION_DAYS_REQ NUMBER(3)
        , DEFAULT_REVIEW_TYPE_CODE VARCHAR2(3)
        , APPLICABLE_REVIEW_TYPE_CODE VARCHAR2(3) NOT NULL
        , CREATE_TIMESTAMP DATE
        , CREATE_USER VARCHAR2(8)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE COMMITTEE
    ADD CONSTRAINT COMMITTEEP1
PRIMARY KEY (ID);


CREATE INDEX UQ_COMMITTEE_ID 
  ON COMMITTEE 
  (SEQUENCE_NUMBER, COMMITTEE_ID);





-----------------------------------------------------------------------------
-- COMMITTEE_DOCUMENT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COMMITTEE_DOCUMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COMMITTEE_DOCUMENT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COMMITTEE_DOCUMENT
(
      DOCUMENT_NUMBER NUMBER(10)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
        , COMMITTEE_ID VARCHAR2(15)
        , DOC_STATUS_CODE VARCHAR2(1)
    

);

ALTER TABLE COMMITTEE_DOCUMENT
    ADD CONSTRAINT COMMITTEE_DOCUMENTP1
PRIMARY KEY (DOCUMENT_NUMBER);







-----------------------------------------------------------------------------
-- COMMITTEE_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COMMITTEE_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COMMITTEE_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COMMITTEE_TYPE
(
      COMMITTEE_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE COMMITTEE_TYPE
    ADD CONSTRAINT COMMITTEE_TYPEP1
PRIMARY KEY (COMMITTEE_TYPE_CODE);







-----------------------------------------------------------------------------
-- COMM_BATCH_CORRESP
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COMM_BATCH_CORRESP';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COMM_BATCH_CORRESP CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COMM_BATCH_CORRESP
(
      COMM_BATCH_CORRESP_ID VARCHAR2(10)
        , COMMITTEE_ID VARCHAR2(15) NOT NULL
        , BATCH_CORRESPONDENCE_TYPE_CODE VARCHAR2(3) NOT NULL
        , BATCH_RUN_DATE DATE NOT NULL
        , TIME_WINDOW_START DATE
        , TIME_WINDOW_END DATE
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE COMM_BATCH_CORRESP
    ADD CONSTRAINT COMM_BATCH_CORRESPP1
PRIMARY KEY (COMM_BATCH_CORRESP_ID);







-----------------------------------------------------------------------------
-- COMM_BATCH_CORRESP_DETAIL
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COMM_BATCH_CORRESP_DETAIL';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COMM_BATCH_CORRESP_DETAIL CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COMM_BATCH_CORRESP_DETAIL
(
      COMM_BATCH_CORRESP_DETAIL_ID NUMBER(12)
        , COMM_BATCH_CORRESP_ID VARCHAR2(10) NOT NULL
        , PROTOCOL_ACTION_ID NUMBER(12) NOT NULL
        , PROTOCOL_CORRESPONDENCE_ID NUMBER(12) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    
    , CONSTRAINT UQ_COMM_BATCH_CORRESP_DETAIL UNIQUE (COMM_BATCH_CORRESP_ID, PROTOCOL_ACTION_ID)

);

ALTER TABLE COMM_BATCH_CORRESP_DETAIL
    ADD CONSTRAINT COMM_BATCH_CORRESP_DETAILP1
PRIMARY KEY (COMM_BATCH_CORRESP_DETAIL_ID);







-----------------------------------------------------------------------------
-- COMM_DECISION_MOTION_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COMM_DECISION_MOTION_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COMM_DECISION_MOTION_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COMM_DECISION_MOTION_TYPE
(
      COMM_DECISION_MOTION_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE COMM_DECISION_MOTION_TYPE
    ADD CONSTRAINT COMM_DECISION_MOTION_TYPEP1
PRIMARY KEY (COMM_DECISION_MOTION_TYPE_CODE);







-----------------------------------------------------------------------------
-- COMM_MEMBERSHIPS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COMM_MEMBERSHIPS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COMM_MEMBERSHIPS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COMM_MEMBERSHIPS
(
      COMM_MEMBERSHIP_ID NUMBER(12)
        , COMMITTEE_ID_FK NUMBER(12) NOT NULL
        , PERSON_ID VARCHAR2(40)
        , ROLODEX_ID NUMBER(12)
        , PERSON_NAME VARCHAR2(90) NOT NULL
        , MEMBERSHIP_ID VARCHAR2(10) NOT NULL
        , PAID_MEMBER_FLAG VARCHAR2(1) NOT NULL
        , TERM_START_DATE DATE NOT NULL
        , TERM_END_DATE DATE
        , MEMBERSHIP_TYPE_CODE VARCHAR2(3) NOT NULL
        , COMMENTS CLOB
        , CONTACT_NOTES CLOB
        , TRAINING_NOTES CLOB
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE COMM_MEMBERSHIPS
    ADD CONSTRAINT COMM_MEMBERSHIPSP1
PRIMARY KEY (COMM_MEMBERSHIP_ID);







-----------------------------------------------------------------------------
-- COMM_MEMBERSHIP_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COMM_MEMBERSHIP_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COMM_MEMBERSHIP_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COMM_MEMBERSHIP_TYPE
(
      MEMBERSHIP_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE COMM_MEMBERSHIP_TYPE
    ADD CONSTRAINT COMM_MEMBERSHIP_TYPEP1
PRIMARY KEY (MEMBERSHIP_TYPE_CODE);







-----------------------------------------------------------------------------
-- COMM_MEMBER_EXPERTISE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COMM_MEMBER_EXPERTISE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COMM_MEMBER_EXPERTISE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COMM_MEMBER_EXPERTISE
(
      COMM_MEMBER_EXPERTISE_ID NUMBER(12)
        , COMM_MEMBERSHIP_ID_FK NUMBER(12) NOT NULL
        , RESEARCH_AREA_CODE VARCHAR2(8) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE COMM_MEMBER_EXPERTISE
    ADD CONSTRAINT COMM_MEMBER_EXPERTISEP1
PRIMARY KEY (COMM_MEMBER_EXPERTISE_ID);







-----------------------------------------------------------------------------
-- COMM_MEMBER_ROLES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COMM_MEMBER_ROLES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COMM_MEMBER_ROLES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COMM_MEMBER_ROLES
(
      UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , COMM_MEMBER_ROLES_ID NUMBER(12)
        , COMM_MEMBERSHIP_ID_FK NUMBER(12) NOT NULL
        , MEMBERSHIP_ROLE_CODE VARCHAR2(3) NOT NULL
        , START_DATE DATE NOT NULL
        , END_DATE DATE NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE COMM_MEMBER_ROLES
    ADD CONSTRAINT COMM_MEMBER_ROLESP1
PRIMARY KEY (COMM_MEMBER_ROLES_ID);







-----------------------------------------------------------------------------
-- COMM_RESEARCH_AREAS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COMM_RESEARCH_AREAS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COMM_RESEARCH_AREAS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COMM_RESEARCH_AREAS
(
      ID NUMBER(12)
        , COMMITTEE_ID_FK NUMBER(12) NOT NULL
        , RESEARCH_AREA_CODE VARCHAR2(8) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE COMM_RESEARCH_AREAS
    ADD CONSTRAINT COMM_RESEARCH_AREASP1
PRIMARY KEY (ID);







-----------------------------------------------------------------------------
-- COMM_SCHEDULE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COMM_SCHEDULE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COMM_SCHEDULE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COMM_SCHEDULE
(
      ID NUMBER(12)
        , SCHEDULE_ID VARCHAR2(10) NOT NULL
        , COMMITTEE_ID_FK NUMBER(12) NOT NULL
        , SCHEDULED_DATE DATE NOT NULL
        , PLACE VARCHAR2(200)
        , TIME DATE
        , PROTOCOL_SUB_DEADLINE DATE NOT NULL
        , SCHEDULE_STATUS_CODE NUMBER(3) NOT NULL
        , MEETING_DATE DATE
        , START_TIME DATE
        , END_TIME DATE
        , AGENDA_PROD_REV_DATE DATE
        , MAX_PROTOCOLS NUMBER(4)
        , COMMENTS VARCHAR2(2000)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE COMM_SCHEDULE
    ADD CONSTRAINT COMM_SCHEDULEP1
PRIMARY KEY (ID);







-----------------------------------------------------------------------------
-- COMM_SCHEDULE_ACT_ITEMS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COMM_SCHEDULE_ACT_ITEMS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COMM_SCHEDULE_ACT_ITEMS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COMM_SCHEDULE_ACT_ITEMS
(
      COMM_SCHEDULE_ACT_ITEMS_ID NUMBER(12)
        , SCHEDULE_ID_FK NUMBER(12) NOT NULL
        , ACTION_ITEM_NUMBER NUMBER(4) NOT NULL
        , SCHEDULE_ACT_ITEM_TYPE_CODE VARCHAR2(3) NOT NULL
        , ITEM_DESCRIPTION VARCHAR2(2000) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE COMM_SCHEDULE_ACT_ITEMS
    ADD CONSTRAINT COMM_SCHEDULE_ACT_ITEMSP1
PRIMARY KEY (COMM_SCHEDULE_ACT_ITEMS_ID);


CREATE INDEX UQ_COMM_SCHEDULE_ACT_ITEMS 
  ON COMM_SCHEDULE_ACT_ITEMS 
  (SCHEDULE_ID_FK, ACTION_ITEM_NUMBER);





-----------------------------------------------------------------------------
-- COMM_SCHEDULE_ATTENDANCE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COMM_SCHEDULE_ATTENDANCE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COMM_SCHEDULE_ATTENDANCE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COMM_SCHEDULE_ATTENDANCE
(
      PERSON_NAME VARCHAR2(90) NOT NULL
        , COMM_SCHEDULE_ATTENDANCE_ID NUMBER(12)
        , SCHEDULE_ID_FK NUMBER(12) NOT NULL
        , PERSON_ID VARCHAR2(40) NOT NULL
        , GUEST_FLAG VARCHAR2(1) NOT NULL
        , ALTERNATE_FLAG VARCHAR2(1) NOT NULL
        , ALTERNATE_FOR VARCHAR2(40)
        , NON_EMPLOYEE_FLAG VARCHAR2(1) NOT NULL
        , COMMENTS VARCHAR2(2000)
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE COMM_SCHEDULE_ATTENDANCE
    ADD CONSTRAINT COMM_SCHEDULE_ATTENDANCEP1
PRIMARY KEY (COMM_SCHEDULE_ATTENDANCE_ID);


CREATE INDEX UQ_COMM_SCHEDULE_ATTENDANCE 
  ON COMM_SCHEDULE_ATTENDANCE 
  (SCHEDULE_ID_FK, PERSON_ID);





-----------------------------------------------------------------------------
-- COMM_SCHEDULE_FREQUENCY
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COMM_SCHEDULE_FREQUENCY';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COMM_SCHEDULE_FREQUENCY CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COMM_SCHEDULE_FREQUENCY
(
      FREQUENCY_CODE NUMBER(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , NO_OF_DAYS NUMBER(3)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE COMM_SCHEDULE_FREQUENCY
    ADD CONSTRAINT COMM_SCHEDULE_FREQUENCYP1
PRIMARY KEY (FREQUENCY_CODE);







-----------------------------------------------------------------------------
-- COMM_SCHEDULE_MINUTES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COMM_SCHEDULE_MINUTES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COMM_SCHEDULE_MINUTES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COMM_SCHEDULE_MINUTES
(
      FINAL_FLAG VARCHAR2(1)
        , REVIEWER_ID_FK NUMBER(12)
        , COMM_SCHEDULE_MINUTES_ID NUMBER(12)
        , SCHEDULE_ID_FK NUMBER(12) NOT NULL
        , PROTOCOL_ID_FK NUMBER(12)
        , ENTRY_NUMBER NUMBER(12) NOT NULL
        , MINUTE_ENTRY_TYPE_CODE VARCHAR2(3) NOT NULL
        , SUBMISSION_ID_FK NUMBER(12)
        , PRIVATE_COMMENT_FLAG VARCHAR2(1)
        , PROTOCOL_CONTINGENCY_CODE VARCHAR2(4)
        , MINUTE_ENTRY CLOB
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
        , PROTOCOL_ONLN_RVW_FK NUMBER(12)
        , COMM_SCHEDULE_ACT_ITEMS_ID_FK NUMBER(12)
        , CREATE_USER VARCHAR2(60)
        , CREATE_TIMESTAMP DATE
    

);

ALTER TABLE COMM_SCHEDULE_MINUTES
    ADD CONSTRAINT COMM_SCHEDULE_MINUTESP1
PRIMARY KEY (COMM_SCHEDULE_MINUTES_ID);


CREATE INDEX UQ_COMM_SCHEDULE_MINUTES 
  ON COMM_SCHEDULE_MINUTES 
  (SCHEDULE_ID_FK, ENTRY_NUMBER);





-----------------------------------------------------------------------------
-- COMM_SCHEDULE_MINUTE_DOC
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COMM_SCHEDULE_MINUTE_DOC';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COMM_SCHEDULE_MINUTE_DOC CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COMM_SCHEDULE_MINUTE_DOC
(
      COMM_SCHEDULE_MINUTE_DOC_ID NUMBER(12)
        , SCHEDULE_ID_FK NUMBER(12) NOT NULL
        , MINUTE_NUMBER NUMBER(4) NOT NULL
        , MINUTE_NAME VARCHAR2(200) NOT NULL
        , CREATE_TIMESTAMP DATE NOT NULL
        , CREATE_USER VARCHAR2(60) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
        , PDF_STORE BLOB NOT NULL
    

);

ALTER TABLE COMM_SCHEDULE_MINUTE_DOC
    ADD CONSTRAINT COMM_SCHEDULE_MINUTE_DOCP1
PRIMARY KEY (COMM_SCHEDULE_MINUTE_DOC_ID);


CREATE INDEX UQ_COMM_SCHEDULE_MINUTE_DOC 
  ON COMM_SCHEDULE_MINUTE_DOC 
  (SCHEDULE_ID_FK, MINUTE_NUMBER);





-----------------------------------------------------------------------------
-- CONTACT_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'CONTACT_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE CONTACT_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE CONTACT_TYPE
(
      VER_NBR NUMBER(8) default 1 NOT NULL
        , CONTACT_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE CONTACT_TYPE
    ADD CONSTRAINT CONTACT_TYPEP1
PRIMARY KEY (CONTACT_TYPE_CODE);







-----------------------------------------------------------------------------
-- CORRESPONDENT_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'CORRESPONDENT_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE CORRESPONDENT_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE CORRESPONDENT_TYPE
(
      CORRESPONDENT_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , QUALIFIER VARCHAR2(1) default 'p' NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE CORRESPONDENT_TYPE
    ADD CONSTRAINT CORRESPONDENT_TYPEP1
PRIMARY KEY (CORRESPONDENT_TYPE_CODE);







-----------------------------------------------------------------------------
-- COST_ELEMENT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COST_ELEMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COST_ELEMENT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COST_ELEMENT
(
      COST_ELEMENT VARCHAR2(8)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , BUDGET_CATEGORY_CODE VARCHAR2(3)
        , ON_OFF_CAMPUS_FLAG CHAR(1) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE COST_ELEMENT
    ADD CONSTRAINT COST_ELEMENTP1
PRIMARY KEY (COST_ELEMENT);







-----------------------------------------------------------------------------
-- COST_SHARE_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'COST_SHARE_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE COST_SHARE_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE COST_SHARE_TYPE
(
      COST_SHARE_TYPE_CODE NUMBER(3)
        , DESCRIPTION VARCHAR2(200)
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8)
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE COST_SHARE_TYPE
    ADD CONSTRAINT COST_SHARE_TYPEP1
PRIMARY KEY (COST_SHARE_TYPE_CODE);







-----------------------------------------------------------------------------
-- CUSTOM_ATTRIBUTE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'CUSTOM_ATTRIBUTE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE CUSTOM_ATTRIBUTE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE CUSTOM_ATTRIBUTE
(
      ID NUMBER(12)
        , NAME VARCHAR2(30) NOT NULL
        , LABEL VARCHAR2(30) NOT NULL
        , DATA_TYPE_CODE VARCHAR2(3) NOT NULL
        , DATA_LENGTH NUMBER(4)
        , DEFAULT_VALUE VARCHAR2(2000)
        , LOOKUP_CLASS VARCHAR2(100)
        , LOOKUP_RETURN VARCHAR2(30)
        , GROUP_NAME VARCHAR2(250)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE CUSTOM_ATTRIBUTE
    ADD CONSTRAINT CUSTOM_ATTRIBUTEP1
PRIMARY KEY (ID);







-----------------------------------------------------------------------------
-- CUSTOM_ATTRIBUTE_DATA_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'CUSTOM_ATTRIBUTE_DATA_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE CUSTOM_ATTRIBUTE_DATA_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE CUSTOM_ATTRIBUTE_DATA_TYPE
(
      DATA_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE CUSTOM_ATTRIBUTE_DATA_TYPE
    ADD CONSTRAINT CUSTOM_ATTRIBUTE_DATA_TYPEP1
PRIMARY KEY (DATA_TYPE_CODE);







-----------------------------------------------------------------------------
-- CUSTOM_ATTRIBUTE_DOCUMENT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'CUSTOM_ATTRIBUTE_DOCUMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE CUSTOM_ATTRIBUTE_DOCUMENT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE CUSTOM_ATTRIBUTE_DOCUMENT
(
      DOCUMENT_TYPE_CODE VARCHAR2(4)
        , CUSTOM_ATTRIBUTE_ID NUMBER(12)
        , TYPE_NAME VARCHAR2(100)
        , IS_REQUIRED CHAR(1)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , ACTIVE_FLAG CHAR(1)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE CUSTOM_ATTRIBUTE_DOCUMENT
    ADD CONSTRAINT CUSTOM_ATTRIBUTE_DOCUMENTP1
PRIMARY KEY (DOCUMENT_TYPE_CODE,CUSTOM_ATTRIBUTE_ID);







-----------------------------------------------------------------------------
-- CUSTOM_ATTRIBUTE_DOC_VALUE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'CUSTOM_ATTRIBUTE_DOC_VALUE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE CUSTOM_ATTRIBUTE_DOC_VALUE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE CUSTOM_ATTRIBUTE_DOC_VALUE
(
      DOCUMENT_NUMBER NUMBER(10)
        , CUSTOM_ATTRIBUTE_ID NUMBER(12)
        , VALUE VARCHAR2(2000)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE CUSTOM_ATTRIBUTE_DOC_VALUE
    ADD CONSTRAINT CUSTOM_ATTRIBUTE_DOC_VALUEP1
PRIMARY KEY (DOCUMENT_NUMBER,CUSTOM_ATTRIBUTE_ID);







-----------------------------------------------------------------------------
-- DEADLINE_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'DEADLINE_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE DEADLINE_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE DEADLINE_TYPE
(
      DEADLINE_TYPE_CODE CHAR(1)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE DEADLINE_TYPE
    ADD CONSTRAINT DEADLINE_TYPEP1
PRIMARY KEY (DEADLINE_TYPE_CODE);







-----------------------------------------------------------------------------
-- DEGREE_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'DEGREE_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE DEGREE_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE DEGREE_TYPE
(
      DEGREE_CODE VARCHAR2(6)
        , DESCRIPTION VARCHAR2(200)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE DEGREE_TYPE
    ADD CONSTRAINT DEGREE_TYPEP1
PRIMARY KEY (DEGREE_CODE);







-----------------------------------------------------------------------------
-- DISTRIBUTION
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'DISTRIBUTION';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE DISTRIBUTION CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE DISTRIBUTION
(
      VER_NBR NUMBER(8) default 1 NOT NULL
        , OSP_DISTRIBUTION_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE DISTRIBUTION
    ADD CONSTRAINT DISTRIBUTIONP1
PRIMARY KEY (OSP_DISTRIBUTION_CODE);







-----------------------------------------------------------------------------
-- DOCUMENT_NEXTVALUE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'DOCUMENT_NEXTVALUE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE DOCUMENT_NEXTVALUE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE DOCUMENT_NEXTVALUE
(
      DOCUMENT_NUMBER NUMBER(12)
        , PROPERTY_NAME VARCHAR2(200)
        , NEXT_VALUE NUMBER(12) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE DOCUMENT_NEXTVALUE
    ADD CONSTRAINT DOCUMENT_NEXTVALUEP1
PRIMARY KEY (DOCUMENT_NUMBER,PROPERTY_NAME);







-----------------------------------------------------------------------------
-- EPS_PROPOSAL
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROPOSAL';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROPOSAL CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROPOSAL
(
      SUBMIT_FLAG CHAR(1) default 'N' NOT NULL
        , IS_HIERARCHY CHAR(1) default 'N' NOT NULL
        , HIERARCHY_PROPOSAL_NUMBER VARCHAR2(12)
        , HIERARCHY_HASH_CODE NUMBER(10)
        , HIERARCHY_BUDGET_TYPE CHAR(1)
        , PROGRAM_ANNOUNCEMENT_NUMBER VARCHAR2(50)
        , PROGRAM_ANNOUNCEMENT_TITLE VARCHAR2(255)
        , ACTIVITY_TYPE_CODE VARCHAR2(3)
        , REQUESTED_START_DATE_INITIAL DATE
        , REQUESTED_START_DATE_TOTAL DATE
        , REQUESTED_END_DATE_INITIAL DATE
        , REQUESTED_END_DATE_TOTAL DATE
        , DURATION_MONTHS NUMBER(3)
        , NUMBER_OF_COPIES VARCHAR2(7)
        , DEADLINE_DATE DATE
        , DEADLINE_TYPE CHAR(1)
        , MAILING_ADDRESS_ID NUMBER(6)
        , MAIL_BY CHAR(1)
        , MAIL_TYPE VARCHAR2(3)
        , CARRIER_CODE_TYPE VARCHAR2(3)
        , CARRIER_CODE VARCHAR2(20)
        , MAIL_DESCRIPTION VARCHAR2(80)
        , MAIL_ACCOUNT_NUMBER VARCHAR2(9)
        , SUBCONTRACT_FLAG CHAR(1)
        , NARRATIVE_STATUS CHAR(1)
        , BUDGET_STATUS CHAR(1)
        , OWNED_BY_UNIT VARCHAR2(8)
        , CREATE_TIMESTAMP DATE
        , CREATE_USER VARCHAR2(60)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , NSF_CODE VARCHAR2(15)
        , PRIME_SPONSOR_CODE CHAR(6)
        , CFDA_NUMBER VARCHAR2(7)
        , AGENCY_PROGRAM_CODE VARCHAR2(50)
        , AGENCY_DIVISION_CODE VARCHAR2(50)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , DOCUMENT_NUMBER NUMBER(10) NOT NULL
        , PROPOSAL_NUMBER VARCHAR2(12)
        , PROPOSAL_TYPE_CODE VARCHAR2(3)
        , STATUS_CODE NUMBER(3)
        , CREATION_STATUS_CODE NUMBER(3)
        , BASE_PROPOSAL_NUMBER VARCHAR2(8)
        , CONTINUED_FROM VARCHAR2(8)
        , TEMPLATE_FLAG CHAR(1)
        , ORGANIZATION_ID VARCHAR2(8)
        , PERFORMING_ORGANIZATION_ID VARCHAR2(8)
        , CURRENT_ACCOUNT_NUMBER CHAR(7)
        , CURRENT_AWARD_NUMBER VARCHAR2(12)
        , TITLE VARCHAR2(150)
        , SPONSOR_CODE CHAR(6)
        , SPONSOR_PROPOSAL_NUMBER VARCHAR2(70)
        , INTR_COOP_ACTIVITIES_FLAG CHAR(1)
        , INTR_COUNTRY_LIST VARCHAR2(150)
        , OTHER_AGENCY_FLAG CHAR(1)
        , NOTICE_OF_OPPORTUNITY_CODE NUMBER(3)
        , HIERARCHY_ORIG_CHILD_PROP_NBR VARCHAR2(12)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROPOSAL
    ADD CONSTRAINT EPS_PROPOSALP1
PRIMARY KEY (PROPOSAL_NUMBER);







-----------------------------------------------------------------------------
-- EPS_PROPOSAL_BUDGET_EXT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROPOSAL_BUDGET_EXT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROPOSAL_BUDGET_EXT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROPOSAL_BUDGET_EXT
(
      BUDGET_ID NUMBER(12)
        , FINAL_VERSION_FLAG VARCHAR2(1)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , DOCUMENT_NUMBER NUMBER(10)
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE EPS_PROPOSAL_BUDGET_EXT
    ADD CONSTRAINT EPS_PROPOSAL_BUDGET_EXTP1
PRIMARY KEY (BUDGET_ID);







-----------------------------------------------------------------------------
-- EPS_PROPOSAL_BUDGET_STATUS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROPOSAL_BUDGET_STATUS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROPOSAL_BUDGET_STATUS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROPOSAL_BUDGET_STATUS
(
      PROPOSAL_NUMBER VARCHAR2(12)
        , BUDGET_STATUS_CODE CHAR(1)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROPOSAL_BUDGET_STATUS
    ADD CONSTRAINT EPS_PROPOSAL_BUDGET_STATUSP1
PRIMARY KEY (PROPOSAL_NUMBER);







-----------------------------------------------------------------------------
-- EPS_PROPOSAL_DOCUMENT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROPOSAL_DOCUMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROPOSAL_DOCUMENT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROPOSAL_DOCUMENT
(
      DOCUMENT_NUMBER NUMBER(10)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROPOSAL_DOCUMENT
    ADD CONSTRAINT EPS_PROPOSAL_DOCUMENTP1
PRIMARY KEY (DOCUMENT_NUMBER);







-----------------------------------------------------------------------------
-- EPS_PROPOSAL_STATUS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROPOSAL_STATUS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROPOSAL_STATUS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROPOSAL_STATUS
(
      STATUS_CODE NUMBER(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
    

);

ALTER TABLE EPS_PROPOSAL_STATUS
    ADD CONSTRAINT EPS_PROPOSAL_STATUSP1
PRIMARY KEY (STATUS_CODE);







-----------------------------------------------------------------------------
-- EPS_PROP_ABSTRACT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_ABSTRACT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_ABSTRACT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_ABSTRACT
(
      TIMESTAMP_DISPLAY DATE
        , USER_DISPLAY VARCHAR2(60)
        , PROPOSAL_NUMBER VARCHAR2(12)
        , ABSTRACT_TYPE_CODE VARCHAR2(3)
        , ABSTRACT_DETAILS CLOB NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_ABSTRACT
    ADD CONSTRAINT EPS_PROP_ABSTRACTP1
PRIMARY KEY (PROPOSAL_NUMBER,ABSTRACT_TYPE_CODE);







-----------------------------------------------------------------------------
-- EPS_PROP_CHANGED_DATA
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_CHANGED_DATA';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_CHANGED_DATA CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_CHANGED_DATA
(
      PROPOSAL_NUMBER VARCHAR2(8)
        , COLUMN_NAME VARCHAR2(30)
        , CHANGE_NUMBER NUMBER(3)
        , CHANGED_VALUE VARCHAR2(200)
        , DISPLAY_VALUE VARCHAR2(200)
        , OLD_DISPLAY_VALUE VARCHAR2(200)
        , COMMENTS VARCHAR2(300)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_CHANGED_DATA
    ADD CONSTRAINT EPS_PROP_CHANGED_DATAP1
PRIMARY KEY (PROPOSAL_NUMBER,COLUMN_NAME,CHANGE_NUMBER);







-----------------------------------------------------------------------------
-- EPS_PROP_COLUMNS_TO_ALTER
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_COLUMNS_TO_ALTER';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_COLUMNS_TO_ALTER CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_COLUMNS_TO_ALTER
(
      LOOKUP_RETURN VARCHAR2(50)
        , COLUMN_NAME VARCHAR2(30)
        , COLUMN_LABEL VARCHAR2(30) NOT NULL
        , DATA_TYPE VARCHAR2(9) NOT NULL
        , DATA_LENGTH NUMBER(4)
        , HAS_LOOKUP CHAR(1) NOT NULL
        , LOOKUP_ARGUMENT VARCHAR2(100)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_COLUMNS_TO_ALTER
    ADD CONSTRAINT EPS_PROP_COLUMNS_TO_ALTERP1
PRIMARY KEY (COLUMN_NAME);







-----------------------------------------------------------------------------
-- EPS_PROP_CONG_DISTRICT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_CONG_DISTRICT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_CONG_DISTRICT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_CONG_DISTRICT
(
      PROPOSAL_NUMBER VARCHAR2(8) NOT NULL
        , SITE_NUMBER NUMBER(3) NOT NULL
        , CONG_DISTRICT VARCHAR2(50) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , CONG_DISTRICT_ID NUMBER(22)
    

);

ALTER TABLE EPS_PROP_CONG_DISTRICT
    ADD CONSTRAINT EPS_PROP_CONG_DISTRICTP1
PRIMARY KEY (CONG_DISTRICT_ID);







-----------------------------------------------------------------------------
-- EPS_PROP_COST_SHARING
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_COST_SHARING';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_COST_SHARING CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_COST_SHARING
(
      BUDGET_ID NUMBER(12)
        , PROPOSAL_NUMBER VARCHAR2(12)
        , BUDGET_VERSION_NUMBER NUMBER(3)
        , COST_SHARE_ID NUMBER(5)
        , FISCAL_YEAR NUMBER(4)
        , AMOUNT NUMBER(12,2)
        , COST_SHARING_PERCENTAGE NUMBER(5,2)
        , SOURCE_ACCOUNT VARCHAR2(32)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , HIERARCHY_PROPOSAL_NUMBER VARCHAR2(12)
        , HIDE_IN_HIERARCHY CHAR(1) default 'N' NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_COST_SHARING
    ADD CONSTRAINT EPS_PROP_COST_SHARINGP1
PRIMARY KEY (BUDGET_ID,COST_SHARE_ID);







-----------------------------------------------------------------------------
-- EPS_PROP_EXEMPT_NUMBER
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_EXEMPT_NUMBER';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_EXEMPT_NUMBER CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_EXEMPT_NUMBER
(
      PROPOSAL_NUMBER VARCHAR2(12)
        , SPECIAL_REVIEW_NUMBER NUMBER(3)
        , EXEMPTION_TYPE_CODE VARCHAR2(3)
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_EXEMPT_NUMBER
    ADD CONSTRAINT EPS_PROP_EXEMPT_NUMBERP1
PRIMARY KEY (PROPOSAL_NUMBER,SPECIAL_REVIEW_NUMBER,EXEMPTION_TYPE_CODE);







-----------------------------------------------------------------------------
-- EPS_PROP_IDC_RATE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_IDC_RATE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_IDC_RATE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_IDC_RATE
(
      BUDGET_ID NUMBER(12)
        , BUDGET_VERSION_NUMBER NUMBER(3)
        , UNRECOVERED_FNA_ID NUMBER(5)
        , FISCAL_YEAR NUMBER(4)
        , UNDERRECOVERY_OF_IDC NUMBER(12,2)
        , APPLICABLE_IDC_RATE NUMBER(6,3)
        , ON_CAMPUS_FLAG CHAR(1)
        , SOURCE_ACCOUNT VARCHAR2(32)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , PROPOSAL_NUMBER VARCHAR2(12)
        , HIERARCHY_PROPOSAL_NUMBER VARCHAR2(12)
        , HIDE_IN_HIERARCHY CHAR(1) default 'N' NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_IDC_RATE
    ADD CONSTRAINT EPS_PROP_IDC_RATEP1
PRIMARY KEY (BUDGET_ID,UNRECOVERED_FNA_ID);







-----------------------------------------------------------------------------
-- EPS_PROP_LA_RATES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_LA_RATES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_LA_RATES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_LA_RATES
(
      BUDGET_ID NUMBER(12)
        , PROPOSAL_NUMBER VARCHAR2(8)
        , VERSION_NUMBER NUMBER(3)
        , RATE_TYPE_CODE VARCHAR2(3)
        , FISCAL_YEAR CHAR(4)
        , ON_OFF_CAMPUS_FLAG CHAR(1)
        , START_DATE DATE
        , APPLICABLE_RATE NUMBER(5,2) NOT NULL
        , INSTITUTE_RATE NUMBER(5,2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , RATE_CLASS_CODE VARCHAR2(3)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_LA_RATES
    ADD CONSTRAINT EPS_PROP_LA_RATESP1
PRIMARY KEY (BUDGET_ID,RATE_TYPE_CODE,FISCAL_YEAR,ON_OFF_CAMPUS_FLAG,START_DATE,RATE_CLASS_CODE);


CREATE INDEX PK_EPS_PROP_LA_RATES_KRA 
  ON EPS_PROP_LA_RATES 
  (RATE_TYPE_CODE, FISCAL_YEAR, START_DATE, ON_OFF_CAMPUS_FLAG, PROPOSAL_NUMBER, VERSION_NUMBER, RATE_CLASS_CODE);





-----------------------------------------------------------------------------
-- EPS_PROP_LOCATION
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_LOCATION';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_LOCATION CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_LOCATION
(
      PROPOSAL_NUMBER VARCHAR2(12)
        , LOCATION_SEQUENCE_NUMBER NUMBER(3)
        , LOCATION VARCHAR2(60) NOT NULL
        , ROLODEX_ID NUMBER(6)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_LOCATION
    ADD CONSTRAINT EPS_PROP_LOCATIONP1
PRIMARY KEY (PROPOSAL_NUMBER,LOCATION_SEQUENCE_NUMBER);







-----------------------------------------------------------------------------
-- EPS_PROP_PERSON
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_PERSON';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_PERSON CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_PERSON
(
      HIERARCHY_PROPOSAL_NUMBER VARCHAR2(12)
        , HIDE_IN_HIERARCHY CHAR(1) default 'N' NOT NULL
        , PROPOSAL_NUMBER VARCHAR2(12)
        , PROP_PERSON_NUMBER NUMBER(12)
        , PROP_PERSON_ROLE_ID VARCHAR2(12)
        , PERSON_ID VARCHAR2(40)
        , ROLODEX_ID NUMBER(6)
        , SSN VARCHAR2(9)
        , LAST_NAME VARCHAR2(30)
        , FIRST_NAME VARCHAR2(30)
        , MIDDLE_NAME VARCHAR2(30)
        , FULL_NAME VARCHAR2(90)
        , PRIOR_NAME VARCHAR2(30)
        , USER_NAME VARCHAR2(60)
        , EMAIL_ADDRESS VARCHAR2(60)
        , DATE_OF_BIRTH DATE
        , AGE NUMBER(3)
        , AGE_BY_FISCAL_YEAR NUMBER(3)
        , GENDER VARCHAR2(30)
        , RACE VARCHAR2(30)
        , EDUCATION_LEVEL VARCHAR2(30)
        , DEGREE VARCHAR2(11)
        , MAJOR VARCHAR2(30)
        , IS_HANDICAPPED CHAR(1)
        , HANDICAP_TYPE VARCHAR2(30)
        , IS_VETERAN CHAR(1)
        , VETERAN_TYPE VARCHAR2(30)
        , VISA_CODE VARCHAR2(20)
        , VISA_TYPE VARCHAR2(30)
        , VISA_RENEWAL_DATE DATE
        , HAS_VISA CHAR(1)
        , OFFICE_LOCATION VARCHAR2(30)
        , OFFICE_PHONE VARCHAR2(20)
        , SECONDRY_OFFICE_LOCATION VARCHAR2(30)
        , SECONDRY_OFFICE_PHONE VARCHAR2(20)
        , SCHOOL VARCHAR2(50)
        , YEAR_GRADUATED VARCHAR2(30)
        , DIRECTORY_DEPARTMENT VARCHAR2(30)
        , SALUTATION VARCHAR2(30)
        , COUNTRY_OF_CITIZENSHIP VARCHAR2(30)
        , PRIMARY_TITLE VARCHAR2(51)
        , DIRECTORY_TITLE VARCHAR2(50)
        , HOME_UNIT VARCHAR2(8)
        , IS_FACULTY CHAR(1)
        , IS_GRADUATE_STUDENT_STAFF CHAR(1)
        , IS_RESEARCH_STAFF CHAR(1)
        , IS_SERVICE_STAFF CHAR(1)
        , IS_SUPPORT_STAFF CHAR(1)
        , IS_OTHER_ACCADEMIC_GROUP CHAR(1)
        , IS_MEDICAL_STAFF CHAR(1)
        , VACATION_ACCURAL CHAR(1)
        , IS_ON_SABBATICAL CHAR(1)
        , ID_PROVIDED VARCHAR2(30)
        , ID_VERIFIED VARCHAR2(30)
        , ADDRESS_LINE_1 VARCHAR2(80)
        , ADDRESS_LINE_2 VARCHAR2(80)
        , ADDRESS_LINE_3 VARCHAR2(80)
        , CITY VARCHAR2(30)
        , COUNTY VARCHAR2(30)
        , STATE VARCHAR2(30)
        , POSTAL_CODE VARCHAR2(15)
        , COUNTRY_CODE CHAR(3)
        , FAX_NUMBER VARCHAR2(20)
        , PAGER_NUMBER VARCHAR2(20)
        , MOBILE_PHONE_NUMBER VARCHAR2(20)
        , ERA_COMMONS_USER_NAME VARCHAR2(20)
        , CONFLICT_OF_INTEREST_FLAG CHAR(1)
        , PERCENTAGE_EFFORT NUMBER(5,2)
        , FEDR_DEBR_FLAG CHAR(1)
        , FEDR_DELQ_FLAG CHAR(1)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OPT_IN_UNIT_STATUS CHAR(1) default 'Y' NOT NULL
        , IS_OSC CHAR(1)
        , OPT_IN_CERTIFICATION_STATUS CHAR(1) default 'Y' NOT NULL
        , ORDINAL_POSITION NUMBER(4)
        , PROJECT_ROLE VARCHAR2(60)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_PERSON
    ADD CONSTRAINT EPS_PROP_PERSONP1
PRIMARY KEY (PROPOSAL_NUMBER,PROP_PERSON_NUMBER,PROP_PERSON_ROLE_ID);







-----------------------------------------------------------------------------
-- EPS_PROP_PERSON_BIO
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_PERSON_BIO';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_PERSON_BIO CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_PERSON_BIO
(
      PROPOSAL_NUMBER VARCHAR2(12)
        , PROP_PERSON_NUMBER NUMBER(12)
        , BIO_NUMBER NUMBER(3)
        , PERSON_ID VARCHAR2(40)
        , ROLODEX_ID NUMBER(6)
        , DESCRIPTION VARCHAR2(200)
        , DOCUMENT_TYPE_CODE VARCHAR2(3)
        , FILE_NAME VARCHAR2(150)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_PERSON_BIO
    ADD CONSTRAINT EPS_PROP_PERSON_BIOP1
PRIMARY KEY (PROPOSAL_NUMBER,PROP_PERSON_NUMBER,BIO_NUMBER);







-----------------------------------------------------------------------------
-- EPS_PROP_PERSON_BIO_ATTACHMENT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_PERSON_BIO_ATTACHMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_PERSON_BIO_ATTACHMENT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_PERSON_BIO_ATTACHMENT
(
      PROPOSAL_NUMBER VARCHAR2(12)
        , PROP_PERSON_NUMBER NUMBER(12)
        , BIO_NUMBER NUMBER(3)
        , BIO_DATA BLOB
        , FILE_NAME VARCHAR2(150)
        , CONTENT_TYPE VARCHAR2(255)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_PERSON_BIO_ATTACHMENT
    ADD CONSTRAINT EPS_PROP_PERSON_BIO_ATTACHMP1
PRIMARY KEY (PROPOSAL_NUMBER,PROP_PERSON_NUMBER,BIO_NUMBER);







-----------------------------------------------------------------------------
-- EPS_PROP_PERSON_DEGREE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_PERSON_DEGREE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_PERSON_DEGREE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_PERSON_DEGREE
(
      PROPOSAL_NUMBER VARCHAR2(12)
        , PROP_PERSON_NUMBER NUMBER(12)
        , DEGREE_SEQUENCE_NUMBER NUMBER(3)
        , GRADUATION_YEAR VARCHAR2(4)
        , DEGREE_CODE VARCHAR2(6)
        , DEGREE VARCHAR2(80)
        , FIELD_OF_STUDY VARCHAR2(80)
        , SPECIALIZATION VARCHAR2(80)
        , SCHOOL VARCHAR2(50)
        , SCHOOL_ID_CODE VARCHAR2(3)
        , SCHOOL_ID VARCHAR2(20)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_PERSON_DEGREE
    ADD CONSTRAINT EPS_PROP_PERSON_DEGREEP1
PRIMARY KEY (PROPOSAL_NUMBER,PROP_PERSON_NUMBER,DEGREE_SEQUENCE_NUMBER);







-----------------------------------------------------------------------------
-- EPS_PROP_PERSON_ROLE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_PERSON_ROLE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_PERSON_ROLE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_PERSON_ROLE
(
      UNIT_DETAILS_REQUIRED CHAR(1) default 'Y' NOT NULL
        , PROP_PERSON_ROLE_ID VARCHAR2(12)
        , DESCRIPTION VARCHAR2(25) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , CERTIFICATION_REQUIRED CHAR(1) default 'Y' NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_PERSON_ROLE
    ADD CONSTRAINT EPS_PROP_PERSON_ROLEP1
PRIMARY KEY (PROP_PERSON_ROLE_ID);







-----------------------------------------------------------------------------
-- EPS_PROP_PERSON_UNITS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_PERSON_UNITS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_PERSON_UNITS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_PERSON_UNITS
(
      PROPOSAL_NUMBER VARCHAR2(12)
        , PROP_PERSON_NUMBER NUMBER(12)
        , UNIT_NUMBER VARCHAR2(8)
        , LEAD_UNIT_FLAG CHAR(1)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_PERSON_UNITS
    ADD CONSTRAINT EPS_PROP_PERSON_UNITSP1
PRIMARY KEY (PROPOSAL_NUMBER,PROP_PERSON_NUMBER,UNIT_NUMBER);







-----------------------------------------------------------------------------
-- EPS_PROP_PERS_YNQ
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_PERS_YNQ';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_PERS_YNQ CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_PERS_YNQ
(
      PROPOSAL_NUMBER VARCHAR2(12)
        , PROP_PERSON_NUMBER NUMBER(12)
        , QUESTION_ID VARCHAR2(4)
        , ANSWER CHAR(1)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_PERS_YNQ
    ADD CONSTRAINT EPS_PROP_PERS_YNQP1
PRIMARY KEY (PROPOSAL_NUMBER,PROP_PERSON_NUMBER,QUESTION_ID);







-----------------------------------------------------------------------------
-- EPS_PROP_PER_CREDIT_SPLIT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_PER_CREDIT_SPLIT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_PER_CREDIT_SPLIT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_PER_CREDIT_SPLIT
(
      PROPOSAL_NUMBER VARCHAR2(12)
        , INV_CREDIT_TYPE_CODE VARCHAR2(3)
        , PROP_PERSON_NUMBER NUMBER(12)
        , CREDIT NUMBER(5,2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_PER_CREDIT_SPLIT
    ADD CONSTRAINT EPS_PROP_PER_CREDIT_SPLITP1
PRIMARY KEY (PROPOSAL_NUMBER,INV_CREDIT_TYPE_CODE,PROP_PERSON_NUMBER);







-----------------------------------------------------------------------------
-- EPS_PROP_PER_DOC_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_PER_DOC_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_PER_DOC_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_PER_DOC_TYPE
(
      DOCUMENT_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_PER_DOC_TYPE
    ADD CONSTRAINT EPS_PROP_PER_DOC_TYPEP1
PRIMARY KEY (DOCUMENT_TYPE_CODE);







-----------------------------------------------------------------------------
-- EPS_PROP_RATES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_RATES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_RATES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_RATES
(
      BUDGET_ID NUMBER(12)
        , PROPOSAL_NUMBER VARCHAR2(12)
        , VERSION_NUMBER NUMBER(3)
        , RATE_CLASS_CODE VARCHAR2(3)
        , RATE_TYPE_CODE VARCHAR2(3)
        , FISCAL_YEAR CHAR(4)
        , ON_OFF_CAMPUS_FLAG CHAR(1)
        , ACTIVITY_TYPE_CODE VARCHAR2(3) NOT NULL
        , START_DATE DATE
        , APPLICABLE_RATE NUMBER(5,2) NOT NULL
        , INSTITUTE_RATE NUMBER(5,2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_RATES
    ADD CONSTRAINT EPS_PROP_RATESP1
PRIMARY KEY (BUDGET_ID,RATE_CLASS_CODE,RATE_TYPE_CODE,FISCAL_YEAR,ON_OFF_CAMPUS_FLAG,START_DATE);


CREATE INDEX PK_EPS_PROP_RATES_KRA 
  ON EPS_PROP_RATES 
  (PROPOSAL_NUMBER, VERSION_NUMBER, RATE_CLASS_CODE, RATE_TYPE_CODE, FISCAL_YEAR, START_DATE, ON_OFF_CAMPUS_FLAG);





-----------------------------------------------------------------------------
-- EPS_PROP_SCIENCE_KEYWORD
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_SCIENCE_KEYWORD';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_SCIENCE_KEYWORD CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_SCIENCE_KEYWORD
(
      HIERARCHY_PROPOSAL_NUMBER VARCHAR2(12)
        , HIDE_IN_HIERARCHY CHAR(1) default 'N' NOT NULL
        , PROPOSAL_NUMBER VARCHAR2(12)
        , SCIENCE_KEYWORD_CODE VARCHAR2(15)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_SCIENCE_KEYWORD
    ADD CONSTRAINT EPS_PROP_SCIENCE_KEYWORDP1
PRIMARY KEY (PROPOSAL_NUMBER,SCIENCE_KEYWORD_CODE);







-----------------------------------------------------------------------------
-- EPS_PROP_SITES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_SITES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_SITES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_SITES
(
      PROPOSAL_NUMBER VARCHAR2(8)
        , SITE_NUMBER NUMBER(3)
        , LOCATION_NAME VARCHAR2(60)
        , LOCATION_TYPE_CODE NUMBER(3) NOT NULL
        , ORGANIZATION_ID VARCHAR2(8)
        , ROLODEX_ID NUMBER(6)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_SITES
    ADD CONSTRAINT EPS_PROP_SITESP1
PRIMARY KEY (PROPOSAL_NUMBER,SITE_NUMBER);







-----------------------------------------------------------------------------
-- EPS_PROP_SPECIAL_REVIEW
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_SPECIAL_REVIEW';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_SPECIAL_REVIEW CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_SPECIAL_REVIEW
(
      EXPIRATION_DATE DATE
        , HIERARCHY_PROPOSAL_NUMBER VARCHAR2(12)
        , HIDE_IN_HIERARCHY CHAR(1) default 'N' NOT NULL
        , PROPOSAL_NUMBER VARCHAR2(12)
        , SPECIAL_REVIEW_NUMBER NUMBER(3)
        , SPECIAL_REVIEW_CODE VARCHAR2(3) NOT NULL
        , APPROVAL_TYPE_CODE VARCHAR2(3) NOT NULL
        , PROTOCOL_NUMBER VARCHAR2(20)
        , APPLICATION_DATE DATE
        , APPROVAL_DATE DATE
        , COMMENTS CLOB
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_SPECIAL_REVIEW
    ADD CONSTRAINT EPS_PROP_SPECIAL_REVIEWP1
PRIMARY KEY (PROPOSAL_NUMBER,SPECIAL_REVIEW_NUMBER);







-----------------------------------------------------------------------------
-- EPS_PROP_UNIT_CREDIT_SPLIT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_UNIT_CREDIT_SPLIT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_UNIT_CREDIT_SPLIT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_UNIT_CREDIT_SPLIT
(
      PROPOSAL_NUMBER VARCHAR2(12)
        , INV_CREDIT_TYPE_CODE VARCHAR2(3)
        , PROP_PERSON_NUMBER NUMBER(12)
        , UNIT_NUMBER VARCHAR2(8)
        , CREDIT NUMBER(5,2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_UNIT_CREDIT_SPLIT
    ADD CONSTRAINT EPS_PROP_UNIT_CREDIT_SPLITP1
PRIMARY KEY (PROPOSAL_NUMBER,INV_CREDIT_TYPE_CODE,PROP_PERSON_NUMBER,UNIT_NUMBER);







-----------------------------------------------------------------------------
-- EPS_PROP_USER_ROLES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_USER_ROLES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_USER_ROLES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_USER_ROLES
(
      PROPOSAL_NUMBER VARCHAR2(12)
        , USER_ID VARCHAR2(40)
        , ROLE_ID NUMBER(5)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_USER_ROLES
    ADD CONSTRAINT EPS_PROP_USER_ROLESP1
PRIMARY KEY (PROPOSAL_NUMBER,USER_ID,ROLE_ID);







-----------------------------------------------------------------------------
-- EPS_PROP_YNQ
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EPS_PROP_YNQ';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EPS_PROP_YNQ CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EPS_PROP_YNQ
(
      PROPOSAL_NUMBER VARCHAR2(12)
        , QUESTION_ID VARCHAR2(4)
        , ANSWER CHAR(1)
        , EXPLANATION CLOB
        , REVIEW_DATE DATE
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EPS_PROP_YNQ
    ADD CONSTRAINT EPS_PROP_YNQP1
PRIMARY KEY (PROPOSAL_NUMBER,QUESTION_ID);







-----------------------------------------------------------------------------
-- EXEMPTION_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EXEMPTION_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EXEMPTION_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EXEMPTION_TYPE
(
      EXEMPTION_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , DETAILED_DESCRIPTION CLOB
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EXEMPTION_TYPE
    ADD CONSTRAINT EXEMPTION_TYPEP1
PRIMARY KEY (EXEMPTION_TYPE_CODE);







-----------------------------------------------------------------------------
-- EXEMPT_STUDIES_CHECKLIST
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EXEMPT_STUDIES_CHECKLIST';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EXEMPT_STUDIES_CHECKLIST CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EXEMPT_STUDIES_CHECKLIST
(
      EXEMPT_STUDIES_CHECKLIST_CODE VARCHAR2(4)
        , DESCRIPTION VARCHAR2(2000) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EXEMPT_STUDIES_CHECKLIST
    ADD CONSTRAINT EXEMPT_STUDIES_CHECKLISTP1
PRIMARY KEY (EXEMPT_STUDIES_CHECKLIST_CODE);







-----------------------------------------------------------------------------
-- EXPEDITED_REVIEW_CHECKLIST
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'EXPEDITED_REVIEW_CHECKLIST';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE EXPEDITED_REVIEW_CHECKLIST CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE EXPEDITED_REVIEW_CHECKLIST
(
      EXPEDITED_REV_CHKLST_CODE VARCHAR2(4)
        , DESCRIPTION VARCHAR2(2000) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE EXPEDITED_REVIEW_CHECKLIST
    ADD CONSTRAINT EXPEDITED_REVIEW_CHECKLISTP1
PRIMARY KEY (EXPEDITED_REV_CHKLST_CODE);







-----------------------------------------------------------------------------
-- FP_DOC_TYPE_T
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'FP_DOC_TYPE_T';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE FP_DOC_TYPE_T CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE FP_DOC_TYPE_T
(
      FDOC_TYP_CD VARCHAR2(4)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , FDOC_NM VARCHAR2(40)
        , FDOC_TYP_ACTIVE_CD VARCHAR2(1)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE FP_DOC_TYPE_T
    ADD CONSTRAINT FP_DOC_TYPE_TP1
PRIMARY KEY (FDOC_TYP_CD);







-----------------------------------------------------------------------------
-- FREQUENCY
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'FREQUENCY';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE FREQUENCY CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE FREQUENCY
(
      VER_NBR NUMBER(8) default 1 NOT NULL
        , FREQUENCY_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , NUMBER_OF_DAYS NUMBER(3)
        , NUMBER_OF_MONTHS NUMBER(2)
        , REPEAT_FLAG CHAR(1) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , ADVANCE_NUMBER_OF_DAYS NUMBER(3)
        , ADVANCE_NUMBER_OF_MONTHS NUMBER(2)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE FREQUENCY
    ADD CONSTRAINT FREQUENCYP1
PRIMARY KEY (FREQUENCY_CODE);







-----------------------------------------------------------------------------
-- FREQUENCY_BASE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'FREQUENCY_BASE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE FREQUENCY_BASE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE FREQUENCY_BASE
(
      VER_NBR NUMBER(8) default 1 NOT NULL
        , FREQUENCY_BASE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE FREQUENCY_BASE
    ADD CONSTRAINT FREQUENCY_BASEP1
PRIMARY KEY (FREQUENCY_BASE_CODE);







-----------------------------------------------------------------------------
-- FUNDING_SOURCE_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'FUNDING_SOURCE_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE FUNDING_SOURCE_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE FUNDING_SOURCE_TYPE
(
      FUNDING_SOURCE_TYPE_CODE NUMBER(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , FUNDING_SOURCE_TYPE_FLAG VARCHAR2(1)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE FUNDING_SOURCE_TYPE
    ADD CONSTRAINT FUNDING_SOURCE_TYPEP1
PRIMARY KEY (FUNDING_SOURCE_TYPE_CODE);







-----------------------------------------------------------------------------
-- GROUP_TYPES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'GROUP_TYPES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE GROUP_TYPES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE GROUP_TYPES
(
      GROUP_TYPE_CODE NUMBER(3)
        , GROUP_NAME VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE GROUP_TYPES
    ADD CONSTRAINT GROUP_TYPESP1
PRIMARY KEY (GROUP_TYPE_CODE);







-----------------------------------------------------------------------------
-- IDC_RATE_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'IDC_RATE_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE IDC_RATE_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE IDC_RATE_TYPE
(
      IDC_RATE_TYPE_CODE NUMBER(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE IDC_RATE_TYPE
    ADD CONSTRAINT IDC_RATE_TYPEP1
PRIMARY KEY (IDC_RATE_TYPE_CODE);







-----------------------------------------------------------------------------
-- INSTITUTE_LA_RATES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'INSTITUTE_LA_RATES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE INSTITUTE_LA_RATES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE INSTITUTE_LA_RATES
(
      ACTIVE_FLAG CHAR(1) default 'Y' NOT NULL
        , UNIT_NUMBER VARCHAR2(8)
        , RATE_TYPE_CODE VARCHAR2(3)
        , FISCAL_YEAR CHAR(4)
        , START_DATE DATE
        , ON_OFF_CAMPUS_FLAG CHAR(1)
        , RATE NUMBER(5,2) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , RATE_CLASS_CODE VARCHAR2(3)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE INSTITUTE_LA_RATES
    ADD CONSTRAINT INSTITUTE_LA_RATESP1
PRIMARY KEY (UNIT_NUMBER,RATE_TYPE_CODE,FISCAL_YEAR,START_DATE,ON_OFF_CAMPUS_FLAG,RATE_CLASS_CODE);







-----------------------------------------------------------------------------
-- INSTITUTE_PROPOSAL_DOCUMENT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'INSTITUTE_PROPOSAL_DOCUMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE INSTITUTE_PROPOSAL_DOCUMENT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE INSTITUTE_PROPOSAL_DOCUMENT
(
      DOCUMENT_NUMBER VARCHAR2(10)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE INSTITUTE_PROPOSAL_DOCUMENT
    ADD CONSTRAINT INSTITUTE_PROPOSAL_DOCUMENTP1
PRIMARY KEY (DOCUMENT_NUMBER);







-----------------------------------------------------------------------------
-- INSTITUTE_RATES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'INSTITUTE_RATES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE INSTITUTE_RATES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE INSTITUTE_RATES
(
      ACTIVE_FLAG CHAR(1) default 'Y' NOT NULL
        , RATE_CLASS_CODE VARCHAR2(3)
        , RATE_TYPE_CODE VARCHAR2(3)
        , ACTIVITY_TYPE_CODE VARCHAR2(3)
        , FISCAL_YEAR CHAR(4)
        , START_DATE DATE
        , ON_OFF_CAMPUS_FLAG CHAR(1)
        , RATE NUMBER(5,2) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , UNIT_NUMBER VARCHAR2(8)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE INSTITUTE_RATES
    ADD CONSTRAINT INSTITUTE_RATESP1
PRIMARY KEY (RATE_CLASS_CODE,RATE_TYPE_CODE,ACTIVITY_TYPE_CODE,FISCAL_YEAR,START_DATE,ON_OFF_CAMPUS_FLAG,UNIT_NUMBER);







-----------------------------------------------------------------------------
-- INV_CREDIT_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'INV_CREDIT_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE INV_CREDIT_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE INV_CREDIT_TYPE
(
      INV_CREDIT_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(300) NOT NULL
        , ADDS_TO_HUNDRED CHAR(1) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , ACTIVE_FLAG CHAR(1)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE INV_CREDIT_TYPE
    ADD CONSTRAINT INV_CREDIT_TYPEP1
PRIMARY KEY (INV_CREDIT_TYPE_CODE);







-----------------------------------------------------------------------------
-- IP_REVIEW
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'IP_REVIEW';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE IP_REVIEW CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE IP_REVIEW
(
      IP_REVIEW_ID NUMBER(12)
        , PROPOSAL_NUMBER VARCHAR2(8) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , IP_REVIEW_REQ_TYPE_CODE NUMBER(3)
        , REVIEW_SUBMISSION_DATE DATE
        , REVIEW_RECEIVE_DATE DATE
        , REVIEW_RESULT_CODE NUMBER(3)
        , IP_REVIEWER VARCHAR2(40)
        , IP_REVIEW_SEQUENCE_STATUS VARCHAR2(10) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE IP_REVIEW
    ADD CONSTRAINT IP_REVIEWP1
PRIMARY KEY (IP_REVIEW_ID);







-----------------------------------------------------------------------------
-- IP_REVIEW_ACTIVITY_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'IP_REVIEW_ACTIVITY_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE IP_REVIEW_ACTIVITY_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE IP_REVIEW_ACTIVITY_TYPE
(
      IP_REVIEW_ACTIVITY_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE IP_REVIEW_ACTIVITY_TYPE
    ADD CONSTRAINT IP_REVIEW_ACTIVITY_TYPEP1
PRIMARY KEY (IP_REVIEW_ACTIVITY_TYPE_CODE);







-----------------------------------------------------------------------------
-- IP_REVIEW_REQ_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'IP_REVIEW_REQ_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE IP_REVIEW_REQ_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE IP_REVIEW_REQ_TYPE
(
      IP_REVIEW_REQ_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE IP_REVIEW_REQ_TYPE
    ADD CONSTRAINT IP_REVIEW_REQ_TYPEP1
PRIMARY KEY (IP_REVIEW_REQ_TYPE_CODE);







-----------------------------------------------------------------------------
-- IP_REVIEW_RESULT_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'IP_REVIEW_RESULT_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE IP_REVIEW_RESULT_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE IP_REVIEW_RESULT_TYPE
(
      IP_REVIEW_RESULT_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE IP_REVIEW_RESULT_TYPE
    ADD CONSTRAINT IP_REVIEW_RESULT_TYPEP1
PRIMARY KEY (IP_REVIEW_RESULT_TYPE_CODE);







-----------------------------------------------------------------------------
-- JOB_CODE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'JOB_CODE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE JOB_CODE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE JOB_CODE
(
      JOB_CODE VARCHAR2(6)
        , JOB_TITLE VARCHAR2(50) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE JOB_CODE
    ADD CONSTRAINT JOB_CODEP1
PRIMARY KEY (JOB_CODE);







-----------------------------------------------------------------------------
-- KRA_USER
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRA_USER';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRA_USER CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRA_USER
(
      USER_ID VARCHAR2(10)
        , USER_NAME VARCHAR2(90)
        , NON_MIT_PERSON_FLAG CHAR(1)
        , PERSON_ID VARCHAR2(40)
        , USER_TYPE CHAR(1)
        , UNIT_NUMBER VARCHAR2(8)
        , STATUS CHAR(1)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE KRA_USER
    ADD CONSTRAINT KRA_USERP1
PRIMARY KEY (USER_ID);







-----------------------------------------------------------------------------
-- KRNS_ADHOC_RTE_ACTN_RECIP_T
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRNS_ADHOC_RTE_ACTN_RECIP_T';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRNS_ADHOC_RTE_ACTN_RECIP_T CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRNS_ADHOC_RTE_ACTN_RECIP_T
(
      RECIP_TYP_CD NUMBER(1)
        , ACTN_RQST_CD VARCHAR2(30)
        , ACTN_RQST_RECIP_ID VARCHAR2(70)
        , OBJ_ID VARCHAR2(36) default SYS_GUID() NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , DOC_HDR_ID VARCHAR2(14)
    
    , CONSTRAINT KRNS_ADHOC_RTE_ACTN_RECIP_TC0 UNIQUE (OBJ_ID)

);

ALTER TABLE KRNS_ADHOC_RTE_ACTN_RECIP_T
    ADD CONSTRAINT KRNS_ADHOC_RTE_ACTN_RECIP_TP1
PRIMARY KEY (RECIP_TYP_CD,ACTN_RQST_CD,ACTN_RQST_RECIP_ID,DOC_HDR_ID);


CREATE INDEX KRNS_ADHOC_RTE_ACTN_RECIP_T2 
  ON KRNS_ADHOC_RTE_ACTN_RECIP_T 
  (DOC_HDR_ID);





-----------------------------------------------------------------------------
-- KRNS_ATT_T
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRNS_ATT_T';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRNS_ATT_T CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRNS_ATT_T
(
      NTE_ID NUMBER(14)
        , OBJ_ID VARCHAR2(36) default SYS_GUID() NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , MIME_TYP VARCHAR2(255)
        , FILE_NM VARCHAR2(250)
        , ATT_ID VARCHAR2(36)
        , FILE_SZ NUMBER(14)
        , ATT_TYP_CD VARCHAR2(40)
    
    , CONSTRAINT KRNS_ATT_TC0 UNIQUE (OBJ_ID)

);

ALTER TABLE KRNS_ATT_T
    ADD CONSTRAINT KRNS_ATT_TP1
PRIMARY KEY (NTE_ID);







-----------------------------------------------------------------------------
-- KRNS_DOC_HDR_T
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRNS_DOC_HDR_T';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRNS_DOC_HDR_T CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRNS_DOC_HDR_T
(
      DOC_HDR_ID VARCHAR2(14)
        , OBJ_ID VARCHAR2(36) default SYS_GUID() NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , FDOC_DESC VARCHAR2(40)
        , ORG_DOC_HDR_ID VARCHAR2(10)
        , TMPL_DOC_HDR_ID VARCHAR2(14)
        , EXPLANATION VARCHAR2(400)
    
    , CONSTRAINT KRNS_DOC_HDR_TC0 UNIQUE (OBJ_ID)

);

ALTER TABLE KRNS_DOC_HDR_T
    ADD CONSTRAINT KRNS_DOC_HDR_TP1
PRIMARY KEY (DOC_HDR_ID);


CREATE INDEX KRNS_DOC_HDR_TI3 
  ON KRNS_DOC_HDR_T 
  (ORG_DOC_HDR_ID);





-----------------------------------------------------------------------------
-- KRNS_LOOKUP_RSLT_T
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRNS_LOOKUP_RSLT_T';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRNS_LOOKUP_RSLT_T CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRNS_LOOKUP_RSLT_T
(
      LOOKUP_RSLT_ID VARCHAR2(14)
        , OBJ_ID VARCHAR2(36) default SYS_GUID() NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , PRNCPL_ID VARCHAR2(40) NOT NULL
        , LOOKUP_DT DATE NOT NULL
        , SERIALZD_RSLTS CLOB
    
    , CONSTRAINT KRNS_LOOKUP_RSLT_TC0 UNIQUE (OBJ_ID)

);

ALTER TABLE KRNS_LOOKUP_RSLT_T
    ADD CONSTRAINT KRNS_LOOKUP_RSLT_TP1
PRIMARY KEY (LOOKUP_RSLT_ID);







-----------------------------------------------------------------------------
-- KRNS_LOOKUP_SEL_T
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRNS_LOOKUP_SEL_T';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRNS_LOOKUP_SEL_T CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRNS_LOOKUP_SEL_T
(
      LOOKUP_RSLT_ID VARCHAR2(14)
        , OBJ_ID VARCHAR2(36) default SYS_GUID() NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , PRNCPL_ID VARCHAR2(40) NOT NULL
        , LOOKUP_DT DATE NOT NULL
        , SEL_OBJ_IDS CLOB
    
    , CONSTRAINT KRNS_LOOKUP_SEL_TC0 UNIQUE (OBJ_ID)

);

ALTER TABLE KRNS_LOOKUP_SEL_T
    ADD CONSTRAINT KRNS_LOOKUP_SEL_TP1
PRIMARY KEY (LOOKUP_RSLT_ID);







-----------------------------------------------------------------------------
-- KRNS_MAINT_DOC_ATT_T
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRNS_MAINT_DOC_ATT_T';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRNS_MAINT_DOC_ATT_T CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRNS_MAINT_DOC_ATT_T
(
      DOC_HDR_ID VARCHAR2(14)
        , ATT_CNTNT BLOB NOT NULL
        , FILE_NM VARCHAR2(150)
        , CNTNT_TYP VARCHAR2(255)
        , OBJ_ID VARCHAR2(36) default SYS_GUID() NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
    
    , CONSTRAINT KRNS_MAINT_DOC_ATT_TC0 UNIQUE (OBJ_ID)

);

ALTER TABLE KRNS_MAINT_DOC_ATT_T
    ADD CONSTRAINT KRNS_MAINT_DOC_ATT_TP1
PRIMARY KEY (DOC_HDR_ID);







-----------------------------------------------------------------------------
-- KRNS_MAINT_DOC_T
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRNS_MAINT_DOC_T';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRNS_MAINT_DOC_T CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRNS_MAINT_DOC_T
(
      DOC_HDR_ID VARCHAR2(14)
        , OBJ_ID VARCHAR2(36) default SYS_GUID() NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , DOC_CNTNT CLOB
    
    , CONSTRAINT KRNS_MAINT_DOC_TC0 UNIQUE (OBJ_ID)

);

ALTER TABLE KRNS_MAINT_DOC_T
    ADD CONSTRAINT KRNS_MAINT_DOC_TP1
PRIMARY KEY (DOC_HDR_ID);







-----------------------------------------------------------------------------
-- KRNS_MAINT_LOCK_T
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRNS_MAINT_LOCK_T';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRNS_MAINT_LOCK_T CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRNS_MAINT_LOCK_T
(
      MAINT_LOCK_REP_TXT VARCHAR2(500)
        , OBJ_ID VARCHAR2(36) default SYS_GUID() NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , DOC_HDR_ID VARCHAR2(14) NOT NULL
        , MAINT_LOCK_ID VARCHAR2(14)
    
    , CONSTRAINT KRNS_MAINT_LOCK_TC0 UNIQUE (OBJ_ID)

);

ALTER TABLE KRNS_MAINT_LOCK_T
    ADD CONSTRAINT KRNS_MAINT_LOCK_TP1
PRIMARY KEY (MAINT_LOCK_ID);


CREATE INDEX KRNS_MAINT_LOCK_TI2 
  ON KRNS_MAINT_LOCK_T 
  (DOC_HDR_ID);





-----------------------------------------------------------------------------
-- KRNS_NTE_T
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRNS_NTE_T';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRNS_NTE_T CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRNS_NTE_T
(
      NTE_ID NUMBER(14)
        , OBJ_ID VARCHAR2(36) default SYS_GUID() NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , RMT_OBJ_ID VARCHAR2(36) NOT NULL
        , AUTH_PRNCPL_ID VARCHAR2(40) NOT NULL
        , POST_TS DATE NOT NULL
        , NTE_TYP_CD VARCHAR2(4) NOT NULL
        , TXT VARCHAR2(800)
        , PRG_CD VARCHAR2(1)
        , TPC_TXT VARCHAR2(40)
    
    , CONSTRAINT KRNS_NTE_TC0 UNIQUE (OBJ_ID)

);

ALTER TABLE KRNS_NTE_T
    ADD CONSTRAINT KRNS_NTE_TP1
PRIMARY KEY (NTE_ID);







-----------------------------------------------------------------------------
-- KRNS_NTE_TYP_T
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRNS_NTE_TYP_T';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRNS_NTE_TYP_T CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRNS_NTE_TYP_T
(
      NTE_TYP_CD VARCHAR2(4)
        , OBJ_ID VARCHAR2(36) default SYS_GUID() NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , TYP_DESC_TXT VARCHAR2(100)
        , ACTV_IND VARCHAR2(1)
    
    , CONSTRAINT KRNS_NTE_TYP_TC0 UNIQUE (OBJ_ID)

);

ALTER TABLE KRNS_NTE_TYP_T
    ADD CONSTRAINT KRNS_NTE_TYP_TP1
PRIMARY KEY (NTE_TYP_CD);







-----------------------------------------------------------------------------
-- KRNS_PESSIMISTIC_LOCK_T
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRNS_PESSIMISTIC_LOCK_T';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRNS_PESSIMISTIC_LOCK_T CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRNS_PESSIMISTIC_LOCK_T
(
      PESSIMISTIC_LOCK_ID NUMBER(14)
        , OBJ_ID VARCHAR2(36) default SYS_GUID() NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , LOCK_DESC_TXT VARCHAR2(4000)
        , DOC_HDR_ID VARCHAR2(14) NOT NULL
        , GNRT_DT DATE NOT NULL
        , PRNCPL_ID VARCHAR2(40) NOT NULL
    
    , CONSTRAINT KRNS_PESSIMISTIC_LOCK_TC0 UNIQUE (OBJ_ID)

);

ALTER TABLE KRNS_PESSIMISTIC_LOCK_T
    ADD CONSTRAINT KRNS_PESSIMISTIC_LOCK_TP1
PRIMARY KEY (PESSIMISTIC_LOCK_ID);


CREATE INDEX KRNS_PESSIMISTIC_LOCK_TI1 
  ON KRNS_PESSIMISTIC_LOCK_T 
  (DOC_HDR_ID);
CREATE INDEX KRNS_PESSIMISTIC_LOCK_TI2 
  ON KRNS_PESSIMISTIC_LOCK_T 
  (PRNCPL_ID);





-----------------------------------------------------------------------------
-- KRNS_SESN_DOC_T
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRNS_SESN_DOC_T';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRNS_SESN_DOC_T CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRNS_SESN_DOC_T
(
      SESN_DOC_ID VARCHAR2(40)
        , DOC_HDR_ID VARCHAR2(14)
        , PRNCPL_ID VARCHAR2(40)
        , IP_ADDR VARCHAR2(60)
        , SERIALZD_DOC_FRM BLOB
        , LAST_UPDT_DT DATE
        , CONTENT_ENCRYPTED_IND CHAR(1) default 'N'
    

);

ALTER TABLE KRNS_SESN_DOC_T
    ADD CONSTRAINT KRNS_SESN_DOC_TP1
PRIMARY KEY (SESN_DOC_ID,DOC_HDR_ID,PRNCPL_ID,IP_ADDR);


CREATE INDEX KRNS_SESN_DOC_TI1 
  ON KRNS_SESN_DOC_T 
  (LAST_UPDT_DT);





-----------------------------------------------------------------------------
-- KRSB_BAM_PARM_T
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRSB_BAM_PARM_T';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRSB_BAM_PARM_T CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRSB_BAM_PARM_T
(
      BAM_PARM_ID NUMBER(14)
        , BAM_ID NUMBER(14) NOT NULL
        , PARM CLOB NOT NULL
    

);

ALTER TABLE KRSB_BAM_PARM_T
    ADD CONSTRAINT KRSB_BAM_PARM_TP1
PRIMARY KEY (BAM_PARM_ID);


CREATE INDEX KREW_BAM_PARM_TI1 
  ON KRSB_BAM_PARM_T 
  (BAM_ID);





-----------------------------------------------------------------------------
-- KRSB_BAM_T
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRSB_BAM_T';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRSB_BAM_T CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRSB_BAM_T
(
      BAM_ID NUMBER(14)
        , SVC_NM VARCHAR2(255) NOT NULL
        , SVC_URL VARCHAR2(500) NOT NULL
        , MTHD_NM VARCHAR2(2000) NOT NULL
        , THRD_NM VARCHAR2(500) NOT NULL
        , CALL_DT DATE NOT NULL
        , TGT_TO_STR VARCHAR2(2000) NOT NULL
        , SRVR_IND NUMBER(1) NOT NULL
        , EXCPN_TO_STR VARCHAR2(2000)
        , EXCPN_MSG CLOB
    

);

ALTER TABLE KRSB_BAM_T
    ADD CONSTRAINT KRSB_BAM_TP1
PRIMARY KEY (BAM_ID);


CREATE INDEX KRSB_BAM_TI1 
  ON KRSB_BAM_T 
  (SVC_NM, MTHD_NM);
CREATE INDEX KRSB_BAM_TI2 
  ON KRSB_BAM_T 
  (SVC_NM);





-----------------------------------------------------------------------------
-- KRSB_MSG_PYLD_T
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRSB_MSG_PYLD_T';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRSB_MSG_PYLD_T CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRSB_MSG_PYLD_T
(
      MSG_QUE_ID NUMBER(14)
        , MSG_PYLD CLOB NOT NULL
    

);

ALTER TABLE KRSB_MSG_PYLD_T
    ADD CONSTRAINT KRSB_MSG_PYLD_TP1
PRIMARY KEY (MSG_QUE_ID);







-----------------------------------------------------------------------------
-- KRSB_MSG_QUE_T
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRSB_MSG_QUE_T';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRSB_MSG_QUE_T CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRSB_MSG_QUE_T
(
      MSG_QUE_ID NUMBER(14)
        , DT DATE NOT NULL
        , EXP_DT DATE
        , PRIO NUMBER(8) NOT NULL
        , STAT_CD CHAR(1) NOT NULL
        , RTRY_CNT NUMBER(8) NOT NULL
        , IP_NBR VARCHAR2(2000) NOT NULL
        , SVC_NM VARCHAR2(255)
        , SVC_NMSPC VARCHAR2(255) NOT NULL
        , SVC_MTHD_NM VARCHAR2(2000)
        , APP_VAL_ONE VARCHAR2(2000)
        , APP_VAL_TWO VARCHAR2(2000)
        , VER_NBR NUMBER(8) default 0
    

);

ALTER TABLE KRSB_MSG_QUE_T
    ADD CONSTRAINT KRSB_MSG_QUE_TP1
PRIMARY KEY (MSG_QUE_ID);


CREATE INDEX KRSB_MSG_QUE_TI1 
  ON KRSB_MSG_QUE_T 
  (SVC_NM, SVC_MTHD_NM);
CREATE INDEX KRSB_MSG_QUE_TI2 
  ON KRSB_MSG_QUE_T 
  (SVC_NMSPC, STAT_CD, IP_NBR, DT);





-----------------------------------------------------------------------------
-- KRSB_QRTZ_BLOB_TRIGGERS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRSB_QRTZ_BLOB_TRIGGERS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRSB_QRTZ_BLOB_TRIGGERS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRSB_QRTZ_BLOB_TRIGGERS
(
      TRIGGER_NAME VARCHAR2(80)
        , TRIGGER_GROUP VARCHAR2(80)
        , BLOB_DATA BLOB
    

);

ALTER TABLE KRSB_QRTZ_BLOB_TRIGGERS
    ADD CONSTRAINT KRSB_QRTZ_BLOB_TRIGGERSP1
PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP);







-----------------------------------------------------------------------------
-- KRSB_QRTZ_CALENDARS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRSB_QRTZ_CALENDARS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRSB_QRTZ_CALENDARS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRSB_QRTZ_CALENDARS
(
      CALENDAR_NAME VARCHAR2(80)
        , CALENDAR BLOB NOT NULL
    

);

ALTER TABLE KRSB_QRTZ_CALENDARS
    ADD CONSTRAINT KRSB_QRTZ_CALENDARSP1
PRIMARY KEY (CALENDAR_NAME);







-----------------------------------------------------------------------------
-- KRSB_QRTZ_CRON_TRIGGERS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRSB_QRTZ_CRON_TRIGGERS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRSB_QRTZ_CRON_TRIGGERS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRSB_QRTZ_CRON_TRIGGERS
(
      TRIGGER_NAME VARCHAR2(80)
        , TRIGGER_GROUP VARCHAR2(80)
        , CRON_EXPRESSION VARCHAR2(80) NOT NULL
        , TIME_ZONE_ID VARCHAR2(80)
    

);

ALTER TABLE KRSB_QRTZ_CRON_TRIGGERS
    ADD CONSTRAINT KRSB_QRTZ_CRON_TRIGGERSP1
PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP);







-----------------------------------------------------------------------------
-- KRSB_QRTZ_FIRED_TRIGGERS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRSB_QRTZ_FIRED_TRIGGERS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRSB_QRTZ_FIRED_TRIGGERS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRSB_QRTZ_FIRED_TRIGGERS
(
      ENTRY_ID VARCHAR2(95)
        , TRIGGER_NAME VARCHAR2(80) NOT NULL
        , TRIGGER_GROUP VARCHAR2(80) NOT NULL
        , IS_VOLATILE VARCHAR2(1) NOT NULL
        , INSTANCE_NAME VARCHAR2(80) NOT NULL
        , FIRED_TIME NUMBER(13) NOT NULL
        , PRIORITY NUMBER(13) NOT NULL
        , STATE VARCHAR2(16) NOT NULL
        , JOB_NAME VARCHAR2(80)
        , JOB_GROUP VARCHAR2(80)
        , IS_STATEFUL VARCHAR2(1)
        , REQUESTS_RECOVERY VARCHAR2(1)
    

);

ALTER TABLE KRSB_QRTZ_FIRED_TRIGGERS
    ADD CONSTRAINT KRSB_QRTZ_FIRED_TRIGGERSP1
PRIMARY KEY (ENTRY_ID);


CREATE INDEX KRSB_QRTZ_FIRED_TRIGGERS_TI1 
  ON KRSB_QRTZ_FIRED_TRIGGERS 
  (JOB_GROUP);
CREATE INDEX KRSB_QRTZ_FIRED_TRIGGERS_TI2 
  ON KRSB_QRTZ_FIRED_TRIGGERS 
  (JOB_NAME);
CREATE INDEX KRSB_QRTZ_FIRED_TRIGGERS_TI3 
  ON KRSB_QRTZ_FIRED_TRIGGERS 
  (REQUESTS_RECOVERY);
CREATE INDEX KRSB_QRTZ_FIRED_TRIGGERS_TI4 
  ON KRSB_QRTZ_FIRED_TRIGGERS 
  (IS_STATEFUL);
CREATE INDEX KRSB_QRTZ_FIRED_TRIGGERS_TI5 
  ON KRSB_QRTZ_FIRED_TRIGGERS 
  (TRIGGER_GROUP);
CREATE INDEX KRSB_QRTZ_FIRED_TRIGGERS_TI6 
  ON KRSB_QRTZ_FIRED_TRIGGERS 
  (INSTANCE_NAME);
CREATE INDEX KRSB_QRTZ_FIRED_TRIGGERS_TI7 
  ON KRSB_QRTZ_FIRED_TRIGGERS 
  (TRIGGER_NAME);
CREATE INDEX KRSB_QRTZ_FIRED_TRIGGERS_TI8 
  ON KRSB_QRTZ_FIRED_TRIGGERS 
  (TRIGGER_NAME, TRIGGER_GROUP);
CREATE INDEX KRSB_QRTZ_FIRED_TRIGGERS_TI9 
  ON KRSB_QRTZ_FIRED_TRIGGERS 
  (IS_VOLATILE);





-----------------------------------------------------------------------------
-- KRSB_QRTZ_JOB_DETAILS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRSB_QRTZ_JOB_DETAILS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRSB_QRTZ_JOB_DETAILS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRSB_QRTZ_JOB_DETAILS
(
      JOB_NAME VARCHAR2(80)
        , JOB_GROUP VARCHAR2(80)
        , DESCRIPTION VARCHAR2(120)
        , JOB_CLASS_NAME VARCHAR2(128) NOT NULL
        , IS_DURABLE VARCHAR2(1) NOT NULL
        , IS_VOLATILE VARCHAR2(1) NOT NULL
        , IS_STATEFUL VARCHAR2(1) NOT NULL
        , REQUESTS_RECOVERY VARCHAR2(1) NOT NULL
        , JOB_DATA BLOB
    

);

ALTER TABLE KRSB_QRTZ_JOB_DETAILS
    ADD CONSTRAINT KRSB_QRTZ_JOB_DETAILSP1
PRIMARY KEY (JOB_NAME,JOB_GROUP);


CREATE INDEX KRSB_QRTZ_JOB_DETAILS_TI1 
  ON KRSB_QRTZ_JOB_DETAILS 
  (REQUESTS_RECOVERY);





-----------------------------------------------------------------------------
-- KRSB_QRTZ_JOB_LISTENERS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRSB_QRTZ_JOB_LISTENERS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRSB_QRTZ_JOB_LISTENERS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRSB_QRTZ_JOB_LISTENERS
(
      JOB_NAME VARCHAR2(80)
        , JOB_GROUP VARCHAR2(80)
        , JOB_LISTENER VARCHAR2(80)
    

);

ALTER TABLE KRSB_QRTZ_JOB_LISTENERS
    ADD CONSTRAINT KRSB_QRTZ_JOB_LISTENERSP1
PRIMARY KEY (JOB_NAME,JOB_GROUP,JOB_LISTENER);







-----------------------------------------------------------------------------
-- KRSB_QRTZ_LOCKS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRSB_QRTZ_LOCKS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRSB_QRTZ_LOCKS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRSB_QRTZ_LOCKS
(
      LOCK_NAME VARCHAR2(40)
    

);

ALTER TABLE KRSB_QRTZ_LOCKS
    ADD CONSTRAINT KRSB_QRTZ_LOCKSP1
PRIMARY KEY (LOCK_NAME);







-----------------------------------------------------------------------------
-- KRSB_QRTZ_PAUSED_TRIGGER_GRPS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRSB_QRTZ_PAUSED_TRIGGER_GRPS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRSB_QRTZ_PAUSED_TRIGGER_GRPS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRSB_QRTZ_PAUSED_TRIGGER_GRPS
(
      TRIGGER_GROUP VARCHAR2(80)
    

);

ALTER TABLE KRSB_QRTZ_PAUSED_TRIGGER_GRPS
    ADD CONSTRAINT KRSB_QRTZ_PAUSED_TRIGGER_GRP1
PRIMARY KEY (TRIGGER_GROUP);







-----------------------------------------------------------------------------
-- KRSB_QRTZ_SCHEDULER_STATE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRSB_QRTZ_SCHEDULER_STATE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRSB_QRTZ_SCHEDULER_STATE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRSB_QRTZ_SCHEDULER_STATE
(
      INSTANCE_NAME VARCHAR2(80)
        , LAST_CHECKIN_TIME NUMBER(13) NOT NULL
        , CHECKIN_INTERVAL NUMBER(13) NOT NULL
    

);

ALTER TABLE KRSB_QRTZ_SCHEDULER_STATE
    ADD CONSTRAINT KRSB_QRTZ_SCHEDULER_STATEP1
PRIMARY KEY (INSTANCE_NAME);







-----------------------------------------------------------------------------
-- KRSB_QRTZ_SIMPLE_TRIGGERS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRSB_QRTZ_SIMPLE_TRIGGERS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRSB_QRTZ_SIMPLE_TRIGGERS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRSB_QRTZ_SIMPLE_TRIGGERS
(
      TRIGGER_NAME VARCHAR2(80)
        , TRIGGER_GROUP VARCHAR2(80)
        , REPEAT_COUNT NUMBER(7) NOT NULL
        , REPEAT_INTERVAL NUMBER(12) NOT NULL
        , TIMES_TRIGGERED NUMBER(7) NOT NULL
    

);

ALTER TABLE KRSB_QRTZ_SIMPLE_TRIGGERS
    ADD CONSTRAINT KRSB_QRTZ_SIMPLE_TRIGGERSP1
PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP);







-----------------------------------------------------------------------------
-- KRSB_QRTZ_TRIGGERS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRSB_QRTZ_TRIGGERS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRSB_QRTZ_TRIGGERS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRSB_QRTZ_TRIGGERS
(
      TRIGGER_NAME VARCHAR2(80)
        , TRIGGER_GROUP VARCHAR2(80)
        , JOB_NAME VARCHAR2(80) NOT NULL
        , JOB_GROUP VARCHAR2(80) NOT NULL
        , IS_VOLATILE VARCHAR2(1) NOT NULL
        , DESCRIPTION VARCHAR2(120)
        , NEXT_FIRE_TIME NUMBER(13)
        , PREV_FIRE_TIME NUMBER(13)
        , PRIORITY NUMBER(13)
        , TRIGGER_STATE VARCHAR2(16) NOT NULL
        , TRIGGER_TYPE VARCHAR2(8) NOT NULL
        , START_TIME NUMBER(13) NOT NULL
        , END_TIME NUMBER(13)
        , CALENDAR_NAME VARCHAR2(80)
        , MISFIRE_INSTR NUMBER(2)
        , JOB_DATA BLOB
    

);

ALTER TABLE KRSB_QRTZ_TRIGGERS
    ADD CONSTRAINT KRSB_QRTZ_TRIGGERSP1
PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP);


CREATE INDEX KRSB_QRTZ_TRIGGERS_TI1 
  ON KRSB_QRTZ_TRIGGERS 
  (NEXT_FIRE_TIME);
CREATE INDEX KRSB_QRTZ_TRIGGERS_TI2 
  ON KRSB_QRTZ_TRIGGERS 
  (NEXT_FIRE_TIME, TRIGGER_STATE);
CREATE INDEX KRSB_QRTZ_TRIGGERS_TI3 
  ON KRSB_QRTZ_TRIGGERS 
  (TRIGGER_STATE);
CREATE INDEX KRSB_QRTZ_TRIGGERS_TI4 
  ON KRSB_QRTZ_TRIGGERS 
  (IS_VOLATILE);





-----------------------------------------------------------------------------
-- KRSB_QRTZ_TRIGGER_LISTENERS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'KRSB_QRTZ_TRIGGER_LISTENERS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE KRSB_QRTZ_TRIGGER_LISTENERS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE KRSB_QRTZ_TRIGGER_LISTENERS
(
      TRIGGER_NAME VARCHAR2(80)
        , TRIGGER_GROUP VARCHAR2(80)
        , TRIGGER_LISTENER VARCHAR2(80)
    

);

ALTER TABLE KRSB_QRTZ_TRIGGER_LISTENERS
    ADD CONSTRAINT KRSB_QRTZ_TRIGGER_LISTENERSP1
PRIMARY KEY (TRIGGER_NAME,TRIGGER_GROUP,TRIGGER_LISTENER);







-----------------------------------------------------------------------------
-- LOCATION_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'LOCATION_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE LOCATION_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE LOCATION_TYPE
(
      LOCATION_TYPE_CODE NUMBER(3)
        , LOCATION_TYPE_DESC VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
    

);

ALTER TABLE LOCATION_TYPE
    ADD CONSTRAINT LOCATION_TYPEP1
PRIMARY KEY (LOCATION_TYPE_CODE);







-----------------------------------------------------------------------------
-- MAIL_BY
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'MAIL_BY';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE MAIL_BY CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE MAIL_BY
(
      MAIL_BY_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE MAIL_BY
    ADD CONSTRAINT MAIL_BYP1
PRIMARY KEY (MAIL_BY_CODE);







-----------------------------------------------------------------------------
-- MAIL_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'MAIL_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE MAIL_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE MAIL_TYPE
(
      MAIL_TYPE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE MAIL_TYPE
    ADD CONSTRAINT MAIL_TYPEP1
PRIMARY KEY (MAIL_TYPE);







-----------------------------------------------------------------------------
-- MEMBERSHIP_ROLE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'MEMBERSHIP_ROLE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE MEMBERSHIP_ROLE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE MEMBERSHIP_ROLE
(
      MEMBERSHIP_ROLE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE MEMBERSHIP_ROLE
    ADD CONSTRAINT MEMBERSHIP_ROLEP1
PRIMARY KEY (MEMBERSHIP_ROLE_CODE);







-----------------------------------------------------------------------------
-- MINUTE_ENTRY_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'MINUTE_ENTRY_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE MINUTE_ENTRY_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE MINUTE_ENTRY_TYPE
(
      MINUTE_ENTRY_TYPE_CODE VARCHAR2(3)
        , SORT_ID NUMBER(3) NOT NULL
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE MINUTE_ENTRY_TYPE
    ADD CONSTRAINT MINUTE_ENTRY_TYPEP1
PRIMARY KEY (MINUTE_ENTRY_TYPE_CODE);







-----------------------------------------------------------------------------
-- MSG_OF_THE_DAY
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'MSG_OF_THE_DAY';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE MSG_OF_THE_DAY CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE MSG_OF_THE_DAY
(
      MSG_OF_THE_DAY_ID NUMBER(12)
        , MSG VARCHAR2(4000)
        , VER_NBR NUMBER(8) NOT NULL
        , DISPLAY_ORDER NUMBER(8) NOT NULL
        , ACTIVE_FLAG VARCHAR2(1) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
    

);

ALTER TABLE MSG_OF_THE_DAY
    ADD CONSTRAINT MSG_OF_THE_DAYP1
PRIMARY KEY (MSG_OF_THE_DAY_ID);







-----------------------------------------------------------------------------
-- NARRATIVE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'NARRATIVE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE NARRATIVE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE NARRATIVE
(
      HIERARCHY_PROPOSAL_NUMBER VARCHAR2(12)
        , HIDE_IN_HIERARCHY CHAR(1) default 'N' NOT NULL
        , PROPOSAL_NUMBER VARCHAR2(12)
        , MODULE_NUMBER NUMBER(4)
        , MODULE_SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , MODULE_TITLE VARCHAR2(150)
        , MODULE_STATUS_CODE VARCHAR2(3) NOT NULL
        , CONTACT_NAME VARCHAR2(30)
        , PHONE_NUMBER VARCHAR2(20)
        , EMAIL_ADDRESS VARCHAR2(60)
        , COMMENTS VARCHAR2(300)
        , FILE_NAME VARCHAR2(150)
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , NARRATIVE_TYPE_CODE VARCHAR2(3) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE NARRATIVE
    ADD CONSTRAINT NARRATIVEP1
PRIMARY KEY (PROPOSAL_NUMBER,MODULE_NUMBER);







-----------------------------------------------------------------------------
-- NARRATIVE_ATTACHMENT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'NARRATIVE_ATTACHMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE NARRATIVE_ATTACHMENT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE NARRATIVE_ATTACHMENT
(
      PROPOSAL_NUMBER VARCHAR2(12)
        , MODULE_NUMBER NUMBER(4)
        , NARRATIVE_DATA BLOB
        , FILE_NAME VARCHAR2(150)
        , CONTENT_TYPE VARCHAR2(255)
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE NARRATIVE_ATTACHMENT
    ADD CONSTRAINT NARRATIVE_ATTACHMENTP1
PRIMARY KEY (PROPOSAL_NUMBER,MODULE_NUMBER);







-----------------------------------------------------------------------------
-- NARRATIVE_STATUS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'NARRATIVE_STATUS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE NARRATIVE_STATUS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE NARRATIVE_STATUS
(
      NARRATIVE_STATUS_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(20) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE NARRATIVE_STATUS
    ADD CONSTRAINT NARRATIVE_STATUSP1
PRIMARY KEY (NARRATIVE_STATUS_CODE);







-----------------------------------------------------------------------------
-- NARRATIVE_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'NARRATIVE_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE NARRATIVE_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE NARRATIVE_TYPE
(
      NARRATIVE_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , SYSTEM_GENERATED VARCHAR2(1) NOT NULL
        , ALLOW_MULTIPLE VARCHAR2(1) NOT NULL
        , NARRATIVE_TYPE_GROUP VARCHAR2(1)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE NARRATIVE_TYPE
    ADD CONSTRAINT NARRATIVE_TYPEP1
PRIMARY KEY (NARRATIVE_TYPE_CODE);







-----------------------------------------------------------------------------
-- NARRATIVE_USER_RIGHTS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'NARRATIVE_USER_RIGHTS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE NARRATIVE_USER_RIGHTS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE NARRATIVE_USER_RIGHTS
(
      PROPOSAL_NUMBER VARCHAR2(12)
        , MODULE_NUMBER NUMBER(4)
        , USER_ID VARCHAR2(40)
        , ACCESS_TYPE CHAR(1) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE NARRATIVE_USER_RIGHTS
    ADD CONSTRAINT NARRATIVE_USER_RIGHTSP1
PRIMARY KEY (PROPOSAL_NUMBER,MODULE_NUMBER,USER_ID);







-----------------------------------------------------------------------------
-- NOTICE_OF_OPPORTUNITY
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'NOTICE_OF_OPPORTUNITY';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE NOTICE_OF_OPPORTUNITY CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE NOTICE_OF_OPPORTUNITY
(
      NOTICE_OF_OPPORTUNITY_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE NOTICE_OF_OPPORTUNITY
    ADD CONSTRAINT NOTICE_OF_OPPORTUNITYP1
PRIMARY KEY (NOTICE_OF_OPPORTUNITY_CODE);







-----------------------------------------------------------------------------
-- NSF_CODES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'NSF_CODES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE NSF_CODES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE NSF_CODES
(
      NSF_SEQUENCE_NUMBER NUMBER(12)
        , NSF_CODE VARCHAR2(15) NOT NULL
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE NSF_CODES
    ADD CONSTRAINT NSF_CODESP1
PRIMARY KEY (NSF_SEQUENCE_NUMBER);







-----------------------------------------------------------------------------
-- ORGANIZATION
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'ORGANIZATION';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE ORGANIZATION CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE ORGANIZATION
(
      ORGANIZATION_ID VARCHAR2(8)
        , ORGANIZATION_NAME VARCHAR2(60) NOT NULL
        , CONTACT_ADDRESS_ID NUMBER(6) NOT NULL
        , ADDRESS VARCHAR2(60)
        , CABLE_ADDRESS VARCHAR2(20)
        , TELEX_NUMBER VARCHAR2(20)
        , COUNTY VARCHAR2(30)
        , CONGRESSIONAL_DISTRICT VARCHAR2(50)
        , INCORPORATED_IN VARCHAR2(50)
        , INCORPORATED_DATE DATE
        , NUMBER_OF_EMPLOYEES NUMBER(6)
        , IRS_TAX_EXCEMPTION VARCHAR2(30)
        , FEDRAL_EMPLOYER_ID VARCHAR2(15)
        , MASS_TAX_EXCEMPT_NUM VARCHAR2(30)
        , AGENCY_SYMBOL VARCHAR2(30)
        , VENDOR_CODE VARCHAR2(30)
        , COM_GOV_ENTITY_CODE VARCHAR2(30)
        , MASS_EMPLOYEE_CLAIM VARCHAR2(30)
        , DUNS_NUMBER VARCHAR2(20)
        , DUNS_PLUS_FOUR_NUMBER VARCHAR2(20)
        , DODAC_NUMBER VARCHAR2(20)
        , CAGE_NUMBER VARCHAR2(20)
        , HUMAN_SUB_ASSURANCE VARCHAR2(30)
        , ANIMAL_WELFARE_ASSURANCE VARCHAR2(20)
        , SCIENCE_MISCONDUCT_COMPL_DATE DATE
        , PHS_ACOUNT VARCHAR2(30)
        , NSF_INSTITUTIONAL_CODE VARCHAR2(30)
        , INDIRECT_COST_RATE_AGREEMENT VARCHAR2(50)
        , COGNIZANT_AUDITOR NUMBER(6)
        , ONR_RESIDENT_REP NUMBER(6)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE ORGANIZATION
    ADD CONSTRAINT ORGANIZATIONP1
PRIMARY KEY (ORGANIZATION_ID);







-----------------------------------------------------------------------------
-- ORGANIZATION_AUDIT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'ORGANIZATION_AUDIT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE ORGANIZATION_AUDIT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE ORGANIZATION_AUDIT
(
      ORGANIZATION_ID VARCHAR2(8)
        , FISCAL_YEAR CHAR(4)
        , AUDIT_ACCEPTED CHAR(1)
        , AUDIT_COMMENT VARCHAR2(300)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE ORGANIZATION_AUDIT
    ADD CONSTRAINT ORGANIZATION_AUDITP1
PRIMARY KEY (ORGANIZATION_ID,FISCAL_YEAR);







-----------------------------------------------------------------------------
-- ORGANIZATION_IDC
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'ORGANIZATION_IDC';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE ORGANIZATION_IDC CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE ORGANIZATION_IDC
(
      ORGANIZATION_ID VARCHAR2(8)
        , IDC_NUMBER NUMBER(3)
        , START_DATE DATE
        , END_DATE DATE
        , REQUESTED_DATE DATE
        , IDC_RATE_TYPE_CODE NUMBER(3)
        , APPLICABLE_IDC_RATE NUMBER(5,2)
        , IDC_COMMENT VARCHAR2(300)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE ORGANIZATION_IDC
    ADD CONSTRAINT ORGANIZATION_IDCP1
PRIMARY KEY (ORGANIZATION_ID,IDC_NUMBER);







-----------------------------------------------------------------------------
-- ORGANIZATION_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'ORGANIZATION_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE ORGANIZATION_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE ORGANIZATION_TYPE
(
      ORGANIZATION_ID VARCHAR2(8)
        , ORGANIZATION_TYPE_CODE NUMBER(3)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE ORGANIZATION_TYPE
    ADD CONSTRAINT ORGANIZATION_TYPEP1
PRIMARY KEY (ORGANIZATION_ID,ORGANIZATION_TYPE_CODE);







-----------------------------------------------------------------------------
-- ORGANIZATION_TYPE_LIST
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'ORGANIZATION_TYPE_LIST';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE ORGANIZATION_TYPE_LIST CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE ORGANIZATION_TYPE_LIST
(
      ORGANIZATION_TYPE_CODE NUMBER(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE ORGANIZATION_TYPE_LIST
    ADD CONSTRAINT ORGANIZATION_TYPE_LISTP1
PRIMARY KEY (ORGANIZATION_TYPE_CODE);







-----------------------------------------------------------------------------
-- ORGANIZATION_YNQ
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'ORGANIZATION_YNQ';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE ORGANIZATION_YNQ CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE ORGANIZATION_YNQ
(
      ORGANIZATION_ID VARCHAR2(8)
        , QUESTION_ID VARCHAR2(4)
        , ANSWER CHAR(1) NOT NULL
        , EXPLANATION VARCHAR2(2000)
        , REVIEW_DATE DATE
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE ORGANIZATION_YNQ
    ADD CONSTRAINT ORGANIZATION_YNQP1
PRIMARY KEY (ORGANIZATION_ID,QUESTION_ID);







-----------------------------------------------------------------------------
-- PENDING_TRANSACTIONS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PENDING_TRANSACTIONS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PENDING_TRANSACTIONS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PENDING_TRANSACTIONS
(
      TRANSACTION_ID NUMBER(10)
        , DOCUMENT_NUMBER VARCHAR2(10) NOT NULL
        , SOURCE_AWARD_NUMBER VARCHAR2(12) NOT NULL
        , DESTINATION_AWARD_NUMBER VARCHAR2(12) NOT NULL
        , OBLIGATED_AMOUNT NUMBER(12,2)
        , ANTICIPATED_AMOUNT NUMBER(12,2)
        , COMMENTS VARCHAR2(2000)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PENDING_TRANSACTIONS
    ADD CONSTRAINT PENDING_TRANSACTIONSP1
PRIMARY KEY (TRANSACTION_ID);







-----------------------------------------------------------------------------
-- PERSON_APPOINTMENT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PERSON_APPOINTMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PERSON_APPOINTMENT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PERSON_APPOINTMENT
(
      APPOINTMENT_ID NUMBER(22)
        , PERSON_ID VARCHAR2(40) NOT NULL
        , UNIT_NUMBER VARCHAR2(8) NOT NULL
        , APPOINTMENT_START_DATE DATE
        , APPOINTMENT_END_DATE DATE
        , APPOINTMENT_TYPE_CODE VARCHAR2(3)
        , JOB_TITLE VARCHAR2(50)
        , PREFERED_JOB_TITLE VARCHAR2(51)
        , JOB_CODE VARCHAR2(6) NOT NULL
        , SALARY NUMBER(12,2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE PERSON_APPOINTMENT
    ADD CONSTRAINT PERSON_APPOINTMENTP1
PRIMARY KEY (APPOINTMENT_ID);







-----------------------------------------------------------------------------
-- PERSON_DEGREE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PERSON_DEGREE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PERSON_DEGREE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PERSON_DEGREE
(
      DEGREE_ID NUMBER(22)
        , PERSON_ID VARCHAR2(40) NOT NULL
        , GRADUATION_YEAR VARCHAR2(4)
        , DEGREE_CODE VARCHAR2(6)
        , DEGREE VARCHAR2(80)
        , FIELD_OF_STUDY VARCHAR2(80)
        , SPECIALIZATION VARCHAR2(80)
        , SCHOOL VARCHAR2(50)
        , SCHOOL_ID_CODE VARCHAR2(3)
        , SCHOOL_ID VARCHAR2(20)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PERSON_DEGREE
    ADD CONSTRAINT PERSON_DEGREEP1
PRIMARY KEY (DEGREE_ID);







-----------------------------------------------------------------------------
-- PERSON_EDITABLE_FIELDS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PERSON_EDITABLE_FIELDS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PERSON_EDITABLE_FIELDS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PERSON_EDITABLE_FIELDS
(
      FIELD_NAME VARCHAR2(255)
        , ACTIVE_FLAG CHAR(1)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PERSON_EDITABLE_FIELDS
    ADD CONSTRAINT PERSON_EDITABLE_FIELDSP1
PRIMARY KEY (FIELD_NAME);







-----------------------------------------------------------------------------
-- PERSON_EXT_T
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PERSON_EXT_T';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PERSON_EXT_T CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PERSON_EXT_T
(
      VER_NBR NUMBER(8) default 1 NOT NULL
        , PERSON_ID VARCHAR2(40)
        , AGE_BY_FISCAL_YEAR NUMBER(3)
        , RACE VARCHAR2(30)
        , EDUCATION_LEVEL VARCHAR2(30)
        , DEGREE VARCHAR2(11)
        , MAJOR VARCHAR2(30)
        , IS_HANDICAPPED CHAR(1)
        , HANDICAP_TYPE VARCHAR2(30)
        , IS_VETERAN CHAR(1)
        , VETERAN_TYPE VARCHAR2(30)
        , VISA_CODE VARCHAR2(20)
        , VISA_TYPE VARCHAR2(30)
        , VISA_RENEWAL_DATE DATE
        , HAS_VISA CHAR(1)
        , OFFICE_LOCATION VARCHAR2(30)
        , SECONDRY_OFFICE_LOCATION VARCHAR2(30)
        , SCHOOL VARCHAR2(50)
        , YEAR_GRADUATED VARCHAR2(30)
        , DIRECTORY_DEPARTMENT VARCHAR2(30)
        , PRIMARY_TITLE VARCHAR2(51)
        , DIRECTORY_TITLE VARCHAR2(50)
        , IS_RESEARCH_STAFF CHAR(1)
        , VACATION_ACCURAL CHAR(1)
        , IS_ON_SABBATICAL CHAR(1)
        , ID_PROVIDED VARCHAR2(30)
        , ID_VERIFIED VARCHAR2(30)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , COUNTY VARCHAR2(30)
        , BIOSKETCH_DESCRIPTION VARCHAR2(4000)
        , BIOSKETCH_FILE BLOB
        , BIOSKETCH_FILENAME VARCHAR2(300)
        , BIOSKETCH_FILE_CONTENT_TYPE VARCHAR2(255)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PERSON_EXT_T
    ADD CONSTRAINT PERSON_EXT_TP1
PRIMARY KEY (PERSON_ID);







-----------------------------------------------------------------------------
-- PERSON_TRAINING
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PERSON_TRAINING';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PERSON_TRAINING CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PERSON_TRAINING
(
      PERSON_TRAINING_ID NUMBER(12)
        , PERSON_ID VARCHAR2(40) NOT NULL
        , TRAINING_NUMBER NUMBER(4) NOT NULL
        , TRAINING_CODE NUMBER(4) NOT NULL
        , DATE_REQUESTED DATE
        , DATE_SUBMITTED DATE
        , DATE_ACKNOWLEDGED DATE
        , FOLLOWUP_DATE DATE
        , SCORE VARCHAR2(9)
        , COMMENTS CLOB
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
        , ACTIVE_FLAG CHAR(1)
    

);

ALTER TABLE PERSON_TRAINING
    ADD CONSTRAINT PERSON_TRAININGP1
PRIMARY KEY (PERSON_TRAINING_ID);


CREATE INDEX UQ_PERSON_TRAINING 
  ON PERSON_TRAINING 
  (PERSON_ID, TRAINING_NUMBER);





-----------------------------------------------------------------------------
-- PROPOSAL
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL
(
      DOCUMENT_NUMBER VARCHAR2(10) NOT NULL
        , CREATE_TIMESTAMP DATE
        , MAIL_DESCRIPTION VARCHAR2(80)
        , PROPOSAL_SEQUENCE_STATUS VARCHAR2(10) NOT NULL
        , FISCAL_MONTH VARCHAR2(2)
        , FISCAL_YEAR VARCHAR2(4)
        , LEAD_UNIT_NUMBER VARCHAR2(8)
        , PROPOSAL_ID NUMBER(12)
        , PROPOSAL_NUMBER VARCHAR2(8) NOT NULL
        , SPONSOR_PROPOSAL_NUMBER VARCHAR2(70)
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , PROPOSAL_TYPE_CODE VARCHAR2(3) NOT NULL
        , CURRENT_ACCOUNT_NUMBER VARCHAR2(7)
        , TITLE VARCHAR2(200) NOT NULL
        , SPONSOR_CODE CHAR(6) NOT NULL
        , ROLODEX_ID NUMBER(6)
        , NOTICE_OF_OPPORTUNITY_CODE VARCHAR2(3)
        , GRAD_STUD_HEADCOUNT NUMBER(3)
        , GRAD_STUD_PERSON_MONTHS NUMBER(5,2)
        , TYPE_OF_ACCOUNT CHAR(1)
        , ACTIVITY_TYPE_CODE VARCHAR2(3) NOT NULL
        , REQUESTED_START_DATE_INITIAL DATE
        , REQUESTED_START_DATE_TOTAL DATE
        , REQUESTED_END_DATE_INITIAL DATE
        , REQUESTED_END_DATE_TOTAL DATE
        , TOTAL_DIRECT_COST_INITIAL NUMBER(12,2)
        , TOTAL_DIRECT_COST_TOTAL NUMBER(12,2)
        , TOTAL_INDIRECT_COST_INITIAL NUMBER(12,2)
        , TOTAL_INDIRECT_COST_TOTAL NUMBER(12,2)
        , NUMBER_OF_COPIES VARCHAR2(7)
        , DEADLINE_DATE DATE
        , DEADLINE_TYPE CHAR(1)
        , MAIL_BY CHAR(1)
        , MAIL_TYPE CHAR(1)
        , MAIL_ACCOUNT_NUMBER CHAR(7)
        , SUBCONTRACT_FLAG CHAR(1) NOT NULL
        , COST_SHARING_INDICATOR CHAR(2) NOT NULL
        , IDC_RATE_INDICATOR CHAR(2) NOT NULL
        , SPECIAL_REVIEW_INDICATOR CHAR(2) NOT NULL
        , STATUS_CODE NUMBER(3) NOT NULL
        , SCIENCE_CODE_INDICATOR CHAR(2) NOT NULL
        , NSF_CODE VARCHAR2(15)
        , PRIME_SPONSOR_CODE CHAR(6)
        , INITIAL_CONTRACT_ADMIN VARCHAR2(40)
        , IP_REVIEW_ACTIVITY_INDICATOR CHAR(2) NOT NULL
        , CURRENT_AWARD_NUMBER VARCHAR2(12)
        , CFDA_NUMBER VARCHAR2(7)
        , OPPORTUNITY VARCHAR2(50)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , AWARD_TYPE_CODE NUMBER(3)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL
    ADD CONSTRAINT PROPOSALP1
PRIMARY KEY (PROPOSAL_ID);


CREATE INDEX UQ_PROPOSAL 
  ON PROPOSAL 
  (PROPOSAL_NUMBER, SEQUENCE_NUMBER);





-----------------------------------------------------------------------------
-- PROPOSAL_ADMIN_DETAILS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_ADMIN_DETAILS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_ADMIN_DETAILS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_ADMIN_DETAILS
(
      PROPOSAL_ADMIN_DETAIL_ID NUMBER(22)
        , DEV_PROPOSAL_NUMBER VARCHAR2(12) NOT NULL
        , INST_PROPOSAL_ID NUMBER(22) NOT NULL
        , DATE_SUBMITTED_BY_DEPT DATE
        , DATE_RETURNED_TO_DEPT DATE
        , DATE_APPROVED_BY_OSP DATE
        , DATE_SUBMITTED_TO_AGENCY DATE
        , INST_PROP_CREATE_DATE DATE
        , INST_PROP_CREATE_USER VARCHAR2(8)
        , SIGNED_BY VARCHAR2(8)
        , SUBMISSION_TYPE CHAR(1)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL_ADMIN_DETAILS
    ADD CONSTRAINT PROPOSAL_ADMIN_DETAILSP1
PRIMARY KEY (PROPOSAL_ADMIN_DETAIL_ID);







-----------------------------------------------------------------------------
-- PROPOSAL_COMMENTS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_COMMENTS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_COMMENTS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_COMMENTS
(
      PROPOSAL_COMMENTS_ID NUMBER(12)
        , PROPOSAL_ID NUMBER(12) NOT NULL
        , PROPOSAL_NUMBER VARCHAR2(8) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , COMMENT_TYPE_CODE VARCHAR2(3) NOT NULL
        , COMMENTS CLOB
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL_COMMENTS
    ADD CONSTRAINT PROPOSAL_COMMENTSP1
PRIMARY KEY (PROPOSAL_COMMENTS_ID);


CREATE INDEX UQ_PROPOSAL_COMMENTS 
  ON PROPOSAL_COMMENTS 
  (PROPOSAL_NUMBER, SEQUENCE_NUMBER, COMMENT_TYPE_CODE);





-----------------------------------------------------------------------------
-- PROPOSAL_COST_SHARING
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_COST_SHARING';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_COST_SHARING CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_COST_SHARING
(
      PROPOSAL_COST_SHARING_ID NUMBER(12)
        , PROPOSAL_ID NUMBER(12) NOT NULL
        , PROPOSAL_NUMBER VARCHAR2(8) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , FISCAL_YEAR CHAR(4) NOT NULL
        , COST_SHARING_PERCENTAGE NUMBER(5,2)
        , COST_SHARING_TYPE_CODE NUMBER(3) NOT NULL
        , SOURCE_ACCOUNT VARCHAR2(32)
        , AMOUNT NUMBER(12,2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL_COST_SHARING
    ADD CONSTRAINT PROPOSAL_COST_SHARINGP1
PRIMARY KEY (PROPOSAL_COST_SHARING_ID);


CREATE INDEX UQ_PROPOSAL_COST_SHARING 
  ON PROPOSAL_COST_SHARING 
  (PROPOSAL_NUMBER, SEQUENCE_NUMBER, FISCAL_YEAR, COST_SHARING_TYPE_CODE, SOURCE_ACCOUNT);





-----------------------------------------------------------------------------
-- PROPOSAL_CUSTOM_DATA
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_CUSTOM_DATA';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_CUSTOM_DATA CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_CUSTOM_DATA
(
      PROPOSAL_CUSTOM_DATA_ID NUMBER(12)
        , PROPOSAL_ID NUMBER(12)
        , PROPOSAL_NUMBER VARCHAR2(10)
        , SEQUENCE_NUMBER NUMBER(8)
        , CUSTOM_ATTRIBUTE_ID NUMBER(12)
        , VALUE VARCHAR2(2000)
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE PROPOSAL_CUSTOM_DATA
    ADD CONSTRAINT PROPOSAL_CUSTOM_DATAP1
PRIMARY KEY (PROPOSAL_CUSTOM_DATA_ID);







-----------------------------------------------------------------------------
-- PROPOSAL_EXEMPT_NUMBER
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_EXEMPT_NUMBER';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_EXEMPT_NUMBER CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_EXEMPT_NUMBER
(
      PROPOSAL_EXEMPT_NUMBER_ID NUMBER(12)
        , PROPOSAL_SPECIAL_REVIEW_ID NUMBER(12)
        , EXEMPTION_TYPE_CODE VARCHAR2(3)
        , UPDATE_USER VARCHAR2(60)
        , UPDATE_TIMESTAMP DATE
        , VER_NBR NUMBER(8) default 1
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL_EXEMPT_NUMBER
    ADD CONSTRAINT PROPOSAL_EXEMPT_NUMBERP1
PRIMARY KEY (PROPOSAL_EXEMPT_NUMBER_ID);







-----------------------------------------------------------------------------
-- PROPOSAL_IDC_RATE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_IDC_RATE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_IDC_RATE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_IDC_RATE
(
      PROPOSAL_ID NUMBER(12) NOT NULL
        , PROPOSAL_IDC_RATE_ID NUMBER(12)
        , PROPOSAL_NUMBER VARCHAR2(8) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , APPLICABLE_IDC_RATE NUMBER(5,2)
        , IDC_RATE_TYPE_CODE NUMBER(3) NOT NULL
        , FISCAL_YEAR CHAR(4) NOT NULL
        , ON_CAMPUS_FLAG CHAR(1) NOT NULL
        , UNDERRECOVERY_OF_IDC NUMBER(12,2)
        , SOURCE_ACCOUNT VARCHAR2(32)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL_IDC_RATE
    ADD CONSTRAINT PROPOSAL_IDC_RATEP1
PRIMARY KEY (PROPOSAL_IDC_RATE_ID);


CREATE INDEX UQ_PROPOSAL_IDC_RATE 
  ON PROPOSAL_IDC_RATE 
  (PROPOSAL_NUMBER, SEQUENCE_NUMBER, APPLICABLE_IDC_RATE, IDC_RATE_TYPE_CODE, FISCAL_YEAR, ON_CAMPUS_FLAG, SOURCE_ACCOUNT);





-----------------------------------------------------------------------------
-- PROPOSAL_INV_CERTIFICATION
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_INV_CERTIFICATION';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_INV_CERTIFICATION CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_INV_CERTIFICATION
(
      PROPOSAL_NUMBER VARCHAR2(12)
        , PROP_PERSON_NUMBER NUMBER(12)
        , CERTIFIED_FLAG CHAR(1)
        , DATE_CERTIFIED DATE
        , DATE_RECEIVED_BY_OSP DATE
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL_INV_CERTIFICATION
    ADD CONSTRAINT PROPOSAL_INV_CERTIFICATIONP1
PRIMARY KEY (PROPOSAL_NUMBER,PROP_PERSON_NUMBER);







-----------------------------------------------------------------------------
-- PROPOSAL_IP_REVIEW_JOIN
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_IP_REVIEW_JOIN';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_IP_REVIEW_JOIN CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_IP_REVIEW_JOIN
(
      PROPOSAL_IP_REVIEW_JOIN_ID NUMBER(12)
        , PROPOSAL_ID NUMBER(12) NOT NULL
        , IP_REVIEW_ID NUMBER(12)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL_IP_REVIEW_JOIN
    ADD CONSTRAINT PROPOSAL_IP_REVIEW_JOINP1
PRIMARY KEY (PROPOSAL_IP_REVIEW_JOIN_ID);







-----------------------------------------------------------------------------
-- PROPOSAL_IP_REV_ACTIVITY
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_IP_REV_ACTIVITY';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_IP_REV_ACTIVITY CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_IP_REV_ACTIVITY
(
      PROPOSAL_IP_REV_ACTIVITY_ID NUMBER(12)
        , PROPOSAL_NUMBER VARCHAR2(8) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , ACTIVITY_NUMBER NUMBER(3) NOT NULL
        , IP_REVIEW_ACTIVITY_TYPE_CODE VARCHAR2(3) NOT NULL
        , ACTIVITY_DATE DATE
        , COMMENTS VARCHAR2(150)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , IP_REVIEW_ID NUMBER(12) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL_IP_REV_ACTIVITY
    ADD CONSTRAINT PROPOSAL_IP_REV_ACTIVITYP1
PRIMARY KEY (PROPOSAL_IP_REV_ACTIVITY_ID);


CREATE INDEX UQ_PROPOSAL_IP_REV_ACTIVITY 
  ON PROPOSAL_IP_REV_ACTIVITY 
  (PROPOSAL_NUMBER, SEQUENCE_NUMBER, ACTIVITY_NUMBER);





-----------------------------------------------------------------------------
-- PROPOSAL_LOG
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_LOG';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_LOG CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_LOG
(
      FISCAL_MONTH NUMBER(2)
        , FISCAL_YEAR NUMBER(4)
        , PI_NAME VARCHAR2(100)
        , PROPOSAL_TYPE_CODE VARCHAR2(3) NOT NULL
        , LOG_STATUS VARCHAR2(3) NOT NULL
        , CREATE_TIMESTAMP DATE NOT NULL
        , CREATE_USER VARCHAR2(60) NOT NULL
        , PI_ID VARCHAR2(40)
        , ROLODEX_ID NUMBER(6)
        , PROPOSAL_LOG_TYPE_CODE VARCHAR2(3)
        , PROPOSAL_NUMBER VARCHAR2(8)
        , TITLE VARCHAR2(200) NOT NULL
        , LEAD_UNIT VARCHAR2(8) NOT NULL
        , SPONSOR_CODE CHAR(6)
        , SPONSOR_NAME VARCHAR2(200)
        , COMMENTS VARCHAR2(300)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , DEADLINE_DATE DATE
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL_LOG
    ADD CONSTRAINT PROPOSAL_LOGP1
PRIMARY KEY (PROPOSAL_NUMBER);







-----------------------------------------------------------------------------
-- PROPOSAL_LOG_STATUS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_LOG_STATUS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_LOG_STATUS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_LOG_STATUS
(
      PROPOSAL_LOG_STATUS_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL_LOG_STATUS
    ADD CONSTRAINT PROPOSAL_LOG_STATUSP1
PRIMARY KEY (PROPOSAL_LOG_STATUS_CODE);







-----------------------------------------------------------------------------
-- PROPOSAL_LOG_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_LOG_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_LOG_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_LOG_TYPE
(
      PROPOSAL_LOG_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL_LOG_TYPE
    ADD CONSTRAINT PROPOSAL_LOG_TYPEP1
PRIMARY KEY (PROPOSAL_LOG_TYPE_CODE);







-----------------------------------------------------------------------------
-- PROPOSAL_NOTEPAD
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_NOTEPAD';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_NOTEPAD CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_NOTEPAD
(
      CREATE_TIMESTAMP DATE NOT NULL
        , NOTE_TOPIC VARCHAR2(60) NOT NULL
        , PROPOSAL_ID NUMBER(12) NOT NULL
        , PROPOSAL_NOTEPAD_ID NUMBER(12)
        , PROPOSAL_NUMBER VARCHAR2(8) NOT NULL
        , ENTRY_NUMBER NUMBER(4) NOT NULL
        , COMMENTS CLOB NOT NULL
        , RESTRICTED_VIEW CHAR(1) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL_NOTEPAD
    ADD CONSTRAINT PROPOSAL_NOTEPADP1
PRIMARY KEY (PROPOSAL_NOTEPAD_ID);







-----------------------------------------------------------------------------
-- PROPOSAL_PERSONS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_PERSONS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_PERSONS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_PERSONS
(
      PROPOSAL_PERSON_ID NUMBER(22)
        , PROPOSAL_ID NUMBER(12) NOT NULL
        , PROPOSAL_NUMBER VARCHAR2(10) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , PERSON_ID VARCHAR2(40)
        , ROLODEX_ID NUMBER(6)
        , FULL_NAME VARCHAR2(90)
        , CONTACT_ROLE_CODE VARCHAR2(12) NOT NULL
        , KEY_PERSON_PROJECT_ROLE VARCHAR2(60)
        , ACADEMIC_YEAR_EFFORT NUMBER(5,2)
        , CALENDAR_YEAR_EFFORT NUMBER(5,2)
        , SUMMER_EFFORT NUMBER(5,2)
        , TOTAL_EFFORT NUMBER(5,2)
        , FACULTY_FLAG CHAR(1) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE PROPOSAL_PERSONS
    ADD CONSTRAINT PROPOSAL_PERSONSP1
PRIMARY KEY (PROPOSAL_PERSON_ID);







-----------------------------------------------------------------------------
-- PROPOSAL_PERSON_UNITS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_PERSON_UNITS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_PERSON_UNITS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_PERSON_UNITS
(
      PROPOSAL_PERSON_ID NUMBER(22) NOT NULL
        , UNIT_NUMBER VARCHAR2(8) NOT NULL
        , LEAD_UNIT_FLAG CHAR(1) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
        , PROPOSAL_PERSON_UNIT_ID NUMBER(22)
    

);

ALTER TABLE PROPOSAL_PERSON_UNITS
    ADD CONSTRAINT PROPOSAL_PERSON_UNITSP1
PRIMARY KEY (PROPOSAL_PERSON_UNIT_ID);







-----------------------------------------------------------------------------
-- PROPOSAL_PERS_UNIT_CRED_SPLITS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_PERS_UNIT_CRED_SPLITS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_PERS_UNIT_CRED_SPLITS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_PERS_UNIT_CRED_SPLITS
(
      PPU_CREDIT_SPLIT_ID NUMBER(22)
        , PROPOSAL_PERSON_UNIT_ID NUMBER(22) NOT NULL
        , INV_CREDIT_TYPE_CODE VARCHAR2(3) NOT NULL
        , CREDIT NUMBER(5,2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE PROPOSAL_PERS_UNIT_CRED_SPLITS
    ADD CONSTRAINT PROPOSAL_PERS_UNIT_CRED_SPLP1
PRIMARY KEY (PPU_CREDIT_SPLIT_ID);







-----------------------------------------------------------------------------
-- PROPOSAL_PER_CREDIT_SPLIT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_PER_CREDIT_SPLIT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_PER_CREDIT_SPLIT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_PER_CREDIT_SPLIT
(
      PROPOSAL_PER_CREDIT_SPLIT_ID NUMBER(22)
        , PROPOSAL_PERSON_ID NUMBER(22) NOT NULL
        , INV_CREDIT_TYPE_CODE VARCHAR2(3) NOT NULL
        , CREDIT NUMBER(5,2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE PROPOSAL_PER_CREDIT_SPLIT
    ADD CONSTRAINT PROPOSAL_PER_CREDIT_SPLITP1
PRIMARY KEY (PROPOSAL_PER_CREDIT_SPLIT_ID);







-----------------------------------------------------------------------------
-- PROPOSAL_RESPONSE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_RESPONSE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_RESPONSE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_RESPONSE
(
      PROPOSAL_RESPONSE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL_RESPONSE
    ADD CONSTRAINT PROPOSAL_RESPONSEP1
PRIMARY KEY (PROPOSAL_RESPONSE_CODE);







-----------------------------------------------------------------------------
-- PROPOSAL_SCIENCE_KEYWORD
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_SCIENCE_KEYWORD';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_SCIENCE_KEYWORD CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_SCIENCE_KEYWORD
(
      PROPOSAL_SCIENCE_KEYWORD_ID NUMBER(12)
        , PROPOSAL_ID NUMBER(12) NOT NULL
        , PROPOSAL_NUMBER VARCHAR2(8) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , SCIENCE_KEYWORD_CODE VARCHAR2(15) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL_SCIENCE_KEYWORD
    ADD CONSTRAINT PROPOSAL_SCIENCE_KEYWORDP1
PRIMARY KEY (PROPOSAL_SCIENCE_KEYWORD_ID);


CREATE INDEX UQ_PROPOSAL_SCIENCE_KEYWORD 
  ON PROPOSAL_SCIENCE_KEYWORD 
  (PROPOSAL_NUMBER, SEQUENCE_NUMBER, SCIENCE_KEYWORD_CODE);





-----------------------------------------------------------------------------
-- PROPOSAL_SPECIAL_REVIEW
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_SPECIAL_REVIEW';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_SPECIAL_REVIEW CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_SPECIAL_REVIEW
(
      EXPIRATION_DATE DATE
        , PROPOSAL_SPECIAL_REVIEW_ID NUMBER(12)
        , PROPOSAL_ID NUMBER(12) NOT NULL
        , PROPOSAL_NUMBER VARCHAR2(8) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , SPECIAL_REVIEW_NUMBER NUMBER(3) NOT NULL
        , SPECIAL_REVIEW_CODE VARCHAR2(3) NOT NULL
        , APPROVAL_TYPE_CODE VARCHAR2(3) NOT NULL
        , PROTOCOL_NUMBER VARCHAR2(20)
        , APPLICATION_DATE DATE
        , APPROVAL_DATE DATE
        , COMMENTS CLOB
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL_SPECIAL_REVIEW
    ADD CONSTRAINT PROPOSAL_SPECIAL_REVIEWP1
PRIMARY KEY (PROPOSAL_SPECIAL_REVIEW_ID);







-----------------------------------------------------------------------------
-- PROPOSAL_STATE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_STATE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_STATE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_STATE
(
      STATE_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL_STATE
    ADD CONSTRAINT PROPOSAL_STATEP1
PRIMARY KEY (STATE_TYPE_CODE);







-----------------------------------------------------------------------------
-- PROPOSAL_STATUS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_STATUS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_STATUS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_STATUS
(
      PROPOSAL_STATUS_CODE NUMBER(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL_STATUS
    ADD CONSTRAINT PROPOSAL_STATUSP1
PRIMARY KEY (PROPOSAL_STATUS_CODE);







-----------------------------------------------------------------------------
-- PROPOSAL_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_TYPE
(
      PROPOSAL_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL_TYPE
    ADD CONSTRAINT PROPOSAL_TYPEP1
PRIMARY KEY (PROPOSAL_TYPE_CODE);







-----------------------------------------------------------------------------
-- PROPOSAL_UNITS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_UNITS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_UNITS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_UNITS
(
      PROPOSAL_NUMBER VARCHAR2(8) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , PERSON_ID VARCHAR2(40) NOT NULL
        , UNIT_NUMBER VARCHAR2(8) NOT NULL
        , LEAD_UNIT_FLAG CHAR(1)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , PROPOSAL_UNITS_ID NUMBER(12)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL_UNITS
    ADD CONSTRAINT PROPOSAL_UNITSP1
PRIMARY KEY (PROPOSAL_UNITS_ID);


CREATE INDEX UQ_PROPOSAL_UNITS 
  ON PROPOSAL_UNITS 
  (PROPOSAL_NUMBER, SEQUENCE_NUMBER, PERSON_ID, UNIT_NUMBER);





-----------------------------------------------------------------------------
-- PROPOSAL_UNIT_CONTACTS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_UNIT_CONTACTS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_UNIT_CONTACTS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_UNIT_CONTACTS
(
      PROPOSAL_UNIT_CONTACT_ID NUMBER(22)
        , PROPOSAL_ID NUMBER(22) NOT NULL
        , PROPOSAL_NUMBER VARCHAR2(10) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , PERSON_ID VARCHAR2(40)
        , FULL_NAME VARCHAR2(90)
        , UNIT_ADMINISTRATOR_TYPE_CODE VARCHAR2(3) NOT NULL
        , UNIT_CONTACT_TYPE VARCHAR2(13) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE PROPOSAL_UNIT_CONTACTS
    ADD CONSTRAINT PROPOSAL_UNIT_CONTACTSP1
PRIMARY KEY (PROPOSAL_UNIT_CONTACT_ID);







-----------------------------------------------------------------------------
-- PROPOSAL_UNIT_CREDIT_SPLIT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROPOSAL_UNIT_CREDIT_SPLIT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROPOSAL_UNIT_CREDIT_SPLIT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROPOSAL_UNIT_CREDIT_SPLIT
(
      PROPOSAL_UNIT_CREDIT_SPLIT_ID NUMBER(12)
        , PROPOSAL_ID NUMBER(12) NOT NULL
        , PROPOSAL_NUMBER VARCHAR2(8) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , PERSON_ID VARCHAR2(40) NOT NULL
        , UNIT_NUMBER VARCHAR2(8) NOT NULL
        , INV_CREDIT_TYPE_CODE VARCHAR2(3) NOT NULL
        , CREDIT NUMBER(5,2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROPOSAL_UNIT_CREDIT_SPLIT
    ADD CONSTRAINT PROPOSAL_UNIT_CREDIT_SPLITP1
PRIMARY KEY (PROPOSAL_UNIT_CREDIT_SPLIT_ID);


CREATE INDEX UQ_PROPOSAL_UNIT_CREDIT_SPLIT 
  ON PROPOSAL_UNIT_CREDIT_SPLIT 
  (PROPOSAL_NUMBER, SEQUENCE_NUMBER, PERSON_ID, UNIT_NUMBER, INV_CREDIT_TYPE_CODE);





-----------------------------------------------------------------------------
-- PROP_ROLE_TEMPLATE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROP_ROLE_TEMPLATE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROP_ROLE_TEMPLATE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROP_ROLE_TEMPLATE
(
      ID NUMBER(8)
        , PERSON_ID VARCHAR2(40) NOT NULL
        , ROLE_NAME VARCHAR2(500) NOT NULL
        , UNIT_NUMBER VARCHAR2(8) NOT NULL
        , ACTIVE_FLAG CHAR(1) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROP_ROLE_TEMPLATE
    ADD CONSTRAINT PROP_ROLE_TEMPLATEP1
PRIMARY KEY (ID);







-----------------------------------------------------------------------------
-- PROTOCOL
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL
(
      ACTIVE CHAR(1) default 'T' NOT NULL
        , PROTOCOL_ID NUMBER(12)
        , DOCUMENT_NUMBER NUMBER(10) NOT NULL
        , PROTOCOL_NUMBER VARCHAR2(20) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , PROTOCOL_TYPE_CODE VARCHAR2(3) NOT NULL
        , PROTOCOL_STATUS_CODE VARCHAR2(3) NOT NULL
        , TITLE VARCHAR2(2000) NOT NULL
        , DESCRIPTION VARCHAR2(2000)
        , APPROVAL_DATE DATE
        , EXPIRATION_DATE DATE
        , LAST_APPROVAL_DATE DATE
        , FDA_APPLICATION_NUMBER VARCHAR2(15)
        , REFERENCE_NUMBER_1 VARCHAR2(50)
        , REFERENCE_NUMBER_2 VARCHAR2(50)
        , SPECIAL_REVIEW_INDICATOR VARCHAR2(2) default 'n0' NOT NULL
        , VULNERABLE_SUBJECT_INDICATOR VARCHAR2(2) default 'n0' NOT NULL
        , KEY_STUDY_PERSON_INDICATOR VARCHAR2(2) default 'n0' NOT NULL
        , FUNDING_SOURCE_INDICATOR VARCHAR2(2) default 'n0' NOT NULL
        , CORRESPONDENT_INDICATOR VARCHAR2(2) default 'n0' NOT NULL
        , REFERENCE_INDICATOR VARCHAR2(2) default 'n0' NOT NULL
        , RELATED_PROJECTS_INDICATOR VARCHAR2(2) default 'n0' NOT NULL
        , CREATE_TIMESTAMP DATE
        , CREATE_USER VARCHAR2(8)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
        , INITIAL_SUBMISSION_DATE DATE
    

);

ALTER TABLE PROTOCOL
    ADD CONSTRAINT PROTOCOLP1
PRIMARY KEY (PROTOCOL_ID);


CREATE INDEX UQ_PROTOCOL 
  ON PROTOCOL 
  (PROTOCOL_NUMBER, SEQUENCE_NUMBER);





-----------------------------------------------------------------------------
-- PROTOCOL_ACTIONS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_ACTIONS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_ACTIONS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_ACTIONS
(
      PROTOCOL_ACTION_ID NUMBER(12)
        , PROTOCOL_NUMBER VARCHAR2(20) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , SUBMISSION_NUMBER NUMBER(4)
        , ACTION_ID NUMBER(6) NOT NULL
        , PROTOCOL_ACTION_TYPE_CODE VARCHAR2(3) NOT NULL
        , PROTOCOL_ID NUMBER(12) NOT NULL
        , SUBMISSION_ID_FK NUMBER(12)
        , COMMENTS VARCHAR2(2000)
        , ACTION_DATE DATE
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , ACTUAL_ACTION_DATE DATE
        , OBJ_ID VARCHAR2(36)
        , PREV_SUBMISSION_STATUS_CODE VARCHAR2(3)
        , SUBMISSION_TYPE_CODE VARCHAR2(3)
        , PREV_PROTOCOL_STATUS_CODE VARCHAR2(3)
    

);

ALTER TABLE PROTOCOL_ACTIONS
    ADD CONSTRAINT PROTOCOL_ACTIONSP1
PRIMARY KEY (PROTOCOL_ACTION_ID);







-----------------------------------------------------------------------------
-- PROTOCOL_ACTION_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_ACTION_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_ACTION_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_ACTION_TYPE
(
      PROTOCOL_ACTION_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , TRIGGER_SUBMISSION CHAR(1) NOT NULL
        , TRIGGER_CORRESPONDENCE CHAR(1) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , FINAL_ACTION_FOR_BATCH_CORRESP CHAR(1) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_ACTION_TYPE
    ADD CONSTRAINT PROTOCOL_ACTION_TYPEP1
PRIMARY KEY (PROTOCOL_ACTION_TYPE_CODE);







-----------------------------------------------------------------------------
-- PROTOCOL_ATTACHMENT_GROUP
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_ATTACHMENT_GROUP';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_ATTACHMENT_GROUP CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_ATTACHMENT_GROUP
(
      GROUP_CD VARCHAR2(3)
        , DESCRIPTION VARCHAR2(300) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_ATTACHMENT_GROUP
    ADD CONSTRAINT PROTOCOL_ATTACHMENT_GROUPP1
PRIMARY KEY (GROUP_CD);







-----------------------------------------------------------------------------
-- PROTOCOL_ATTACHMENT_PERSONNEL
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_ATTACHMENT_PERSONNEL';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_ATTACHMENT_PERSONNEL CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_ATTACHMENT_PERSONNEL
(
      PA_PERSONNEL_ID NUMBER(12)
        , PROTOCOL_ID_FK NUMBER(12) NOT NULL
        , PROTOCOL_NUMBER VARCHAR2(20) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , TYPE_CD VARCHAR2(3) NOT NULL
        , DOCUMENT_ID NUMBER(4) NOT NULL
        , FILE_ID NUMBER(22) NOT NULL
        , DESCRIPTION VARCHAR2(200)
        , PERSON_ID NUMBER(12) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_ATTACHMENT_PERSONNEL
    ADD CONSTRAINT PROTOCOL_ATTACHMENT_PERSONNP1
PRIMARY KEY (PA_PERSONNEL_ID);







-----------------------------------------------------------------------------
-- PROTOCOL_ATTACHMENT_PROTOCOL
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_ATTACHMENT_PROTOCOL';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_ATTACHMENT_PROTOCOL CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_ATTACHMENT_PROTOCOL
(
      PA_PROTOCOL_ID NUMBER(12)
        , PROTOCOL_ID_FK NUMBER(12) NOT NULL
        , PROTOCOL_NUMBER VARCHAR2(20) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , TYPE_CD VARCHAR2(3) NOT NULL
        , DOCUMENT_ID NUMBER(4) NOT NULL
        , FILE_ID NUMBER(22) NOT NULL
        , DESCRIPTION VARCHAR2(200)
        , STATUS_CD VARCHAR2(3)
        , CONTACT_NAME VARCHAR2(30)
        , EMAIL_ADDRESS VARCHAR2(60)
        , PHONE_NUMBER VARCHAR2(20)
        , COMMENTS VARCHAR2(300)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
        , DOCUMENT_STATUS_CODE VARCHAR2(3)
        , CREATE_TIMESTAMP DATE NOT NULL
        , ATTACHMENT_VERSION NUMBER(4)
    

);

ALTER TABLE PROTOCOL_ATTACHMENT_PROTOCOL
    ADD CONSTRAINT PROTOCOL_ATTACHMENT_PROTOCOP1
PRIMARY KEY (PA_PROTOCOL_ID);







-----------------------------------------------------------------------------
-- PROTOCOL_ATTACHMENT_STATUS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_ATTACHMENT_STATUS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_ATTACHMENT_STATUS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_ATTACHMENT_STATUS
(
      STATUS_CD VARCHAR2(3)
        , DESCRIPTION VARCHAR2(300) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_ATTACHMENT_STATUS
    ADD CONSTRAINT PROTOCOL_ATTACHMENT_STATUSP1
PRIMARY KEY (STATUS_CD);







-----------------------------------------------------------------------------
-- PROTOCOL_ATTACHMENT_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_ATTACHMENT_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_ATTACHMENT_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_ATTACHMENT_TYPE
(
      TYPE_CD VARCHAR2(3)
        , DESCRIPTION VARCHAR2(300) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_ATTACHMENT_TYPE
    ADD CONSTRAINT PROTOCOL_ATTACHMENT_TYPEP1
PRIMARY KEY (TYPE_CD);







-----------------------------------------------------------------------------
-- PROTOCOL_ATTACHMENT_TYPE_GROUP
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_ATTACHMENT_TYPE_GROUP';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_ATTACHMENT_TYPE_GROUP CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_ATTACHMENT_TYPE_GROUP
(
      TYPE_GROUP_ID NUMBER(12)
        , TYPE_CD VARCHAR2(3) NOT NULL
        , GROUP_CD VARCHAR2(3) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_ATTACHMENT_TYPE_GROUP
    ADD CONSTRAINT PROTOCOL_ATTACHMENT_TYPE_GRP1
PRIMARY KEY (TYPE_GROUP_ID);







-----------------------------------------------------------------------------
-- PROTOCOL_CONTINGENCY
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_CONTINGENCY';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_CONTINGENCY CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_CONTINGENCY
(
      PROTOCOL_CONTINGENCY_CODE VARCHAR2(4)
        , DESCRIPTION VARCHAR2(2000) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_CONTINGENCY
    ADD CONSTRAINT PROTOCOL_CONTINGENCYP1
PRIMARY KEY (PROTOCOL_CONTINGENCY_CODE);







-----------------------------------------------------------------------------
-- PROTOCOL_CORRESPONDENCE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_CORRESPONDENCE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_CORRESPONDENCE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_CORRESPONDENCE
(
      ID NUMBER(12)
        , PROTOCOL_NUMBER VARCHAR2(20) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , ACTION_ID NUMBER(6) NOT NULL
        , PROTOCOL_ID NUMBER(12) NOT NULL
        , ACTION_ID_FK NUMBER(12) NOT NULL
        , PROTO_CORRESP_TYPE_CODE VARCHAR2(3) NOT NULL
        , FINAL_FLAG CHAR(1) NOT NULL
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , CORRESPONDENCE BLOB NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_CORRESPONDENCE
    ADD CONSTRAINT PROTOCOL_CORRESPONDENCEP1
PRIMARY KEY (ID);







-----------------------------------------------------------------------------
-- PROTOCOL_DOCUMENT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_DOCUMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_DOCUMENT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_DOCUMENT
(
      DOCUMENT_NUMBER NUMBER(10)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , PROTOCOL_WORKFLOW_TYPE VARCHAR2(80)
        , OBJ_ID VARCHAR2(36)
        , REROUTED_FLAG CHAR(1) default 'N' NOT NULL
    

);

ALTER TABLE PROTOCOL_DOCUMENT
    ADD CONSTRAINT PROTOCOL_DOCUMENTP1
PRIMARY KEY (DOCUMENT_NUMBER);







-----------------------------------------------------------------------------
-- PROTOCOL_EXEMPT_CHKLST
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_EXEMPT_CHKLST';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_EXEMPT_CHKLST CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_EXEMPT_CHKLST
(
      PROTOCOL_EXEMPT_CHKLST_ID NUMBER(12)
        , PROTOCOL_ID NUMBER(12) NOT NULL
        , SUBMISSION_ID_FK NUMBER(12) NOT NULL
        , PROTOCOL_NUMBER VARCHAR2(20) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , SUBMISSION_NUMBER NUMBER(4) NOT NULL
        , EXEMPT_STUDIES_CHECKLIST_CODE VARCHAR2(3) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_EXEMPT_CHKLST
    ADD CONSTRAINT PROTOCOL_EXEMPT_CHKLSTP1
PRIMARY KEY (PROTOCOL_EXEMPT_CHKLST_ID);







-----------------------------------------------------------------------------
-- PROTOCOL_EXEMPT_NUMBER
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_EXEMPT_NUMBER';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_EXEMPT_NUMBER CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_EXEMPT_NUMBER
(
      PROTOCOL_EXEMPT_NUMBER_ID NUMBER(12)
        , PROTOCOL_SPECIAL_REVIEW_ID NUMBER(12) NOT NULL
        , EXEMPTION_TYPE_CODE VARCHAR2(3) NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_EXEMPT_NUMBER
    ADD CONSTRAINT PROTOCOL_EXEMPT_NUMBERP1
PRIMARY KEY (PROTOCOL_EXEMPT_NUMBER_ID);







-----------------------------------------------------------------------------
-- PROTOCOL_EXPIDITED_CHKLST
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_EXPIDITED_CHKLST';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_EXPIDITED_CHKLST CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_EXPIDITED_CHKLST
(
      PROTOCOL_EXPEDITED_CHKLST_ID NUMBER(12)
        , PROTOCOL_ID NUMBER(12) NOT NULL
        , SUBMISSION_ID_FK NUMBER(12) NOT NULL
        , PROTOCOL_NUMBER VARCHAR2(20) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , SUBMISSION_NUMBER NUMBER(4) NOT NULL
        , EXPEDITED_REV_CHKLST_CODE VARCHAR2(3) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_EXPIDITED_CHKLST
    ADD CONSTRAINT PROTOCOL_EXPIDITED_CHKLSTP1
PRIMARY KEY (PROTOCOL_EXPEDITED_CHKLST_ID);







-----------------------------------------------------------------------------
-- PROTOCOL_FUNDING_SOURCE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_FUNDING_SOURCE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_FUNDING_SOURCE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_FUNDING_SOURCE
(
      PROTOCOL_FUNDING_SOURCE_ID NUMBER(12)
        , PROTOCOL_ID NUMBER(12) NOT NULL
        , PROTOCOL_NUMBER VARCHAR2(20)
        , SEQUENCE_NUMBER NUMBER(4)
        , FUNDING_SOURCE_TYPE_CODE NUMBER(3) NOT NULL
        , FUNDING_SOURCE VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , FUNDING_SOURCE_NAME VARCHAR2(200)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_FUNDING_SOURCE
    ADD CONSTRAINT PROTOCOL_FUNDING_SOURCEP1
PRIMARY KEY (PROTOCOL_FUNDING_SOURCE_ID);


CREATE INDEX UQ_PROTOCOL_FUNDING_SOURCE 
  ON PROTOCOL_FUNDING_SOURCE 
  (PROTOCOL_ID, FUNDING_SOURCE_TYPE_CODE, FUNDING_SOURCE);





-----------------------------------------------------------------------------
-- PROTOCOL_LOCATION
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_LOCATION';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_LOCATION CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_LOCATION
(
      PROTOCOL_LOCATION_ID NUMBER(12)
        , PROTOCOL_ID NUMBER(12) NOT NULL
        , PROTOCOL_NUMBER VARCHAR2(20) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , PROTOCOL_ORG_TYPE_CODE VARCHAR2(3) NOT NULL
        , ORGANIZATION_ID VARCHAR2(8) NOT NULL
        , ROLODEX_ID NUMBER(6)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_LOCATION
    ADD CONSTRAINT PROTOCOL_LOCATIONP1
PRIMARY KEY (PROTOCOL_LOCATION_ID);


CREATE INDEX UQ_PROTOCOL_LOCATION 
  ON PROTOCOL_LOCATION 
  (PROTOCOL_ORG_TYPE_CODE, ORGANIZATION_ID, PROTOCOL_ID);





-----------------------------------------------------------------------------
-- PROTOCOL_MODULES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_MODULES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_MODULES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_MODULES
(
      PROTOCOL_MODULE_CODE VARCHAR2(5)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_MODULES
    ADD CONSTRAINT PROTOCOL_MODULESP1
PRIMARY KEY (PROTOCOL_MODULE_CODE);







-----------------------------------------------------------------------------
-- PROTOCOL_NOTEPAD
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_NOTEPAD';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_NOTEPAD CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_NOTEPAD
(
      PROTOCOL_NOTEPAD_ID NUMBER(12)
        , PROTOCOL_ID_FK NUMBER(12) NOT NULL
        , PROTOCOL_NUMBER VARCHAR2(20) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , ENTRY_NUMBER NUMBER(4) NOT NULL
        , COMMENTS CLOB
        , RESTRICTED_VIEW CHAR(1) NOT NULL
        , NOTE_TYPE VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_NOTEPAD
    ADD CONSTRAINT PROTOCOL_NOTEPADP1
PRIMARY KEY (PROTOCOL_NOTEPAD_ID);


CREATE INDEX UQ_PROTOCOL_NOTEPAD 
  ON PROTOCOL_NOTEPAD 
  (PROTOCOL_NUMBER, ENTRY_NUMBER);





-----------------------------------------------------------------------------
-- PROTOCOL_ONLN_RVWS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_ONLN_RVWS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_ONLN_RVWS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_ONLN_RVWS
(
      PROTOCOL_ONLN_RVW_ID NUMBER(12)
        , DOCUMENT_NUMBER NUMBER(12) NOT NULL
        , PROTOCOL_ID NUMBER(12)
        , SUBMISSION_ID_FK NUMBER(12)
        , PROTOCOL_REVIEWER_FK NUMBER(12) NOT NULL
        , PROTOCOL_ONLN_RVW_STATUS_CODE VARCHAR2(3) NOT NULL
        , REVIEW_DETERM_RECOM_CD NUMBER(3)
        , DATE_REQUESTED DATE NOT NULL
        , DATE_DUE DATE
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    
    , CONSTRAINT UQ1_PROTOCOL_ONLN_RVWS UNIQUE (PROTOCOL_ID, SUBMISSION_ID_FK, PROTOCOL_REVIEWER_FK)

);

ALTER TABLE PROTOCOL_ONLN_RVWS
    ADD CONSTRAINT PROTOCOL_ONLN_RVWSP1
PRIMARY KEY (PROTOCOL_ONLN_RVW_ID);







-----------------------------------------------------------------------------
-- PROTOCOL_ONLN_RVW_DETERM_RECOM
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_ONLN_RVW_DETERM_RECOM';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_ONLN_RVW_DETERM_RECOM CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_ONLN_RVW_DETERM_RECOM
(
      REVIEW_DETERM_RECOM_CD NUMBER(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE PROTOCOL_ONLN_RVW_DETERM_RECOM
    ADD CONSTRAINT PROTOCOL_ONLN_RVW_DETERM_REP1
PRIMARY KEY (REVIEW_DETERM_RECOM_CD);







-----------------------------------------------------------------------------
-- PROTOCOL_ONLN_RVW_DOCUMENT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_ONLN_RVW_DOCUMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_ONLN_RVW_DOCUMENT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_ONLN_RVW_DOCUMENT
(
      DOCUMENT_NUMBER NUMBER(10)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
    

);

ALTER TABLE PROTOCOL_ONLN_RVW_DOCUMENT
    ADD CONSTRAINT PROTOCOL_ONLN_RVW_DOCUMENTP1
PRIMARY KEY (DOCUMENT_NUMBER);







-----------------------------------------------------------------------------
-- PROTOCOL_ONLN_RVW_STATUS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_ONLN_RVW_STATUS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_ONLN_RVW_STATUS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_ONLN_RVW_STATUS
(
      STATUS_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE PROTOCOL_ONLN_RVW_STATUS
    ADD CONSTRAINT PROTOCOL_ONLN_RVW_STATUSP1
PRIMARY KEY (STATUS_CODE);







-----------------------------------------------------------------------------
-- PROTOCOL_ORG_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_ORG_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_ORG_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_ORG_TYPE
(
      PROTOCOL_ORG_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_ORG_TYPE
    ADD CONSTRAINT PROTOCOL_ORG_TYPEP1
PRIMARY KEY (PROTOCOL_ORG_TYPE_CODE);







-----------------------------------------------------------------------------
-- PROTOCOL_PERSONS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_PERSONS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_PERSONS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_PERSONS
(
      PROTOCOL_PERSON_ID NUMBER(12)
        , PROTOCOL_ID NUMBER(12) NOT NULL
        , PROTOCOL_NUMBER VARCHAR2(20) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , PERSON_ID VARCHAR2(40)
        , PERSON_NAME VARCHAR2(90) NOT NULL
        , PROTOCOL_PERSON_ROLE_ID VARCHAR2(12)
        , ROLODEX_ID NUMBER(12)
        , AFFILIATION_TYPE_CODE NUMBER(3)
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
        , COMMENTS CLOB
    

);

ALTER TABLE PROTOCOL_PERSONS
    ADD CONSTRAINT PROTOCOL_PERSONSP1
PRIMARY KEY (PROTOCOL_PERSON_ID);







-----------------------------------------------------------------------------
-- PROTOCOL_PERSON_ROLES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_PERSON_ROLES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_PERSON_ROLES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_PERSON_ROLES
(
      PROTOCOL_PERSON_ROLE_ID VARCHAR2(12)
        , DESCRIPTION VARCHAR2(250) NOT NULL
        , UNIT_DETAILS_REQUIRED CHAR(1) default 'N' NOT NULL
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , AFFILIATION_DETAILS_REQUIRED CHAR(1) default 'N' NOT NULL
        , TRAINING_DETAILS_REQUIRED CHAR(1) default 'N' NOT NULL
        , OBJ_ID VARCHAR2(36)
        , COMMENTS_DETAILS_REQUIRED CHAR(1) default 'N' NOT NULL
    

);

ALTER TABLE PROTOCOL_PERSON_ROLES
    ADD CONSTRAINT PROTOCOL_PERSON_ROLESP1
PRIMARY KEY (PROTOCOL_PERSON_ROLE_ID);







-----------------------------------------------------------------------------
-- PROTOCOL_PERSON_ROLE_MAPPING
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_PERSON_ROLE_MAPPING';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_PERSON_ROLE_MAPPING CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_PERSON_ROLE_MAPPING
(
      ROLE_MAPPING_ID NUMBER(12)
        , SOURCE_ROLE_ID VARCHAR2(12) NOT NULL
        , TARGET_ROLE_ID VARCHAR2(12) NOT NULL
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_PERSON_ROLE_MAPPING
    ADD CONSTRAINT PROTOCOL_PERSON_ROLE_MAPPINP1
PRIMARY KEY (ROLE_MAPPING_ID);


CREATE INDEX UQ_PERSON_MAPPING 
  ON PROTOCOL_PERSON_ROLE_MAPPING 
  (SOURCE_ROLE_ID, TARGET_ROLE_ID);





-----------------------------------------------------------------------------
-- PROTOCOL_REFERENCES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_REFERENCES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_REFERENCES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_REFERENCES
(
      PROTOCOL_REFERENCE_ID NUMBER(12)
        , PROTOCOL_ID NUMBER(12) NOT NULL
        , PROTOCOL_NUMBER VARCHAR2(20) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , PROTOCOL_REFERENCE_NUMBER NUMBER(12) NOT NULL
        , PROTOCOL_REFERENCE_TYPE_CODE NUMBER(3) NOT NULL
        , REFERENCE_KEY VARCHAR2(50) NOT NULL
        , APPLICATION_DATE DATE
        , APPROVAL_DATE DATE
        , COMMENTS CLOB
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_REFERENCES
    ADD CONSTRAINT PROTOCOL_REFERENCESP1
PRIMARY KEY (PROTOCOL_REFERENCE_ID);







-----------------------------------------------------------------------------
-- PROTOCOL_REFERENCE_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_REFERENCE_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_REFERENCE_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_REFERENCE_TYPE
(
      PROTOCOL_REFERENCE_TYPE_CODE NUMBER(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
        , ACTIVE_FLAG CHAR(1)
    

);

ALTER TABLE PROTOCOL_REFERENCE_TYPE
    ADD CONSTRAINT PROTOCOL_REFERENCE_TYPEP1
PRIMARY KEY (PROTOCOL_REFERENCE_TYPE_CODE);







-----------------------------------------------------------------------------
-- PROTOCOL_RESEARCH_AREAS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_RESEARCH_AREAS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_RESEARCH_AREAS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_RESEARCH_AREAS
(
      ID NUMBER(12)
        , PROTOCOL_ID NUMBER(12) NOT NULL
        , PROTOCOL_NUMBER VARCHAR2(20) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , RESEARCH_AREA_CODE VARCHAR2(8) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_RESEARCH_AREAS
    ADD CONSTRAINT PROTOCOL_RESEARCH_AREASP1
PRIMARY KEY (ID);







-----------------------------------------------------------------------------
-- PROTOCOL_REVIEWERS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_REVIEWERS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_REVIEWERS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_REVIEWERS
(
      PROTOCOL_REVIEWER_ID NUMBER(12)
        , PROTOCOL_ID NUMBER(12) NOT NULL
        , SUBMISSION_ID_FK NUMBER(12) NOT NULL
        , PROTOCOL_NUMBER VARCHAR2(20) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , SUBMISSION_NUMBER NUMBER(4) NOT NULL
        , PERSON_ID VARCHAR2(40)
        , NON_EMPLOYEE_FLAG CHAR(1) NOT NULL
        , REVIEWER_TYPE_CODE VARCHAR2(3) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
        , ROLODEX_ID NUMBER(12)
    

);

ALTER TABLE PROTOCOL_REVIEWERS
    ADD CONSTRAINT PROTOCOL_REVIEWERSP1
PRIMARY KEY (PROTOCOL_REVIEWER_ID);







-----------------------------------------------------------------------------
-- PROTOCOL_REVIEWER_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_REVIEWER_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_REVIEWER_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_REVIEWER_TYPE
(
      REVIEWER_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_REVIEWER_TYPE
    ADD CONSTRAINT PROTOCOL_REVIEWER_TYPEP1
PRIMARY KEY (REVIEWER_TYPE_CODE);







-----------------------------------------------------------------------------
-- PROTOCOL_REVIEW_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_REVIEW_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_REVIEW_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_REVIEW_TYPE
(
      PROTOCOL_REVIEW_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_REVIEW_TYPE
    ADD CONSTRAINT PROTOCOL_REVIEW_TYPEP1
PRIMARY KEY (PROTOCOL_REVIEW_TYPE_CODE);







-----------------------------------------------------------------------------
-- PROTOCOL_RISK_LEVELS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_RISK_LEVELS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_RISK_LEVELS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_RISK_LEVELS
(
      PROTOCOL_NUMBER VARCHAR2(20) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , RISK_LEVEL_CODE VARCHAR2(3) NOT NULL
        , COMMENTS VARCHAR2(2000)
        , DATE_ASSIGNED DATE NOT NULL
        , DATE_INACTIVATED DATE
        , STATUS CHAR(1) NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , PROTOCOL_RISK_LEVELS_ID NUMBER(12)
        , PROTOCOL_ID NUMBER(12) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_RISK_LEVELS
    ADD CONSTRAINT PROTOCOL_RISK_LEVELSP1
PRIMARY KEY (PROTOCOL_RISK_LEVELS_ID);


CREATE INDEX UQ_PROTOCOL_RISK_LEVELS 
  ON PROTOCOL_RISK_LEVELS 
  (PROTOCOL_NUMBER, SEQUENCE_NUMBER, RISK_LEVEL_CODE);





-----------------------------------------------------------------------------
-- PROTOCOL_SPECIAL_REVIEW
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_SPECIAL_REVIEW';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_SPECIAL_REVIEW CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_SPECIAL_REVIEW
(
      PROTOCOL_SPECIAL_REVIEW_ID NUMBER(12)
        , PROTOCOL_ID NUMBER(12) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , SPECIAL_REVIEW_NUMBER NUMBER(3) NOT NULL
        , SPECIAL_REVIEW_CODE NUMBER(3) NOT NULL
        , APPROVAL_TYPE_CODE NUMBER(3) NOT NULL
        , PROTOCOL_NUMBER VARCHAR2(20)
        , APPLICATION_DATE DATE
        , APPROVAL_DATE DATE
        , EXPIRATION_DATE DATE
        , COMMENTS CLOB
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_SPECIAL_REVIEW
    ADD CONSTRAINT PROTOCOL_SPECIAL_REVIEWP1
PRIMARY KEY (PROTOCOL_SPECIAL_REVIEW_ID);







-----------------------------------------------------------------------------
-- PROTOCOL_STATUS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_STATUS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_STATUS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_STATUS
(
      PROTOCOL_STATUS_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_STATUS
    ADD CONSTRAINT PROTOCOL_STATUSP1
PRIMARY KEY (PROTOCOL_STATUS_CODE);







-----------------------------------------------------------------------------
-- PROTOCOL_SUBMISSION
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_SUBMISSION';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_SUBMISSION CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_SUBMISSION
(
      SUBMISSION_ID NUMBER(12)
        , PROTOCOL_NUMBER VARCHAR2(20) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , SUBMISSION_NUMBER NUMBER(4) NOT NULL
        , SCHEDULE_ID VARCHAR2(10)
        , COMMITTEE_ID VARCHAR2(15)
        , PROTOCOL_ID NUMBER(12) NOT NULL
        , SCHEDULE_ID_FK NUMBER(12)
        , COMMITTEE_ID_FK NUMBER(12)
        , SUBMISSION_TYPE_CODE VARCHAR2(3) NOT NULL
        , SUBMISSION_TYPE_QUAL_CODE VARCHAR2(3)
        , SUBMISSION_STATUS_CODE VARCHAR2(3) NOT NULL
        , PROTOCOL_REVIEW_TYPE_CODE VARCHAR2(3) NOT NULL
        , SUBMISSION_DATE DATE NOT NULL
        , COMMENTS VARCHAR2(2000)
        , YES_VOTE_COUNT NUMBER(3)
        , NO_VOTE_COUNT NUMBER(3)
        , ABSTAINER_COUNT NUMBER(3)
        , VOTING_COMMENTS VARCHAR2(2000)
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
        , RECUSED_COUNT NUMBER(3)
        , IS_BILLABLE VARCHAR2(1) default 'N' NOT NULL
        , COMM_DECISION_MOTION_TYPE_CODE VARCHAR2(3)
    

);

ALTER TABLE PROTOCOL_SUBMISSION
    ADD CONSTRAINT PROTOCOL_SUBMISSIONP1
PRIMARY KEY (SUBMISSION_ID);







-----------------------------------------------------------------------------
-- PROTOCOL_SUBMISSION_DOC
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_SUBMISSION_DOC';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_SUBMISSION_DOC CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_SUBMISSION_DOC
(
      SUBMISSION_DOC_ID NUMBER(12)
        , PROTOCOL_NUMBER VARCHAR2(20) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , SUBMISSION_NUMBER NUMBER(4) NOT NULL
        , PROTOCOL_ID NUMBER(12) NOT NULL
        , SUBMISSION_ID_FK NUMBER(12) NOT NULL
        , DOCUMENT_ID NUMBER(3) NOT NULL
        , FILE_NAME VARCHAR2(300)
        , DOCUMENT BLOB
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
        , DESCRIPTION VARCHAR2(200)
        , CONTENT_TYPE VARCHAR2(255)
    

);

ALTER TABLE PROTOCOL_SUBMISSION_DOC
    ADD CONSTRAINT PROTOCOL_SUBMISSION_DOCP1
PRIMARY KEY (SUBMISSION_DOC_ID);







-----------------------------------------------------------------------------
-- PROTOCOL_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_TYPE
(
      PROTOCOL_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_TYPE
    ADD CONSTRAINT PROTOCOL_TYPEP1
PRIMARY KEY (PROTOCOL_TYPE_CODE);







-----------------------------------------------------------------------------
-- PROTOCOL_UNITS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_UNITS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_UNITS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_UNITS
(
      PROTOCOL_PERSON_ID NUMBER(12) NOT NULL
        , PROTOCOL_UNITS_ID NUMBER(12)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , PROTOCOL_NUMBER VARCHAR2(20)
        , SEQUENCE_NUMBER NUMBER(4)
        , UNIT_NUMBER VARCHAR2(8) NOT NULL
        , LEAD_UNIT_FLAG VARCHAR2(1) NOT NULL
        , PERSON_ID VARCHAR2(40)
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_UNITS
    ADD CONSTRAINT PROTOCOL_UNITSP1
PRIMARY KEY (PROTOCOL_UNITS_ID);


CREATE INDEX UQ_PROTOCOL_UNITS 
  ON PROTOCOL_UNITS 
  (UNIT_NUMBER, PERSON_ID, PROTOCOL_PERSON_ID);





-----------------------------------------------------------------------------
-- PROTOCOL_VOTE_ABSTAINEES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_VOTE_ABSTAINEES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_VOTE_ABSTAINEES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_VOTE_ABSTAINEES
(
      PROTOCOL_VOTE_ABSTAINEES_ID NUMBER(12)
        , PROTOCOL_ID_FK NUMBER(12) NOT NULL
        , PERSON_ID VARCHAR2(40)
        , NON_EMPLOYEE_FLAG VARCHAR2(1) NOT NULL
        , COMMENTS VARCHAR2(2000)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
        , SUBMISSION_ID_FK NUMBER(12) NOT NULL
        , ROLODEX_ID NUMBER(12)
    

);

ALTER TABLE PROTOCOL_VOTE_ABSTAINEES
    ADD CONSTRAINT PROTOCOL_VOTE_ABSTAINEESP1
PRIMARY KEY (PROTOCOL_VOTE_ABSTAINEES_ID);







-----------------------------------------------------------------------------
-- PROTOCOL_VOTE_RECUSED
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_VOTE_RECUSED';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_VOTE_RECUSED CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_VOTE_RECUSED
(
      PROTOCOL_VOTE_RECUSED_ID NUMBER(12)
        , PROTOCOL_ID_FK NUMBER(12) NOT NULL
        , SUBMISSION_ID_FK NUMBER(12) NOT NULL
        , PERSON_ID VARCHAR2(40)
        , ROLODEX_ID NUMBER(12)
        , NON_EMPLOYEE_FLAG VARCHAR2(1) NOT NULL
        , COMMENTS VARCHAR2(2000)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_VOTE_RECUSED
    ADD CONSTRAINT PROTOCOL_VOTE_RECUSEDP1
PRIMARY KEY (PROTOCOL_VOTE_RECUSED_ID);







-----------------------------------------------------------------------------
-- PROTOCOL_VULNERABLE_SUB
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTOCOL_VULNERABLE_SUB';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTOCOL_VULNERABLE_SUB CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTOCOL_VULNERABLE_SUB
(
      PROTOCOL_VULNERABLE_SUB_ID NUMBER(12)
        , PROTOCOL_ID NUMBER(12) NOT NULL
        , PROTOCOL_NUMBER VARCHAR2(20) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , VULNERABLE_SUBJECT_TYPE_CODE VARCHAR2(3) NOT NULL
        , SUBJECT_COUNT NUMBER(6)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTOCOL_VULNERABLE_SUB
    ADD CONSTRAINT PROTOCOL_VULNERABLE_SUBP1
PRIMARY KEY (PROTOCOL_VULNERABLE_SUB_ID);


CREATE INDEX UQ_PROTOCOL_VULNERABLE_SUB 
  ON PROTOCOL_VULNERABLE_SUB 
  (PROTOCOL_ID, VULNERABLE_SUBJECT_TYPE_CODE);





-----------------------------------------------------------------------------
-- PROTO_AMEND_RENEWAL
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTO_AMEND_RENEWAL';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTO_AMEND_RENEWAL CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTO_AMEND_RENEWAL
(
      PROTO_AMEND_RENEWAL_ID NUMBER(12)
        , PROTO_AMEND_REN_NUMBER VARCHAR2(20) NOT NULL
        , DATE_CREATED DATE NOT NULL
        , SUMMARY CLOB
        , PROTOCOL_ID NUMBER(12) NOT NULL
        , PROTOCOL_NUMBER VARCHAR2(20)
        , SEQUENCE_NUMBER NUMBER(4)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTO_AMEND_RENEWAL
    ADD CONSTRAINT PROTO_AMEND_RENEWALP1
PRIMARY KEY (PROTO_AMEND_RENEWAL_ID);







-----------------------------------------------------------------------------
-- PROTO_AMEND_RENEW_MODULES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTO_AMEND_RENEW_MODULES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTO_AMEND_RENEW_MODULES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTO_AMEND_RENEW_MODULES
(
      PROTO_AMEND_RENEW_MODULES_ID NUMBER(12)
        , PROTO_AMEND_RENEWAL_NUMBER VARCHAR2(20) NOT NULL
        , PROTO_AMEND_RENEWAL_ID NUMBER(12) NOT NULL
        , PROTOCOL_NUMBER VARCHAR2(20) NOT NULL
        , PROTOCOL_MODULE_CODE VARCHAR2(5) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTO_AMEND_RENEW_MODULES
    ADD CONSTRAINT PROTO_AMEND_RENEW_MODULESP1
PRIMARY KEY (PROTO_AMEND_RENEW_MODULES_ID);







-----------------------------------------------------------------------------
-- PROTO_CORRESP_TEMPL
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTO_CORRESP_TEMPL';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTO_CORRESP_TEMPL CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTO_CORRESP_TEMPL
(
      PROTO_CORRESP_TEMPL_ID NUMBER(12)
        , PROTO_CORRESP_TYPE_CODE VARCHAR2(3) NOT NULL
        , COMMITTEE_ID VARCHAR2(15) NOT NULL
        , FILE_NAME VARCHAR2(150) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
        , CORRESPONDENCE_TEMPLATE CLOB
    
    , CONSTRAINT UQ_PROTO_CORRESP_TEMPL UNIQUE (PROTO_CORRESP_TYPE_CODE, COMMITTEE_ID)

);

ALTER TABLE PROTO_CORRESP_TEMPL
    ADD CONSTRAINT PROTO_CORRESP_TEMPLP1
PRIMARY KEY (PROTO_CORRESP_TEMPL_ID);







-----------------------------------------------------------------------------
-- PROTO_CORRESP_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTO_CORRESP_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTO_CORRESP_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTO_CORRESP_TYPE
(
      PROTO_CORRESP_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , MODULE_ID VARCHAR2(1) default 'Y' NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE PROTO_CORRESP_TYPE
    ADD CONSTRAINT PROTO_CORRESP_TYPEP1
PRIMARY KEY (PROTO_CORRESP_TYPE_CODE);







-----------------------------------------------------------------------------
-- PROTO_NOTIFICATION_TEMPL
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'PROTO_NOTIFICATION_TEMPL';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE PROTO_NOTIFICATION_TEMPL CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE PROTO_NOTIFICATION_TEMPL
(
      NOTIFICATION_TEMPL_ID NUMBER(12)
        , ACTION_TYPE_CODE VARCHAR2(3) NOT NULL
        , FILE_NAME VARCHAR2(150) NOT NULL
        , NOTIFICATION_TEMPLATE BLOB NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);

ALTER TABLE PROTO_NOTIFICATION_TEMPL
    ADD CONSTRAINT PROTO_NOTIFICATION_TEMPLP1
PRIMARY KEY (NOTIFICATION_TEMPL_ID);







-----------------------------------------------------------------------------
-- QUESTION
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'QUESTION';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE QUESTION CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE QUESTION
(
      QUESTION_REF_ID NUMBER(12)
        , QUESTION_ID NUMBER(6) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , SEQUENCE_STATUS CHAR(1) NOT NULL
        , QUESTION VARCHAR2(2000) NOT NULL
        , STATUS CHAR(1) NOT NULL
        , GROUP_TYPE_CODE NUMBER(3) NOT NULL
        , QUESTION_TYPE_ID NUMBER(12) NOT NULL
        , LOOKUP_CLASS VARCHAR2(100)
        , LOOKUP_RETURN VARCHAR2(30)
        , DISPLAYED_ANSWERS NUMBER(2)
        , MAX_ANSWERS NUMBER(2)
        , ANSWER_MAX_LENGTH NUMBER(4)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE QUESTION
    ADD CONSTRAINT QUESTIONP1
PRIMARY KEY (QUESTION_REF_ID);


CREATE INDEX UQ_QUESTION_ID 
  ON QUESTION 
  (QUESTION_ID, SEQUENCE_NUMBER);





-----------------------------------------------------------------------------
-- QUESTIONNAIRE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'QUESTIONNAIRE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE QUESTIONNAIRE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE QUESTIONNAIRE
(
      QUESTIONNAIRE_REF_ID NUMBER(12)
        , QUESTIONNAIRE_ID NUMBER(6) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , NAME VARCHAR2(50) NOT NULL
        , DESCRIPTION VARCHAR2(2000)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , IS_FINAL VARCHAR2(1) NOT NULL
        , DOCUMENT_NUMBER NUMBER(10)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE QUESTIONNAIRE
    ADD CONSTRAINT QUESTIONNAIREP1
PRIMARY KEY (QUESTIONNAIRE_REF_ID);







-----------------------------------------------------------------------------
-- QUESTIONNAIRE_ANSWER
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'QUESTIONNAIRE_ANSWER';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE QUESTIONNAIRE_ANSWER CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE QUESTIONNAIRE_ANSWER
(
      QUESTIONNAIRE_ANSWER_ID NUMBER(12)
        , QUESTIONNAIRE_AH_ID_FK NUMBER(12) NOT NULL
        , QUESTION_REF_ID_FK NUMBER(12) NOT NULL
        , QUESTION_NUMBER NUMBER(6) NOT NULL
        , ANSWER_NUMBER NUMBER(3) NOT NULL
        , ANSWER VARCHAR2(2000)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , QUESTIONNAIRE_QUESTIONS_ID_FK NUMBER(12) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE QUESTIONNAIRE_ANSWER
    ADD CONSTRAINT QUESTIONNAIRE_ANSWERP1
PRIMARY KEY (QUESTIONNAIRE_ANSWER_ID);


CREATE INDEX UQ_QUESTIONNAIRE_ANSWER 
  ON QUESTIONNAIRE_ANSWER 
  (QUESTIONNAIRE_AH_ID_FK, QUESTION_NUMBER, ANSWER_NUMBER);





-----------------------------------------------------------------------------
-- QUESTIONNAIRE_ANSWER_HEADER
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'QUESTIONNAIRE_ANSWER_HEADER';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE QUESTIONNAIRE_ANSWER_HEADER CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE QUESTIONNAIRE_ANSWER_HEADER
(
      QUESTIONNAIRE_ANSWER_HEADER_ID NUMBER(12)
        , QUESTIONNAIRE_REF_ID_FK NUMBER(12) NOT NULL
        , MODULE_ITEM_CODE VARCHAR2(3) NOT NULL
        , MODULE_ITEM_KEY VARCHAR2(20) NOT NULL
        , MODULE_SUB_ITEM_CODE NUMBER(3) NOT NULL
        , MODULE_SUB_ITEM_KEY VARCHAR2(20) NOT NULL
        , QUESTIONNAIRE_COMPLETED_FLAG VARCHAR2(1) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE QUESTIONNAIRE_ANSWER_HEADER
    ADD CONSTRAINT QUESTIONNAIRE_ANSWER_HEADERP1
PRIMARY KEY (QUESTIONNAIRE_ANSWER_HEADER_ID);







-----------------------------------------------------------------------------
-- QUESTIONNAIRE_QUESTIONS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'QUESTIONNAIRE_QUESTIONS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE QUESTIONNAIRE_QUESTIONS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE QUESTIONNAIRE_QUESTIONS
(
      QUESTIONNAIRE_QUESTIONS_ID NUMBER(12)
        , QUESTIONNAIRE_REF_ID_FK NUMBER(12) NOT NULL
        , QUESTION_REF_ID_FK NUMBER(12) NOT NULL
        , QUESTION_NUMBER NUMBER(6) NOT NULL
        , PARENT_QUESTION_NUMBER NUMBER(6) NOT NULL
        , CONDITION_FLAG VARCHAR2(1) NOT NULL
        , CONDITION_TYPE VARCHAR2(50)
        , CONDITION_VALUE VARCHAR2(2000)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , QUESTION_SEQ_NUMBER NUMBER(3)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE QUESTIONNAIRE_QUESTIONS
    ADD CONSTRAINT QUESTIONNAIRE_QUESTIONSP1
PRIMARY KEY (QUESTIONNAIRE_QUESTIONS_ID);


CREATE INDEX UQ_QUESTIONNAIRE_QUESTIONS 
  ON QUESTIONNAIRE_QUESTIONS 
  (QUESTIONNAIRE_REF_ID_FK, QUESTION_NUMBER);





-----------------------------------------------------------------------------
-- QUESTIONNAIRE_USAGE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'QUESTIONNAIRE_USAGE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE QUESTIONNAIRE_USAGE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE QUESTIONNAIRE_USAGE
(
      QUESTIONNAIRE_USAGE_ID NUMBER(12)
        , MODULE_ITEM_CODE NUMBER(3) NOT NULL
        , MODULE_SUB_ITEM_CODE NUMBER(3) NOT NULL
        , QUESTIONNAIRE_REF_ID_FK NUMBER(12) NOT NULL
        , QUESTIONNAIRE_SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , RULE_ID NUMBER(6)
        , QUESTIONNAIRE_LABEL VARCHAR2(50)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
        , IS_MANDATORY CHAR(1)
    

);

ALTER TABLE QUESTIONNAIRE_USAGE
    ADD CONSTRAINT QUESTIONNAIRE_USAGEP1
PRIMARY KEY (QUESTIONNAIRE_USAGE_ID);


CREATE INDEX UQ_QUESTIONNAIRE_USAGE 
  ON QUESTIONNAIRE_USAGE 
  (MODULE_ITEM_CODE, MODULE_SUB_ITEM_CODE, QUESTIONNAIRE_REF_ID_FK, QUESTIONNAIRE_SEQUENCE_NUMBER);





-----------------------------------------------------------------------------
-- QUESTION_EXPLANATION
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'QUESTION_EXPLANATION';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE QUESTION_EXPLANATION CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE QUESTION_EXPLANATION
(
      QUESTION_EXPLANATION_ID NUMBER(12)
        , QUESTION_REF_ID_FK NUMBER(12) NOT NULL
        , EXPLANATION_TYPE CHAR(1) NOT NULL
        , EXPLANATION CLOB
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE QUESTION_EXPLANATION
    ADD CONSTRAINT QUESTION_EXPLANATIONP1
PRIMARY KEY (QUESTION_EXPLANATION_ID);


CREATE INDEX UQ_QUESTION_EXPLANATION 
  ON QUESTION_EXPLANATION 
  (QUESTION_REF_ID_FK, EXPLANATION_TYPE);





-----------------------------------------------------------------------------
-- QUESTION_TYPES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'QUESTION_TYPES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE QUESTION_TYPES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE QUESTION_TYPES
(
      QUESTION_TYPE_ID NUMBER(12)
        , QUESTION_TYPE_NAME VARCHAR2(30) NOT NULL
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE QUESTION_TYPES
    ADD CONSTRAINT QUESTION_TYPESP1
PRIMARY KEY (QUESTION_TYPE_ID);


CREATE INDEX UQ_QUESTION_TYPE 
  ON QUESTION_TYPES 
  (QUESTION_TYPE_NAME);





-----------------------------------------------------------------------------
-- RATE_CLASS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'RATE_CLASS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE RATE_CLASS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE RATE_CLASS
(
      RATE_CLASS_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , RATE_CLASS_TYPE CHAR(1) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
        , ICR_TYPE_CODE NUMBER(2)
    

);

ALTER TABLE RATE_CLASS
    ADD CONSTRAINT RATE_CLASSP1
PRIMARY KEY (RATE_CLASS_CODE);







-----------------------------------------------------------------------------
-- RATE_CLASS_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'RATE_CLASS_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE RATE_CLASS_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE RATE_CLASS_TYPE
(
      SORT_ID NUMBER(2)
        , PREFIX_ACTIVITY_TYPE CHAR(1) default 'N' NOT NULL
        , RATE_CLASS_TYPE CHAR(1)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE RATE_CLASS_TYPE
    ADD CONSTRAINT RATE_CLASS_TYPEP1
PRIMARY KEY (RATE_CLASS_TYPE);







-----------------------------------------------------------------------------
-- RATE_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'RATE_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE RATE_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE RATE_TYPE
(
      RATE_CLASS_CODE VARCHAR2(3)
        , RATE_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE RATE_TYPE
    ADD CONSTRAINT RATE_TYPEP1
PRIMARY KEY (RATE_CLASS_CODE,RATE_TYPE_CODE);







-----------------------------------------------------------------------------
-- REPORT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'REPORT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE REPORT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE REPORT
(
      VER_NBR NUMBER(8) default 1 NOT NULL
        , REPORT_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , FINAL_REPORT_FLAG CHAR(1) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE REPORT
    ADD CONSTRAINT REPORTP1
PRIMARY KEY (REPORT_CODE);







-----------------------------------------------------------------------------
-- REPORT_CLASS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'REPORT_CLASS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE REPORT_CLASS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE REPORT_CLASS
(
      VER_NBR NUMBER(8) default 1 NOT NULL
        , REPORT_CLASS_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , GENERATE_REPORT_REQUIREMENTS VARCHAR2(1) default 'N' NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE REPORT_CLASS
    ADD CONSTRAINT REPORT_CLASSP1
PRIMARY KEY (REPORT_CLASS_CODE);







-----------------------------------------------------------------------------
-- RESEARCH_AREAS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'RESEARCH_AREAS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE RESEARCH_AREAS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE RESEARCH_AREAS
(
      RESEARCH_AREA_CODE VARCHAR2(8)
        , PARENT_RESEARCH_AREA_CODE VARCHAR2(8) NOT NULL
        , HAS_CHILDREN_FLAG VARCHAR2(1) NOT NULL
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE RESEARCH_AREAS
    ADD CONSTRAINT RESEARCH_AREASP1
PRIMARY KEY (RESEARCH_AREA_CODE);







-----------------------------------------------------------------------------
-- RIGHTS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'RIGHTS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE RIGHTS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE RIGHTS
(
      RIGHT_ID VARCHAR2(30)
        , DESCRIPTION VARCHAR2(80) NOT NULL
        , RIGHT_TYPE CHAR(1) NOT NULL
        , DESCEND_FLAG CHAR(1) NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE RIGHTS
    ADD CONSTRAINT RIGHTSP1
PRIMARY KEY (RIGHT_ID);







-----------------------------------------------------------------------------
-- RISK_LEVEL
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'RISK_LEVEL';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE RISK_LEVEL CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE RISK_LEVEL
(
      VER_NBR NUMBER(8) default 1 NOT NULL
        , RISK_LEVEL_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200)
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE RISK_LEVEL
    ADD CONSTRAINT RISK_LEVELP1
PRIMARY KEY (RISK_LEVEL_CODE);







-----------------------------------------------------------------------------
-- ROLE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'ROLE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE ROLE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE ROLE
(
      ROLE_ID NUMBER(5)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , ROLE_NAME VARCHAR2(50) NOT NULL
        , ROLE_TYPE CHAR(1) NOT NULL
        , OWNED_BY_UNIT VARCHAR2(8) NOT NULL
        , DESCEND_FLAG CHAR(1) NOT NULL
        , STATUS_FLAG CHAR(1) NOT NULL
        , CREATE_TIMESTAMP DATE NOT NULL
        , CREATE_USER VARCHAR2(60) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE ROLE
    ADD CONSTRAINT ROLEP1
PRIMARY KEY (ROLE_ID);







-----------------------------------------------------------------------------
-- ROLE_RIGHTS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'ROLE_RIGHTS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE ROLE_RIGHTS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE ROLE_RIGHTS
(
      RIGHT_ID VARCHAR2(30)
        , ROLE_ID NUMBER(5)
        , DESCEND_FLAG CHAR(1) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE ROLE_RIGHTS
    ADD CONSTRAINT ROLE_RIGHTSP1
PRIMARY KEY (RIGHT_ID,ROLE_ID);







-----------------------------------------------------------------------------
-- ROLODEX
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'ROLODEX';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE ROLODEX CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE ROLODEX
(
      ROLODEX_ID NUMBER(6)
        , LAST_NAME VARCHAR2(20)
        , FIRST_NAME VARCHAR2(20)
        , MIDDLE_NAME VARCHAR2(20)
        , SUFFIX VARCHAR2(10)
        , PREFIX VARCHAR2(10)
        , TITLE VARCHAR2(35)
        , ORGANIZATION VARCHAR2(80) NOT NULL
        , ADDRESS_LINE_1 VARCHAR2(80)
        , ADDRESS_LINE_2 VARCHAR2(80)
        , ADDRESS_LINE_3 VARCHAR2(80)
        , FAX_NUMBER VARCHAR2(20)
        , EMAIL_ADDRESS VARCHAR2(60)
        , CITY VARCHAR2(30)
        , COUNTY VARCHAR2(30)
        , STATE VARCHAR2(30)
        , POSTAL_CODE VARCHAR2(15)
        , COMMENTS VARCHAR2(300)
        , PHONE_NUMBER VARCHAR2(20)
        , COUNTRY_CODE CHAR(3)
        , SPONSOR_CODE CHAR(6)
        , OWNED_BY_UNIT VARCHAR2(8) NOT NULL
        , SPONSOR_ADDRESS_FLAG CHAR(1) NOT NULL
        , DELETE_FLAG CHAR(1)
        , CREATE_USER VARCHAR2(60) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE ROLODEX
    ADD CONSTRAINT ROLODEXP1
PRIMARY KEY (ROLODEX_ID);







-----------------------------------------------------------------------------
-- S2S_APPLICATION
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'S2S_APPLICATION';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE S2S_APPLICATION CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE S2S_APPLICATION
(
      PROPOSAL_NUMBER VARCHAR2(8)
        , APPLICATION CLOB
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE S2S_APPLICATION
    ADD CONSTRAINT S2S_APPLICATIONP1
PRIMARY KEY (PROPOSAL_NUMBER);







-----------------------------------------------------------------------------
-- S2S_APP_ATTACHMENTS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'S2S_APP_ATTACHMENTS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE S2S_APP_ATTACHMENTS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE S2S_APP_ATTACHMENTS
(
      CONTENT_ID VARCHAR2(300) NOT NULL
        , PROPOSAL_NUMBER VARCHAR2(8) NOT NULL
        , HASH_CODE VARCHAR2(200)
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , CONTENT_TYPE VARCHAR2(255)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , S2S_APP_ATTACHMENT_ID NUMBER(12)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE S2S_APP_ATTACHMENTS
    ADD CONSTRAINT S2S_APP_ATTACHMENTSP1
PRIMARY KEY (S2S_APP_ATTACHMENT_ID);







-----------------------------------------------------------------------------
-- S2S_APP_SUBMISSION
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'S2S_APP_SUBMISSION';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE S2S_APP_SUBMISSION CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE S2S_APP_SUBMISSION
(
      SUBMISSION_NUMBER NUMBER(3)
        , COMMENTS VARCHAR2(2000)
        , STATUS VARCHAR2(50)
        , GG_TRACKING_ID VARCHAR2(50)
        , AGENCY_TRACKING_ID VARCHAR2(50)
        , RECEIVED_DATE DATE
        , LAST_MODIFIED_DATE DATE
        , LAST_NOTIFIED_DATE DATE
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , PROPOSAL_NUMBER VARCHAR2(8)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE S2S_APP_SUBMISSION
    ADD CONSTRAINT S2S_APP_SUBMISSIONP1
PRIMARY KEY (SUBMISSION_NUMBER,PROPOSAL_NUMBER);







-----------------------------------------------------------------------------
-- S2S_OPPORTUNITY
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'S2S_OPPORTUNITY';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE S2S_OPPORTUNITY CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE S2S_OPPORTUNITY
(
      PROPOSAL_NUMBER VARCHAR2(8)
        , OPPORTUNITY_TITLE VARCHAR2(255)
        , COMPETETION_ID VARCHAR2(50)
        , OPENING_DATE DATE
        , CLOSING_DATE DATE
        , SCHEMA_URL VARCHAR2(200)
        , INSTRUCTION_URL VARCHAR2(200)
        , OPPORTUNITY_ID VARCHAR2(50)
        , CFDA_NUMBER VARCHAR2(6)
        , S2S_SUBMISSION_TYPE_CODE VARCHAR2(3) default '1'
        , REVISION_CODE VARCHAR2(2)
        , REVISION_OTHER_DESCRIPTION VARCHAR2(45)
        , UPDATE_TIMESTAMP DATE
        , UPDATE_USER VARCHAR2(60)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
        , OPPORTUNITY CLOB NOT NULL
    

);

ALTER TABLE S2S_OPPORTUNITY
    ADD CONSTRAINT S2S_OPPORTUNITYP1
PRIMARY KEY (PROPOSAL_NUMBER);







-----------------------------------------------------------------------------
-- S2S_OPP_FORMS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'S2S_OPP_FORMS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE S2S_OPP_FORMS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE S2S_OPP_FORMS
(
      PROPOSAL_NUMBER VARCHAR2(8)
        , OPP_NAME_SPACE VARCHAR2(200)
        , FORM_NAME VARCHAR2(100)
        , MANDATORY VARCHAR2(1) default 'N'
        , AVAILABLE VARCHAR2(1) default 'Y'
        , INCLUDE VARCHAR2(1) default 'Y'
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE S2S_OPP_FORMS
    ADD CONSTRAINT S2S_OPP_FORMSP1
PRIMARY KEY (PROPOSAL_NUMBER,OPP_NAME_SPACE);







-----------------------------------------------------------------------------
-- S2S_REVISION_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'S2S_REVISION_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE S2S_REVISION_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE S2S_REVISION_TYPE
(
      S2S_REVISION_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE S2S_REVISION_TYPE
    ADD CONSTRAINT S2S_REVISION_TYPEP1
PRIMARY KEY (S2S_REVISION_TYPE_CODE);







-----------------------------------------------------------------------------
-- S2S_SUBMISSION_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'S2S_SUBMISSION_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE S2S_SUBMISSION_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE S2S_SUBMISSION_TYPE
(
      SORT_ID NUMBER(2)
        , S2S_SUBMISSION_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE S2S_SUBMISSION_TYPE
    ADD CONSTRAINT S2S_SUBMISSION_TYPEP1
PRIMARY KEY (S2S_SUBMISSION_TYPE_CODE);







-----------------------------------------------------------------------------
-- SCHEDULE_ACT_ITEM_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'SCHEDULE_ACT_ITEM_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE SCHEDULE_ACT_ITEM_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE SCHEDULE_ACT_ITEM_TYPE
(
      SCHEDULE_ACT_ITEM_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE SCHEDULE_ACT_ITEM_TYPE
    ADD CONSTRAINT SCHEDULE_ACT_ITEM_TYPEP1
PRIMARY KEY (SCHEDULE_ACT_ITEM_TYPE_CODE);







-----------------------------------------------------------------------------
-- SCHEDULE_AGENDA
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'SCHEDULE_AGENDA';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE SCHEDULE_AGENDA CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE SCHEDULE_AGENDA
(
      SCHEDULE_AGENDA_ID NUMBER(12)
        , SCHEDULE_ID_FK NUMBER(12) NOT NULL
        , AGENDA_NUMBER NUMBER(4) NOT NULL
        , AGENDA_NAME VARCHAR2(200) NOT NULL
        , CREATE_TIMESTAMP DATE NOT NULL
        , CREATE_USER VARCHAR2(60) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
        , PDF_STORE BLOB
    

);

ALTER TABLE SCHEDULE_AGENDA
    ADD CONSTRAINT SCHEDULE_AGENDAP1
PRIMARY KEY (SCHEDULE_AGENDA_ID);


CREATE INDEX UQ_COMM_SCHEDULE_AGENDA 
  ON SCHEDULE_AGENDA 
  (SCHEDULE_ID_FK, AGENDA_NUMBER);





-----------------------------------------------------------------------------
-- SCHEDULE_STATUS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'SCHEDULE_STATUS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE SCHEDULE_STATUS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE SCHEDULE_STATUS
(
      SCHEDULE_STATUS_CODE NUMBER(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE SCHEDULE_STATUS
    ADD CONSTRAINT SCHEDULE_STATUSP1
PRIMARY KEY (SCHEDULE_STATUS_CODE);







-----------------------------------------------------------------------------
-- SCHOOL_CODE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'SCHOOL_CODE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE SCHOOL_CODE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE SCHOOL_CODE
(
      SCHOOL_CODE NUMBER(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE SCHOOL_CODE
    ADD CONSTRAINT SCHOOL_CODEP1
PRIMARY KEY (SCHOOL_CODE);







-----------------------------------------------------------------------------
-- SCIENCE_KEYWORD
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'SCIENCE_KEYWORD';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE SCIENCE_KEYWORD CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE SCIENCE_KEYWORD
(
      SCIENCE_KEYWORD_CODE VARCHAR2(15)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE SCIENCE_KEYWORD
    ADD CONSTRAINT SCIENCE_KEYWORDP1
PRIMARY KEY (SCIENCE_KEYWORD_CODE);







-----------------------------------------------------------------------------
-- SPECIAL_REVIEW
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'SPECIAL_REVIEW';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE SPECIAL_REVIEW CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE SPECIAL_REVIEW
(
      SPECIAL_REVIEW_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE SPECIAL_REVIEW
    ADD CONSTRAINT SPECIAL_REVIEWP1
PRIMARY KEY (SPECIAL_REVIEW_CODE);







-----------------------------------------------------------------------------
-- SPONSOR
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'SPONSOR';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE SPONSOR CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE SPONSOR
(
      SPONSOR_CODE CHAR(6)
        , SPONSOR_NAME VARCHAR2(60) NOT NULL
        , ACRONYM VARCHAR2(10)
        , SPONSOR_TYPE_CODE VARCHAR2(3) NOT NULL
        , DUN_AND_BRADSTREET_NUMBER VARCHAR2(20)
        , DUNS_PLUS_FOUR_NUMBER VARCHAR2(20)
        , DODAC_NUMBER VARCHAR2(20)
        , CAGE_NUMBER VARCHAR2(20)
        , POSTAL_CODE VARCHAR2(15)
        , STATE VARCHAR2(30)
        , COUNTRY_CODE CHAR(3)
        , ROLODEX_ID NUMBER(6) NOT NULL
        , AUDIT_REPORT_SENT_FOR_FY CHAR(4)
        , OWNED_BY_UNIT VARCHAR2(8) NOT NULL
        , CREATE_USER VARCHAR2(60) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE SPONSOR
    ADD CONSTRAINT SPONSORP1
PRIMARY KEY (SPONSOR_CODE);







-----------------------------------------------------------------------------
-- SPONSOR_FORMS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'SPONSOR_FORMS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE SPONSOR_FORMS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE SPONSOR_FORMS
(
      SPONSOR_CODE CHAR(6)
        , PACKAGE_NUMBER NUMBER(3)
        , PACKAGE_NAME VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE SPONSOR_FORMS
    ADD CONSTRAINT SPONSOR_FORMSP1
PRIMARY KEY (SPONSOR_CODE,PACKAGE_NUMBER);







-----------------------------------------------------------------------------
-- SPONSOR_FORM_TEMPLATES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'SPONSOR_FORM_TEMPLATES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE SPONSOR_FORM_TEMPLATES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE SPONSOR_FORM_TEMPLATES
(
      SPONSOR_CODE CHAR(6)
        , PACKAGE_NUMBER NUMBER(3)
        , PAGE_NUMBER NUMBER(3)
        , PAGE_DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , FILE_NAME VARCHAR2(150)
        , CONTENT_TYPE VARCHAR2(255)
        , FORM_TEMPLATE CLOB
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE SPONSOR_FORM_TEMPLATES
    ADD CONSTRAINT SPONSOR_FORM_TEMPLATESP1
PRIMARY KEY (SPONSOR_CODE,PACKAGE_NUMBER,PAGE_NUMBER);







-----------------------------------------------------------------------------
-- SPONSOR_HIERARCHY
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'SPONSOR_HIERARCHY';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE SPONSOR_HIERARCHY CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE SPONSOR_HIERARCHY
(
      HIERARCHY_NAME VARCHAR2(100)
        , SPONSOR_CODE CHAR(6)
        , LEVEL1 VARCHAR2(50)
        , LEVEL2 VARCHAR2(50)
        , LEVEL3 VARCHAR2(50)
        , LEVEL4 VARCHAR2(50)
        , LEVEL5 VARCHAR2(50)
        , LEVEL6 VARCHAR2(50)
        , LEVEL7 VARCHAR2(50)
        , LEVEL8 VARCHAR2(50)
        , LEVEL9 VARCHAR2(50)
        , LEVEL10 VARCHAR2(50)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , LEVEL1_SORTID NUMBER(4)
        , LEVEL2_SORTID NUMBER(4)
        , LEVEL3_SORTID NUMBER(4)
        , LEVEL4_SORTID NUMBER(4)
        , LEVEL5_SORTID NUMBER(4)
        , LEVEL6_SORTID NUMBER(4)
        , LEVEL7_SORTID NUMBER(4)
        , LEVEL8_SORTID NUMBER(4)
        , LEVEL9_SORTID NUMBER(4)
        , LEVEL10_SORTID NUMBER(4)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE SPONSOR_HIERARCHY
    ADD CONSTRAINT SPONSOR_HIERARCHYP1
PRIMARY KEY (HIERARCHY_NAME,SPONSOR_CODE);







-----------------------------------------------------------------------------
-- SPONSOR_HIERARCHY_MT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'SPONSOR_HIERARCHY_MT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE SPONSOR_HIERARCHY_MT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE SPONSOR_HIERARCHY_MT
(
      HIERARCHY_NAME VARCHAR2(150)
        , SPONSOR_CODE CHAR(6)
        , LEVEL1 VARCHAR2(50)
        , LEVEL2 VARCHAR2(50)
        , LEVEL3 VARCHAR2(50)
        , LEVEL4 VARCHAR2(50)
        , LEVEL5 VARCHAR2(50)
        , LEVEL6 VARCHAR2(50)
        , LEVEL7 VARCHAR2(50)
        , LEVEL8 VARCHAR2(50)
        , LEVEL9 VARCHAR2(50)
        , LEVEL10 VARCHAR2(50)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , LEVEL1_SORTID NUMBER(4)
        , LEVEL2_SORTID NUMBER(4)
        , LEVEL3_SORTID NUMBER(4)
        , LEVEL4_SORTID NUMBER(4)
        , LEVEL5_SORTID NUMBER(4)
        , LEVEL6_SORTID NUMBER(4)
        , LEVEL7_SORTID NUMBER(4)
        , LEVEL8_SORTID NUMBER(4)
        , LEVEL9_SORTID NUMBER(4)
        , LEVEL10_SORTID NUMBER(4)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE SPONSOR_HIERARCHY_MT
    ADD CONSTRAINT SPONSOR_HIERARCHY_MTP1
PRIMARY KEY (HIERARCHY_NAME,SPONSOR_CODE);







-----------------------------------------------------------------------------
-- SPONSOR_TERM
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'SPONSOR_TERM';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE SPONSOR_TERM CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE SPONSOR_TERM
(
      VER_NBR NUMBER(8) default 1 NOT NULL
        , SPONSOR_TERM_ID NUMBER(12)
        , SPONSOR_TERM_CODE VARCHAR2(3) NOT NULL
        , SPONSOR_TERM_TYPE_CODE VARCHAR2(3) NOT NULL
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE SPONSOR_TERM
    ADD CONSTRAINT SPONSOR_TERMP1
PRIMARY KEY (SPONSOR_TERM_ID);


CREATE INDEX U_SPONSOR_TERM 
  ON SPONSOR_TERM 
  (SPONSOR_TERM_CODE, SPONSOR_TERM_TYPE_CODE);





-----------------------------------------------------------------------------
-- SPONSOR_TERM_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'SPONSOR_TERM_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE SPONSOR_TERM_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE SPONSOR_TERM_TYPE
(
      VER_NBR NUMBER(8) default 1 NOT NULL
        , SPONSOR_TERM_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE SPONSOR_TERM_TYPE
    ADD CONSTRAINT SPONSOR_TERM_TYPEP1
PRIMARY KEY (SPONSOR_TERM_TYPE_CODE);







-----------------------------------------------------------------------------
-- SPONSOR_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'SPONSOR_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE SPONSOR_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE SPONSOR_TYPE
(
      SPONSOR_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(100) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE SPONSOR_TYPE
    ADD CONSTRAINT SPONSOR_TYPEP1
PRIMARY KEY (SPONSOR_TYPE_CODE);







-----------------------------------------------------------------------------
-- SP_REV_APPROVAL_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'SP_REV_APPROVAL_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE SP_REV_APPROVAL_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE SP_REV_APPROVAL_TYPE
(
      APPROVAL_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE SP_REV_APPROVAL_TYPE
    ADD CONSTRAINT SP_REV_APPROVAL_TYPEP1
PRIMARY KEY (APPROVAL_TYPE_CODE);







-----------------------------------------------------------------------------
-- SUBMISSION_STATUS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'SUBMISSION_STATUS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE SUBMISSION_STATUS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE SUBMISSION_STATUS
(
      SUBMISSION_STATUS_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE SUBMISSION_STATUS
    ADD CONSTRAINT SUBMISSION_STATUSP1
PRIMARY KEY (SUBMISSION_STATUS_CODE);







-----------------------------------------------------------------------------
-- SUBMISSION_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'SUBMISSION_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE SUBMISSION_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE SUBMISSION_TYPE
(
      SUBMISSION_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE SUBMISSION_TYPE
    ADD CONSTRAINT SUBMISSION_TYPEP1
PRIMARY KEY (SUBMISSION_TYPE_CODE);







-----------------------------------------------------------------------------
-- SUBMISSION_TYPE_QUALIFIER
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'SUBMISSION_TYPE_QUALIFIER';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE SUBMISSION_TYPE_QUALIFIER CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE SUBMISSION_TYPE_QUALIFIER
(
      SUBMISSION_TYPE_QUAL_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE SUBMISSION_TYPE_QUALIFIER
    ADD CONSTRAINT SUBMISSION_TYPE_QUALIFIERP1
PRIMARY KEY (SUBMISSION_TYPE_QUAL_CODE);







-----------------------------------------------------------------------------
-- TBN
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'TBN';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE TBN CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE TBN
(
      TBN_ID VARCHAR2(9)
        , PERSON_NAME VARCHAR2(90) NOT NULL
        , JOB_CODE VARCHAR2(6)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE TBN
    ADD CONSTRAINT TBNP1
PRIMARY KEY (TBN_ID);







-----------------------------------------------------------------------------
-- TIME_AND_MONEY_DOCUMENT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'TIME_AND_MONEY_DOCUMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE TIME_AND_MONEY_DOCUMENT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE TIME_AND_MONEY_DOCUMENT
(
      DOCUMENT_NUMBER VARCHAR2(10)
        , AWARD_NUMBER VARCHAR2(12) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE TIME_AND_MONEY_DOCUMENT
    ADD CONSTRAINT TIME_AND_MONEY_DOCUMENTP1
PRIMARY KEY (DOCUMENT_NUMBER);







-----------------------------------------------------------------------------
-- TRAINING
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'TRAINING';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE TRAINING CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE TRAINING
(
      TRAINING_CODE NUMBER(4)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE TRAINING
    ADD CONSTRAINT TRAININGP1
PRIMARY KEY (TRAINING_CODE);







-----------------------------------------------------------------------------
-- TRANSACTION_DETAILS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'TRANSACTION_DETAILS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE TRANSACTION_DETAILS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE TRANSACTION_DETAILS
(
      TRANSACTION_DETAIL_ID NUMBER(10)
        , AWARD_NUMBER VARCHAR2(12) NOT NULL
        , SEQUENCE_NUMBER NUMBER(4) NOT NULL
        , TRANSACTION_ID NUMBER(10) NOT NULL
        , TNM_DOCUMENT_NUMBER VARCHAR2(10) NOT NULL
        , COMMENTS VARCHAR2(200)
        , SOURCE_AWARD_NUMBER VARCHAR2(12) NOT NULL
        , DESTINATION_AWARD_NUMBER VARCHAR2(12) NOT NULL
        , OBLIGATED_AMOUNT NUMBER(12,2)
        , ANTICIPATED_AMOUNT NUMBER(12,2)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
        , TRANSACTION_DETAIL_TYPE VARCHAR2(12)
    

);

ALTER TABLE TRANSACTION_DETAILS
    ADD CONSTRAINT TRANSACTION_DETAILSP1
PRIMARY KEY (TRANSACTION_DETAIL_ID);







-----------------------------------------------------------------------------
-- TST_SEARCH_ATTR_INDX_TST_DOC_T
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'TST_SEARCH_ATTR_INDX_TST_DOC_T';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE TST_SEARCH_ATTR_INDX_TST_DOC_T CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE TST_SEARCH_ATTR_INDX_TST_DOC_T
(
      DOC_HDR_ID VARCHAR2(14)
        , OBJ_ID VARCHAR2(36)
        , VER_NBR NUMBER(14)
        , RTE_LVL_CNT NUMBER(14)
        , CNSTNT_STR VARCHAR2(50)
        , RTD_STR VARCHAR2(50)
        , HLD_RTD_STR VARCHAR2(50)
        , RD_ACCS_CNT NUMBER(14)
    

);

ALTER TABLE TST_SEARCH_ATTR_INDX_TST_DOC_T
    ADD CONSTRAINT TST_SEARCH_ATTR_INDX_TST_DOP1
PRIMARY KEY (DOC_HDR_ID);







-----------------------------------------------------------------------------
-- UNIT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'UNIT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE UNIT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE UNIT
(
      UNIT_NUMBER VARCHAR2(8)
        , UNIT_NAME VARCHAR2(60)
        , ORGANIZATION_ID VARCHAR2(8)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , PARENT_UNIT_NUMBER VARCHAR2(8)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE UNIT
    ADD CONSTRAINT UNITP1
PRIMARY KEY (UNIT_NUMBER);







-----------------------------------------------------------------------------
-- UNIT_ADMINISTRATOR
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'UNIT_ADMINISTRATOR';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE UNIT_ADMINISTRATOR CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE UNIT_ADMINISTRATOR
(
      UNIT_NUMBER VARCHAR2(8)
        , PERSON_ID VARCHAR2(40)
        , UNIT_ADMINISTRATOR_TYPE_CODE VARCHAR2(3)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE UNIT_ADMINISTRATOR
    ADD CONSTRAINT UNIT_ADMINISTRATORP1
PRIMARY KEY (UNIT_NUMBER,PERSON_ID,UNIT_ADMINISTRATOR_TYPE_CODE);







-----------------------------------------------------------------------------
-- UNIT_ADMINISTRATOR_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'UNIT_ADMINISTRATOR_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE UNIT_ADMINISTRATOR_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE UNIT_ADMINISTRATOR_TYPE
(
      UNIT_ADMINISTRATOR_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , DEFAULT_GROUP_FLAG VARCHAR2(1)
        , MULTIPLES_FLAG VARCHAR2(1)
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE UNIT_ADMINISTRATOR_TYPE
    ADD CONSTRAINT UNIT_ADMINISTRATOR_TYPEP1
PRIMARY KEY (UNIT_ADMINISTRATOR_TYPE_CODE);







-----------------------------------------------------------------------------
-- USER_ROLES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'USER_ROLES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE USER_ROLES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE USER_ROLES
(
      USER_ID VARCHAR2(10)
        , ROLE_ID NUMBER(5)
        , UNIT_NUMBER VARCHAR2(8)
        , DESCEND_FLAG CHAR(1) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE USER_ROLES
    ADD CONSTRAINT USER_ROLESP1
PRIMARY KEY (USER_ID,ROLE_ID,UNIT_NUMBER);







-----------------------------------------------------------------------------
-- VALID_AWARD_BASIS_PAYMENT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'VALID_AWARD_BASIS_PAYMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE VALID_AWARD_BASIS_PAYMENT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE VALID_AWARD_BASIS_PAYMENT
(
      VALID_AWARD_BASIS_PAYMENT_ID NUMBER(12)
        , AWARD_TYPE_CODE NUMBER(3) NOT NULL
        , BASIS_OF_PAYMENT_CODE VARCHAR2(3) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE VALID_AWARD_BASIS_PAYMENT
    ADD CONSTRAINT VALID_AWARD_BASIS_PAYMENTP1
PRIMARY KEY (VALID_AWARD_BASIS_PAYMENT_ID);


CREATE INDEX UQ_VALID_AWARD_BASIS_PAYMENT 
  ON VALID_AWARD_BASIS_PAYMENT 
  (AWARD_TYPE_CODE, BASIS_OF_PAYMENT_CODE);





-----------------------------------------------------------------------------
-- VALID_BASIS_METHOD_PMT
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'VALID_BASIS_METHOD_PMT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE VALID_BASIS_METHOD_PMT CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE VALID_BASIS_METHOD_PMT
(
      VALID_BASIS_METHOD_PMT_ID NUMBER(12)
        , BASIS_OF_PAYMENT_CODE VARCHAR2(3) NOT NULL
        , METHOD_OF_PAYMENT_CODE VARCHAR2(3) NOT NULL
        , FREQUENCY_INDICATOR CHAR(1) NOT NULL
        , INV_INSTRUCTIONS_INDICATOR CHAR(1) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE VALID_BASIS_METHOD_PMT
    ADD CONSTRAINT VALID_BASIS_METHOD_PMTP1
PRIMARY KEY (VALID_BASIS_METHOD_PMT_ID);


CREATE INDEX UQ_VALID_BASIS_METHOD_PMT 
  ON VALID_BASIS_METHOD_PMT 
  (BASIS_OF_PAYMENT_CODE, METHOD_OF_PAYMENT_CODE);





-----------------------------------------------------------------------------
-- VALID_CALC_TYPES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'VALID_CALC_TYPES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE VALID_CALC_TYPES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE VALID_CALC_TYPES
(
      CALC_TYPE_ID VARCHAR2(8)
        , RATE_CLASS_TYPE CHAR(1)
        , DEPENDENT_SEQ_NUMBER NUMBER(3)
        , DEPENDENT_RATE_CLASS_TYPE CHAR(1)
        , RATE_CLASS_CODE VARCHAR2(3)
        , RATE_TYPE_CODE VARCHAR2(3)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE VALID_CALC_TYPES
    ADD CONSTRAINT VALID_CALC_TYPESP1
PRIMARY KEY (CALC_TYPE_ID,RATE_CLASS_TYPE,DEPENDENT_SEQ_NUMBER);







-----------------------------------------------------------------------------
-- VALID_CE_JOB_CODES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'VALID_CE_JOB_CODES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE VALID_CE_JOB_CODES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE VALID_CE_JOB_CODES
(
      COST_ELEMENT VARCHAR2(8)
        , JOB_CODE VARCHAR2(6)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE VALID_CE_JOB_CODES
    ADD CONSTRAINT VALID_CE_JOB_CODESP1
PRIMARY KEY (COST_ELEMENT,JOB_CODE);







-----------------------------------------------------------------------------
-- VALID_CE_RATE_TYPES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'VALID_CE_RATE_TYPES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE VALID_CE_RATE_TYPES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE VALID_CE_RATE_TYPES
(
      ACTIVE_FLAG VARCHAR2(1) default 'Y' NOT NULL
        , COST_ELEMENT VARCHAR2(8)
        , RATE_CLASS_CODE VARCHAR2(3)
        , RATE_TYPE_CODE VARCHAR2(3)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE VALID_CE_RATE_TYPES
    ADD CONSTRAINT VALID_CE_RATE_TYPESP1
PRIMARY KEY (COST_ELEMENT,RATE_CLASS_CODE,RATE_TYPE_CODE);







-----------------------------------------------------------------------------
-- VALID_CLASS_REPORT_FREQ
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'VALID_CLASS_REPORT_FREQ';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE VALID_CLASS_REPORT_FREQ CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE VALID_CLASS_REPORT_FREQ
(
      VALID_CLASS_REPORT_FREQ_ID NUMBER(12)
        , REPORT_CLASS_CODE VARCHAR2(3) NOT NULL
        , REPORT_CODE VARCHAR2(3) NOT NULL
        , FREQUENCY_CODE VARCHAR2(3) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE VALID_CLASS_REPORT_FREQ
    ADD CONSTRAINT VALID_CLASS_REPORT_FREQP1
PRIMARY KEY (VALID_CLASS_REPORT_FREQ_ID);


CREATE INDEX UQ_VALID_CLASS_REPORT_FREQ 
  ON VALID_CLASS_REPORT_FREQ 
  (REPORT_CLASS_CODE, REPORT_CODE, FREQUENCY_CODE);





-----------------------------------------------------------------------------
-- VALID_FREQUENCY_BASE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'VALID_FREQUENCY_BASE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE VALID_FREQUENCY_BASE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE VALID_FREQUENCY_BASE
(
      VALID_FREQUENCY_BASE_ID NUMBER(12)
        , FREQUENCY_CODE VARCHAR2(3) NOT NULL
        , FREQUENCY_BASE_CODE VARCHAR2(3) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE VALID_FREQUENCY_BASE
    ADD CONSTRAINT VALID_FREQUENCY_BASEP1
PRIMARY KEY (VALID_FREQUENCY_BASE_ID);


CREATE INDEX UQ_VALID_FREQUENCY_BASE 
  ON VALID_FREQUENCY_BASE 
  (FREQUENCY_CODE, FREQUENCY_BASE_CODE);





-----------------------------------------------------------------------------
-- VALID_NARR_FORMS
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'VALID_NARR_FORMS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE VALID_NARR_FORMS CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE VALID_NARR_FORMS
(
      VALID_NARR_FORMS_ID NUMBER(12)
        , FORM_NAME VARCHAR2(100) NOT NULL
        , NARRATIVE_TYPE_CODE VARCHAR2(3) NOT NULL
        , MANDATORY VARCHAR2(3)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
    

);

ALTER TABLE VALID_NARR_FORMS
    ADD CONSTRAINT VALID_NARR_FORMSP1
PRIMARY KEY (VALID_NARR_FORMS_ID);







-----------------------------------------------------------------------------
-- VALID_PROTO_ACTION_CORESP
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'VALID_PROTO_ACTION_CORESP';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE VALID_PROTO_ACTION_CORESP CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE VALID_PROTO_ACTION_CORESP
(
      VALID_PROTO_ACTION_CORESP_ID NUMBER(12)
        , PROTOCOL_ACTION_TYPE_CODE VARCHAR2(3) NOT NULL
        , PROTO_CORRESP_TYPE_CODE VARCHAR2(3) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , FINAL_FLAG VARCHAR2(1)
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    
    , CONSTRAINT UQ_VALID_PROTO_ACTION_CORESP UNIQUE (PROTOCOL_ACTION_TYPE_CODE, PROTO_CORRESP_TYPE_CODE)

);

ALTER TABLE VALID_PROTO_ACTION_CORESP
    ADD CONSTRAINT VALID_PROTO_ACTION_CORESPP1
PRIMARY KEY (VALID_PROTO_ACTION_CORESP_ID);







-----------------------------------------------------------------------------
-- VALID_PROTO_SUB_REV_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'VALID_PROTO_SUB_REV_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE VALID_PROTO_SUB_REV_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE VALID_PROTO_SUB_REV_TYPE
(
      VALID_PROTO_SUB_REV_TYPE_ID NUMBER(12)
        , SUBMISSION_TYPE_CODE VARCHAR2(3) NOT NULL
        , PROTOCOL_REVIEW_TYPE_CODE VARCHAR2(3) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    
    , CONSTRAINT UQ_VALID_PROTO_SUB_REV_TYPE UNIQUE (SUBMISSION_TYPE_CODE, PROTOCOL_REVIEW_TYPE_CODE)

);

ALTER TABLE VALID_PROTO_SUB_REV_TYPE
    ADD CONSTRAINT VALID_PROTO_SUB_REV_TYPEP1
PRIMARY KEY (VALID_PROTO_SUB_REV_TYPE_ID);







-----------------------------------------------------------------------------
-- VALID_PROTO_SUB_TYPE_QUAL
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'VALID_PROTO_SUB_TYPE_QUAL';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE VALID_PROTO_SUB_TYPE_QUAL CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE VALID_PROTO_SUB_TYPE_QUAL
(
      VALID_PROTO_SUB_TYPE_QUAL_ID NUMBER(12)
        , SUBMISSION_TYPE_CODE VARCHAR2(3) NOT NULL
        , SUBMISSION_TYPE_QUAL_CODE VARCHAR2(3) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    
    , CONSTRAINT UQ_VALID_PROTO_SUB_TYPE_QUAL UNIQUE (SUBMISSION_TYPE_CODE, SUBMISSION_TYPE_QUAL_CODE)

);

ALTER TABLE VALID_PROTO_SUB_TYPE_QUAL
    ADD CONSTRAINT VALID_PROTO_SUB_TYPE_QUALP1
PRIMARY KEY (VALID_PROTO_SUB_TYPE_QUAL_ID);







-----------------------------------------------------------------------------
-- VALID_RATES
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'VALID_RATES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE VALID_RATES CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE VALID_RATES
(
      VALID_RATES_ID NUMBER(12)
        , ON_CAMPUS_RATE NUMBER(5,2) NOT NULL
        , OFF_CAMPUS_RATE NUMBER(5,2) NOT NULL
        , RATE_CLASS_TYPE VARCHAR2(1) NOT NULL
        , ADJUSTMENT_KEY VARCHAR2(6) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , OBJ_ID VARCHAR2(36)
        , ICR_RATE_CODE NUMBER(3)
    

);

ALTER TABLE VALID_RATES
    ADD CONSTRAINT VALID_RATESP1
PRIMARY KEY (VALID_RATES_ID);







-----------------------------------------------------------------------------
-- VALID_SP_REV_APPROVAL
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'VALID_SP_REV_APPROVAL';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE VALID_SP_REV_APPROVAL CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE VALID_SP_REV_APPROVAL
(
      EXEMPT_NUMBER_FLAG CHAR(1) NOT NULL
        , SPECIAL_REVIEW_CODE VARCHAR2(3)
        , APPROVAL_TYPE_CODE VARCHAR2(3)
        , PROTOCOL_NUMBER_FLAG CHAR(1) NOT NULL
        , APPROVAL_DATE_FLAG CHAR(1) NOT NULL
        , APPLICATION_DATE_FLAG CHAR(1) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE VALID_SP_REV_APPROVAL
    ADD CONSTRAINT VALID_SP_REV_APPROVALP1
PRIMARY KEY (SPECIAL_REVIEW_CODE,APPROVAL_TYPE_CODE);







-----------------------------------------------------------------------------
-- VERSION_HISTORY
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'VERSION_HISTORY';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE VERSION_HISTORY CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE VERSION_HISTORY
(
      VERSION_HISTORY_ID NUMBER(22) NOT NULL
        , SEQ_OWNER_CLASS_NAME VARCHAR2(256) NOT NULL
        , SEQ_OWNER_VERSION_NAME_FIELD VARCHAR2(32) NOT NULL
        , SEQ_OWNER_VERSION_NAME_VALUE VARCHAR2(32) NOT NULL
        , SEQ_OWNER_SEQ_NUMBER NUMBER(12) NOT NULL
        , VERSION_STATUS VARCHAR2(16) NOT NULL
        , VERSION_DATE DATE NOT NULL
        , USER_ID VARCHAR2(60) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) NOT NULL
        , OBJ_ID VARCHAR2(36) NOT NULL
    

);








-----------------------------------------------------------------------------
-- VULNERABLE_SUBJECT_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'VULNERABLE_SUBJECT_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE VULNERABLE_SUBJECT_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE VULNERABLE_SUBJECT_TYPE
(
      VULNERABLE_SUBJECT_TYPE_CODE VARCHAR2(3)
        , DESCRIPTION VARCHAR2(200) NOT NULL
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE VULNERABLE_SUBJECT_TYPE
    ADD CONSTRAINT VULNERABLE_SUBJECT_TYPEP1
PRIMARY KEY (VULNERABLE_SUBJECT_TYPE_CODE);







-----------------------------------------------------------------------------
-- YNQ
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'YNQ';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE YNQ CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE YNQ
(
      QUESTION_ID VARCHAR2(4)
        , DESCRIPTION VARCHAR2(500) NOT NULL
        , QUESTION_TYPE CHAR(1) NOT NULL
        , NO_OF_ANSWERS NUMBER(2) NOT NULL
        , EXPLANATION_REQUIRED_FOR VARCHAR2(3)
        , DATE_REQUIRED_FOR VARCHAR2(3)
        , STATUS CHAR(1) NOT NULL
        , EFFECTIVE_DATE DATE NOT NULL
        , GROUP_NAME VARCHAR2(150)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE YNQ
    ADD CONSTRAINT YNQP1
PRIMARY KEY (QUESTION_ID);







-----------------------------------------------------------------------------
-- YNQ_EXPLANATION
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'YNQ_EXPLANATION';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE YNQ_EXPLANATION CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE YNQ_EXPLANATION
(
      QUESTION_ID VARCHAR2(4)
        , EXPLANATION_TYPE CHAR(1)
        , EXPLANATION CLOB
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE YNQ_EXPLANATION
    ADD CONSTRAINT YNQ_EXPLANATIONP1
PRIMARY KEY (QUESTION_ID,EXPLANATION_TYPE);







-----------------------------------------------------------------------------
-- YNQ_EXPLANATION_TYPE
-----------------------------------------------------------------------------
DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_tables WHERE table_name = 'YNQ_EXPLANATION_TYPE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP TABLE YNQ_EXPLANATION_TYPE CASCADE CONSTRAINTS PURGE'; END IF;
end;
/

CREATE TABLE YNQ_EXPLANATION_TYPE
(
      EXPLANATION_TYPE CHAR(1)
        , DESCRIPTION VARCHAR2(200)
        , UPDATE_TIMESTAMP DATE NOT NULL
        , UPDATE_USER VARCHAR2(60) NOT NULL
        , VER_NBR NUMBER(8) default 1 NOT NULL
        , OBJ_ID VARCHAR2(36)
    

);

ALTER TABLE YNQ_EXPLANATION_TYPE
    ADD CONSTRAINT YNQ_EXPLANATION_TYPEP1
PRIMARY KEY (EXPLANATION_TYPE);






DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'DIRTY_CACHE_SEQ';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE DIRTY_CACHE_SEQ'; END IF;
end;
/

CREATE SEQUENCE DIRTY_CACHE_SEQ INCREMENT BY 1 START WITH 2000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'KRNS_DOC_TYP_ATTR_S';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE KRNS_DOC_TYP_ATTR_S'; END IF;
end;
/

CREATE SEQUENCE KRNS_DOC_TYP_ATTR_S INCREMENT BY 1 START WITH 1000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'KRNS_LOCK_S';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE KRNS_LOCK_S'; END IF;
end;
/

CREATE SEQUENCE KRNS_LOCK_S INCREMENT BY 1 START WITH 2000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'KRNS_LOOKUP_RSLT_S';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE KRNS_LOOKUP_RSLT_S'; END IF;
end;
/

CREATE SEQUENCE KRNS_LOOKUP_RSLT_S INCREMENT BY 1 START WITH 2000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'KRNS_MAINT_LOCK_S';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE KRNS_MAINT_LOCK_S'; END IF;
end;
/

CREATE SEQUENCE KRNS_MAINT_LOCK_S INCREMENT BY 1 START WITH 2020 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'KRNS_NTE_S';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE KRNS_NTE_S'; END IF;
end;
/

CREATE SEQUENCE KRNS_NTE_S INCREMENT BY 1 START WITH 2020 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'KRSB_BAM_PARM_S';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE KRSB_BAM_PARM_S'; END IF;
end;
/

CREATE SEQUENCE KRSB_BAM_PARM_S INCREMENT BY 1 START WITH 2000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'KRSB_BAM_S';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE KRSB_BAM_S'; END IF;
end;
/

CREATE SEQUENCE KRSB_BAM_S INCREMENT BY 1 START WITH 2000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'KRSB_FLT_SVC_DEF_S';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE KRSB_FLT_SVC_DEF_S'; END IF;
end;
/

CREATE SEQUENCE KRSB_FLT_SVC_DEF_S INCREMENT BY 1 START WITH 1000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'KRSB_MSG_QUE_S';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE KRSB_MSG_QUE_S'; END IF;
end;
/

CREATE SEQUENCE KRSB_MSG_QUE_S INCREMENT BY 1 START WITH 65904 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'KRSB_SVC_DEF_S';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE KRSB_SVC_DEF_S'; END IF;
end;
/

CREATE SEQUENCE KRSB_SVC_DEF_S INCREMENT BY 1 START WITH 3900 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQUENCE_IPPUCS_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQUENCE_IPPUCS_ID'; END IF;
end;
/

CREATE SEQUENCE SEQUENCE_IPPUCS_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQUENCE_NSF_CODES';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQUENCE_NSF_CODES'; END IF;
end;
/

CREATE SEQUENCE SEQUENCE_NSF_CODES INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQUENCE_PROPOSAL_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQUENCE_PROPOSAL_ID'; END IF;
end;
/

CREATE SEQUENCE SEQUENCE_PROPOSAL_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_APPLICATIONS_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_APPLICATIONS_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_APPLICATIONS_ID INCREMENT BY 1 START WITH 1000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_APP_SPONSRD_USER_ATTR_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_APP_SPONSRD_USER_ATTR_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_APP_SPONSRD_USER_ATTR_ID INCREMENT BY 1 START WITH 1000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_ATTACHMENT_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_ATTACHMENT_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_ATTACHMENT_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_ATTRIBUTE_TYPES_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_ATTRIBUTE_TYPES_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_ATTRIBUTE_TYPES_ID INCREMENT BY 1 START WITH 1000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_AWARD_AMOUNT_TRANS_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_AWARD_AMOUNT_TRANS_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_AWARD_AMOUNT_TRANS_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_AWARD_AMT_FNA_DSTRBTN_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_AWARD_AMT_FNA_DSTRBTN_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_AWARD_AMT_FNA_DSTRBTN_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_AWARD_APPROVED_SUBAWARD_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_AWARD_APPROVED_SUBAWARD_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_AWARD_APPROVED_SUBAWARD_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_AWARD_ATTACHMENT_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_AWARD_ATTACHMENT_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_AWARD_ATTACHMENT_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_AWARD_AWARD_CLOSEOUT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_AWARD_AWARD_CLOSEOUT'; END IF;
end;
/

CREATE SEQUENCE SEQ_AWARD_AWARD_CLOSEOUT INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_AWARD_AWARD_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_AWARD_AWARD_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_AWARD_AWARD_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_AWARD_AWARD_NUMBER';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_AWARD_AWARD_NUMBER'; END IF;
end;
/

CREATE SEQUENCE SEQ_AWARD_AWARD_NUMBER INCREMENT BY 1 START WITH 21 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_AWARD_COMMENT_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_AWARD_COMMENT_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_AWARD_COMMENT_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_AWARD_COST_SHARE_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_AWARD_COST_SHARE_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_AWARD_COST_SHARE_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_AWARD_CUSTOM_DATA_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_AWARD_CUSTOM_DATA_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_AWARD_CUSTOM_DATA_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_AWARD_EXEMPT_NUMBER_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_AWARD_EXEMPT_NUMBER_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_AWARD_EXEMPT_NUMBER_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_AWARD_NOTEPAD_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_AWARD_NOTEPAD_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_AWARD_NOTEPAD_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_AWARD_REP_TERMS_RECNT_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_AWARD_REP_TERMS_RECNT_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_AWARD_REP_TERMS_RECNT_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_AWARD_SCIENCE_KEYWORD_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_AWARD_SCIENCE_KEYWORD_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_AWARD_SCIENCE_KEYWORD_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_AWARD_SPECIAL_REVIEW_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_AWARD_SPECIAL_REVIEW_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_AWARD_SPECIAL_REVIEW_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_AWARD_SPONSOR_TERM';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_AWARD_SPONSOR_TERM'; END IF;
end;
/

CREATE SEQUENCE SEQ_AWARD_SPONSOR_TERM INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_AWARD_SPONSOR_TERMS';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_AWARD_SPONSOR_TERMS'; END IF;
end;
/

CREATE SEQUENCE SEQ_AWARD_SPONSOR_TERMS INCREMENT BY 1 START WITH 321 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_AWARD_TEMPLATE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_AWARD_TEMPLATE'; END IF;
end;
/

CREATE SEQUENCE SEQ_AWARD_TEMPLATE INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_AWARD_TRANS_SPONSOR_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_AWARD_TRANS_SPONSOR_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_AWARD_TRANS_SPONSOR_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_BATCH_CORRESPONDENCE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_BATCH_CORRESPONDENCE'; END IF;
end;
/

CREATE SEQUENCE SEQ_BATCH_CORRESPONDENCE INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_BGT_PER_DET_RATE_BASE_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_BGT_PER_DET_RATE_BASE_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_BGT_PER_DET_RATE_BASE_ID INCREMENT BY 1 START WITH 9 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_BUDGET_DETAILS_CAL_AMTS_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_BUDGET_DETAILS_CAL_AMTS_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_BUDGET_DETAILS_CAL_AMTS_ID INCREMENT BY 1 START WITH 9 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_BUDGET_DETAILS_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_BUDGET_DETAILS_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_BUDGET_DETAILS_ID INCREMENT BY 1 START WITH 9 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_BUDGET_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_BUDGET_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_BUDGET_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_BUDGET_PERIOD_NUMBER';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_BUDGET_PERIOD_NUMBER'; END IF;
end;
/

CREATE SEQUENCE SEQ_BUDGET_PERIOD_NUMBER INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_BUDGET_PER_CAL_AMTS_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_BUDGET_PER_CAL_AMTS_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_BUDGET_PER_CAL_AMTS_ID INCREMENT BY 1 START WITH 9 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_BUDGET_PER_DET_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_BUDGET_PER_DET_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_BUDGET_PER_DET_ID INCREMENT BY 1 START WITH 9 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_BUDGET_RATE_AND_BASE_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_BUDGET_RATE_AND_BASE_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_BUDGET_RATE_AND_BASE_ID INCREMENT BY 1 START WITH 9 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_COMMITTEE_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_COMMITTEE_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_COMMITTEE_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_COMM_RESEARCH_AREAS_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_COMM_RESEARCH_AREAS_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_COMM_RESEARCH_AREAS_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_COMM_SCHEDULE_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_COMM_SCHEDULE_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_COMM_SCHEDULE_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_CONG_DISTRICT_ID_KRA';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_CONG_DISTRICT_ID_KRA'; END IF;
end;
/

CREATE SEQUENCE SEQ_CONG_DISTRICT_ID_KRA INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_DOCUMENT_ROUTE_HEADER';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_DOCUMENT_ROUTE_HEADER'; END IF;
end;
/

CREATE SEQUENCE SEQ_DOCUMENT_ROUTE_HEADER INCREMENT BY 1 START WITH 3360 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_DOCUMENT_TYPE_ATTRIBUTE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_DOCUMENT_TYPE_ATTRIBUTE'; END IF;
end;
/

CREATE SEQUENCE SEQ_DOCUMENT_TYPE_ATTRIBUTE INCREMENT BY 1 START WITH 2280 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_DOC_NTE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_DOC_NTE'; END IF;
end;
/

CREATE SEQUENCE SEQ_DOC_NTE INCREMENT BY 1 START WITH 2000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_EDL_FIELD_DMP';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_EDL_FIELD_DMP'; END IF;
end;
/

CREATE SEQUENCE SEQ_EDL_FIELD_DMP INCREMENT BY 1 START WITH 5000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_EN_EDOCLT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_EN_EDOCLT'; END IF;
end;
/

CREATE SEQUENCE SEQ_EN_EDOCLT INCREMENT BY 1 START WITH 2000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_GROUPS_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_GROUPS_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_GROUPS_ID INCREMENT BY 1 START WITH 1000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_GROUP_ATTRIBUTES_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_GROUP_ATTRIBUTES_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_GROUP_ATTRIBUTES_ID INCREMENT BY 1 START WITH 1000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_HELP_ENTRY';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_HELP_ENTRY'; END IF;
end;
/

CREATE SEQUENCE SEQ_HELP_ENTRY INCREMENT BY 1 START WITH 100 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_IP_COMMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_IP_COMMENT'; END IF;
end;
/

CREATE SEQUENCE SEQ_IP_COMMENT INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_IP_REVIEW_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_IP_REVIEW_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_IP_REVIEW_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_IP_REV_ACTIVITY_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_IP_REV_ACTIVITY_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_IP_REV_ACTIVITY_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_MEETING_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_MEETING_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_MEETING_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_OUT_BOX_ITM';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_OUT_BOX_ITM'; END IF;
end;
/

CREATE SEQUENCE SEQ_OUT_BOX_ITM INCREMENT BY 1 START WITH 10000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PERMISSIONS_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PERMISSIONS_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_PERMISSIONS_ID INCREMENT BY 1 START WITH 1000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PERSON_APPOINTMENT';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PERSON_APPOINTMENT'; END IF;
end;
/

CREATE SEQUENCE SEQ_PERSON_APPOINTMENT INCREMENT BY 1 START WITH 1000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PERSON_DEGREE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PERSON_DEGREE'; END IF;
end;
/

CREATE SEQUENCE SEQ_PERSON_DEGREE INCREMENT BY 1 START WITH 1000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PROPOSAL_ADMIN_DETAILS_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PROPOSAL_ADMIN_DETAILS_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_PROPOSAL_ADMIN_DETAILS_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PROPOSAL_COMMENTS_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PROPOSAL_COMMENTS_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_PROPOSAL_COMMENTS_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PROPOSAL_COST_SHARE_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PROPOSAL_COST_SHARE_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_PROPOSAL_COST_SHARE_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PROPOSAL_CUSTOM_DATA_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PROPOSAL_CUSTOM_DATA_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_PROPOSAL_CUSTOM_DATA_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PROPOSAL_EXEMPT_NUMBER_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PROPOSAL_EXEMPT_NUMBER_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_PROPOSAL_EXEMPT_NUMBER_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PROPOSAL_IP_REVIEW_JOIN_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PROPOSAL_IP_REVIEW_JOIN_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_PROPOSAL_IP_REVIEW_JOIN_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PROPOSAL_NOTEPAD_IDN';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PROPOSAL_NOTEPAD_IDN'; END IF;
end;
/

CREATE SEQUENCE SEQ_PROPOSAL_NOTEPAD_IDN INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PROPOSAL_NUMBER';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PROPOSAL_NUMBER'; END IF;
end;
/

CREATE SEQUENCE SEQ_PROPOSAL_NUMBER INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PROPOSAL_NUMBER_KRA';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PROPOSAL_NUMBER_KRA'; END IF;
end;
/

CREATE SEQUENCE SEQ_PROPOSAL_NUMBER_KRA INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PROPOSAL_PROPOSAL_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PROPOSAL_PROPOSAL_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_PROPOSAL_PROPOSAL_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PROPOSAL_SPECIAL_REVIEW_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PROPOSAL_SPECIAL_REVIEW_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_PROPOSAL_SPECIAL_REVIEW_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PROP_ROLE_TEMPLATE_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PROP_ROLE_TEMPLATE_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_PROP_ROLE_TEMPLATE_ID INCREMENT BY 1 START WITH 1000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PROP_UNIT_ADMIN_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PROP_UNIT_ADMIN_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_PROP_UNIT_ADMIN_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PROTOCOL_EXEMPT_NUMBER_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PROTOCOL_EXEMPT_NUMBER_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_PROTOCOL_EXEMPT_NUMBER_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PROTOCOL_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PROTOCOL_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_PROTOCOL_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PROTOCOL_REFERENCES_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PROTOCOL_REFERENCES_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_PROTOCOL_REFERENCES_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PROTOCOL_RESEARCH_AREAS_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PROTOCOL_RESEARCH_AREAS_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_PROTOCOL_RESEARCH_AREAS_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PROTOCOL_SPECIAL_REVIEW_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PROTOCOL_SPECIAL_REVIEW_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_PROTOCOL_SPECIAL_REVIEW_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PROTO_CORRESP_TEMPL';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PROTO_CORRESP_TEMPL'; END IF;
end;
/

CREATE SEQUENCE SEQ_PROTO_CORRESP_TEMPL INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_PROTO_NOTIFICATION_TEMPL';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_PROTO_NOTIFICATION_TEMPL'; END IF;
end;
/

CREATE SEQUENCE SEQ_PROTO_NOTIFICATION_TEMPL INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_QUESTIONNAIRE_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_QUESTIONNAIRE_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_QUESTIONNAIRE_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_QUESTIONNAIRE_REF_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_QUESTIONNAIRE_REF_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_QUESTIONNAIRE_REF_ID INCREMENT BY 1 START WITH 317 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_QUESTION_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_QUESTION_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_QUESTION_ID INCREMENT BY 1 START WITH 80 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_RESPONSIBILITY_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_RESPONSIBILITY_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_RESPONSIBILITY_ID INCREMENT BY 1 START WITH 2220 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_ROLES_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_ROLES_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_ROLES_ID INCREMENT BY 1 START WITH 1000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_ROLE_ATTRIBUTES_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_ROLE_ATTRIBUTES_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_ROLE_ATTRIBUTES_ID INCREMENT BY 1 START WITH 1000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_ROUTE_QUEUE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_ROUTE_QUEUE'; END IF;
end;
/

CREATE SEQUENCE SEQ_ROUTE_QUEUE INCREMENT BY 1 START WITH 4420 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_ROUTE_TEMPLATE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_ROUTE_TEMPLATE'; END IF;
end;
/

CREATE SEQUENCE SEQ_ROUTE_TEMPLATE INCREMENT BY 1 START WITH 1300 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_RTE_NODE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_RTE_NODE'; END IF;
end;
/

CREATE SEQUENCE SEQ_RTE_NODE INCREMENT BY 1 START WITH 3600 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_RTE_NODE_CFG_PARM';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_RTE_NODE_CFG_PARM'; END IF;
end;
/

CREATE SEQUENCE SEQ_RTE_NODE_CFG_PARM INCREMENT BY 1 START WITH 3800 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_RULE_EXPR';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_RULE_EXPR'; END IF;
end;
/

CREATE SEQUENCE SEQ_RULE_EXPR INCREMENT BY 1 START WITH 2000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_RULE_TMPL_OPTN';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_RULE_TMPL_OPTN'; END IF;
end;
/

CREATE SEQUENCE SEQ_RULE_TMPL_OPTN INCREMENT BY 1 START WITH 2000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_S2S_APP_ATTACHMENT_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_S2S_APP_ATTACHMENT_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_S2S_APP_ATTACHMENT_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_SEARCHABLE_ATTRIBUTE_VALUE';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_SEARCHABLE_ATTRIBUTE_VALUE'; END IF;
end;
/

CREATE SEQUENCE SEQ_SEARCHABLE_ATTRIBUTE_VALUE INCREMENT BY 1 START WITH 2000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_SPONSOR_TERM';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_SPONSOR_TERM'; END IF;
end;
/

CREATE SEQUENCE SEQ_SPONSOR_TERM INCREMENT BY 1 START WITH 307 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_SUB_AWD_BGT_ATT_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_SUB_AWD_BGT_ATT_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_SUB_AWD_BGT_ATT_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_TRANSACTION_DETAIL_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_TRANSACTION_DETAIL_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_TRANSACTION_DETAIL_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_TRANSACTION_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_TRANSACTION_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_TRANSACTION_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_TRANSACTION_TST';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_TRANSACTION_TST'; END IF;
end;
/

CREATE SEQUENCE SEQ_TRANSACTION_TST INCREMENT BY 1 START WITH 100 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_TRAVEL_DOC_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_TRAVEL_DOC_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_TRAVEL_DOC_ID INCREMENT BY 1 START WITH 1000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_TRAVEL_FO_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_TRAVEL_FO_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_TRAVEL_FO_ID INCREMENT BY 1 START WITH 1000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_UNRECOVERED_FNA_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_UNRECOVERED_FNA_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_UNRECOVERED_FNA_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_USERS_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_USERS_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_USERS_ID INCREMENT BY 1 START WITH 1000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_USER_ATTRIBUTES_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_USER_ATTRIBUTES_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_USER_ATTRIBUTES_ID INCREMENT BY 1 START WITH 1000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_VALID_BASIS_METHOD_PMT_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_VALID_BASIS_METHOD_PMT_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_VALID_BASIS_METHOD_PMT_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_VALID_CLASS_REPORT_FREQ';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_VALID_CLASS_REPORT_FREQ'; END IF;
end;
/

CREATE SEQUENCE SEQ_VALID_CLASS_REPORT_FREQ INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_VALID_NARR_FORMS_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_VALID_NARR_FORMS_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_VALID_NARR_FORMS_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_VALID_SUBM_REVW_TYPE_QUAL';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_VALID_SUBM_REVW_TYPE_QUAL'; END IF;
end;
/

CREATE SEQUENCE SEQ_VALID_SUBM_REVW_TYPE_QUAL INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQ_VERSION_HISTORY_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQ_VERSION_HISTORY_ID'; END IF;
end;
/

CREATE SEQUENCE SEQ_VERSION_HISTORY_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SERVICE_DEF_SEQ';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SERVICE_DEF_SEQ'; END IF;
end;
/

CREATE SEQUENCE SERVICE_DEF_SEQ INCREMENT BY 1 START WITH 2320 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'TRV_FO_ID_S';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE TRV_FO_ID_S'; END IF;
end;
/

CREATE SEQUENCE TRV_FO_ID_S INCREMENT BY 1 START WITH 1000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'USER_CHANNEL_SUBSCRIPTIONS_SEQ';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE USER_CHANNEL_SUBSCRIPTIONS_SEQ'; END IF;
end;
/

CREATE SEQUENCE USER_CHANNEL_SUBSCRIPTIONS_SEQ INCREMENT BY 1 START WITH 1000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQUENCE_IPPCS_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQUENCE_IPPCS_ID'; END IF;
end;
/

CREATE SEQUENCE SEQUENCE_IPPCS_ID INCREMENT BY 1 START WITH 1 NOMAXVALUE NOCYCLE NOCACHE ORDER;

DECLARE temp NUMBER;
BEGIN
	SELECT COUNT(*) INTO temp FROM user_sequences WHERE sequence_name = 'SEQUENCE_AWARD_ID';
	IF temp > 0 THEN EXECUTE IMMEDIATE 'DROP SEQUENCE SEQUENCE_AWARD_ID'; END IF;
end;
/

CREATE SEQUENCE SEQUENCE_AWARD_ID INCREMENT BY 1 START WITH 1000 NOMAXVALUE NOCYCLE NOCACHE ORDER;

