/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.kim;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.common.assignee.Assignee;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.role.RoleMembership;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.kim.role.DerivedRoleTypeServiceBase;

public class PermissionDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    private static PermissionService permissionService;
    private String permissionTemplateNamespace;
    private String permissionTemplateName;

    public String getPermissionTemplateNamespace() {
        return this.permissionTemplateNamespace;
    }

    public void setPermissionTemplateNamespace(String permissionTemplateNamespace) {
        this.permissionTemplateNamespace = permissionTemplateNamespace;
    }

    public String getPermissionTemplateName() {
        return this.permissionTemplateName;
    }

    public void setPermissionTemplateName(String permissionTemplateName) {
        this.permissionTemplateName = permissionTemplateName;
    }

    protected List<Assignee> getPermissionAssignees(Map<String, String> qualification) {
        return this.getPermissionService().getPermissionAssigneesByTemplate(this.permissionTemplateNamespace, this.permissionTemplateName, new HashMap<String, String>(qualification), new HashMap<String, String>(qualification));
    }

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was null or blank");
        }
        if (roleName == null) {
            throw new RiceIllegalArgumentException("roleName was null");
        }
        List<Assignee> permissionAssignees = this.getPermissionAssignees(qualification);
        ArrayList<RoleMembership> members = new ArrayList<RoleMembership>();
        for (Assignee permissionAssigneeInfo : permissionAssignees) {
            if (StringUtils.isNotBlank((String)permissionAssigneeInfo.getPrincipalId())) {
                members.add(RoleMembership.Builder.create(null, null, (String)permissionAssigneeInfo.getPrincipalId(), (MemberType)MemberType.PRINCIPAL, null).build());
                continue;
            }
            if (!StringUtils.isNotBlank((String)permissionAssigneeInfo.getGroupId())) continue;
            members.add(RoleMembership.Builder.create(null, null, (String)permissionAssigneeInfo.getGroupId(), (MemberType)MemberType.GROUP, null).build());
        }
        return members;
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new RiceIllegalArgumentException("principalId was null or blank");
        }
        if (groupIds == null) {
            throw new RiceIllegalArgumentException("groupIds was null or blank");
        }
        if (StringUtils.isBlank((String)namespaceCode)) {
            throw new RiceIllegalArgumentException("namespaceCode was null or blank");
        }
        if (StringUtils.isBlank((String)roleName)) {
            throw new RiceIllegalArgumentException("roleName was null or blank");
        }
        if (qualification == null) {
            throw new RiceIllegalArgumentException("qualification was null");
        }
        return this.getPermissionService().isAuthorizedByTemplate(principalId, this.permissionTemplateNamespace, this.permissionTemplateName, new HashMap<String, String>(qualification), new HashMap<String, String>(qualification));
    }

    protected PermissionService getPermissionService() {
        if (permissionService == null) {
            permissionService = KimApiServiceLocator.getPermissionService();
        }
        return permissionService;
    }
}

