/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.kuali.rice.krad.data.CopyOption;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.context.ContextDefinitionContract;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.ContextAttributeBo;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionBo;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;

@Entity
@Table(name="KRMS_CNTXT_T")
public class ContextBo
implements ContextDefinitionContract,
Serializable,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    private static final long serialVersionUID = 1L;
    public static final String CONTEXT_SEQ_NAME = "KRMS_CNTXT_S";
    @PortableSequenceGenerator(name="KRMS_CNTXT_S")
    @GeneratedValue(generator="KRMS_CNTXT_S")
    @Id
    @Column(name="CNTXT_ID")
    private String id;
    @Column(name="NM")
    private String name;
    @Column(name="NMSPC_CD")
    private String namespace;
    @Column(name="TYP_ID")
    private String typeId;
    @Column(name="DESC_TXT")
    private String description;
    @Column(name="ACTV")
    @Convert(converter=BooleanYNConverter.class)
    private boolean active = true;
    @OneToMany(mappedBy="context")
    @JoinColumn(name="CNTXT_ID", referencedColumnName="CNTXT_ID", insertable=false, updatable=false)
    private List<AgendaBo> agendas = new ArrayList<AgendaBo>();
    @OneToMany(targetEntity=ContextAttributeBo.class, orphanRemoval=true, mappedBy="context", cascade={CascadeType.REFRESH, CascadeType.REMOVE, CascadeType.PERSIST}, fetch=FetchType.LAZY)
    @JoinColumn(name="CNTXT_ID", referencedColumnName="CNTXT_ID", insertable=true, updatable=true)
    private List<ContextAttributeBo> attributeBos = new ArrayList<ContextAttributeBo>();
    @Column(name="VER_NBR")
    @Version
    private Long versionNumber;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public List<AgendaBo> getAgendas() {
        return this._persistence_get_agendas();
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (this._persistence_get_attributeBos() != null) {
            for (ContextAttributeBo attr : this._persistence_get_attributeBos()) {
                attributes.put(attr.getAttributeDefinition().getName(), attr.getValue());
            }
        }
        return attributes;
    }

    public ContextBo copyContext(String additionalNameText) {
        ContextBo copy = (ContextBo)KradDataServiceLocator.getDataObjectService().copyInstance((Object)this, new CopyOption[]{CopyOption.RESET_PK_FIELDS, CopyOption.RESET_OBJECT_ID});
        copy.setId(null);
        copy.setAgendas(null);
        for (ContextAttributeBo attributeBo : copy.getAttributeBos()) {
            attributeBo.setId(null);
            attributeBo.setVersionNumber(null);
        }
        if (!StringUtils.isEmpty((String)additionalNameText)) {
            copy.setName(copy.getName() + additionalNameText);
        }
        return copy;
    }

    public static ContextDefinition to(ContextBo bo) {
        if (bo == null) {
            return null;
        }
        return ContextDefinition.Builder.create((ContextDefinitionContract)bo).build();
    }

    public static ContextBo from(ContextDefinition im) {
        if (im == null) {
            return null;
        }
        ContextBo bo = new ContextBo();
        bo._persistence_set_id(im.getId());
        bo._persistence_set_namespace(im.getNamespace());
        bo._persistence_set_name(im.getName());
        bo._persistence_set_typeId(im.getTypeId());
        bo._persistence_set_description(im.getDescription());
        bo._persistence_set_active(im.isActive());
        bo._persistence_set_agendas(new ArrayList());
        for (AgendaDefinition agenda : im.getAgendas()) {
            bo._persistence_get_agendas().add(KrmsRepositoryServiceLocator.getAgendaBoService().from(agenda));
        }
        ArrayList<ContextAttributeBo> attrs = new ArrayList<ContextAttributeBo>();
        for (Map.Entry entry : im.getAttributes().entrySet()) {
            KrmsAttributeDefinitionBo attrDefBo = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService().getKrmsAttributeBo((String)entry.getKey(), im.getNamespace());
            ContextAttributeBo attributeBo = new ContextAttributeBo();
            attributeBo.setContext(bo);
            attributeBo.setValue((String)entry.getValue());
            attributeBo.setAttributeDefinition(attrDefBo);
            attrs.add(attributeBo);
        }
        bo.setAttributeBos(attrs);
        bo._persistence_set_versionNumber(im.getVersionNumber());
        return bo;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException, ClassNotFoundException {
        this._persistence_get_agendas().size();
        this._persistence_get_attributeBos().size();
        stream.defaultWriteObject();
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public String getNamespace() {
        return this._persistence_get_namespace();
    }

    public void setNamespace(String namespace) {
        this._persistence_set_namespace(namespace);
    }

    public String getTypeId() {
        return this._persistence_get_typeId();
    }

    public void setTypeId(String typeId) {
        this._persistence_set_typeId(typeId);
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    public void setDescription(String description) {
        this._persistence_set_description(description);
    }

    public boolean getActive() {
        return this._persistence_get_active();
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public void setAgendas(List<AgendaBo> agendas) {
        this._persistence_set_agendas(agendas);
    }

    public List<ContextAttributeBo> getAttributeBos() {
        return this._persistence_get_attributeBos();
    }

    public void setAttributeBos(List<ContextAttributeBo> attributeBos) {
        this._persistence_set_attributeBos(attributeBos);
    }

    public Long getVersionNumber() {
        return this._persistence_get_versionNumber();
    }

    public void setVersionNumber(Long versionNumber) {
        this._persistence_set_versionNumber(versionNumber);
    }

    public Object _persistence_post_clone() {
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ContextBo();
    }

    public Object _persistence_get(String string) {
        if (string == "attributeBos") {
            return this.attributeBos;
        }
        if (string == "agendas") {
            return this.agendas;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "namespace") {
            return this.namespace;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "typeId") {
            return this.typeId;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "versionNumber") {
            return this.versionNumber;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "attributeBos") {
            this.attributeBos = (List)object;
            return;
        }
        if (string == "agendas") {
            this.agendas = (List)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "namespace") {
            this.namespace = (String)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "typeId") {
            this.typeId = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "versionNumber") {
            this.versionNumber = (Long)object;
            return;
        }
    }

    public List _persistence_get_attributeBos() {
        this._persistence_checkFetched("attributeBos");
        return this.attributeBos;
    }

    public void _persistence_set_attributeBos(List list) {
        this._persistence_checkFetchedForSet("attributeBos");
        this._persistence_propertyChange("attributeBos", this.attributeBos, list);
        this.attributeBos = list;
    }

    public List _persistence_get_agendas() {
        this._persistence_checkFetched("agendas");
        return this.agendas;
    }

    public void _persistence_set_agendas(List list) {
        this._persistence_checkFetchedForSet("agendas");
        this._persistence_propertyChange("agendas", this.agendas, list);
        this.agendas = list;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", this.name, string);
        this.name = string;
    }

    public String _persistence_get_namespace() {
        this._persistence_checkFetched("namespace");
        return this.namespace;
    }

    public void _persistence_set_namespace(String string) {
        this._persistence_checkFetchedForSet("namespace");
        this._persistence_propertyChange("namespace", this.namespace, string);
        this.namespace = string;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this._persistence_propertyChange("description", this.description, string);
        this.description = string;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this._persistence_propertyChange("active", new Boolean(this.active), new Boolean(bl));
        this.active = bl;
    }

    public String _persistence_get_typeId() {
        this._persistence_checkFetched("typeId");
        return this.typeId;
    }

    public void _persistence_set_typeId(String string) {
        this._persistence_checkFetchedForSet("typeId");
        this._persistence_propertyChange("typeId", this.typeId, string);
        this.typeId = string;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, string);
        this.id = string;
    }

    public Long _persistence_get_versionNumber() {
        this._persistence_checkFetched("versionNumber");
        return this.versionNumber;
    }

    public void _persistence_set_versionNumber(Long l) {
        this._persistence_checkFetchedForSet("versionNumber");
        this._persistence_propertyChange("versionNumber", this.versionNumber, l);
        this.versionNumber = l;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

