/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.tree.Node;
import org.kuali.rice.krad.data.CopyOption;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.maintenance.MaintenanceDocumentController;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.uif.view.ViewModel;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.DocumentFormBase;
import org.kuali.rice.krad.web.form.MaintenanceDocumentForm;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krms.api.KrmsApiServiceLocator;
import org.kuali.rice.krms.api.engine.expression.ComparisonOperatorService;
import org.kuali.rice.krms.api.repository.LogicalOperator;
import org.kuali.rice.krms.api.repository.operator.CustomOperator;
import org.kuali.rice.krms.api.repository.proposition.PropositionParameterType;
import org.kuali.rice.krms.api.repository.proposition.PropositionType;
import org.kuali.rice.krms.api.repository.rule.RuleDefinition;
import org.kuali.rice.krms.api.repository.term.TermDefinition;
import org.kuali.rice.krms.api.repository.term.TermResolverDefinition;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.impl.repository.ActionBo;
import org.kuali.rice.krms.impl.repository.AgendaBo;
import org.kuali.rice.krms.impl.repository.AgendaItemBo;
import org.kuali.rice.krms.impl.repository.ContextBoService;
import org.kuali.rice.krms.impl.repository.FunctionBoService;
import org.kuali.rice.krms.impl.repository.KrmsAttributeDefinitionService;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;
import org.kuali.rice.krms.impl.repository.PropositionBo;
import org.kuali.rice.krms.impl.repository.PropositionParameterBo;
import org.kuali.rice.krms.impl.repository.RepositoryBoIncrementer;
import org.kuali.rice.krms.impl.repository.RuleBo;
import org.kuali.rice.krms.impl.repository.RuleBoService;
import org.kuali.rice.krms.impl.repository.TermBo;
import org.kuali.rice.krms.impl.rule.AgendaEditorBusRule;
import org.kuali.rice.krms.impl.ui.AgendaEditor;
import org.kuali.rice.krms.impl.ui.AgendaEditorMaintainable;
import org.kuali.rice.krms.impl.ui.CompoundOpCodeNode;
import org.kuali.rice.krms.impl.ui.CustomOperatorUiTranslator;
import org.kuali.rice.krms.impl.ui.PropositionOpCodeValuesFinder;
import org.kuali.rice.krms.impl.ui.RuleTreeNode;
import org.kuali.rice.krms.impl.util.KrmsServiceLocatorInternal;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"krmsAgendaEditor"})
public class AgendaEditorController
extends MaintenanceDocumentController {
    private static final RepositoryBoIncrementer agendaIdIncrementer = new RepositoryBoIncrementer("KRMS_AGENDA_S");
    private static final RepositoryBoIncrementer agendaItemIdIncrementer = new RepositoryBoIncrementer("KRMS_AGENDA_ITM_S");
    private static final RepositoryBoIncrementer ruleIdIncrementer = new RepositoryBoIncrementer("KRMS_RULE_S");

    @RequestMapping(params={"methodToCall=route"})
    public ModelAndView route(DocumentFormBase form) {
        MaintenanceDocumentForm maintenanceForm = (MaintenanceDocumentForm)form;
        AgendaEditor agendaEditor = (AgendaEditor)maintenanceForm.getDocument().getNewMaintainableObject().getDataObject();
        agendaEditor.setSelectedAgendaItemId("");
        agendaEditor.setDisableButtons(true);
        ModelAndView modelAndView = super.route(form);
        return modelAndView;
    }

    @RequestMapping(params={"methodToCall=refresh"})
    public ModelAndView refresh(UifFormBase form) {
        ModelAndView modelAndView = super.refresh(form);
        AgendaEditorBusRule rule = new AgendaEditorBusRule();
        MaintenanceDocumentForm maintenanceForm = (MaintenanceDocumentForm)form;
        AgendaEditor agendaEditor = (AgendaEditor)maintenanceForm.getDocument().getNewMaintainableObject().getDataObject();
        if (rule.validContext(agendaEditor) && rule.validAgendaName(agendaEditor) && !StringUtils.equals((String)agendaEditor.getOldContextId(), (String)agendaEditor.getAgenda().getContextId())) {
            agendaEditor.setOldContextId(agendaEditor.getAgenda().getContextId());
            String namespace = "";
            if (!StringUtils.isBlank((String)agendaEditor.getAgenda().getContextId())) {
                namespace = this.getContextBoService().getContextByContextId(agendaEditor.getAgenda().getContextId()).getNamespace();
            }
            for (AgendaItemBo agendaItem : agendaEditor.getAgenda().getItems()) {
                agendaItem.getRule().setNamespace(namespace);
                for (ActionBo action : agendaItem.getRule().getActions()) {
                    action.setNamespace(namespace);
                }
            }
        }
        return modelAndView;
    }

    public ModelAndView setupMaintenanceEdit(MaintenanceDocumentForm form) {
        form.setPageId(null);
        return super.setupMaintenanceEdit(form);
    }

    @RequestMapping(params={"methodToCall=goToAddRule"})
    public ModelAndView goToAddRule(UifFormBase form) throws Exception {
        AgendaEditorBusRule rule = new AgendaEditorBusRule();
        AgendaEditor agendaEditorForBusRuleChecks = this.getAgendaEditor(form);
        if (rule.validContext(agendaEditorForBusRuleChecks) && rule.validAgendaName(agendaEditorForBusRuleChecks)) {
            this.setAgendaItemLine(form, null);
            AgendaEditor agendaEditor = this.getAgendaEditor(form);
            agendaEditor.setAddRuleInProgress(true);
            form.getActionParameters().put("navigateToPageId", "AgendaEditorView-AddRule-Page");
            return super.navigate(form);
        }
        return super.navigate(form);
    }

    private void setAgendaItemLine(UifFormBase form, AgendaItemBo agendaItem) {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        if (agendaItem == null) {
            RuleBo rule = new RuleBo();
            rule.setId(ruleIdIncrementer.getNewId());
            if (StringUtils.isBlank((String)agendaEditor.getAgenda().getContextId())) {
                rule.setNamespace("");
            } else {
                rule.setNamespace(this.getContextBoService().getContextByContextId(agendaEditor.getAgenda().getContextId()).getNamespace());
            }
            agendaItem = new AgendaItemBo();
            agendaItem.setRule(rule);
            agendaEditor.setAgendaItemLine(agendaItem);
        } else {
            agendaEditor.setAgendaItemLine((AgendaItemBo)KradDataServiceLocator.getDataObjectService().copyInstance((Object)agendaItem, new CopyOption[0]));
        }
        if (agendaItem.getRule().getActions().isEmpty()) {
            ActionBo actionBo = new ActionBo();
            actionBo.setTypeId("");
            actionBo.setNamespace(agendaItem.getRule().getNamespace());
            actionBo.setRule(agendaItem.getRule());
            actionBo.setSequenceNumber(1);
            agendaEditor.setAgendaItemLineRuleAction(actionBo);
        } else {
            agendaEditor.setAgendaItemLineRuleAction(agendaItem.getRule().getActions().get(0));
        }
        agendaEditor.setCustomRuleActionAttributesMap(agendaEditor.getAgendaItemLineRuleAction().getAttributes());
        agendaEditor.setCustomRuleAttributesMap(agendaEditor.getAgendaItemLine().getRule().getAttributes());
    }

    private String getSelectedAgendaItemId(UifFormBase form) {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        return agendaEditor.getSelectedAgendaItemId();
    }

    private void setCutAgendaItemId(UifFormBase form, String cutAgendaItemId) {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        agendaEditor.setCutAgendaItemId(cutAgendaItemId);
    }

    private String getCutAgendaItemId(UifFormBase form) {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        return agendaEditor.getCutAgendaItemId();
    }

    @RequestMapping(params={"methodToCall=goToEditRule"})
    public ModelAndView goToEditRule(UifFormBase form) throws Exception {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        AgendaEditorBusRule rule = new AgendaEditorBusRule();
        agendaEditor.clearDeletedPropositionIdsFromRule();
        if (rule.validContext(agendaEditor) && rule.validAgendaName(agendaEditor)) {
            agendaEditor.setAddRuleInProgress(false);
            AgendaItemBo firstItem = this.getFirstAgendaItem(agendaEditor.getAgenda());
            String selectedItemId = agendaEditor.getSelectedAgendaItemId();
            AgendaItemBo node = this.getAgendaItemById(firstItem, selectedItemId);
            this.preprocessCustomOperators(node.getRule().getProposition(), this.getCustomOperatorValueMap(form));
            this.setAgendaItemLine(form, node);
            form.getActionParameters().put("navigateToPageId", "AgendaEditorView-EditRule-Page");
            return super.navigate(form);
        }
        return super.navigate(form);
    }

    protected Map<String, String> getCustomOperatorValueMap(UifFormBase form) {
        List<KeyValue> allPropositionOpCodes = new PropositionOpCodeValuesFinder().getKeyValues((ViewModel)form);
        HashMap<String, String> functionIdToCustomOpCodeMap = new HashMap<String, String>();
        for (KeyValue opCode : allPropositionOpCodes) {
            if (!opCode.getKey().startsWith("customOperator:")) continue;
            CustomOperator customOperator = this.getCustomOperatorUiTranslator().getCustomOperator(opCode.getKey());
            functionIdToCustomOpCodeMap.put(customOperator.getOperatorFunctionDefinition().getId(), opCode.getKey());
        }
        return functionIdToCustomOpCodeMap;
    }

    protected void preprocessCustomOperators(PropositionBo proposition, Map<String, String> customOperatorValuesMap) {
        block4: {
            block3: {
                if (proposition == null) {
                    return;
                }
                if (proposition.getParameters() == null || proposition.getParameters().size() <= 0) break block3;
                for (PropositionParameterBo param : proposition.getParameters()) {
                    String convertedValue;
                    if (!PropositionParameterType.FUNCTION.getCode().equals(param.getParameterType()) || StringUtils.isEmpty((String)(convertedValue = customOperatorValuesMap.get(param.getValue())))) continue;
                    param.setValue(convertedValue);
                }
                break block4;
            }
            if (proposition.getCompoundComponents() == null || proposition.getCompoundComponents().size() <= 0) break block4;
            for (PropositionBo childProposition : proposition.getCompoundComponents()) {
                this.preprocessCustomOperators(childProposition, customOperatorValuesMap);
            }
        }
    }

    @RequestMapping(params={"methodToCall=addRule"})
    public ModelAndView addRule(UifFormBase form) throws Exception {
        MaintenanceDocumentForm maintenanceForm;
        MaintenanceDocument document;
        AgendaEditorBusRule rule;
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        AgendaBo agenda = agendaEditor.getAgenda();
        AgendaItemBo newAgendaItem = agendaEditor.getAgendaItemLine();
        if (!this.validateProposition(newAgendaItem.getRule().getProposition(), newAgendaItem.getRule().getNamespace())) {
            form.getActionParameters().put("navigateToPageId", "AgendaEditorView-AddRule-Page");
            return super.navigate(form);
        }
        newAgendaItem.getRule().setAttributes(agendaEditor.getCustomRuleAttributesMap());
        RuleDefinition existingRule = this.getRuleBoService().getRuleByRuleId(newAgendaItem.getRuleId());
        if (existingRule != null) {
            GlobalVariables.getMessageMap().putError("AgendaEditorView-AddRule-Page", "error.rule.unsavedCopyRule", new String[0]);
            return super.navigate(form);
        }
        this.updateRuleAction(agendaEditor);
        if (agenda.getItems() == null) {
            agenda.setItems(new ArrayList<AgendaItemBo>());
        }
        if ((rule = new AgendaEditorBusRule()).processAgendaItemBusinessRules(document = (maintenanceForm = (MaintenanceDocumentForm)form).getDocument())) {
            newAgendaItem.setId(agendaItemIdIncrementer.getNewId());
            newAgendaItem.setAgendaId(this.getCreateAgendaId(agenda));
            if (agenda.getFirstItemId() == null) {
                agenda.setFirstItem(newAgendaItem);
                agenda.setFirstItemId(newAgendaItem.getId());
            } else {
                String selectedAgendaItemId = this.getSelectedAgendaItemId(form);
                if (StringUtils.isBlank((String)selectedAgendaItemId)) {
                    AgendaItemBo node = this.getFirstAgendaItem(agenda);
                    while (node.getAlways() != null) {
                        node = node.getAlways();
                    }
                    node.setAlwaysId(newAgendaItem.getId());
                    node.setAlways(newAgendaItem);
                } else {
                    AgendaItemBo firstItem = this.getFirstAgendaItem(agenda);
                    AgendaItemBo node = this.getAgendaItemById(firstItem, selectedAgendaItemId);
                    newAgendaItem.setAlwaysId(node.getAlwaysId());
                    newAgendaItem.setAlways(node.getAlways());
                    node.setAlwaysId(newAgendaItem.getId());
                    node.setAlways(newAgendaItem);
                }
            }
            agenda.getItems().add(newAgendaItem);
            agendaEditor.setAddRuleInProgress(false);
            form.getActionParameters().put("navigateToPageId", "AgendaEditorView-Agenda-Page");
        } else {
            form.getActionParameters().put("navigateToPageId", "AgendaEditorView-AddRule-Page");
        }
        return super.navigate(form);
    }

    private boolean validateProposition(PropositionBo proposition, String namespace) {
        boolean result = true;
        if (proposition != null) {
            if (StringUtils.isBlank((String)proposition.getDescription())) {
                GlobalVariables.getMessageMap().putError("RuleEditorView-Tree", "error.rule.proposition.missingDescription", new String[0]);
                result &= false;
            }
            if (StringUtils.isBlank((String)proposition.getCompoundOpCode())) {
                result &= this.validateSimpleProposition(proposition, namespace);
            } else {
                List<PropositionBo> compoundComponents = proposition.getCompoundComponents();
                if (!CollectionUtils.isEmpty(proposition.getParameters())) {
                    GlobalVariables.getMessageMap().putError("RuleEditorView-Tree", "error.rule.proposition.compound.invalidParameter", new String[]{proposition.getDescription()});
                    result &= false;
                }
                if (!CollectionUtils.isEmpty(compoundComponents)) {
                    for (PropositionBo childProp : compoundComponents) {
                        result &= this.validateProposition(childProp, namespace);
                    }
                }
            }
        }
        return result;
    }

    private boolean validateSimpleProposition(PropositionBo proposition, String namespace) {
        boolean result = true;
        if (!CollectionUtils.isEmpty(proposition.getCompoundComponents())) {
            GlobalVariables.getMessageMap().putError("RuleEditorView-Tree", "error.rule.proposition.simple.hasChildren", new String[]{proposition.getDescription()});
            result &= false;
        }
        if (CollectionUtils.isEmpty(proposition.getParameters())) {
            return result &= false;
        }
        String propConstant = null;
        if (proposition.getParameters().get(1) != null) {
            propConstant = proposition.getParameters().get(1).getValue();
        }
        String operatorCode = null;
        if (proposition.getParameters().get(2) != null) {
            operatorCode = proposition.getParameters().get(2).getValue();
        }
        String termId = null;
        if (proposition.getParameters().get(0) != null) {
            termId = proposition.getParameters().get(0).getValue();
        }
        if (StringUtils.isBlank(termId)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("RuleEditorView-Tree", "error.rule.proposition.simple.blankField", new String[]{proposition.getDescription(), "Term"});
            result &= false;
        } else {
            result = this.validateTerm(proposition, namespace);
        }
        if (StringUtils.isBlank((String)operatorCode)) {
            GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("RuleEditorView-Tree", "error.rule.proposition.simple.blankField", new String[]{proposition.getDescription(), "Operator"});
            return result &= false;
        }
        if (StringUtils.isBlank((String)propConstant) && !operatorCode.endsWith("null")) {
            GlobalVariables.getMessageMap().putErrorForSectionId("RuleEditorView-Tree", "error.rule.proposition.simple.blankField", new String[]{proposition.getDescription(), "Value"});
            result &= false;
        } else if (operatorCode.endsWith("null")) {
            if (propConstant != null) {
                proposition.getParameters().get(1).setValue(null);
            }
        } else if (!StringUtils.isBlank((String)termId)) {
            String termType = this.lookupTermType(termId);
            if (operatorCode.startsWith("customOperator:")) {
                CustomOperator customOperator = this.getCustomOperatorUiTranslator().getCustomOperator(operatorCode);
                List errors = customOperator.validateOperandClasses(termType, String.class.getName());
                if (!CollectionUtils.isEmpty((Collection)errors)) {
                    for (RemotableAttributeError error : errors) {
                        GlobalVariables.getMessageMap().putError("RuleEditorView-Tree", error.getMessage(), new String[]{proposition.getDescription(), termType});
                    }
                    result &= false;
                }
            } else {
                ComparisonOperatorService comparisonOperatorService = KrmsApiServiceLocator.getComparisonOperatorService();
                if (comparisonOperatorService.canCoerce(termType, propConstant) && comparisonOperatorService.coerce(termType, propConstant) == null) {
                    GlobalVariables.getMessageMap().putError("RuleEditorView-Tree", "error.rule.proposition.simple.invalidValue", new String[]{proposition.getDescription(), propConstant});
                    result &= false;
                }
            }
        }
        return result;
    }

    private boolean validateTerm(PropositionBo proposition, String namespace) {
        boolean result = true;
        String termId = proposition.getParameters().get(0).getValue();
        if (termId.startsWith("parameterized:")) {
            if (StringUtils.isBlank((String)proposition.getNewTermDescription())) {
                GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("RuleEditorView-Tree", "error.rule.proposition.simple.emptyTermName", new String[]{proposition.getDescription()});
                result &= false;
            } else {
                HashMap<String, String> critMap = new HashMap<String, String>();
                critMap.put("description", proposition.getNewTermDescription());
                critMap.put("specification.namespace", namespace);
                QueryByCriteria criteria = QueryByCriteria.Builder.andAttributes(critMap).build();
                QueryResults matchingTerms = KRADServiceLocator.getDataObjectService().findMatching(TermBo.class, criteria);
                if (!CollectionUtils.isEmpty((Collection)matchingTerms.getResults())) {
                    GlobalVariables.getMessageMap().putWarningWithoutFullErrorPath("RuleEditorView-Tree", "warning.rule.proposition.simple.duplicateTermName", new String[]{proposition.getDescription()});
                }
            }
            String termSpecificationId = termId.substring("parameterized:".length());
            TermResolverDefinition termResolverDefinition = AgendaEditorMaintainable.getSimplestTermResolver(termSpecificationId, namespace);
            if (termResolverDefinition == null) {
                GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("RuleEditorView-Tree", "error.rule.proposition.simple.invalidTerm", new String[]{proposition.getDescription()});
                result &= false;
            } else {
                ArrayList parameterNames = new ArrayList(termResolverDefinition.getParameterNames());
                Collections.sort(parameterNames);
                for (String parameterName : parameterNames) {
                    if (proposition.getTermParameters().containsKey(parameterName) && !StringUtils.isBlank((String)proposition.getTermParameters().get(parameterName))) continue;
                    GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("RuleEditorView-Tree", "error.rule.proposition.simple.missingTermParameter", new String[]{proposition.getDescription()});
                    result &= false;
                    break;
                }
            }
        } else {
            TermDefinition termDefinition = KrmsRepositoryServiceLocator.getTermBoService().getTerm(termId);
            if (termDefinition == null) {
                GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("RuleEditorView-Tree", "error.rule.proposition.simple.invalidTerm", new String[]{proposition.getDescription()});
            } else if (!namespace.equals(termDefinition.getSpecification().getNamespace())) {
                GlobalVariables.getMessageMap().putErrorWithoutFullErrorPath("RuleEditorView-Tree", "error.rule.proposition.simple.invalidTerm", new String[]{proposition.getDescription()});
            }
        }
        return result;
    }

    private String lookupTermType(String key) {
        TermSpecificationDefinition termSpec = null;
        if (key.startsWith("parameterized:")) {
            String termSpecificationId = key.substring("parameterized:".length());
            termSpec = KrmsRepositoryServiceLocator.getTermBoService().getTermSpecificationById(termSpecificationId);
        } else {
            TermDefinition term = KrmsRepositoryServiceLocator.getTermBoService().getTerm(key);
            if (term != null) {
                termSpec = term.getSpecification();
            }
        }
        if (termSpec != null) {
            return termSpec.getType();
        }
        return null;
    }

    private String getCreateAgendaId(AgendaBo agenda) {
        if (agenda.getId() == null) {
            agenda.setId(agendaIdIncrementer.getNewId());
        }
        return agenda.getId();
    }

    private void updateRuleAction(AgendaEditor agendaEditor) {
        agendaEditor.getAgendaItemLine().getRule().setActions(new ArrayList<ActionBo>());
        if (StringUtils.isNotBlank((String)agendaEditor.getAgendaItemLineRuleAction().getTypeId())) {
            agendaEditor.getAgendaItemLineRuleAction().setAttributes(agendaEditor.getCustomRuleActionAttributesMap());
            agendaEditor.getAgendaItemLine().getRule().getActions().add(agendaEditor.getAgendaItemLineRuleAction());
        }
    }

    private Map<String, KrmsAttributeDefinition> buildAttributeDefinitionMap(String actionTypeId) {
        KrmsAttributeDefinitionService attributeDefinitionService = KrmsRepositoryServiceLocator.getKrmsAttributeDefinitionService();
        HashMap<String, KrmsAttributeDefinition> attributeDefinitionMap = new HashMap<String, KrmsAttributeDefinition>();
        List<KrmsAttributeDefinition> attributeDefinitions = attributeDefinitionService.findAttributeDefinitionsByType(actionTypeId);
        for (KrmsAttributeDefinition attributeDefinition : attributeDefinitions) {
            attributeDefinitionMap.put(attributeDefinition.getName(), attributeDefinition);
        }
        return attributeDefinitionMap;
    }

    @RequestMapping(params={"methodToCall=editRule"})
    public ModelAndView editRule(UifFormBase form) throws Exception {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        AgendaItemBo firstItem = this.getFirstAgendaItem(agendaEditor.getAgenda());
        AgendaItemBo node = this.getAgendaItemById(firstItem, this.getSelectedAgendaItemId(form));
        AgendaItemBo agendaItemLine = agendaEditor.getAgendaItemLine();
        if (!this.validateProposition(agendaItemLine.getRule().getProposition(), agendaItemLine.getRule().getNamespace())) {
            form.getActionParameters().put("navigateToPageId", "AgendaEditorView-EditRule-Page");
            return super.navigate(form);
        }
        agendaItemLine.getRule().setAttributes(agendaEditor.getCustomRuleAttributesMap());
        this.updateRuleAction(agendaEditor);
        AgendaEditorBusRule rule = new AgendaEditorBusRule();
        MaintenanceDocumentForm maintenanceForm = (MaintenanceDocumentForm)form;
        MaintenanceDocument document = maintenanceForm.getDocument();
        if (rule.processAgendaItemBusinessRules(document)) {
            node.setRule(agendaItemLine.getRule());
            form.getActionParameters().put("navigateToPageId", "AgendaEditorView-Agenda-Page");
        } else {
            form.getActionParameters().put("navigateToPageId", "AgendaEditorView-EditRule-Page");
        }
        agendaEditor.applyDeletedPropositionIdsFromRule();
        return super.navigate(form);
    }

    private AgendaItemInstanceChildAccessor getLastChildsAlwaysAccessor(AgendaItemInstanceChildAccessor instanceAccessor) {
        AgendaItemBo next = instanceAccessor.getChild();
        if (next == null) {
            return instanceAccessor;
        }
        while (next.getAlways() != null) {
            next = next.getAlways();
        }
        return new AgendaItemInstanceChildAccessor(AgendaItemChildAccessor.always, next);
    }

    private AgendaItemInstanceChildAccessor getInstanceAccessorToChild(AgendaItemBo parent, String agendaItemId) {
        for (AgendaItemChildAccessor levelOrderChildAccessor : AgendaItemChildAccessor.children) {
            AgendaItemBo next = levelOrderChildAccessor.getChild(parent);
            if (next != null && agendaItemId.equals(next.getId())) {
                return new AgendaItemInstanceChildAccessor(levelOrderChildAccessor, parent);
            }
            while (next != null && next.getAlwaysId() != null) {
                if (next.getAlwaysId().equals(agendaItemId)) {
                    return new AgendaItemInstanceChildAccessor(AgendaItemChildAccessor.always, next);
                }
                next = next.getAlways();
            }
        }
        return null;
    }

    @RequestMapping(params={"methodToCall=ajaxRefresh"})
    public ModelAndView ajaxRefresh(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.getModelAndView(form);
    }

    @RequestMapping(params={"methodToCall=ajaxMoveUp"})
    public ModelAndView ajaxMoveUp(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.moveSelectedSubtreeUp(form);
        return this.getModelAndView(form);
    }

    @RequestMapping(params={"methodToCall=ajaxValidRuleName"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean ajaxValidRuleName(@RequestParam String name, @RequestParam String namespace) {
        return this.getRuleBoService().getRuleByNameAndNamespace(name, namespace) != null;
    }

    private void moveSelectedSubtreeUp(UifFormBase form) {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        AgendaItemBo firstItem = this.getFirstAgendaItem(agendaEditor.getAgenda());
        String selectedItemId = agendaEditor.getSelectedAgendaItemId();
        AgendaItemBo node = this.getAgendaItemById(firstItem, selectedItemId);
        AgendaItemBo parent = this.getParent(firstItem, selectedItemId);
        AgendaItemBo parentsOlderCousin = parent == null ? null : this.getNextOldestOfSameGeneration(firstItem, parent);
        StringBuilder ruleEditorMessage = new StringBuilder();
        AgendaItemChildAccessor childAccessor = this.getOldestChildAccessor(node, parent);
        if (childAccessor != null) {
            if (childAccessor == AgendaItemChildAccessor.whenFalse) {
                AgendaItemInstanceChildAccessor youngestWhenTrueSiblingInsertionPoint = this.getLastChildsAlwaysAccessor(new AgendaItemInstanceChildAccessor(AgendaItemChildAccessor.whenTrue, parent));
                youngestWhenTrueSiblingInsertionPoint.setChild(node);
                AgendaItemChildAccessor.whenFalse.setChild(parent, node.getAlways());
                AgendaItemChildAccessor.always.setChild(node, null);
                ruleEditorMessage.append("Moved ").append(node.getRule().getName()).append(" up ");
                ruleEditorMessage.append("to last position in When TRUE group of ").append(parent.getRule().getName());
            } else if (parentsOlderCousin != null) {
                AgendaItemInstanceChildAccessor youngestWhenFalseSiblingInsertionPoint = this.getLastChildsAlwaysAccessor(new AgendaItemInstanceChildAccessor(AgendaItemChildAccessor.whenFalse, parentsOlderCousin));
                youngestWhenFalseSiblingInsertionPoint.setChild(node);
                AgendaItemChildAccessor.whenTrue.setChild(parent, node.getAlways());
                AgendaItemChildAccessor.always.setChild(node, null);
                ruleEditorMessage.append("Moved ").append(node.getRule().getName()).append(" up ");
                ruleEditorMessage.append("to When FALSE group of ").append(parentsOlderCousin.getRule().getName());
            }
        } else if (!selectedItemId.equals(firstItem.getId())) {
            AgendaItemBo bogusRootNode = null;
            if (parent == null) {
                bogusRootNode = new AgendaItemBo();
                AgendaItemChildAccessor.whenTrue.setChild(bogusRootNode, firstItem);
                parent = bogusRootNode;
            }
            AgendaItemInstanceChildAccessor accessorToSelectedNode = this.getInstanceAccessorToChild(parent, node.getId());
            AgendaItemBo olderSibling = accessorToSelectedNode.getInstance();
            AgendaItemInstanceChildAccessor accessorToOlderSibling = this.getInstanceAccessorToChild(parent, olderSibling.getId());
            accessorToOlderSibling.setChild(node);
            accessorToSelectedNode.setChild(node.getAlways());
            AgendaItemChildAccessor.always.setChild(node, olderSibling);
            ruleEditorMessage.append("Moved ").append(node.getRule().getName()).append(" up ");
            if (bogusRootNode != null) {
                agendaEditor.getAgenda().setFirstItemId(bogusRootNode.getWhenTrueId());
                agendaEditor.getAgenda().setFirstItem(bogusRootNode.getWhenTrue());
                ruleEditorMessage.append(" to ").append(this.getFirstAgendaItem(agendaEditor.getAgenda()).getRule().getName()).append(" When TRUE group");
            } else {
                ruleEditorMessage.append(" within its sibling group, above " + olderSibling.getRule().getName());
            }
        }
        agendaEditor.setRuleEditorMessage(ruleEditorMessage.toString());
    }

    @RequestMapping(params={"methodToCall=ajaxMoveDown"})
    public ModelAndView ajaxMoveDown(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.moveSelectedSubtreeDown(form);
        return this.getModelAndView(form);
    }

    private void moveSelectedSubtreeDown(UifFormBase form) {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        AgendaItemBo firstItem = this.getFirstAgendaItem(agendaEditor.getAgenda());
        String selectedItemId = agendaEditor.getSelectedAgendaItemId();
        AgendaItemBo node = this.getAgendaItemById(firstItem, selectedItemId);
        AgendaItemBo parent = this.getParent(firstItem, selectedItemId);
        AgendaItemBo parentsYoungerCousin = parent == null ? null : this.getNextYoungestOfSameGeneration(firstItem, parent);
        StringBuilder ruleEditorMessage = new StringBuilder();
        if (node.getAlways() == null && parent != null) {
            if (parent.getWhenTrue() != null && this.isSiblings(parent.getWhenTrue(), node)) {
                AgendaItemInstanceChildAccessor accessorToSelectedNode = this.getInstanceAccessorToChild(parent, node.getId());
                accessorToSelectedNode.setChild(null);
                AgendaItemBo parentsFirstChild = parent.getWhenFalse();
                AgendaItemChildAccessor.whenFalse.setChild(parent, node);
                AgendaItemChildAccessor.always.setChild(node, parentsFirstChild);
                ruleEditorMessage.append("Moved ").append(node.getRule().getName()).append(" down ");
                ruleEditorMessage.append("to first child under When FALSE group of ").append(parent.getRule().getName());
            } else if (parentsYoungerCousin != null) {
                AgendaItemInstanceChildAccessor accessorToSelectedNode = this.getInstanceAccessorToChild(parent, node.getId());
                accessorToSelectedNode.setChild(null);
                AgendaItemBo parentsYoungerCousinsFirstChild = parentsYoungerCousin.getWhenTrue();
                AgendaItemChildAccessor.whenTrue.setChild(parentsYoungerCousin, node);
                AgendaItemChildAccessor.always.setChild(node, parentsYoungerCousinsFirstChild);
                ruleEditorMessage.append("Moved ").append(node.getRule().getName()).append(" down ");
                ruleEditorMessage.append("to first child under When TRUE group of ").append(parentsYoungerCousin.getRule().getName());
            }
        } else if (node.getAlways() != null) {
            AgendaItemBo bogusRootNode = null;
            if (parent == null) {
                bogusRootNode = new AgendaItemBo();
                AgendaItemChildAccessor.whenFalse.setChild(bogusRootNode, firstItem);
                parent = bogusRootNode;
            }
            AgendaItemInstanceChildAccessor accessorToSelectedNode = this.getInstanceAccessorToChild(parent, node.getId());
            AgendaItemBo youngerSibling = node.getAlways();
            accessorToSelectedNode.setChild(youngerSibling);
            AgendaItemChildAccessor.always.setChild(node, youngerSibling.getAlways());
            AgendaItemChildAccessor.always.setChild(youngerSibling, node);
            if (bogusRootNode != null) {
                agendaEditor.getAgenda().setFirstItemId(bogusRootNode.getWhenFalseId());
                agendaEditor.getAgenda().setFirstItem(bogusRootNode.getWhenFalse());
            }
            ruleEditorMessage.append("Moved ").append(node.getRule().getName()).append(" down ");
            ruleEditorMessage.append(" within its sibling group, below ").append(youngerSibling.getRule().getName());
        }
        agendaEditor.setRuleEditorMessage(ruleEditorMessage.toString());
    }

    @RequestMapping(params={"methodToCall=ajaxMoveLeft"})
    public ModelAndView ajaxMoveLeft(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.moveSelectedSubtreeLeft(form);
        return this.getModelAndView(form);
    }

    private void moveSelectedSubtreeLeft(UifFormBase form) {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        AgendaItemBo firstItem = this.getFirstAgendaItem(agendaEditor.getAgenda());
        String selectedItemId = agendaEditor.getSelectedAgendaItemId();
        AgendaItemBo node = this.getAgendaItemById(firstItem, selectedItemId);
        AgendaItemBo parent = this.getParent(firstItem, selectedItemId);
        if (parent != null) {
            AgendaItemInstanceChildAccessor accessorToSelectedNode = this.getInstanceAccessorToChild(parent, node.getId());
            accessorToSelectedNode.setChild(node.getAlways());
            AgendaItemChildAccessor.always.setChild(node, parent.getAlways());
            AgendaItemChildAccessor.always.setChild(parent, node);
            StringBuilder ruleEditorMessage = new StringBuilder();
            ruleEditorMessage.append("Moved ").append(node.getRule().getName()).append(" left to be a sibling of its parent ").append(parent.getRule().getName());
            agendaEditor.setRuleEditorMessage(ruleEditorMessage.toString());
        }
    }

    @RequestMapping(params={"methodToCall=ajaxMoveRight"})
    public ModelAndView ajaxMoveRight(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.moveSelectedSubtreeRight(form);
        return this.getModelAndView(form);
    }

    private void moveSelectedSubtreeRight(UifFormBase form) {
        AgendaItemInstanceChildAccessor accessorToSelectedNode;
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        AgendaItemBo firstItem = this.getFirstAgendaItem(agendaEditor.getAgenda());
        String selectedItemId = agendaEditor.getSelectedAgendaItemId();
        AgendaItemBo node = this.getAgendaItemById(firstItem, selectedItemId);
        AgendaItemBo parent = this.getParent(firstItem, selectedItemId);
        AgendaItemBo bogusRootNode = null;
        if (parent == null) {
            bogusRootNode = new AgendaItemBo();
            AgendaItemChildAccessor.whenFalse.setChild(bogusRootNode, firstItem);
            parent = bogusRootNode;
        }
        AgendaItemBo olderSibling = (accessorToSelectedNode = this.getInstanceAccessorToChild(parent, node.getId())).getInstance() == parent ? null : accessorToSelectedNode.getInstance();
        StringBuilder ruleEditorMessage = new StringBuilder();
        if (olderSibling != null) {
            accessorToSelectedNode.setChild(node.getAlways());
            AgendaItemInstanceChildAccessor yougestWhenFalseSiblingInsertionPoint = this.getLastChildsAlwaysAccessor(new AgendaItemInstanceChildAccessor(AgendaItemChildAccessor.whenFalse, olderSibling));
            yougestWhenFalseSiblingInsertionPoint.setChild(node);
            AgendaItemChildAccessor.always.setChild(node, null);
            ruleEditorMessage.append("Moved ").append(node.getRule().getName()).append(" right to ");
            ruleEditorMessage.append(olderSibling.getRule().getName()).append(" When FALSE group.");
        } else if (node.getAlways() != null) {
            accessorToSelectedNode.setChild(node.getAlways());
            AgendaItemBo childsWhenTrue = node.getAlways().getWhenTrue();
            AgendaItemChildAccessor.whenTrue.setChild(node.getAlways(), node);
            AgendaItemChildAccessor.always.setChild(node, childsWhenTrue);
            ruleEditorMessage.append("Moved ").append(node.getRule().getName()).append(" right to ");
            if (childsWhenTrue != null) {
                ruleEditorMessage.append(childsWhenTrue.getRule().getName()).append(" When TRUE group");
            }
        }
        if (bogusRootNode != null) {
            agendaEditor.getAgenda().setFirstItemId(bogusRootNode.getWhenFalseId());
            agendaEditor.getAgenda().setFirstItem(bogusRootNode.getWhenFalse());
            ruleEditorMessage.append(this.getFirstAgendaItem(agendaEditor.getAgenda()).getRule().getName()).append(" When TRUE group");
        }
        agendaEditor.setRuleEditorMessage(ruleEditorMessage.toString());
    }

    private boolean isSiblings(AgendaItemBo cousin1, AgendaItemBo cousin2) {
        if (cousin1.equals(cousin2)) {
            return true;
        }
        AgendaItemBo candidate = cousin2;
        while (null != (candidate = candidate.getAlways())) {
            if (!candidate.equals(cousin1)) continue;
            return true;
        }
        candidate = cousin1;
        while (null != (candidate = candidate.getAlways())) {
            if (!candidate.equals(cousin2)) continue;
            return true;
        }
        return false;
    }

    private AgendaItemChildAccessor getOldestChildAccessor(AgendaItemBo child, AgendaItemBo parent) {
        AgendaItemChildAccessor levelOrderChildAccessor = null;
        if (parent != null) {
            for (AgendaItemChildAccessor childAccessor : AgendaItemChildAccessor.children) {
                if (!child.equals(childAccessor.getChild(parent))) continue;
                levelOrderChildAccessor = childAccessor;
                break;
            }
        }
        return levelOrderChildAccessor;
    }

    private AgendaItemBo getFirstAgendaItem(AgendaBo agenda) {
        AgendaItemBo firstItem = null;
        if (agenda != null && agenda.getItems() != null) {
            for (AgendaItemBo agendaItem : agenda.getItems()) {
                if (!agenda.getFirstItemId().equals(agendaItem.getId())) continue;
                firstItem = agendaItem;
                break;
            }
        }
        return firstItem;
    }

    private AgendaItemBo getNextYoungestOfSameGeneration(AgendaItemBo root, AgendaItemBo agendaItem) {
        int genNumber = this.getAgendaItemGenerationNumber(0, root, agendaItem.getId());
        ArrayList<AgendaItemBo> genList = new ArrayList<AgendaItemBo>();
        this.buildAgendaItemGenerationList(genList, root, 0, genNumber);
        int itemIndex = genList.indexOf(agendaItem);
        if (genList.size() > itemIndex + 1) {
            return (AgendaItemBo)genList.get(itemIndex + 1);
        }
        return null;
    }

    private int getAgendaItemGenerationNumber(int currentLevel, AgendaItemBo node, String agendaItemId) {
        int result = -1;
        if (agendaItemId.equals(node.getId())) {
            result = currentLevel;
        } else {
            for (AgendaItemChildAccessor childAccessor : AgendaItemChildAccessor.linkedNodes) {
                AgendaItemBo child = childAccessor.getChild(node);
                if (child == null) continue;
                int nextLevel = currentLevel;
                if (childAccessor != AgendaItemChildAccessor.always) {
                    nextLevel = currentLevel + 1;
                }
                if ((result = this.getAgendaItemGenerationNumber(nextLevel, child, agendaItemId)) != -1) break;
            }
        }
        return result;
    }

    private void buildAgendaItemGenerationList(List<AgendaItemBo> genList, AgendaItemBo node, int currentLevel, int generation) {
        if (currentLevel == generation) {
            genList.add(node);
        }
        if (currentLevel > generation) {
            return;
        }
        for (AgendaItemChildAccessor childAccessor : AgendaItemChildAccessor.linkedNodes) {
            AgendaItemBo child = childAccessor.getChild(node);
            if (child == null) continue;
            int nextLevel = currentLevel;
            if (childAccessor != AgendaItemChildAccessor.always) {
                nextLevel = currentLevel + 1;
            }
            this.buildAgendaItemGenerationList(genList, child, nextLevel, generation);
        }
    }

    private AgendaItemBo getNextOldestOfSameGeneration(AgendaItemBo root, AgendaItemBo agendaItem) {
        int genNumber = this.getAgendaItemGenerationNumber(0, root, agendaItem.getId());
        ArrayList<AgendaItemBo> genList = new ArrayList<AgendaItemBo>();
        this.buildAgendaItemGenerationList(genList, root, 0, genNumber);
        int itemIndex = genList.indexOf(agendaItem);
        if (itemIndex >= 1) {
            return (AgendaItemBo)genList.get(itemIndex - 1);
        }
        return null;
    }

    private AgendaItemBo getParent(AgendaItemBo root, String agendaItemId) {
        return this.getParentHelper(root, null, agendaItemId);
    }

    private AgendaItemBo getParentHelper(AgendaItemBo node, AgendaItemBo levelOrderParent, String agendaItemId) {
        AgendaItemBo result = null;
        if (agendaItemId.equals(node.getId())) {
            result = levelOrderParent;
        } else {
            AgendaItemBo lop;
            AgendaItemChildAccessor childAccessor;
            AgendaItemBo child;
            AgendaItemChildAccessor[] agendaItemChildAccessorArray = AgendaItemChildAccessor.linkedNodes;
            int n = agendaItemChildAccessorArray.length;
            for (int i = 0; i < n && ((child = (childAccessor = agendaItemChildAccessorArray[i]).getChild(node)) == null || (result = this.getParentHelper(child, lop = childAccessor == AgendaItemChildAccessor.always ? levelOrderParent : node, agendaItemId)) == null); ++i) {
            }
        }
        return result;
    }

    private AgendaItemBo getAgendaItemById(AgendaItemBo node, String agendaItemId) {
        if (node == null) {
            throw new IllegalArgumentException("node must be non-null");
        }
        AgendaItemBo result = null;
        if (agendaItemId.equals(node.getId())) {
            result = node;
        } else {
            AgendaItemChildAccessor childAccessor;
            AgendaItemBo child;
            AgendaItemChildAccessor[] agendaItemChildAccessorArray = AgendaItemChildAccessor.linkedNodes;
            int n = agendaItemChildAccessorArray.length;
            for (int i = 0; i < n && ((child = (childAccessor = agendaItemChildAccessorArray[i]).getChild(node)) == null || (result = this.getAgendaItemById(child, agendaItemId)) == null); ++i) {
            }
        }
        return result;
    }

    private AgendaEditor getAgendaEditor(UifFormBase form) {
        MaintenanceDocumentForm maintenanceForm = (MaintenanceDocumentForm)form;
        return (AgendaEditor)maintenanceForm.getDocument().getDocumentDataObject();
    }

    @RequestMapping(params={"methodToCall=ajaxDelete"})
    public ModelAndView ajaxDelete(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.deleteSelectedSubtree(form);
        return this.getModelAndView(form);
    }

    private void deleteSelectedSubtree(UifFormBase form) {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        AgendaItemBo firstItem = this.getFirstAgendaItem(agendaEditor.getAgenda());
        if (firstItem != null) {
            String agendaItemSelected = agendaEditor.getSelectedAgendaItemId();
            AgendaItemBo selectedItem = this.getAgendaItemById(firstItem, agendaItemSelected);
            if (agendaItemSelected.equals(firstItem.getId())) {
                agendaEditor.getAgenda().setFirstItemId(firstItem.getAlwaysId());
                agendaEditor.getAgenda().setFirstItem(firstItem.getAlways());
            } else {
                this.deleteAgendaItem(firstItem, agendaItemSelected);
            }
            StringBuilder ruleEditorMessage = new StringBuilder();
            ruleEditorMessage.append("Deleted ").append(selectedItem.getRule().getName());
            if (selectedItem.getWhenTrue() != null) {
                this.removeAgendaItem(agendaEditor.getAgenda().getItems(), selectedItem.getWhenTrue());
                ruleEditorMessage.append(" and its When TRUE ").append(selectedItem.getWhenTrue().getRule().getName());
            }
            if (selectedItem.getWhenFalse() != null) {
                this.removeAgendaItem(agendaEditor.getAgenda().getItems(), selectedItem.getWhenFalse());
                ruleEditorMessage.append(" and its When FALSE ").append(selectedItem.getWhenFalse().getRule().getName());
            }
            agendaEditor.getAgenda().getItems().remove(selectedItem);
            agendaEditor.setRuleEditorMessage(ruleEditorMessage.toString());
        }
    }

    private void deleteAgendaItem(AgendaItemBo root, String agendaItemIdToDelete) {
        if (this.deleteAgendaItem(root, AgendaItemChildAccessor.whenTrue, agendaItemIdToDelete) || this.deleteAgendaItem(root, AgendaItemChildAccessor.whenFalse, agendaItemIdToDelete) || this.deleteAgendaItem(root, AgendaItemChildAccessor.always, agendaItemIdToDelete)) {
            // empty if block
        }
    }

    private boolean deleteAgendaItem(AgendaItemBo agendaItem, AgendaItemChildAccessor childAccessor, String agendaItemIdToDelete) {
        if (agendaItem == null || childAccessor.getChild(agendaItem) == null) {
            return false;
        }
        if (agendaItemIdToDelete.equals(childAccessor.getChild(agendaItem).getId())) {
            AgendaItemBo grandchildToKeep = childAccessor.getChild(agendaItem).getAlways();
            childAccessor.setChild(agendaItem, grandchildToKeep);
            return true;
        }
        AgendaItemBo child = childAccessor.getChild(agendaItem);
        for (AgendaItemChildAccessor nextChildAccessor : AgendaItemChildAccessor.linkedNodes) {
            if (!this.deleteAgendaItem(child, nextChildAccessor, agendaItemIdToDelete)) continue;
            return true;
        }
        return false;
    }

    private void removeAgendaItem(List<AgendaItemBo> items, AgendaItemBo removeAgendaItem) {
        if (removeAgendaItem.getWhenTrue() != null) {
            this.removeAgendaItem(items, removeAgendaItem.getWhenTrue());
        }
        if (removeAgendaItem.getWhenFalse() != null) {
            this.removeAgendaItem(items, removeAgendaItem.getWhenFalse());
        }
        if (removeAgendaItem.getAlways() != null) {
            this.removeAgendaItem(items, removeAgendaItem.getAlways());
        }
        items.remove(removeAgendaItem);
    }

    @RequestMapping(params={"methodToCall=ajaxCut"})
    public ModelAndView ajaxCut(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        AgendaItemBo firstItem = this.getFirstAgendaItem(agendaEditor.getAgenda());
        String selectedItemId = agendaEditor.getSelectedAgendaItemId();
        AgendaItemBo selectedAgendaItem = this.getAgendaItemById(firstItem, selectedItemId);
        this.setCutAgendaItemId(form, selectedItemId);
        StringBuilder ruleEditorMessage = new StringBuilder();
        ruleEditorMessage.append("Marked ").append(selectedAgendaItem.getRule().getName()).append(" for cutting.");
        agendaEditor.setRuleEditorMessage(ruleEditorMessage.toString());
        return this.getModelAndView(form);
    }

    @RequestMapping(params={"methodToCall=ajaxPaste"})
    public ModelAndView ajaxPaste(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        AgendaItemBo firstItem = this.getFirstAgendaItem(agendaEditor.getAgenda());
        String selectedItemId = agendaEditor.getSelectedAgendaItemId();
        String agendaItemId = this.getCutAgendaItemId(form);
        if (StringUtils.isNotBlank((String)selectedItemId) && StringUtils.isNotBlank((String)agendaItemId)) {
            StringBuilder ruleEditorMessage = new StringBuilder();
            AgendaItemBo node = this.getAgendaItemById(firstItem, agendaItemId);
            AgendaItemBo orgRefNode = this.getReferringNode(firstItem, agendaItemId);
            AgendaItemBo newRefNode = this.getAgendaItemById(firstItem, selectedItemId);
            if (this.isSameOrChildNode(node, newRefNode)) {
                ruleEditorMessage.append("Cannot paste ").append(node.getRule().getName()).append(" to itself.");
            } else {
                if (orgRefNode == null) {
                    agendaEditor.getAgenda().setFirstItemId(node.getAlwaysId());
                    agendaEditor.getAgenda().setFirstItem(node.getAlways());
                } else if (node.getId().equals(orgRefNode.getWhenTrueId())) {
                    orgRefNode.setWhenTrueId(node.getAlwaysId());
                    orgRefNode.setWhenTrue(node.getAlways());
                } else if (node.getId().equals(orgRefNode.getWhenFalseId())) {
                    orgRefNode.setWhenFalseId(node.getAlwaysId());
                    orgRefNode.setWhenFalse(node.getAlways());
                } else {
                    orgRefNode.setAlwaysId(node.getAlwaysId());
                    orgRefNode.setAlways(node.getAlways());
                }
                node.setAlwaysId(newRefNode.getAlwaysId());
                node.setAlways(newRefNode.getAlways());
                newRefNode.setAlwaysId(node.getId());
                newRefNode.setAlways(node);
                ruleEditorMessage.append(" Pasted ").append(node.getRule().getName());
                ruleEditorMessage.append(" to ").append(newRefNode.getRule().getName());
                agendaEditor.setRuleEditorMessage(ruleEditorMessage.toString());
            }
            this.setCutAgendaItemId(form, null);
        }
        return this.getModelAndView(form);
    }

    private boolean isSameOrChildNode(AgendaItemBo node, AgendaItemBo newParent) {
        return this.isSameOrChildNodeHelper(node, newParent, AgendaItemChildAccessor.children);
    }

    private boolean isSameOrChildNodeHelper(AgendaItemBo node, AgendaItemBo newParent, AgendaItemChildAccessor[] childAccessors) {
        boolean result = false;
        if (newParent == null || node == null) {
            return false;
        }
        if (StringUtils.equals((String)node.getId(), (String)newParent.getId())) {
            result = true;
        } else {
            AgendaItemChildAccessor childAccessor;
            AgendaItemBo child;
            AgendaItemChildAccessor[] agendaItemChildAccessorArray = childAccessors;
            int n = agendaItemChildAccessorArray.length;
            for (int i = 0; !(i >= n || (child = (childAccessor = agendaItemChildAccessorArray[i]).getChild(node)) != null && (result = this.isSameOrChildNodeHelper(child, newParent, AgendaItemChildAccessor.linkedNodes))); ++i) {
            }
        }
        return result;
    }

    private AgendaItemBo getReferringNode(AgendaItemBo root, String agendaItemId) {
        return this.getReferringNodeHelper(root, null, agendaItemId);
    }

    private AgendaItemBo getReferringNodeHelper(AgendaItemBo node, AgendaItemBo referringNode, String agendaItemId) {
        AgendaItemBo result = null;
        if (agendaItemId.equals(node.getId())) {
            result = referringNode;
        } else {
            AgendaItemChildAccessor childAccessor;
            AgendaItemBo child;
            AgendaItemChildAccessor[] agendaItemChildAccessorArray = AgendaItemChildAccessor.linkedNodes;
            int n = agendaItemChildAccessorArray.length;
            for (int i = 0; i < n && ((child = (childAccessor = agendaItemChildAccessorArray[i]).getChild(node)) == null || (result = this.getReferringNodeHelper(child, node, agendaItemId)) == null); ++i) {
            }
        }
        return result;
    }

    private FunctionBoService getFunctionBoService() {
        return KrmsRepositoryServiceLocator.getFunctionBoService();
    }

    private ContextBoService getContextBoService() {
        return KrmsRepositoryServiceLocator.getContextBoService();
    }

    private RuleBoService getRuleBoService() {
        return KrmsRepositoryServiceLocator.getRuleBoService();
    }

    private CustomOperatorUiTranslator getCustomOperatorUiTranslator() {
        return KrmsServiceLocatorInternal.getCustomOperatorUiTranslator();
    }

    @RequestMapping(params={"methodToCall=copyRule"})
    public ModelAndView copyRule(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        String name = agendaEditor.getCopyRuleName();
        String namespace = agendaEditor.getNamespace();
        String copyRuleNameErrorPropertyName = "AgendaEditorView-AddRule-Page";
        if (StringUtils.isBlank((String)name)) {
            GlobalVariables.getMessageMap().putError("AgendaEditorView-AddRule-Page", "error.rule.missingCopyRuleName", new String[0]);
            return super.refresh(form);
        }
        RuleDefinition oldRuleDefinition = this.getRuleBoService().getRuleByNameAndNamespace(name, namespace);
        if (oldRuleDefinition == null) {
            GlobalVariables.getMessageMap().putError("AgendaEditorView-AddRule-Page", "error.rule.invalidCopyRuleName", new String[]{namespace + ":" + name});
            return super.refresh(form);
        }
        RuleBo oldRule = RuleBo.from(oldRuleDefinition);
        RuleBo newRule = RuleBo.copyRule(oldRule);
        agendaEditor.getAgendaItemLine().setRule(newRule);
        if (!newRule.getActions().isEmpty()) {
            agendaEditor.setAgendaItemLineRuleAction(newRule.getActions().get(0));
        }
        return super.refresh(form);
    }

    @RequestMapping(params={"methodToCall=goToEditProposition"})
    public ModelAndView goToEditProposition(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        RuleBo rule = agendaEditor.getAgendaItemLine().getRule();
        String selectedPropId = agendaEditor.getSelectedPropositionId();
        Node root = rule.getPropositionTree().getRootElement();
        PropositionBo propositionToToggleEdit = null;
        boolean newEditMode = true;
        Node<RuleTreeNode, String> parent = this.findParentPropositionNode((Node<RuleTreeNode, String>)root, selectedPropId);
        if (parent != null) {
            List children = parent.getChildren();
            for (int index = 0; index < children.size(); ++index) {
                Node child = (Node)children.get(index);
                if (this.propIdMatches((Node<RuleTreeNode, String>)child, selectedPropId)) {
                    PropositionBo prop;
                    propositionToToggleEdit = prop = ((RuleTreeNode)child.getData()).getProposition();
                    newEditMode = !prop.getEditMode();
                    break;
                }
                ((RuleTreeNode)child.getData()).getProposition().setEditMode(false);
            }
        }
        this.resetEditModeOnPropositionTree((Node<RuleTreeNode, String>)root);
        if (propositionToToggleEdit != null) {
            propositionToToggleEdit.setEditMode(newEditMode);
            rule.refreshPropositionTree(null);
        }
        return this.getModelAndView(form);
    }

    protected Node<RuleTreeNode, String> getLastSimpleNode(List<Node<RuleTreeNode, String>> grandChildren) {
        int lastIndex;
        Node<RuleTreeNode, String> lastSimpleNode = grandChildren.get(lastIndex);
        for (lastIndex = grandChildren.size() - 1; !"ruleTreeNode simplePropositionNode".equalsIgnoreCase(lastSimpleNode.getNodeType()) && !"ruleTreeNode simplePropositionEditNode".equalsIgnoreCase(lastSimpleNode.getNodeType()) && lastIndex >= 0; --lastIndex) {
            lastSimpleNode = grandChildren.get(lastIndex);
        }
        return lastSimpleNode;
    }

    protected String getDefaultAddLocationPropositionId(Node<RuleTreeNode, String> root) {
        List children = root.getChildren();
        String selectedId = "";
        if (children.size() != 0) {
            Node child = (Node)children.get(0);
            List grandChildren = child.getChildren();
            if (grandChildren.size() != 0) {
                Node<RuleTreeNode, String> lastSimpleNode = this.getLastSimpleNode(grandChildren);
                selectedId = ((RuleTreeNode)lastSimpleNode.getData()).getProposition().getId();
            } else {
                selectedId = ((RuleTreeNode)child.getData()).getProposition().getId();
            }
        }
        return selectedId;
    }

    @RequestMapping(params={"methodToCall=addProposition"})
    public ModelAndView addProposition(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        RuleBo rule = agendaEditor.getAgendaItemLine().getRule();
        String selectedPropId = agendaEditor.getSelectedPropositionId();
        Node root = agendaEditor.getAgendaItemLine().getRule().getPropositionTree().getRootElement();
        if (StringUtils.isEmpty((String)selectedPropId)) {
            selectedPropId = this.getDefaultAddLocationPropositionId((Node<RuleTreeNode, String>)root);
        }
        Node<RuleTreeNode, String> parent = this.findParentPropositionNode((Node<RuleTreeNode, String>)root, selectedPropId);
        this.resetEditModeOnPropositionTree((Node<RuleTreeNode, String>)root);
        if (parent != null) {
            List children = parent.getChildren();
            for (int index = 0; index < children.size(); ++index) {
                Node child = (Node)children.get(index);
                if (!this.propIdMatches((Node<RuleTreeNode, String>)child, selectedPropId)) continue;
                if (parent == root && ("ruleTreeNode simplePropositionNode".equalsIgnoreCase(child.getNodeType()) || "ruleTreeNode simplePropositionEditNode".equalsIgnoreCase(child.getNodeType()))) {
                    PropositionBo compound = PropositionBo.createCompoundPropositionBoStub(((RuleTreeNode)child.getData()).getProposition(), true);
                    compound.setDescription("New Compound Proposition");
                    rule.setProposition(compound);
                    rule.refreshPropositionTree(null);
                } else if ("ruleTreeNode simplePropositionNode".equalsIgnoreCase(child.getNodeType()) || "ruleTreeNode simplePropositionEditNode".equalsIgnoreCase(child.getNodeType())) {
                    PropositionBo blank = PropositionBo.createSimplePropositionBoStub(((RuleTreeNode)child.getData()).getProposition(), PropositionType.SIMPLE.getCode());
                    PropositionBo parentProp = ((RuleTreeNode)parent.getData()).getProposition();
                    parentProp.getCompoundComponents().add(index / 2 + 1, blank);
                    rule.refreshPropositionTree(true);
                }
                break;
            }
        } else if (root.getChildren().isEmpty()) {
            PropositionBo blank = PropositionBo.createSimplePropositionBoStub(null, PropositionType.SIMPLE.getCode());
            blank.setRuleId(rule.getId());
            rule.setProposition(blank);
            rule.setProposition(blank);
            rule.refreshPropositionTree(true);
        }
        return this.getModelAndView(form);
    }

    private void addOpCodeNode(Node currentNode, PropositionBo prop, int index) {
        String opCodeLabel = "";
        if (LogicalOperator.AND.getCode().equalsIgnoreCase(prop.getCompoundOpCode())) {
            opCodeLabel = "AND";
        } else if (LogicalOperator.OR.getCode().equalsIgnoreCase(prop.getCompoundOpCode())) {
            opCodeLabel = "OR";
        }
        Node aNode = new Node();
        aNode.setNodeLabel((Object)"");
        aNode.setNodeType("ruleTreeNode compoundOpCodeNode");
        aNode.setData((Object)new CompoundOpCodeNode(prop));
        currentNode.insertChildAt(index, aNode);
    }

    private boolean propIdMatches(Node<RuleTreeNode, String> node, String propId) {
        return propId != null && node != null && node.getData() != null && propId.equalsIgnoreCase(((RuleTreeNode)node.getData()).getProposition().getId());
    }

    private void resetEditModeOnPropositionTree(Node<RuleTreeNode, String> currentNode) {
        if (currentNode.getData() != null) {
            RuleTreeNode dataNode = (RuleTreeNode)currentNode.getData();
            dataNode.getProposition().setEditMode(false);
        }
        List children = currentNode.getChildren();
        for (Node child : children) {
            this.resetEditModeOnPropositionTree((Node<RuleTreeNode, String>)child);
        }
    }

    private Node<RuleTreeNode, String> findPropositionTreeNode(Node<RuleTreeNode, String> currentNode, String selectedPropId) {
        Node child;
        RuleTreeNode dataNode;
        Node<RuleTreeNode, String> bingo = null;
        if (currentNode.getData() != null && selectedPropId.equalsIgnoreCase((dataNode = (RuleTreeNode)currentNode.getData()).getProposition().getId())) {
            return currentNode;
        }
        List children = currentNode.getChildren();
        Iterator iterator = children.iterator();
        while (iterator.hasNext() && (bingo = this.findPropositionTreeNode((Node<RuleTreeNode, String>)(child = (Node)iterator.next()), selectedPropId)) == null) {
        }
        return bingo;
    }

    private Node<RuleTreeNode, String> findParentPropositionNode(Node<RuleTreeNode, String> currentNode, String selectedPropId) {
        Node<RuleTreeNode, String> bingo;
        block2: {
            Node kid;
            bingo = null;
            if (selectedPropId == null) break block2;
            List children = currentNode.getChildren();
            for (Node child : children) {
                RuleTreeNode dataNode = (RuleTreeNode)child.getData();
                if (!selectedPropId.equalsIgnoreCase(dataNode.getProposition().getId())) continue;
                return currentNode;
            }
            Iterator iterator = children.iterator();
            while (iterator.hasNext() && (bingo = this.findParentPropositionNode((Node<RuleTreeNode, String>)(kid = (Node)iterator.next()), selectedPropId)) == null) {
            }
        }
        return bingo;
    }

    private int findChildIndex(Node<RuleTreeNode, String> parent, String propId) {
        List children = parent.getChildren();
        for (int index = 0; index < children.size(); ++index) {
            Node child = (Node)children.get(index);
            if (!this.propIdMatches((Node<RuleTreeNode, String>)child, propId)) continue;
            return index;
        }
        return -1;
    }

    @RequestMapping(params={"methodToCall=movePropositionUp"})
    public ModelAndView movePropositionUp(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.moveSelectedProposition(form, true);
        return this.getModelAndView(form);
    }

    @RequestMapping(params={"methodToCall=movePropositionDown"})
    public ModelAndView movePropositionDown(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.moveSelectedProposition(form, false);
        return this.getModelAndView(form);
    }

    private void moveSelectedProposition(UifFormBase form, boolean up) {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        RuleBo rule = agendaEditor.getAgendaItemLine().getRule();
        String selectedPropId = agendaEditor.getSelectedPropositionId();
        Node<RuleTreeNode, String> parent = this.findParentPropositionNode((Node<RuleTreeNode, String>)rule.getPropositionTree().getRootElement(), selectedPropId);
        if (parent != null) {
            List children = parent.getChildren();
            for (int index = 0; index < children.size(); ++index) {
                Node child = (Node)children.get(index);
                if (!this.propIdMatches((Node<RuleTreeNode, String>)child, selectedPropId)) continue;
                if (!"ruleTreeNode simplePropositionNode".equalsIgnoreCase(child.getNodeType()) && !"ruleTreeNode simplePropositionEditNode".equalsIgnoreCase(child.getNodeType()) && !"ruleTreeNode compoundNode".equalsIgnoreCase(child.getNodeType()) || (index <= 0 || !up) && (index >= children.size() - 1 || up)) break;
                PropositionBo parentProp = ((RuleTreeNode)parent.getData()).getProposition();
                PropositionBo workingProp = parentProp.getCompoundComponents().remove(index / 2);
                if (up) {
                    parentProp.getCompoundComponents().add(index / 2 - 1, workingProp);
                } else {
                    parentProp.getCompoundComponents().add(index / 2 + 1, workingProp);
                }
                boolean editMode = "ruleTreeNode simplePropositionEditNode".equalsIgnoreCase(child.getNodeType());
                rule.refreshPropositionTree(editMode);
                break;
            }
        }
    }

    @RequestMapping(params={"methodToCall=movePropositionLeft"})
    public ModelAndView movePropositionLeft(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Node<RuleTreeNode, String> granny;
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        RuleBo rule = agendaEditor.getAgendaItemLine().getRule();
        String selectedPropId = agendaEditor.getSelectedPropositionId();
        Node root = rule.getPropositionTree().getRootElement();
        Node<RuleTreeNode, String> parent = this.findParentPropositionNode((Node<RuleTreeNode, String>)root, selectedPropId);
        if (parent != null && "ruleTreeNode compoundNode".equalsIgnoreCase(parent.getNodeType()) && (granny = this.findParentPropositionNode((Node<RuleTreeNode, String>)root, ((RuleTreeNode)parent.getData()).getProposition().getId())) != root) {
            int oldIndex = this.findChildIndex(parent, selectedPropId);
            int newIndex = this.findChildIndex(granny, ((RuleTreeNode)parent.getData()).getProposition().getId());
            if (oldIndex >= 0 && newIndex >= 0) {
                PropositionBo prop = ((RuleTreeNode)parent.getData()).getProposition().getCompoundComponents().remove(oldIndex / 2);
                ((RuleTreeNode)granny.getData()).getProposition().getCompoundComponents().add(newIndex / 2 + 1, prop);
                rule.refreshPropositionTree(false);
            }
        }
        return this.getModelAndView(form);
    }

    @RequestMapping(params={"methodToCall=movePropositionRight"})
    public ModelAndView movePropositionRight(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int index;
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        RuleBo rule = agendaEditor.getAgendaItemLine().getRule();
        String selectedPropId = agendaEditor.getSelectedPropositionId();
        Node<RuleTreeNode, String> parent = this.findParentPropositionNode((Node<RuleTreeNode, String>)rule.getPropositionTree().getRootElement(), selectedPropId);
        if (parent != null && (index = this.findChildIndex(parent, selectedPropId)) >= 0 && index + 1 < parent.getChildren().size()) {
            Node child = (Node)parent.getChildren().get(index);
            Node nextSibling = (Node)parent.getChildren().get(index + 2);
            if ("ruleTreeNode compoundNode".equalsIgnoreCase(nextSibling.getNodeType())) {
                PropositionBo prop = ((RuleTreeNode)parent.getData()).getProposition().getCompoundComponents().remove(index / 2);
                ((RuleTreeNode)nextSibling.getData()).getProposition().getCompoundComponents().add(0, prop);
                rule.refreshPropositionTree(false);
            }
        }
        return this.getModelAndView(form);
    }

    @RequestMapping(params={"methodToCall=togglePropositionSimpleCompound"})
    public ModelAndView togglePropositionSimpleCompound(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Node<RuleTreeNode, String> parent;
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        RuleBo rule = agendaEditor.getAgendaItemLine().getRule();
        String selectedPropId = agendaEditor.getSelectedPropositionId();
        this.resetEditModeOnPropositionTree((Node<RuleTreeNode, String>)rule.getPropositionTree().getRootElement());
        if (!StringUtils.isBlank((String)selectedPropId) && (parent = this.findParentPropositionNode((Node<RuleTreeNode, String>)rule.getPropositionTree().getRootElement(), selectedPropId)) != null) {
            int index = this.findChildIndex(parent, selectedPropId);
            PropositionBo propBo = ((RuleTreeNode)((Node)parent.getChildren().get(index)).getData()).getProposition();
            PropositionBo compound = PropositionBo.createCompoundPropositionBoStub(propBo, true);
            compound.setDescription("New Compound Proposition");
            compound.setEditMode(false);
            if (parent.getData() == null) {
                rule.setProposition(compound);
            } else {
                PropositionBo parentBo = ((RuleTreeNode)parent.getData()).getProposition();
                List<PropositionBo> siblings = parentBo.getCompoundComponents();
                int propIndex = -1;
                for (int i = 0; i < siblings.size(); ++i) {
                    if (!propBo.getId().equals(siblings.get(i).getId())) continue;
                    propIndex = i;
                    break;
                }
                parentBo.getCompoundComponents().set(propIndex, compound);
            }
        }
        agendaEditor.getAgendaItemLine().getRule().refreshPropositionTree(true);
        return this.getModelAndView(form);
    }

    @RequestMapping(params={"methodToCall=cutProposition"})
    public ModelAndView cutProposition(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        String selectedPropId = agendaEditor.getSelectedPropositionId();
        agendaEditor.setCutPropositionId(selectedPropId);
        return this.getModelAndView(form);
    }

    @RequestMapping(params={"methodToCall=pasteProposition"})
    public ModelAndView pasteProposition(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        RuleBo rule = agendaEditor.getAgendaItemLine().getRule();
        String cutPropId = agendaEditor.getCutPropositionId();
        String selectedPropId = agendaEditor.getSelectedPropositionId();
        if (!StringUtils.isNotBlank((String)selectedPropId) || !selectedPropId.equals(cutPropId)) {
            Node root = rule.getPropositionTree().getRootElement();
            if (StringUtils.isNotBlank((String)selectedPropId) && StringUtils.isNotBlank((String)cutPropId)) {
                int index;
                List<PropositionBo> children;
                PropositionBo newParent;
                Node<RuleTreeNode, String> parentNode = this.findParentPropositionNode((Node<RuleTreeNode, String>)root, selectedPropId);
                if (parentNode == root) {
                    newParent = PropositionBo.createCompoundPropositionBoStub2(((RuleTreeNode)((Node)root.getChildren().get(0)).getData()).getProposition());
                    newParent.setEditMode(true);
                    rule.setProposition(newParent);
                } else {
                    newParent = ((RuleTreeNode)parentNode.getData()).getProposition();
                }
                PropositionBo oldParent = ((RuleTreeNode)this.findParentPropositionNode((Node<RuleTreeNode, String>)root, cutPropId).getData()).getProposition();
                PropositionBo workingProp = null;
                if (oldParent != null) {
                    children = oldParent.getCompoundComponents();
                    for (index = 0; index < children.size(); ++index) {
                        if (!cutPropId.equalsIgnoreCase(children.get(index).getId())) continue;
                        workingProp = oldParent.getCompoundComponents().remove(index);
                        break;
                    }
                }
                if (newParent != null && workingProp != null) {
                    children = newParent.getCompoundComponents();
                    for (index = 0; index < children.size(); ++index) {
                        if (!selectedPropId.equalsIgnoreCase(children.get(index).getId())) continue;
                        children.add(index + 1, workingProp);
                        break;
                    }
                }
                rule.refreshPropositionTree(false);
            }
        }
        agendaEditor.setCutPropositionId(null);
        return this.getModelAndView(form);
    }

    @RequestMapping(params={"methodToCall=deleteProposition"})
    public ModelAndView deleteProposition(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        String selectedPropId = agendaEditor.getSelectedPropositionId();
        Node root = agendaEditor.getAgendaItemLine().getRule().getPropositionTree().getRootElement();
        Node<RuleTreeNode, String> parentNode = this.findParentPropositionNode((Node<RuleTreeNode, String>)root, selectedPropId);
        if (parentNode != null && parentNode.getData() != null) {
            PropositionBo parent = ((RuleTreeNode)parentNode.getData()).getProposition();
            if (parent != null) {
                List<PropositionBo> children = parent.getCompoundComponents();
                for (int index = 0; index < children.size(); ++index) {
                    if (!selectedPropId.equalsIgnoreCase(children.get(index).getId())) continue;
                    parent.getCompoundComponents().remove(index);
                    break;
                }
            }
        } else if (KRADUtils.isNotNull(parentNode)) {
            parentNode.getChildren().clear();
            agendaEditor.getAgendaItemLine().getRule().getPropositionTree().setRootElement(null);
            agendaEditor.getAgendaItemLine().getRule().setProposition(null);
        } else {
            GlobalVariables.getMessageMap().putError("RuleEditorView-Tree", "error.rule.proposition.noneHighlighted", new String[0]);
        }
        agendaEditor.getDeletedPropositionIdsFromRule().add(selectedPropId);
        agendaEditor.getAgendaItemLine().getRule().refreshPropositionTree(false);
        return this.getModelAndView(form);
    }

    @RequestMapping(params={"methodToCall=updateCompoundOperator"})
    public ModelAndView updateCompoundOperator(@ModelAttribute(value="KualiForm") UifFormBase form, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AgendaEditor agendaEditor = this.getAgendaEditor(form);
        RuleBo rule = agendaEditor.getAgendaItemLine().getRule();
        rule.refreshPropositionTree(false);
        return this.getModelAndView(form);
    }

    protected static class AgendaItemChildAccessor {
        private static final AgendaItemChildAccessor whenTrue = new AgendaItemChildAccessor(Child.WHEN_TRUE);
        private static final AgendaItemChildAccessor whenFalse = new AgendaItemChildAccessor(Child.WHEN_FALSE);
        private static final AgendaItemChildAccessor always = new AgendaItemChildAccessor(Child.ALWAYS);
        private static final AgendaItemChildAccessor[] linkedNodes = new AgendaItemChildAccessor[]{whenTrue, whenFalse, always};
        private static final AgendaItemChildAccessor[] children = new AgendaItemChildAccessor[]{whenTrue, whenFalse};
        private final Child whichChild;

        private AgendaItemChildAccessor(Child whichChild) {
            if (whichChild == null) {
                throw new IllegalArgumentException("whichChild must be non-null");
            }
            this.whichChild = whichChild;
        }

        public AgendaItemBo getChild(AgendaItemBo parent) {
            switch (this.whichChild) {
                case WHEN_TRUE: {
                    return parent.getWhenTrue();
                }
                case WHEN_FALSE: {
                    return parent.getWhenFalse();
                }
                case ALWAYS: {
                    return parent.getAlways();
                }
            }
            throw new IllegalStateException();
        }

        public void setChild(AgendaItemBo parent, AgendaItemBo child) {
            switch (this.whichChild) {
                case WHEN_TRUE: {
                    parent.setWhenTrue(child);
                    parent.setWhenTrueId(child == null ? null : child.getId());
                    break;
                }
                case WHEN_FALSE: {
                    parent.setWhenFalse(child);
                    parent.setWhenFalseId(child == null ? null : child.getId());
                    break;
                }
                case ALWAYS: {
                    parent.setAlways(child);
                    parent.setAlwaysId(child == null ? null : child.getId());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        private static enum Child {
            WHEN_TRUE,
            WHEN_FALSE,
            ALWAYS;

        }
    }

    private static class AgendaItemInstanceChildAccessor {
        private final AgendaItemChildAccessor accessor;
        private final AgendaItemBo instance;

        public AgendaItemInstanceChildAccessor(AgendaItemChildAccessor accessor, AgendaItemBo instance) {
            this.accessor = accessor;
            this.instance = instance;
        }

        public void setChild(AgendaItemBo child) {
            this.accessor.setChild(this.instance, child);
        }

        public AgendaItemBo getChild() {
            return this.accessor.getChild(this.instance);
        }

        public AgendaItemBo getInstance() {
            return this.instance;
        }
    }
}

