/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.memory.jca;

import java.io.PrintWriter;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.transaction.memory.TransactionalMapWrapper;
import org.apache.commons.transaction.util.LoggerFacade;
import org.apache.commons.transaction.util.PrintWriterLogger;
import org.apache.commons.transaction.util.xa.AbstractTransactionalResource;
import org.apache.commons.transaction.util.xa.AbstractXAResource;
import org.apache.commons.transaction.util.xa.TransactionalResource;

public class MapXAResource
extends AbstractXAResource {
    TransactionalMapWrapper map;
    LoggerFacade loggerFacade;

    public MapXAResource(TransactionalMapWrapper map) {
        this.map = map;
        this.loggerFacade = new PrintWriterLogger(new PrintWriter(System.out), "WebDAVXAResource", false);
    }

    public MapXAResource(TransactionalMapWrapper map, LoggerFacade loggerFacade) {
        this.map = map;
        this.loggerFacade = loggerFacade;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        return xares != null && xares instanceof MapXAResource && this.map.equals(((MapXAResource)xares).map);
    }

    public Xid[] recover(int flag) throws XAException {
        return null;
    }

    public LoggerFacade getLoggerFacade() {
        return this.loggerFacade;
    }

    public void setLoggerFacade(LoggerFacade loggerFacade) {
        this.loggerFacade = loggerFacade;
    }

    protected void setLoggerFacade(PrintWriter out) {
        this.loggerFacade = new PrintWriterLogger(out, "WebDAVXAResource", true);
    }

    protected TransactionalResource createTransactionResource(Xid xid) throws Exception {
        return new MapTransactionalResource(xid, this.map, this.getLoggerFacade());
    }

    protected boolean includeBranchInXid() {
        return true;
    }

    protected static class MapTransactionalResource
    extends AbstractTransactionalResource {
        TransactionalMapWrapper map;
        private TransactionalMapWrapper.TxContext txContext = null;
        LoggerFacade loggerFacade;

        public MapTransactionalResource(Xid xid, TransactionalMapWrapper map, LoggerFacade loggerFacade) {
            super(xid);
            this.map = map;
            this.loggerFacade = loggerFacade;
        }

        public void commit() throws XAException {
            try {
                this.map.commitTransaction();
            }
            catch (IllegalStateException e) {
                throw new XAException(e.toString());
            }
        }

        public void rollback() throws XAException {
            if (this.isSuspended()) {
                this.resume();
            }
            try {
                this.map.rollbackTransaction();
            }
            catch (IllegalStateException e) {
                throw new XAException(e.toString());
            }
        }

        public int prepare() throws XAException {
            if (this.isSuspended()) {
                this.resume();
            }
            if (this.map.isTransactionMarkedForRollback()) {
                throw new XAException(100);
            }
            return this.map.isReadOnly() ? 3 : 0;
        }

        public void suspend() throws XAException {
            if (this.isSuspended()) {
                throw new XAException(-6);
            }
            this.txContext = this.map.suspendTransaction();
        }

        public void resume() throws XAException {
            if (!this.isSuspended()) {
                throw new XAException(-6);
            }
            this.map.resumeTransaction(this.txContext);
            this.txContext = null;
        }

        public void begin() throws XAException {
            if (this.isSuspended()) {
                throw new XAException(-6);
            }
            this.map.startTransaction();
        }

        private boolean isSuspended() {
            return this.txContext != null;
        }
    }
}

