/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.impl.config.module;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.builder.api.Component;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.kuali.rice.core.api.config.property.Config;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.lifecycle.BaseLifecycle;
import org.springframework.util.ResourceUtils;

class Log4jLifeCycle
extends BaseLifecycle {
    private static final String LOG4J_FILE_NOT_FOUND = "log4j settings file not found at location: ";

    Log4jLifeCycle() {
    }

    public void start() throws Exception {
        Config config = ConfigContext.getCurrentContextConfig();
        String log4jFilePath = config.getProperty("log4j.settings.path");
        boolean log4jFileExists = this.checkPropertiesFileExists(log4jFilePath);
        String log4jConfigXml = config.getProperty("log4j.settings.xml");
        String log4jConfigProps = config.getProperty("log4j.settings.props");
        if (StringUtils.isNotBlank((String)log4jConfigXml)) {
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            context.start((Configuration)new XmlConfiguration(context, new ConfigurationSource((InputStream)new ByteArrayInputStream(log4jConfigXml.getBytes()))));
        } else if (StringUtils.isNotBlank((String)log4jConfigProps)) {
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            context.start((Configuration)new PropertiesConfiguration(context, new ConfigurationSource((InputStream)new ByteArrayInputStream(log4jConfigProps.getBytes())), new Component()));
        } else if (log4jFileExists) {
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            context.setConfigLocation(ResourceUtils.getFile((String)log4jFilePath).toURI());
        }
        super.start();
    }

    private boolean checkPropertiesFileExists(String log4jSettingsPath) {
        boolean exists;
        if (StringUtils.isBlank((String)log4jSettingsPath)) {
            return false;
        }
        try {
            exists = ResourceUtils.getFile((String)log4jSettingsPath).exists();
        }
        catch (FileNotFoundException e) {
            exists = false;
        }
        if (!exists) {
            System.out.println(LOG4J_FILE_NOT_FOUND + log4jSettingsPath);
        }
        return exists;
    }
}

