/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.Recipient;
import org.kuali.rice.kew.actions.ActionTakenEvent;
import org.kuali.rice.kew.actions.ReturnToPreviousNodeAction;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.action.MovePoint;
import org.kuali.rice.kew.api.document.DocumentOrchestrationQueue;
import org.kuali.rice.kew.api.document.DocumentProcessingOptions;
import org.kuali.rice.kew.api.document.OrchestrationConfig;
import org.kuali.rice.kew.api.exception.InvalidActionTakenException;
import org.kuali.rice.kew.engine.RouteContext;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.RouteNodeInstance;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

public class MoveDocumentAction
extends ActionTakenEvent {
    protected final Logger LOG = LogManager.getLogger(this.getClass());
    private MovePoint movePoint;

    public MoveDocumentAction(DocumentRouteHeaderValue routeHeader, PrincipalContract principal) {
        super("M", routeHeader, principal);
    }

    public MoveDocumentAction(DocumentRouteHeaderValue routeHeader, PrincipalContract principal, String annotation, MovePoint movePoint) {
        super("M", routeHeader, principal, annotation);
        this.movePoint = movePoint;
    }

    @Override
    public String validateActionRules() {
        return this.validateActionRules(this.getActionRequestService().findAllPendingRequests(this.routeHeader.getDocumentId()), KEWServiceLocator.getRouteNodeService().getActiveRouteNodeNames(this.getRouteHeader().getDocumentId()));
    }

    @Override
    public String validateActionRules(List<ActionRequestValue> actionRequests) {
        return this.validateActionRules(actionRequests, KEWServiceLocator.getRouteNodeService().getActiveRouteNodeNames(this.getRouteHeader().getDocumentId()));
    }

    private String validateActionRules(List<ActionRequestValue> actionRequests, Collection<String> activeNodes) {
        if (!this.getRouteHeader().isValidActionToTake(this.getActionPerformedCode())) {
            return "Document is not in a state to be moved";
        }
        if (activeNodes.isEmpty()) {
            return "Document has no active nodes.";
        }
        List<ActionRequestValue> filteredActionRequests = this.filterActionRequestsByCode(actionRequests, "C");
        if (!this.isActionCompatibleRequest(filteredActionRequests)) {
            return "No request for the user is compatible with the MOVE action";
        }
        return "";
    }

    @Override
    public boolean isActionCompatibleRequest(List<ActionRequestValue> requests) {
        return true;
    }

    @Override
    public void recordAction() throws InvalidActionTakenException {
        ThreadContext.put((String)"docId", (String)this.getRouteHeader().getDocumentId());
        this.updateSearchableAttributesIfPossible();
        this.LOG.debug("Moving document " + this.getRouteHeader().getDocumentId() + " to point: " + this.displayMovePoint(this.movePoint) + ", annotation: " + this.annotation);
        List<ActionRequestValue> actionRequests = this.getActionRequestService().findAllValidRequests(this.getPrincipal().getPrincipalId(), this.getDocumentId(), "C");
        List<RouteNodeInstance> activeNodes = KEWServiceLocator.getRouteNodeService().getActiveNodeInstances(this.getRouteHeader().getDocumentId());
        String errorMessage = this.validateActionRules(actionRequests, activeNodes);
        if (!StringUtils.isEmpty((String)errorMessage)) {
            throw new InvalidActionTakenException(errorMessage);
        }
        if (this.getRouteHeader().isStateInitiated() || this.getRouteHeader().isStateSaved()) {
            this.markDocumentEnroute(this.getRouteHeader());
            this.getRouteHeader().setRoutedByUserWorkflowId(this.getPrincipal().getPrincipalId());
        }
        RouteNodeInstance startNodeInstance = this.determineStartNode(activeNodes, this.movePoint);
        this.LOG.debug("Record the move action");
        Recipient delegator = this.findDelegatorForActionRequests(actionRequests);
        ActionTakenValue actionTaken = this.saveActionTaken(delegator);
        this.getActionRequestService().deactivateRequests(actionTaken, actionRequests);
        this.notifyActionTaken(actionTaken);
        if (this.movePoint.getStepsToMove() > 0) {
            HashSet<String> targetNodeNames = new HashSet<String>();
            targetNodeNames.add(this.determineFutureNodeName(startNodeInstance, this.movePoint));
            boolean shouldIndex = this.getRouteHeader().getDocumentType().hasSearchableAttributes() && RouteContext.getCurrentRouteContext().isSearchIndexingRequestedForContext();
            String applicationId = this.routeHeader.getDocumentType().getApplicationId();
            DocumentOrchestrationQueue orchestrationQueue = KewApiServiceLocator.getDocumentOrchestrationQueue((String)this.routeHeader.getDocumentId(), (String)applicationId);
            OrchestrationConfig orchestrationConfig = OrchestrationConfig.create((String)actionTaken.getActionTakenId(), targetNodeNames);
            DocumentProcessingOptions options = DocumentProcessingOptions.create((boolean)true, (boolean)shouldIndex, (boolean)false, (boolean)true, (boolean)true);
            orchestrationQueue.orchestrateDocument(this.routeHeader.getDocumentId(), this.getPrincipal().getPrincipalId(), orchestrationConfig, options);
        } else {
            String targetNodeName = this.determineReturnNodeName(startNodeInstance, this.movePoint);
            ReturnToPreviousNodeAction returnAction = new ReturnToPreviousNodeAction("M", this.getRouteHeader(), this.getPrincipal(), this.annotation, targetNodeName, false);
            returnAction.recordAction();
        }
    }

    private RouteNodeInstance determineStartNode(Collection<RouteNodeInstance> activeNodes, MovePoint movePoint) throws InvalidActionTakenException {
        RouteNodeInstance startNodeInstance = null;
        for (RouteNodeInstance nodeInstance : activeNodes) {
            if (!nodeInstance.getName().equals(movePoint.getStartNodeName())) continue;
            if (startNodeInstance != null) {
                throw new InvalidActionTakenException("More than one active node exists with the given name:  " + movePoint.getStartNodeName());
            }
            startNodeInstance = nodeInstance;
        }
        if (startNodeInstance == null) {
            throw new InvalidActionTakenException("Could not locate an active node with the given name: " + movePoint.getStartNodeName());
        }
        return startNodeInstance;
    }

    private String determineFutureNodeName(RouteNodeInstance startNodeInstance, MovePoint movePoint) throws InvalidActionTakenException {
        return this.determineFutureNodeName(startNodeInstance.getRouteNode(), movePoint, 0, new HashSet());
    }

    private String determineFutureNodeName(RouteNode node, MovePoint movePoint, int currentStep, Set nodesProcessed) throws InvalidActionTakenException {
        if (nodesProcessed.contains(node.getRouteNodeId())) {
            throw new InvalidActionTakenException("Detected a cycle at node " + node.getRouteNodeName() + " when attempting to move document.");
        }
        nodesProcessed.add(node.getRouteNodeId());
        if (currentStep == movePoint.getStepsToMove()) {
            return node.getRouteNodeName();
        }
        List<RouteNode> nextNodes = node.getNextNodes();
        if (nextNodes.size() == 0) {
            throw new InvalidActionTakenException("Could not proceed forward, there are no more nodes in the route.  Halted on step " + currentStep);
        }
        if (nextNodes.size() != 1) {
            throw new InvalidActionTakenException("Cannot move forward in a multi-branch path.  Located " + nextNodes.size() + " branches.  Halted on step " + currentStep);
        }
        return this.determineFutureNodeName(nextNodes.get(0), movePoint, currentStep + 1, nodesProcessed);
    }

    private String determineReturnNodeName(RouteNodeInstance startNodeInstance, MovePoint movePoint) throws InvalidActionTakenException {
        return this.determineReturnNodeName(startNodeInstance.getRouteNode(), movePoint, 0);
    }

    private String determineReturnNodeName(RouteNode node, MovePoint movePoint, int currentStep) throws InvalidActionTakenException {
        if (currentStep == movePoint.getStepsToMove()) {
            return node.getRouteNodeName();
        }
        List<RouteNode> previousNodes = node.getPreviousNodes();
        if (previousNodes.size() == 0) {
            throw new InvalidActionTakenException("Could not locate the named target node in the document's past route.  Halted on step " + currentStep);
        }
        if (previousNodes.size() != 1) {
            throw new InvalidActionTakenException("Located a multi-branch path, could not proceed backward past this point.  Halted on step " + currentStep);
        }
        return this.determineReturnNodeName(previousNodes.get(0), movePoint, currentStep - 1);
    }

    private String displayMovePoint(MovePoint movePoint) {
        return "fromNode=" + movePoint.getStartNodeName() + ", stepsToMove=" + movePoint.getStepsToMove();
    }

    protected void markDocumentEnroute(DocumentRouteHeaderValue routeHeader) throws InvalidActionTakenException {
        String oldStatus = routeHeader.getDocRouteStatus();
        routeHeader.markDocumentEnroute();
        String newStatus = routeHeader.getDocRouteStatus();
        this.notifyStatusChange(newStatus, oldStatus);
        KEWServiceLocator.getRouteHeaderService().saveRouteHeader(routeHeader);
    }
}

