/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.web.struts.action;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleMember;
import org.kuali.rice.kim.bo.ui.KimDocumentRolePermission;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleQualifier;
import org.kuali.rice.kim.bo.ui.KimDocumentRoleResponsibility;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMember;
import org.kuali.rice.kim.bo.ui.RoleDocumentDelegationMemberQualifier;
import org.kuali.rice.kim.document.IdentityManagementRoleDocument;
import org.kuali.rice.kim.impl.responsibility.AddResponsibilityEvent;
import org.kuali.rice.kim.impl.responsibility.ResponsibilityBo;
import org.kuali.rice.kim.impl.type.KimTypeLookupableHelperServiceImpl;
import org.kuali.rice.kim.rule.event.ui.AddDelegationMemberEvent;
import org.kuali.rice.kim.rule.event.ui.AddMemberEvent;
import org.kuali.rice.kim.rule.event.ui.AddPermissionEvent;
import org.kuali.rice.kim.web.struts.action.IdentityManagementDocumentActionBase;
import org.kuali.rice.kim.web.struts.form.IdentityManagementRoleDocumentForm;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiTableRenderFormMetadata;
import org.kuali.rice.krad.data.CopyOption;
import org.kuali.rice.krad.data.KradDataServiceLocator;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public class IdentityManagementRoleDocumentAction
extends IdentityManagementDocumentActionBase {
    public static final String CHANGE_DEL_ROLE_MEMBER_METHOD_TO_CALL = "changeDelegationRoleMember";
    public static final String SWITCH_TO_ROLE_MEMBER_METHOD_TO_CALL = "jumpToRoleMember";
    public static final String REMOVE_AFFECTED_DELEGATES_QUESTION_ID = "RemoveAffectedDelegates";
    protected List<String> methodToCallToUncheckedList = new ArrayList<String>();

    public IdentityManagementRoleDocumentAction() {
        this.methodToCallToUncheckedList.add(CHANGE_DEL_ROLE_MEMBER_METHOD_TO_CALL);
        this.methodToCallToUncheckedList.add("changeMemberTypeCode");
        this.methodToCallToUncheckedList.add("changeNamespace");
        this.methodToCallToUncheckedList.add(SWITCH_TO_ROLE_MEMBER_METHOD_TO_CALL);
        for (String methodToCallToUncheck : this.methodToCallToUncheckedList) {
            this.addMethodToCallToUncheckedList(methodToCallToUncheck);
        }
    }

    public ActionForward sort(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        KualiTableRenderFormMetadata memberTableMetadata = roleDocumentForm.getMemberTableMetadata();
        memberTableMetadata.setSwitchToPageNumber(0);
        return mapping.findForward("basic");
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        if (roleDocumentForm.getRoleId() == null) {
            String roleId = request.getParameter("roleId");
            roleDocumentForm.setRoleId(roleId);
        }
        String kimTypeId = request.getParameter("id");
        this.setKimType(kimTypeId, roleDocumentForm);
        KualiTableRenderFormMetadata memberTableMetadata = roleDocumentForm.getMemberTableMetadata();
        if (roleDocumentForm.getRoleDocument() != null && roleDocumentForm.getMemberRows() != null) {
            memberTableMetadata.jumpToPage(memberTableMetadata.getViewedPageNumber(), roleDocumentForm.getMemberRows().size(), roleDocumentForm.getRecordsPerPage());
            memberTableMetadata.sort(roleDocumentForm.getMemberRows(), roleDocumentForm.getRecordsPerPage());
        }
        if ((forward = this.promptForAffectedDelegates(mapping, form, request, response, roleDocumentForm, new KimDocumentRoleMember[0])) != null) {
            return forward;
        }
        forward = super.execute(mapping, (ActionForm)roleDocumentForm, request, response);
        roleDocumentForm.setCanAssignRole(this.validAssignRole(roleDocumentForm.getRoleDocument()));
        if (KimTypeLookupableHelperServiceImpl.hasDerivedRoleTypeService(roleDocumentForm.getRoleDocument().getKimType())) {
            roleDocumentForm.setCanModifyAssignees(false);
        }
        GlobalVariables.getUserSession().addObject("IMRD", (Object)roleDocumentForm.getRoleDocument());
        return forward;
    }

    protected void loadDocument(KualiDocumentFormBase form) throws WorkflowException {
        super.loadDocument(form);
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        this.setKimType(roleDocumentForm.getRoleDocument().getRoleTypeId(), roleDocumentForm);
        this.getUiDocumentService().setDelegationMembersInDocument(roleDocumentForm.getRoleDocument());
        this.getUiDocumentService().setMembersInDocument(roleDocumentForm.getRoleDocument());
        roleDocumentForm.setMember(roleDocumentForm.getRoleDocument().getBlankMember());
        roleDocumentForm.setDelegationMember(roleDocumentForm.getRoleDocument().getBlankDelegationMember());
        KualiTableRenderFormMetadata memberTableMetadata = roleDocumentForm.getMemberTableMetadata();
        if (roleDocumentForm.getMemberRows() != null) {
            memberTableMetadata.jumpToFirstPage(roleDocumentForm.getMemberRows().size(), roleDocumentForm.getRecordsPerPage());
        }
    }

    protected void createDocument(KualiDocumentFormBase form) throws WorkflowException {
        super.createDocument(form);
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        if (roleDocumentForm.getRoleId() == null) {
            roleDocumentForm.getRoleDocument().setKimType(roleDocumentForm.getKimType());
            roleDocumentForm.getRoleDocument().initializeDocumentForNewRole();
            roleDocumentForm.setRoleId(roleDocumentForm.getRoleDocument().getRoleId());
        } else {
            this.loadRoleIntoDocument(roleDocumentForm.getRoleId(), roleDocumentForm);
        }
        roleDocumentForm.setMember(roleDocumentForm.getRoleDocument().getBlankMember());
        roleDocumentForm.setDelegationMember(roleDocumentForm.getRoleDocument().getBlankDelegationMember());
        KualiTableRenderFormMetadata memberTableMetadata = roleDocumentForm.getMemberTableMetadata();
        if (roleDocumentForm.getMemberRows() != null) {
            memberTableMetadata.jumpToFirstPage(roleDocumentForm.getMemberRows().size(), roleDocumentForm.getRecordsPerPage());
        }
    }

    protected void setKimType(String kimTypeId, IdentityManagementRoleDocumentForm roleDocumentForm) {
        if (StringUtils.isNotBlank((String)kimTypeId)) {
            roleDocumentForm.setKimType(KimApiServiceLocator.getKimTypeInfoService().getKimType(kimTypeId));
            if (roleDocumentForm.getRoleDocument() != null) {
                roleDocumentForm.getRoleDocument().setKimType(roleDocumentForm.getKimType());
            }
        } else if (roleDocumentForm.getRoleDocument() != null && StringUtils.isNotBlank((String)roleDocumentForm.getRoleDocument().getRoleTypeId())) {
            roleDocumentForm.setKimType(KimApiServiceLocator.getKimTypeInfoService().getKimType(roleDocumentForm.getRoleDocument().getRoleTypeId()));
            roleDocumentForm.getRoleDocument().setKimType(roleDocumentForm.getKimType());
        }
    }

    protected void loadRoleIntoDocument(String roleId, IdentityManagementRoleDocumentForm roleDocumentForm) {
        Role role = KimApiServiceLocator.getRoleService().getRole(roleId);
        roleDocumentForm.getRoleDocument().setMemberMetaDataTypeToSort(roleDocumentForm.getMemberTableMetadata().getColumnToSortIndex());
        this.getUiDocumentService().loadRoleDoc(roleDocumentForm.getRoleDocument(), role);
    }

    @Override
    public String getActionName() {
        return "identityManagementRoleDocument.do";
    }

    protected boolean validAssignRole(IdentityManagementRoleDocument document) {
        boolean rulePassed = true;
        if (StringUtils.isNotEmpty((String)document.getRoleNamespace())) {
            HashMap<String, String> additionalPermissionDetails = new HashMap<String, String>();
            additionalPermissionDetails.put("namespaceCode", document.getRoleNamespace());
            additionalPermissionDetails.put("roleName", document.getRoleName());
            if (!this.getDocumentHelperService().getDocumentAuthorizer((Document)document).isAuthorizedByTemplate((Object)document, "KR-IDM", "Assign Role", GlobalVariables.getUserSession().getPrincipalId(), additionalPermissionDetails, null)) {
                rulePassed = false;
            }
        }
        return rulePassed;
    }

    public ActionForward changeMemberTypeCode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        roleDocumentForm.getMember().setMemberId("");
        return this.refresh(mapping, (ActionForm)roleDocumentForm, request, response);
    }

    public ActionForward changeDelegationMemberTypeCode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        KimDocumentRoleMember roleMember = roleDocumentForm.getRoleDocument().getMember(roleDocumentForm.getDelegationMember().getRoleMemberId());
        if (roleMember != null) {
            for (KimDocumentRoleQualifier roleQualifier : roleMember.getQualifiers()) {
                RoleDocumentDelegationMemberQualifier delegationMemberQualifier = roleDocumentForm.getDelegationMember().getQualifier(roleQualifier.getKimAttrDefnId());
                delegationMemberQualifier.setAttrVal(roleQualifier.getAttrVal());
            }
        }
        return this.refresh(mapping, (ActionForm)roleDocumentForm, request, response);
    }

    public ActionForward addResponsibility(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        KimDocumentRoleResponsibility newResponsibility = roleDocumentForm.getResponsibility();
        if (newResponsibility != null && StringUtils.isNotBlank((String)newResponsibility.getResponsibilityId())) {
            ResponsibilityBo responsibilityImpl = (ResponsibilityBo)KradDataServiceLocator.getDataObjectService().find(ResponsibilityBo.class, (Object)newResponsibility.getResponsibilityId());
            newResponsibility.setKimResponsibility(responsibilityImpl);
        }
        if (KRADServiceLocatorWeb.getKualiRuleService().applyRules((DocumentEvent)new AddResponsibilityEvent("", (Document)roleDocumentForm.getRoleDocument(), newResponsibility))) {
            if (newResponsibility != null) {
                newResponsibility.setDocumentNumber(roleDocumentForm.getDocument().getDocumentNumber());
            }
            roleDocumentForm.getRoleDocument().addResponsibility(newResponsibility);
            roleDocumentForm.setResponsibility(new KimDocumentRoleResponsibility());
            roleDocumentForm.getRoleDocument().updateMembers(newResponsibility);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteResponsibility(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        roleDocumentForm.getRoleDocument().getResponsibilities().remove(this.getLineToDelete(request));
        roleDocumentForm.getRoleDocument().updateMembers(roleDocumentForm);
        return mapping.findForward("basic");
    }

    public ActionForward addPermission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        KimDocumentRolePermission newPermission = roleDocumentForm.getPermission();
        if (KRADServiceLocatorWeb.getKualiRuleService().applyRules((DocumentEvent)new AddPermissionEvent("", (Document)roleDocumentForm.getRoleDocument(), newPermission))) {
            newPermission.setDocumentNumber(roleDocumentForm.getDocument().getDocumentNumber());
            newPermission.setRoleId(roleDocumentForm.getRoleDocument().getRoleId());
            roleDocumentForm.getRoleDocument().getPermissions().add(newPermission);
            roleDocumentForm.setPermission(new KimDocumentRolePermission());
        }
        return mapping.findForward("basic");
    }

    public ActionForward addMember(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String fullName;
        Group tempGroup;
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        KimDocumentRoleMember newMember = roleDocumentForm.getMember();
        if (StringUtils.equals((String)newMember.getMemberTypeCode(), (String)KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE.getCode()) && StringUtils.isEmpty((String)newMember.getMemberId()) && !newMember.isMemberNameNull() && !newMember.isMemberNameSpaceCodeNull() && (tempGroup = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(newMember.getMemberNamespaceCode(), newMember.getMemberName())) != null) {
            newMember.setMemberId(tempGroup.getId());
        }
        if (StringUtils.equals((String)newMember.getMemberTypeCode(), (String)KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode()) && StringUtils.isEmpty((String)newMember.getMemberId()) && StringUtils.isNotEmpty((String)newMember.getMemberName())) {
            Principal principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(newMember.getMemberName());
            if (principal != null) {
                newMember.setMemberId(principal.getPrincipalId());
                String fullName2 = this.checkMemberFullName(principal.getPrincipalId());
                if (fullName2 != null) {
                    newMember.setMemberFullName(fullName2);
                }
            }
        } else if (StringUtils.equals((String)newMember.getMemberTypeCode(), (String)KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode()) && StringUtils.isNotEmpty((String)newMember.getMemberId()) && StringUtils.isNotEmpty((String)newMember.getMemberName()) && (fullName = this.checkMemberFullName(newMember.getMemberId())) != null) {
            newMember.setMemberFullName(fullName);
        }
        if (this.checkKimDocumentRoleMember(newMember) && KRADServiceLocatorWeb.getKualiRuleService().applyRules((DocumentEvent)new AddMemberEvent("", (Document)roleDocumentForm.getRoleDocument(), newMember))) {
            newMember.setDocumentNumber(roleDocumentForm.getDocument().getDocumentNumber());
            roleDocumentForm.getRoleDocument().addMember(newMember);
            roleDocumentForm.setMember(roleDocumentForm.getRoleDocument().getBlankMember());
        }
        return mapping.findForward("basic");
    }

    protected String checkMemberFullName(String principalId) {
        Person psn;
        Principal principal = this.getIdentityService().getPrincipal(principalId);
        if (principal != null && (psn = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(principal.getPrincipalName())) != null) {
            return psn.getFirstName() + " " + psn.getLastName();
        }
        return null;
    }

    protected boolean checkKimDocumentRoleMember(KimDocumentRoleMember newMember) {
        boolean memberExists = false;
        String memberName = null;
        String memberNamespace = null;
        if (StringUtils.isBlank((String)newMember.getMemberId())) {
            GlobalVariables.getMessageMap().putError("document.member.memberId", "error.empty.entry", new String[]{"Member ID"});
            return false;
        }
        if (MemberType.PRINCIPAL.getCode().equals(newMember.getMemberTypeCode())) {
            Principal pi = this.getIdentityService().getPrincipal(newMember.getMemberId());
            if (pi != null) {
                memberExists = true;
                memberName = pi.getPrincipalName();
                memberNamespace = "";
            }
        } else if (MemberType.GROUP.getCode().equals(newMember.getMemberTypeCode())) {
            Group gi = KimApiServiceLocator.getGroupService().getGroup(newMember.getMemberId());
            if (gi != null) {
                memberExists = true;
                memberName = gi.getName();
                memberNamespace = gi.getNamespaceCode();
            }
        } else if (MemberType.ROLE.getCode().equals(newMember.getMemberTypeCode())) {
            Role ri = KimApiServiceLocator.getRoleService().getRole(newMember.getMemberId());
            if (!this.validateRole(newMember.getMemberId(), ri, "document.member.memberId", "Role")) {
                return false;
            }
            memberExists = true;
            memberName = ri.getName();
            memberNamespace = ri.getNamespaceCode();
        }
        if (!memberExists) {
            GlobalVariables.getMessageMap().putError("document.member.memberId", "error.memberid.membertype.mismatch", new String[]{newMember.getMemberId()});
            return false;
        }
        newMember.setMemberName(memberName);
        newMember.setMemberNamespaceCode(memberNamespace);
        return true;
    }

    public ActionForward deleteMember(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        KimDocumentRoleMember inactivatedRoleMember = roleDocumentForm.getRoleDocument().getModifiedMembers().get(this.getLineToDelete(request));
        ActionForward forward = this.promptForAffectedDelegates(mapping, form, request, response, roleDocumentForm, inactivatedRoleMember);
        if (forward != null) {
            return forward;
        }
        Calendar cal = Calendar.getInstance();
        inactivatedRoleMember.setActiveToDate(new Timestamp(cal.getTimeInMillis()));
        roleDocumentForm.getRoleDocument().getModifiedMembers().set(this.getLineToDelete(request), inactivatedRoleMember);
        return mapping.findForward("basic");
    }

    public ActionForward editMember(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        KimDocumentRoleMember roleMemberToEdit = roleDocumentForm.getRoleDocument().getMembers().get(this.getLineToEdit(request));
        KimDocumentRoleMember copiedMember = (KimDocumentRoleMember)((Object)KradDataServiceLocator.getDataObjectService().copyInstance((Object)roleMemberToEdit, new CopyOption[0]));
        roleDocumentForm.getRoleDocument().getModifiedMembers().add(copiedMember);
        roleDocumentForm.getRoleDocument().getMembers().remove((Object)roleMemberToEdit);
        return mapping.findForward("basic");
    }

    public ActionForward editSearchResultsMember(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        KimDocumentRoleMember roleMemberToEdit = roleDocumentForm.getRoleDocument().getSearchResultMembers().get(this.getLineToEdit(request));
        KimDocumentRoleMember copiedMember = (KimDocumentRoleMember)((Object)KradDataServiceLocator.getDataObjectService().copyInstance((Object)roleMemberToEdit, new CopyOption[0]));
        roleDocumentForm.getRoleDocument().getModifiedMembers().add(copiedMember);
        roleDocumentForm.getRoleDocument().getSearchResultMembers().remove((Object)roleMemberToEdit);
        roleDocumentForm.getRoleDocument().getMembers().remove((Object)roleMemberToEdit);
        return mapping.findForward("basic");
    }

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        String memberSearchValue = roleDocumentForm.getMemberSearchValue();
        if (memberSearchValue != null && !memberSearchValue.isEmpty()) {
            memberSearchValue = memberSearchValue.replaceAll("[%*]", "");
            this.getUiDocumentService().loadRoleMembersBasedOnSearch(roleDocumentForm.getRoleDocument(), memberSearchValue);
        } else {
            this.clear(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward clear(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        roleDocumentForm.setMemberSearchValue("");
        this.getUiDocumentService().clearRestrictedRoleMembersSearchResults(roleDocumentForm.getRoleDocument());
        KualiTableRenderFormMetadata memberTableMetadata = roleDocumentForm.getMemberTableMetadata();
        if (roleDocumentForm.getMemberRows() != null) {
            memberTableMetadata.jumpToFirstPage(roleDocumentForm.getMemberRows().size(), roleDocumentForm.getRecordsPerPage());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deletePermission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        roleDocumentForm.getRoleDocument().getPermissions().remove(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    protected boolean checkDelegationMember(RoleDocumentDelegationMember newMember) {
        if (StringUtils.isBlank((String)newMember.getMemberTypeCode()) || StringUtils.isBlank((String)newMember.getMemberId())) {
            GlobalVariables.getMessageMap().putError("document.delegationMember.memberId", "error.empty.entry", new String[]{"Member Type Code and Member ID"});
            return false;
        }
        if (MemberType.PRINCIPAL.getCode().equals(newMember.getMemberTypeCode())) {
            Principal principalInfo = this.getIdentityService().getPrincipal(newMember.getMemberId());
            if (principalInfo == null) {
                GlobalVariables.getMessageMap().putError("document.delegationMember.memberId", "error.memberid.membertype.mismatch", new String[]{newMember.getMemberId()});
                return false;
            }
            newMember.setMemberName(principalInfo.getPrincipalName());
        } else if (MemberType.GROUP.getCode().equals(newMember.getMemberTypeCode())) {
            Group groupInfo = null;
            groupInfo = this.getGroupService().getGroup(newMember.getMemberId());
            if (groupInfo == null) {
                GlobalVariables.getMessageMap().putError("document.delegationMember.memberId", "error.memberid.membertype.mismatch", new String[]{newMember.getMemberId()});
                return false;
            }
            newMember.setMemberName(groupInfo.getName());
            newMember.setMemberNamespaceCode(groupInfo.getNamespaceCode());
        } else if (MemberType.ROLE.getCode().equals(newMember.getMemberTypeCode())) {
            Role roleInfo = KimApiServiceLocator.getRoleService().getRole(newMember.getMemberId());
            if (roleInfo == null) {
                GlobalVariables.getMessageMap().putError("document.delegationMember.memberId", "error.memberid.membertype.mismatch", new String[]{newMember.getMemberId()});
                return false;
            }
            newMember.setMemberName(roleInfo.getName());
            newMember.setMemberNamespaceCode(roleInfo.getNamespaceCode());
        }
        return true;
    }

    public ActionForward addDelegationMember(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Principal principal;
        Group tempGroup;
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        RoleDocumentDelegationMember newDelegationMember = roleDocumentForm.getDelegationMember();
        if (StringUtils.isEmpty((String)newDelegationMember.getMemberId()) && StringUtils.isNotEmpty((String)newDelegationMember.getMemberName()) && StringUtils.isNotEmpty((String)newDelegationMember.getMemberNamespaceCode()) && StringUtils.equals((String)newDelegationMember.getMemberTypeCode(), (String)KimConstants.KimGroupMemberTypes.GROUP_MEMBER_TYPE.getCode()) && (tempGroup = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(newDelegationMember.getMemberNamespaceCode(), newDelegationMember.getMemberName())) != null) {
            newDelegationMember.setMemberId(tempGroup.getId());
        }
        if (StringUtils.isEmpty((String)newDelegationMember.getMemberId()) && StringUtils.isNotEmpty((String)newDelegationMember.getMemberName()) && StringUtils.equals((String)newDelegationMember.getMemberTypeCode(), (String)KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE.getCode()) && (principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(newDelegationMember.getMemberName())) != null) {
            newDelegationMember.setMemberId(principal.getPrincipalId());
        }
        if (this.checkDelegationMember(newDelegationMember) && KRADServiceLocatorWeb.getKualiRuleService().applyRules((DocumentEvent)new AddDelegationMemberEvent("", (Document)roleDocumentForm.getRoleDocument(), newDelegationMember))) {
            newDelegationMember.setDocumentNumber(roleDocumentForm.getDocument().getDocumentNumber());
            if (StringUtils.isEmpty((String)newDelegationMember.getDelegationTypeCode())) {
                newDelegationMember.setDelegationTypeCode(DelegationType.SECONDARY.getCode());
            }
            roleDocumentForm.getRoleDocument().addDelegationMember(newDelegationMember);
            roleDocumentForm.setDelegationMember(roleDocumentForm.getRoleDocument().getBlankDelegationMember());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteDelegationMember(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementRoleDocumentForm roleDocumentForm = (IdentityManagementRoleDocumentForm)form;
        roleDocumentForm.getRoleDocument().getDelegationMembers().remove(this.getLineToDelete(request));
        roleDocumentForm.setDelegationMember(roleDocumentForm.getRoleDocument().getBlankDelegationMember());
        return mapping.findForward("basic");
    }

    public ActionForward jumpToRoleMember(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentityManagementRoleDocumentForm idmForm = (IdentityManagementRoleDocumentForm)form;
        String delegationRoleMemberId = this.getDelegationRoleMemberToJumpTo(request);
        KualiTableRenderFormMetadata memberTableMetadata = idmForm.getMemberTableMetadata();
        memberTableMetadata.jumpToPage(idmForm.getPageNumberOfRoleMemberId(delegationRoleMemberId), idmForm.getMemberRows().size(), idmForm.getRecordsPerPage());
        memberTableMetadata.setColumnToSortIndex(memberTableMetadata.getPreviouslySortedColumnIndex());
        idmForm.setAnchor(delegationRoleMemberId);
        return mapping.findForward("basic");
    }

    protected String getDelegationRoleMemberToJumpTo(HttpServletRequest request) {
        String delegationRoleMemberIdToJumpTo = "";
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            delegationRoleMemberIdToJumpTo = StringUtils.substringBetween((String)parameterName, (String)".dmrmi", (String)".");
        }
        return delegationRoleMemberIdToJumpTo;
    }

    private ActionForward promptForAffectedDelegates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, IdentityManagementRoleDocumentForm roleDocumentForm, KimDocumentRoleMember ... roleMembersToConsiderInactive) throws Exception {
        List<RoleDocumentDelegationMember> activeDelegatesOfInactiveRoleMembers = this.getActiveDelegatesOfInactiveRoleMembers(roleDocumentForm, roleMembersToConsiderInactive);
        ActionForward forward = this.getAffectedDelegatesQuestionActionForward(activeDelegatesOfInactiveRoleMembers, mapping, form, request, response, roleDocumentForm);
        if (forward != null) {
            return forward;
        }
        if (activeDelegatesOfInactiveRoleMembers.size() > 0) {
            Calendar cal = Calendar.getInstance();
            for (RoleDocumentDelegationMember delegateToDeactivate : activeDelegatesOfInactiveRoleMembers) {
                delegateToDeactivate.setActiveToDate(new Timestamp(cal.getTimeInMillis()));
            }
        }
        return null;
    }

    private ActionForward getAffectedDelegatesQuestionActionForward(List<RoleDocumentDelegationMember> activeDelegatesOfInactiveRoleMembers, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, IdentityManagementRoleDocumentForm roleDocumentForm) throws Exception {
        if (activeDelegatesOfInactiveRoleMembers.size() > 0) {
            Object question = this.getQuestion(request);
            if (question == null || !REMOVE_AFFECTED_DELEGATES_QUESTION_ID.equals(question)) {
                return this.performQuestionWithoutInput(mapping, form, request, response, REMOVE_AFFECTED_DELEGATES_QUESTION_ID, this.getKualiConfigurationService().getPropertyValueAsString("question.document.maintenance.role.activeDelegatesForInactiveRoleMembers"), "confirmationQuestion", roleDocumentForm.getMethodToCall(), "");
            }
            String buttonClicked = request.getParameter("buttonClicked");
            if (!REMOVE_AFFECTED_DELEGATES_QUESTION_ID.equals(question) || !"0".equals(buttonClicked)) {
                return mapping.findForward("basic");
            }
        }
        return null;
    }

    private List<RoleDocumentDelegationMember> getActiveDelegatesOfInactiveRoleMembers(IdentityManagementRoleDocumentForm roleDocumentForm, KimDocumentRoleMember ... roleMembersToConsiderInactive) {
        List<KimDocumentRoleMember> roleMembers = roleDocumentForm.getMemberRows();
        ArrayList<KimDocumentRoleMember> inactiveRoleMembers = new ArrayList<KimDocumentRoleMember>();
        ArrayList<RoleDocumentDelegationMember> activeDelegatesOfInactivatedRoleMembers = new ArrayList<RoleDocumentDelegationMember>();
        inactiveRoleMembers.addAll(Arrays.asList(roleMembersToConsiderInactive));
        if (roleMembers != null) {
            for (KimDocumentRoleMember roleMember : roleMembers) {
                if (roleMember == null || roleMember.isActive()) continue;
                inactiveRoleMembers.add(roleMember);
            }
        }
        for (KimDocumentRoleMember inactiveRoleMember : inactiveRoleMembers) {
            List<RoleDocumentDelegationMember> delegationMembers = roleDocumentForm.getRoleDocument().getDelegationMembers();
            if (delegationMembers == null) continue;
            for (RoleDocumentDelegationMember delegationMember : delegationMembers) {
                if (delegationMember == null || !delegationMember.isActive() || !delegationMember.getRoleMemberId().equals(inactiveRoleMember.getRoleMemberId())) continue;
                activeDelegatesOfInactivatedRoleMembers.add(delegationMember);
            }
        }
        return activeDelegatesOfInactivatedRoleMembers;
    }

    @Override
    protected boolean validateRole(String roleId, Role role, String propertyName, String message) {
        if (role == null) {
            GlobalVariables.getMessageMap().putError(propertyName, "error.invalid.role", new String[]{roleId});
            return false;
        }
        return true;
    }
}

