/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.meeting;

import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.committee.impl.bo.CommitteeBase;
import org.kuali.coeus.common.committee.impl.bo.CommitteeScheduleBase;
import org.kuali.coeus.common.committee.impl.document.CommitteeDocumentBase;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleMinuteBase;
import org.kuali.coeus.common.committee.impl.meeting.CommonMeetingService;
import org.kuali.coeus.common.committee.impl.meeting.MeetingControllerService;
import org.kuali.coeus.common.committee.impl.meeting.MeetingEventBase;
import org.kuali.coeus.common.committee.impl.meeting.MeetingFormBase;
import org.kuali.coeus.common.committee.impl.meeting.MeetingHelperBase;
import org.kuali.coeus.common.committee.impl.meeting.MeetingSaveEvent;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionLiteBase;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class MeetingActionBase
extends KualiAction {
    private static final Logger LOG = LogManager.getLogger(MeetingActionBase.class);
    private static final String CLOSE_QUESTION = "Would you like to save meeting data before close it ?";
    private static final String CLOSE_QUESTION_ID = "meeting.close.question";
    private static final String REFRESH_CALLER = "refreshCaller";
    private static final String COMMITTEE_SCHEDULE_ERROR_PATH = "meetingHelper.committeeSchedule";
    private static final String SCHEDULE_ID = "scheduleId";
    public static final String DOC_TYPE_NAME = "docTypeName";
    public static final String PROTOCOL_DOCUMENT = "ProtocolDocument";
    public static final String SUBMISSION_ID = "submissionId";
    public static final String VIEW_DOCUMENT = "viewDocument=";
    public static final String PROTOCOL_ID = "protocolId";

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getMeetingControllerService().populateSchedule((MeetingFormBase)form, request, request.getParameter(SCHEDULE_ID));
        return mapping.findForward("basic");
    }

    protected abstract Class<? extends CommitteeScheduleBase> getCommitteeScheduleBOClass();

    public ActionForward management(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("management");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MeetingFormBase meetingFormBase = (MeetingFormBase)form;
        CommitteeScheduleBase<?, ?, ?, ?> committeeSchedule = meetingFormBase.getMeetingHelper().getCommitteeSchedule();
        if (this.isValidToSave(meetingFormBase.getMeetingHelper(), meetingFormBase.isReadOnly())) {
            meetingFormBase.getMeetingHelper().populateAttendancePreSave();
            this.getMeetingService().saveMeetingDetails(committeeSchedule, meetingFormBase.getMeetingHelper().getDeletedBos());
            meetingFormBase.getMeetingHelper().initDeletedList();
        }
        return mapping.findForward("basic");
    }

    private boolean isValidToSave(MeetingHelperBase meetingHelper, boolean readOnly) {
        if (readOnly) {
            return false;
        }
        GlobalVariables.getMessageMap().addToErrorPath(COMMITTEE_SCHEDULE_ERROR_PATH);
        this.getDictionaryValidationService().validateBusinessObject(meetingHelper.getCommitteeSchedule());
        GlobalVariables.getMessageMap().removeFromErrorPath(COMMITTEE_SCHEDULE_ERROR_PATH);
        boolean valid = GlobalVariables.getMessageMap().hasNoErrors();
        try {
            valid &= this.applyRules((DocumentEvent)new MeetingSaveEvent("", this.getCommitteeDocument(((CommitteeBase)meetingHelper.getCommitteeSchedule().getParentCommittee()).getCommitteeDocument().getDocumentHeader().getDocumentNumber()), meetingHelper, MeetingEventBase.ErrorType.HARDERROR));
        }
        catch (NullPointerException e) {
            LOG.warn("Possible behavior change; not changing value of `valid` variable. It remains: " + valid);
        }
        return valid;
    }

    protected CommitteeDocumentBase getCommitteeDocument(String documentNumber) {
        try {
            return (CommitteeDocumentBase)KcServiceLocator.getService(DocumentService.class).getByDocumentHeaderId(documentNumber);
        }
        catch (Exception e) {
            LOG.warn("Problem with doc header retrieval: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public ActionForward actions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("actions");
    }

    private ActionForward viewProtocolSubmission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolSubmissionLiteBase protocolSubmission = (ProtocolSubmissionLiteBase)((MeetingFormBase)form).getMeetingHelper().getCommitteeSchedule().getLatestProtocolSubmissions().get(Integer.parseInt(request.getParameter("line")));
        response.sendRedirect(this.getActionIdHook() + ".do?docId=" + this.getDocumentNumber(protocolSubmission) + "&submissionId=" + protocolSubmission.getSubmissionId() + "&docTypeName=ProtocolDocument&correctionMode=true&methodToCall=docHandler&&command=displayDocSearchView");
        return null;
    }

    protected abstract String getDocumentNumber(ProtocolSubmissionLiteBase var1);

    protected abstract String getActionIdHook();

    protected BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MeetingFormBase meetingFormBase;
        MeetingFormBase meetingForm = meetingFormBase = (MeetingFormBase)form;
        String question = request.getParameter("questionIndex");
        if (question == null && meetingForm.getMeetingHelper().canModifySchedule()) {
            return this.performQuestionWithoutInput(mapping, form, request, response, CLOSE_QUESTION_ID, CLOSE_QUESTION, "confirmationQuestion", meetingFormBase.getMethodToCall(), "");
        }
        if (meetingForm.getMeetingHelper().canModifySchedule()) {
            String buttonClicked = request.getParameter("buttonClicked");
            if (CLOSE_QUESTION_ID.equals(question) && "0".equals(buttonClicked)) {
                CommitteeScheduleBase<?, ?, ?, ?> committeeSchedule = meetingForm.getMeetingHelper().getCommitteeSchedule();
                if (this.isValidToSave(meetingFormBase.getMeetingHelper(), meetingFormBase.isReadOnly())) {
                    meetingFormBase.getMeetingHelper().populateAttendancePreSave();
                    this.getMeetingService().saveMeetingDetails(committeeSchedule, meetingFormBase.getMeetingHelper().getDeletedBos());
                    meetingFormBase.getMeetingHelper().initDeletedList();
                } else {
                    return mapping.findForward("basic");
                }
            }
        }
        return mapping.findForward("portal");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("portal");
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)request.getParameter(REFRESH_CALLER))) {
            if ("nonOrganizationalRolodexLookupable".equals(request.getParameter(REFRESH_CALLER))) {
                ((MeetingFormBase)form).getMeetingHelper().getNewOtherPresentBean().getAttendance().setNonEmployeeFlag(true);
            } else {
                ((MeetingFormBase)form).getMeetingHelper().getNewOtherPresentBean().getAttendance().setNonEmployeeFlag(false);
            }
        }
        return super.refresh(mapping, form, request, response);
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        ((MeetingFormBase)form).getMeetingHelper().sortAttendances();
        String command = request.getParameter("command");
        if (StringUtils.isNotBlank((CharSequence)command) && "viewProtocolSubmission".equals(command)) {
            forward = this.viewProtocolSubmission(mapping, form, request, response);
        }
        ((MeetingFormBase)form).getMeetingHelper().setHideReviewerName(this.getReviewerCommentsService().setHideReviewerName(((MeetingFormBase)form).getMeetingHelper().getCommitteeSchedule().getCommitteeScheduleMinutes()));
        Collections.sort(((MeetingFormBase)form).getMeetingHelper().getCommitteeSchedule().getCommitteeScheduleMinutes(), CommitteeScheduleMinuteBase.entryTypeComparator);
        return forward;
    }

    protected DictionaryValidationService getDictionaryValidationService() {
        return KNSServiceLocator.getKNSDictionaryValidationService();
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    protected boolean applyRules(DocumentEvent event) {
        return KcServiceLocator.getService(KualiRuleService.class).applyRules(event);
    }

    protected abstract CommonMeetingService getMeetingService();

    protected abstract ReviewCommentsService<?> getReviewerCommentsService();

    protected abstract MeetingControllerService getMeetingControllerService();
}

