/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.web.struts.form.schedule;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.DailyScheduleDetails;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.MonthlyScheduleDetails;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.StyleKey;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.Time12HrFmt;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.WeeklyScheduleDetails;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.YearlyScheduleDetails;
import org.kuali.coeus.common.committee.impl.web.struts.form.schedule.util.ScheduleOptionsUtil;
import org.kuali.coeus.sys.framework.scheduling.util.CronSpecialChars;

public class ScheduleData
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(ScheduleData.class);
    public static final String NONE = "display: none; background:#f4f4f4; border:solid; border-color:#CCCCCC; border-width:1px; padding:5px";
    public static final String BLOCK = "display: block; background:#f4f4f4; border:solid; border-color:#CCCCCC; border-width:1px; padding:5px";
    public static final String DEFAULTTIME = "12:00";
    private java.sql.Date scheduleStartDate;
    private Time12HrFmt time;
    private String place;
    private String recurrenceType;
    private Map<String, String> styleClasses;
    private DailyScheduleDetails dailySchedule;
    private WeeklyScheduleDetails weeklySchedule;
    private MonthlyScheduleDetails monthlySchedule;
    private YearlyScheduleDetails yearlySchedule;
    private java.sql.Date filterStartDate;
    private java.sql.Date filerEndDate;
    private List<java.sql.Date> datesInConflict;

    public ScheduleData() {
        this.setScheduleStartDate(new java.sql.Date(new Date().getTime()));
        this.setTime(new Time12HrFmt(DEFAULTTIME, Time12HrFmt.MERIDIEM.PM));
        this.setRecurrenceType(StyleKey.NEVER.toString());
        this.setStyleClasses(new HashMap<String, String>());
        this.populateStyleClass();
        this.setDailySchedule(new DailyScheduleDetails());
        this.setWeeklySchedule(new WeeklyScheduleDetails());
        this.setMonthlySchedule(new MonthlyScheduleDetails());
        this.setYearlySchedule(new YearlyScheduleDetails());
    }

    public Map<String, String> getStyleClasses() {
        return this.styleClasses;
    }

    public void setStyleClasses(Map<String, String> styleClasses) {
        this.styleClasses = styleClasses;
    }

    public String getRecurrenceType() {
        return this.recurrenceType;
    }

    public void setRecurrenceType(String recurrenceType) {
        this.recurrenceType = recurrenceType;
    }

    public String getPlace() {
        return this.place;
    }

    public void setPlace(String place) {
        this.place = place;
    }

    public void setScheduleStartDate(java.sql.Date scheduleStartDate) {
        this.scheduleStartDate = scheduleStartDate;
    }

    public java.sql.Date getScheduleStartDate() {
        return this.scheduleStartDate;
    }

    public void setDailySchedule(DailyScheduleDetails dailySchedule) {
        this.dailySchedule = dailySchedule;
    }

    public DailyScheduleDetails getDailySchedule() {
        return this.dailySchedule;
    }

    public void setWeeklySchedule(WeeklyScheduleDetails weeklySchedule) {
        this.weeklySchedule = weeklySchedule;
    }

    public WeeklyScheduleDetails getWeeklySchedule() {
        return this.weeklySchedule;
    }

    public void setMonthlySchedule(MonthlyScheduleDetails monthlySchedule) {
        this.monthlySchedule = monthlySchedule;
    }

    public MonthlyScheduleDetails getMonthlySchedule() {
        return this.monthlySchedule;
    }

    public void setYearlySchedule(YearlyScheduleDetails yearlySchedule) {
        this.yearlySchedule = yearlySchedule;
    }

    public YearlyScheduleDetails getYearlySchedule() {
        return this.yearlySchedule;
    }

    public java.sql.Date getFilterStartDate() {
        return this.filterStartDate;
    }

    public void setFilterStartDate(java.sql.Date filterStartDate) {
        this.filterStartDate = filterStartDate;
    }

    public java.sql.Date getFilerEndDate() {
        return this.filerEndDate;
    }

    public void setFilerEndDate(java.sql.Date filerEndDate) {
        this.filerEndDate = filerEndDate;
    }

    public Time12HrFmt getTime() {
        return this.time;
    }

    public void setTime(Time12HrFmt time) {
        this.time = time;
    }

    public List<java.sql.Date> getDatesInConflict() {
        return this.datesInConflict;
    }

    public void setDatesInConflict(List<java.sql.Date> datesInConflict) {
        this.datesInConflict = datesInConflict;
    }

    public void populateStyleClass() {
        for (StyleKey str : StyleKey.values()) {
            this.getStyleClasses().put(str.toString(), NONE);
        }
        for (StyleKey str : StyleKey.values()) {
            if (!str.equalsString(this.getRecurrenceType())) continue;
            this.getStyleClasses().put(str.toString(), BLOCK);
            break;
        }
    }

    public static CronSpecialChars getMonthOfWeek(String month) {
        return ScheduleOptionsUtil.getMonthOfWeek(month);
    }

    public static CronSpecialChars getDayOfWeek(String dayOfWeek) {
        return ScheduleOptionsUtil.getDayOfWeek(dayOfWeek);
    }

    public static CronSpecialChars getWeekOfMonth(String monthsWeek) {
        return ScheduleOptionsUtil.getWeekOfMonth(monthsWeek);
    }

    public static CronSpecialChars[] convertToWeekdays(String[] daysOfWeek) {
        return ScheduleOptionsUtil.convertToWeekdays(daysOfWeek);
    }

    public void printf() {
        LOG.info("=========================================================");
        LOG.info("ScheduleStartDate Date is :" + this.scheduleStartDate.toString());
        LOG.info("Start time is :" + this.getTime().getTime() + this.getTime().getMeridiem());
        LOG.info("Place is :" + this.place);
        LOG.info("recurrenceType is :" + this.recurrenceType);
        LOG.info("=========================================================");
        LOG.info("Schedule Daily End Date is :" + this.dailySchedule.getScheduleEndDate());
        LOG.info("Day is :" + this.dailySchedule.getDay());
        LOG.info("Radio Button Option is :" + this.dailySchedule.getDayOption());
        LOG.info("=========================================================");
        LOG.info("Schedule Weekly End Date is :" + this.weeklySchedule.getScheduleEndDate());
        LOG.info("Week is :" + this.weeklySchedule.getWeek());
        LOG.info("Days is :" + this.weeklySchedule.getDaysOfWeek().toString());
        LOG.info("=========================================================");
        LOG.info("Schedule Monthly End Date is :" + this.monthlySchedule.getScheduleEndDate());
        LOG.info("Day is :" + this.monthlySchedule.getDay());
        LOG.info("Month Option1 is :" + this.monthlySchedule.getOption1Month());
        LOG.info("Month Option2 is :" + this.monthlySchedule.getOption2Month());
        LOG.info("Radio Button Option is :" + this.monthlySchedule.getMonthOption());
        LOG.info("Month's Week is :" + this.monthlySchedule.getSelectedMonthsWeek());
        LOG.info("Day Of Week is :" + this.monthlySchedule.getSelectedDayOfWeek());
        LOG.info("=========================================================");
        LOG.info("Schedule Yearly End Date is :" + this.yearlySchedule.getScheduleEndDate());
        LOG.info("Day is :" + this.yearlySchedule.getDay());
        LOG.info("Year Option1 is :" + this.yearlySchedule.getOption1Year());
        LOG.info("Year Option2 is :" + this.yearlySchedule.getOption2Year());
        LOG.info("Radio Button Option is :" + this.yearlySchedule.getYearOption());
        LOG.info("Month Option1 is :" + this.yearlySchedule.getSelectedOption1Month());
        LOG.info("Month Option2 is :" + this.yearlySchedule.getSelectedOption2Month());
        LOG.info("Month's Week is :" + this.yearlySchedule.getSelectedMonthsWeek());
        LOG.info("Day Of Week is :" + this.yearlySchedule.getSelectedDayOfWeek());
        LOG.info("=========================================================");
    }
}

