/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.framework.question;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.version.sequence.owner.SequenceOwner;
import org.kuali.coeus.common.questionnaire.api.question.QuestionContract;
import org.kuali.coeus.common.questionnaire.framework.question.QuestionCategory;
import org.kuali.coeus.common.questionnaire.framework.question.QuestionExplanation;
import org.kuali.coeus.common.questionnaire.framework.question.QuestionMultiChoice;
import org.kuali.coeus.common.questionnaire.framework.question.QuestionType;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kns.datadictionary.BusinessObjectEntry;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.kns.service.KNSServiceLocator;

public class Question
extends KcPersistableBusinessObjectBase
implements Comparable<Question>,
SequenceOwner<Question>,
QuestionContract {
    private static final long serialVersionUID = 1L;
    private static final String SEQUENCE_STATUS_CURRENT = "C";
    private String documentNumber;
    private Long id;
    private Integer questionSeqId;
    private Integer sequenceNumber;
    private String sequenceStatus;
    private String question;
    private String status;
    private Long categoryTypeCode;
    private Long questionTypeId;
    private String lookupClass;
    private String lookupReturn;
    private Integer displayedAnswers;
    private Integer maxAnswers;
    private Integer answerMaxLength;
    private QuestionCategory questionCategory;
    private QuestionType questionType;
    private List<QuestionExplanation> questionExplanations;
    private List<QuestionMultiChoice> questionMultiChoices;

    public Question() {
        this.setSequenceNumber(1);
        this.setSequenceStatus(SEQUENCE_STATUS_CURRENT);
        this.setQuestionExplanations(new ArrayList<QuestionExplanation>());
        this.setQuestionMultiChoices(new ArrayList<QuestionMultiChoice>());
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getQuestionSeqId() {
        return this.questionSeqId;
    }

    public void setQuestionSeqId(Integer questionId) {
        this.questionSeqId = questionId;
    }

    @Override
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getSequenceStatus() {
        return this.sequenceStatus;
    }

    public void setSequenceStatus(String sequenceStatus) {
        this.sequenceStatus = sequenceStatus;
    }

    public String getQuestion() {
        return this.question;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getCategoryTypeCode() {
        return this.categoryTypeCode;
    }

    public void setCategoryTypeCode(Long categoryTypeCode) {
        this.categoryTypeCode = categoryTypeCode;
    }

    public Long getQuestionTypeId() {
        return this.questionTypeId;
    }

    public void setQuestionTypeId(Long questionTypeId) {
        this.questionTypeId = questionTypeId;
    }

    public String getLookupClass() {
        return this.lookupClass;
    }

    public void setLookupClass(String lookupClass) {
        this.lookupClass = lookupClass;
    }

    public String getLookupClassDescription() {
        if (this.lookupClass != null) {
            DataDictionaryService dataDictionaryService = KNSServiceLocator.getDataDictionaryService();
            BusinessObjectEntry businessObjectEntry = (BusinessObjectEntry)dataDictionaryService.getDataDictionary().getBusinessObjectEntries().get(this.lookupClass);
            return StringUtils.removeEnd((String)businessObjectEntry.getLookupDefinition().getTitle().trim(), (String)" Lookup");
        }
        return "";
    }

    public String getLookupReturn() {
        return this.lookupReturn;
    }

    public void setLookupReturn(String lookupReturn) {
        this.lookupReturn = lookupReturn;
    }

    public String getLookupReturnDescription() {
        if (this.lookupClass != null && this.lookupReturn != null) {
            DataDictionaryService dataDictionaryService = KcServiceLocator.getService(DataDictionaryService.class);
            return dataDictionaryService.getAttributeLabel(this.lookupClass, this.lookupReturn);
        }
        return "";
    }

    public Integer getDisplayedAnswers() {
        return this.displayedAnswers;
    }

    public void setDisplayedAnswers(Integer displayedAnswers) {
        this.displayedAnswers = displayedAnswers;
    }

    public Integer getMaxAnswers() {
        return this.maxAnswers;
    }

    public void setMaxAnswers(Integer maxAnswers) {
        this.maxAnswers = maxAnswers;
    }

    public Integer getAnswerMaxLength() {
        return this.answerMaxLength;
    }

    public void setAnswerMaxLength(Integer answerMaxLength) {
        this.answerMaxLength = answerMaxLength;
    }

    public QuestionCategory getQuestionCategory() {
        if (this.questionCategory == null) {
            this.refreshReferenceObject("questionCategory");
        }
        return this.questionCategory;
    }

    public void setQuestionCategory(QuestionCategory questionCategory) {
        this.questionCategory = questionCategory;
    }

    public QuestionType getQuestionType() {
        if (this.questionType == null) {
            this.refreshReferenceObject("questionType");
        }
        return this.questionType;
    }

    public void setQuestionType(QuestionType questionType) {
        this.questionType = questionType;
    }

    public List<QuestionExplanation> getQuestionExplanations() {
        return this.questionExplanations;
    }

    public void setQuestionExplanations(List<QuestionExplanation> questionExplanations) {
        this.questionExplanations = questionExplanations;
    }

    public String getExplanation() {
        return this.getExplanation("E");
    }

    public void setExplanation(String explanation) {
        this.setExplanation(explanation, "E");
    }

    public String getPolicy() {
        return this.getExplanation("P");
    }

    public void setPolicy(String policy) {
        this.setExplanation(policy, "P");
    }

    public String getRegulation() {
        return this.getExplanation("R");
    }

    public void setRegulation(String regulation) {
        this.setExplanation(regulation, "R");
    }

    public String getAffirmativeStatementConversion() {
        return this.getExplanation("A");
    }

    public void setAffirmativeStatementConversion(String affirmativeStatementConversion) {
        this.setExplanation(affirmativeStatementConversion, "A");
    }

    public String getNegativeStatementConversion() {
        return this.getExplanation("N");
    }

    public void setNegativeStatementConversion(String negativeStatementConversion) {
        this.setExplanation(negativeStatementConversion, "N");
    }

    private String getExplanation(String explanationType) {
        int index = this.getExplanationObjectIndex(explanationType);
        if (index < 0) {
            return "";
        }
        return this.questionExplanations.get(index).getExplanation();
    }

    private void setExplanation(String explanation, String explanationType) {
        int index = this.getExplanationObjectIndex(explanationType);
        if (index < 0) {
            QuestionExplanation questionExplanation = new QuestionExplanation();
            questionExplanation.setQuestionId(this.id);
            questionExplanation.setExplanationType(explanationType);
            questionExplanation.setExplanation(explanation);
            this.questionExplanations.add(questionExplanation);
        } else {
            this.questionExplanations.get(index).setExplanation(explanation);
        }
    }

    private int getExplanationObjectIndex(String explanationType) {
        if (this.questionExplanations.isEmpty()) {
            this.refreshReferenceObject("questionExplanations");
        }
        for (QuestionExplanation questionExplanation : this.getQuestionExplanations()) {
            if (!questionExplanation.getExplanationType().equals(explanationType)) continue;
            return this.getQuestionExplanations().indexOf(questionExplanation);
        }
        return -1;
    }

    @Override
    public int compareTo(Question argQuestion) {
        if (Objects.equals(this.getQuestionSeqId(), argQuestion.getQuestionSeqId())) {
            return this.getSequenceNumber().compareTo(argQuestion.getSequenceNumber());
        }
        return this.getQuestionSeqId().compareTo(argQuestion.getQuestionSeqId());
    }

    @Override
    public Integer getOwnerSequenceNumber() {
        return null;
    }

    @Override
    public String getVersionNameField() {
        return "questionSeqId";
    }

    @Override
    public String getVersionNameFieldValue() {
        return this.questionSeqId.toString();
    }

    @Override
    public void incrementSequenceNumber() {
        Integer n = this.sequenceNumber;
        Integer n2 = this.sequenceNumber = Integer.valueOf(this.sequenceNumber + 1);
    }

    @Override
    public Question getSequenceOwner() {
        return this;
    }

    @Override
    public void setSequenceOwner(Question newlyVersionedOwner) {
    }

    @Override
    public void resetPersistenceState() {
        this.id = null;
    }

    public List<QuestionMultiChoice> getQuestionMultiChoices() {
        return this.questionMultiChoices;
    }

    public void setQuestionMultiChoices(List<QuestionMultiChoice> questionMultiChoices) {
        this.questionMultiChoices = questionMultiChoices;
    }

    public boolean isRadioButton() {
        return this.getMaxAnswers() == 1 && this.getDisplayedAnswers() != 1;
    }
}

