/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.dataoverride;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetControllerBase;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetForm;
import org.kuali.coeus.propdev.impl.budget.editable.BudgetChangedData;
import org.kuali.coeus.propdev.impl.budget.editable.BudgetColumnsToAlter;
import org.kuali.coeus.propdev.impl.budget.editable.BudgetDataOverrideEvent;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.dataovveride.common.CommonDataOverrideService;
import org.kuali.coeus.propdev.impl.notification.NotificationControllerService;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotificationContext;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotificationRenderer;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalBudgetDataOverrideController
extends ProposalBudgetControllerBase {
    private static final String BUDGET_JUSTIFICATION = "budgetJustification";
    private static final String CHANGE_NUMBER = "proposalDevelopment.budgetChangedDataList.changeNumber";
    private static final String AD_HOC_NOTIFICATION = "Ad-Hoc Notification";
    private static final String PROP_BUDGET_DATA_OVERRIDE_DIALOG = "PropBudget-DataOverride-Dialog";
    @Autowired
    @Qualifier(value="kualiRuleService")
    private KualiRuleService kualiRuleService;
    @Autowired
    @Qualifier(value="notificationControllerService")
    private NotificationControllerService notificationControllerService;
    @Autowired
    @Qualifier(value="commonDataOverrideService")
    private CommonDataOverrideService commonDataOverrideService;

    @Transactional
    @RequestMapping(value={"/proposalBudget"}, params={"methodToCall=prepareDataOverride"})
    public ModelAndView prepareDataOverride(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        String columnName = form.getNewBudgetChangedData().getColumnName();
        if (StringUtils.isNotEmpty((CharSequence)columnName)) {
            form.getNewBudgetChangedData().setEditableColumn((BudgetColumnsToAlter)this.getDataObjectService().find(BudgetColumnsToAlter.class, (Object)columnName));
            String propertyValue = this.getCommonDataOverrideService().getChangedValue(form.getBudget(), form.getNewBudgetChangedData().getAttributeName());
            form.getNewBudgetChangedData().setDisplayValue(propertyValue);
            form.getNewBudgetChangedData().setOldDisplayValue(propertyValue);
        } else {
            form.setNewBudgetChangedData(new BudgetChangedData());
        }
        form.setUpdateComponentId(PROP_BUDGET_DATA_OVERRIDE_DIALOG);
        form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey());
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalBudget"}, params={"methodToCall=createOverride"})
    public ModelAndView createOverride(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        ProposalDevelopmentBudgetExt budget = form.getBudget();
        BudgetChangedData newBudgetChangedData = form.getNewBudgetChangedData();
        int changeNumber = ((Budget)budget).getBudgetParent().getDocument().getDocumentNextValue(CHANGE_NUMBER);
        newBudgetChangedData.setProposalNumber(((Budget)budget).getBudgetParent().getParentNumber());
        newBudgetChangedData.setChangeNumber(changeNumber);
        newBudgetChangedData.setDisplayValue(newBudgetChangedData.getChangedValue());
        newBudgetChangedData.prePersist();
        if (this.getKualiRuleService().applyRules((DocumentEvent)new BudgetDataOverrideEvent((ProposalDevelopmentDocument)((Budget)budget).getBudgetParent().getDocument(), newBudgetChangedData))) {
            if (BUDGET_JUSTIFICATION.equals(newBudgetChangedData.getAttributeName())) {
                form.getBudgetJustificationWrapper().setJustificationText(newBudgetChangedData.getChangedValue());
            } else {
                this.getCommonDataOverrideService().setChangedValue(budget, newBudgetChangedData.getAttributeName(), newBudgetChangedData.getChangedValue());
            }
            this.growProposalChangedHistory(budget, newBudgetChangedData);
            ArrayList<BudgetChangedData> budgetChangedDataList = new ArrayList<BudgetChangedData>();
            budgetChangedDataList.add((BudgetChangedData)this.getDataObjectService().save((Object)newBudgetChangedData, new PersistenceOption[0]));
            budgetChangedDataList.addAll(form.getDevelopmentProposal().getBudgetChangedDataList());
            form.getDevelopmentProposal().setBudgetChangedDataList(budgetChangedDataList);
            form.getDevelopmentProposal().getBudgetChangedDataList().add((BudgetChangedData)this.getDataObjectService().save((Object)newBudgetChangedData, new PersistenceOption[0]));
            this.getDataObjectService().save((Object)((Budget)budget).getBudgetParent().getDocument().getDocumentNextvalueBo(CHANGE_NUMBER), new PersistenceOption[0]);
            super.saveBudget(form);
            String value = this.getCommonDataOverrideService().getDisplayReferenceValue(budget, newBudgetChangedData.getAttributeName(), Budget.class);
            if (value != null) {
                newBudgetChangedData.setDisplayValue(value);
            }
            form.setNewBudgetChangedData(new BudgetChangedData());
            ProposalDevelopmentNotificationContext context = new ProposalDevelopmentNotificationContext((DevelopmentProposal)((Budget)budget).getBudgetParent(), "103", "Proposal Data Override");
            context.getRenderer().setBudgetChangedData(newBudgetChangedData);
            context.getRenderer().setDevelopmentProposal((DevelopmentProposal)((Budget)budget).getBudgetParent());
            this.getNotificationControllerService().sendNotificationIfNoErrors(form, context);
        }
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalBudget"}, params={"methodToCall=sendOverrideNotification"})
    public ModelAndView sendOverrideNotification(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        return this.getNotificationControllerService().sendNotification(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalBudget"}, params={"methodToCall=performRecipientSearch"})
    public ModelAndView performRecipientSearch(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        return this.getNotificationControllerService().performRecipientSearch(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalBudget"}, params={"methodToCall=addRecipients"})
    public ModelAndView addRecipients(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        return this.getNotificationControllerService().addRecipients(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalBudget"}, params={"methodToCall=sendNotifications"})
    public ModelAndView sendNotifications(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        ProposalDevelopmentNotificationRenderer renderer = new ProposalDevelopmentNotificationRenderer(form.getDevelopmentProposal());
        ProposalDevelopmentNotificationContext context = new ProposalDevelopmentNotificationContext(form.getDevelopmentProposal(), null, AD_HOC_NOTIFICATION, renderer);
        return this.getNotificationControllerService().sendNotifications(form, context);
    }

    @Transactional
    @RequestMapping(value={"/proposalBudget"}, params={"methodToCall=prepareNotificationWizard"})
    public ModelAndView prepareNotificationWizard(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) {
        return this.getNotificationControllerService().prepareNotificationWizard(form);
    }

    private void growProposalChangedHistory(Budget budget, BudgetChangedData newBudgetChangedData) {
        Map<String, List<BudgetChangedData>> changeHistory = ((DevelopmentProposal)budget.getBudgetParent()).getBudgetChangeHistory();
        changeHistory.computeIfAbsent(newBudgetChangedData.getEditableColumn().getColumnLabel(), k -> new ArrayList());
        changeHistory.get(newBudgetChangedData.getEditableColumn().getColumnLabel()).add(0, newBudgetChangedData);
    }

    public KualiRuleService getKualiRuleService() {
        return this.kualiRuleService;
    }

    public void setKualiRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }

    public NotificationControllerService getNotificationControllerService() {
        return this.notificationControllerService;
    }

    public void setNotificationControllerService(NotificationControllerService notificationControllerService) {
        this.notificationControllerService = notificationControllerService;
    }

    public CommonDataOverrideService getCommonDataOverrideService() {
        return this.commonDataOverrideService;
    }

    public void setCommonDataOverrideService(CommonDataOverrideService commonDataOverrideService) {
        this.commonDataOverrideService = commonDataOverrideService;
    }
}

