/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.note;

import org.kuali.coeus.common.budget.framework.core.BudgetException;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetJustificationService;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetControllerBase;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetForm;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.web.controller.MethodAccessible;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalBudgetNoteController
extends ProposalBudgetControllerBase {
    @Autowired
    @Qualifier(value="budgetJustificationService")
    private BudgetJustificationService budgetJustificationService;

    @Override
    public BudgetJustificationService getBudgetJustificationService() {
        return this.budgetJustificationService;
    }

    @Override
    public void setBudgetJustificationService(BudgetJustificationService budgetJustificationService) {
        this.budgetJustificationService = budgetJustificationService;
    }

    @MethodAccessible
    @Transactional
    @RequestMapping(value={"/proposalBudget"}, params={"methodToCall=consolidateExpenseJustifications"})
    public ModelAndView consolidateExpenseJustifications(@ModelAttribute(value="KualiForm") ProposalBudgetForm form) throws Exception {
        try {
            this.getBudgetJustificationService().consolidateExpenseJustifications(form.getBudget(), form.getBudgetJustificationWrapper());
        }
        catch (BudgetException exc) {
            GlobalVariables.getMessageMap().putError("budgetJustificationWrapper.justificationText", "error.custom", new String[]{"There are no line item budget justifications"});
        }
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }
}

