/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.specialreview;

import org.kuali.coeus.common.framework.compliance.core.AddSpecialReviewEvent;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.specialreview.ProposalDevelopmentSpecialReviewService;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReview;
import org.kuali.kra.iacuc.protocol.funding.IacucProtocolProposalDevelopmentProtocolDocumentService;
import org.kuali.kra.iacuc.specialreview.IacucProtocolSpecialReviewService;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.protocol.funding.ProposalDevelopmentProtocolDocumentService;
import org.kuali.kra.irb.specialreview.ProtocolSpecialReviewService;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.KualiRuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="proposalDevelopmentSpecialReviewService")
public class ProposalDevelopmentSpecialReviewServiceImpl
implements ProposalDevelopmentSpecialReviewService {
    @Autowired
    @Qualifier(value="proposalDevelopmentProtocolDocumentService")
    private ProposalDevelopmentProtocolDocumentService proposalDevelopmentProtocolDocumentService;
    @Autowired
    @Qualifier(value="iacucProtocolProposalDevelopmentProtocolDocumentService")
    private IacucProtocolProposalDevelopmentProtocolDocumentService iacucProtocolProposalDevelopmentProtocolDocumentService;
    @Autowired
    @Qualifier(value="protocolSpecialReviewService")
    private ProtocolSpecialReviewService protocolSpecialReviewService;
    @Autowired
    @Qualifier(value="iacucProtocolSpecialReviewService")
    private IacucProtocolSpecialReviewService iacucProtocolSpecialReviewService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="kualiRuleService")
    private KualiRuleService kualiRuleService;

    @Override
    public boolean createProtocol(ProposalSpecialReview specialReview, ProposalDevelopmentDocument document) throws Exception {
        IacucProtocolProposalDevelopmentProtocolDocumentService service;
        Object protocolDocument;
        if ("1".equals(specialReview.getSpecialReviewTypeCode())) {
            ProposalDevelopmentProtocolDocumentService service2;
            ProtocolDocument protocolDocument2;
            if (this.isCreateIrbProtocolEnabled() && (protocolDocument2 = (ProtocolDocument)(service2 = this.getProposalDevelopmentProtocolDocumentService()).createProtocolDocument(document)) != null) {
                specialReview.setSpecialReviewTypeCode("1");
                if (specialReview.getSpecialReviewNumber() == null) {
                    specialReview.setSpecialReviewNumber(this.generateSpecialReviewNumber(document));
                }
                specialReview.setApprovalTypeCode("1");
                specialReview.setProtocolNumber(protocolDocument2.getProtocol().getProtocolNumber());
                specialReview.setDevelopmentProposal(document.getDevelopmentProposal());
                specialReview.setProtocolStatus(protocolDocument2.getProtocol().getProtocolStatus().getDescription());
                specialReview.setComments("A Special Review has been inserted.");
                this.prepareProtocolLinkViewFields(specialReview);
                if (this.getKualiRuleService().applyRules(new AddSpecialReviewEvent<ProposalSpecialReview>((Document)document, specialReview, document.getDevelopmentProposal().getPropSpecialReviews(), this.isIrbLinkingEnabled()))) {
                    document.getDevelopmentProposal().getPropSpecialReviews().add(specialReview);
                    return true;
                }
            }
        } else if ("2".equals(specialReview.getSpecialReviewTypeCode()) && this.isCreateIacucProtocolEnabled() && (protocolDocument = (service = this.getIacucProtocolProposalDevelopmentProtocolDocumentService()).createProtocolDocument(document)) != null) {
            specialReview.setSpecialReviewTypeCode("2");
            if (specialReview.getSpecialReviewNumber() == null) {
                specialReview.setSpecialReviewNumber(this.generateSpecialReviewNumber(document));
            }
            specialReview.setApprovalTypeCode("1");
            specialReview.setProtocolNumber(((ProtocolDocumentBase)protocolDocument).getProtocol().getProtocolNumber());
            specialReview.setDevelopmentProposal(document.getDevelopmentProposal());
            specialReview.setProtocolStatus(((ProtocolDocumentBase)protocolDocument).getProtocol().getProtocolStatus().getDescription());
            specialReview.setComments("A Special Review has been inserted.");
            this.prepareProtocolLinkViewFields(specialReview);
            if (this.getKualiRuleService().applyRules(new AddSpecialReviewEvent<ProposalSpecialReview>((Document)document, specialReview, document.getDevelopmentProposal().getPropSpecialReviews(), this.isIacucLinkingEnabled()))) {
                document.getDevelopmentProposal().getPropSpecialReviews().add(specialReview);
                return true;
            }
        }
        return false;
    }

    @Override
    public Integer generateSpecialReviewNumber(ProposalDevelopmentDocument document) {
        return document.getDocumentNextValue("proposalDevelopment.proposalSpecialReview.specialReviewNumber");
    }

    public void prepareProtocolLinkViewFields(ProposalSpecialReview specialReview) {
        if (this.isIrbLinkingEnabled() || this.isIacucLinkingEnabled()) {
            if (specialReview != null && "1".equals(specialReview.getSpecialReviewTypeCode())) {
                ProtocolSpecialReviewService protocolSpecialReviewService = this.getProtocolSpecialReviewService();
                protocolSpecialReviewService.populateSpecialReview(specialReview);
            } else if (specialReview != null && "2".equals(specialReview.getSpecialReviewTypeCode())) {
                IacucProtocolSpecialReviewService iacucProtocolSpecialReviewService = this.getIacucProtocolSpecialReviewService();
                iacucProtocolSpecialReviewService.populateSpecialReview(specialReview);
            }
        }
    }

    @Override
    public boolean isCreateIrbProtocolEnabled() {
        return this.isIrbLinkingEnabled() && this.isCreateProtocolFromProposalEnabled("ENABLE_CREATE_PROPOSAL_TO_IRB_PROTOCOL");
    }

    @Override
    public boolean isCreateIacucProtocolEnabled() {
        return this.isIacucLinkingEnabled() && this.isCreateProtocolFromProposalEnabled("ENABLE_CREATE_PROPOSAL_TO_IACUC_PROTOCOL");
    }

    @Override
    public boolean isIrbLinkingEnabled() {
        return this.isProtocolLinkEnabled("KC-PROTOCOL", "irb.protocol.development.proposal.linking.enabled");
    }

    @Override
    public boolean isIacucLinkingEnabled() {
        return this.isProtocolLinkEnabled("KC-IACUC", "iacuc.protocol.proposal.development.linking.enabled");
    }

    private boolean isProtocolLinkEnabled(String moduleNameSpace, String proposalLinkParam) {
        return this.getParameterService().getParameterValueAsBoolean(moduleNameSpace, "Document", proposalLinkParam);
    }

    @Override
    public boolean isCreateProtocolFromProposalEnabled(String protocolLinkParam) {
        return this.getParameterService().getParameterValueAsBoolean("KC-PD", "Document", protocolLinkParam);
    }

    @Override
    public boolean canCreateIrbProtocol(ProposalDevelopmentDocument document) {
        return this.getProposalDevelopmentProtocolDocumentService().isAuthorizedCreateProtocol(document);
    }

    @Override
    public boolean canCreateIacucProtocol(ProposalDevelopmentDocument document) {
        return this.getIacucProtocolProposalDevelopmentProtocolDocumentService().isAuthorizedCreateProtocol(document);
    }

    protected ProposalDevelopmentProtocolDocumentService getProposalDevelopmentProtocolDocumentService() {
        return this.proposalDevelopmentProtocolDocumentService;
    }

    public void setProposalDevelopmentProtocolDocumentService(ProposalDevelopmentProtocolDocumentService proposalDevelopmentProtocolDocumentService) {
        this.proposalDevelopmentProtocolDocumentService = proposalDevelopmentProtocolDocumentService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public IacucProtocolProposalDevelopmentProtocolDocumentService getIacucProtocolProposalDevelopmentProtocolDocumentService() {
        return this.iacucProtocolProposalDevelopmentProtocolDocumentService;
    }

    public void setIacucProtocolProposalDevelopmentProtocolDocumentService(IacucProtocolProposalDevelopmentProtocolDocumentService iacucProtocolProposalDevelopmentProtocolDocumentService) {
        this.iacucProtocolProposalDevelopmentProtocolDocumentService = iacucProtocolProposalDevelopmentProtocolDocumentService;
    }

    protected ProtocolSpecialReviewService getProtocolSpecialReviewService() {
        return this.protocolSpecialReviewService;
    }

    public void setProtocolSpecialReviewService(ProtocolSpecialReviewService protocolSpecialReviewService) {
        this.protocolSpecialReviewService = protocolSpecialReviewService;
    }

    protected IacucProtocolSpecialReviewService getIacucProtocolSpecialReviewService() {
        return this.iacucProtocolSpecialReviewService;
    }

    public void setIacucProtocolSpecialReviewService(IacucProtocolSpecialReviewService iacucProtocolSpecialReviewService) {
        this.iacucProtocolSpecialReviewService = iacucProtocolSpecialReviewService;
    }

    public KualiRuleService getKualiRuleService() {
        return this.kualiRuleService;
    }

    public void setKualiRuleService(KualiRuleService kualiRuleService) {
        this.kualiRuleService = kualiRuleService;
    }
}

